/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;

public class PropFuncArg
extends PrintSerializableBase {
    private List<Node> argList = null;
    private Node arg = null;

    public PropFuncArg(List<Node> argList, Node arg) {
        if (argList == null) {
            this.arg = arg;
            return;
        }
        this.argList = argList;
        if (argList.isEmpty()) {
            this.arg = NodeConst.nodeNil;
        }
    }

    public PropFuncArg(List<Node> argList) {
        this.argList = argList;
    }

    public PropFuncArg(Node arg) {
        this.arg = arg;
    }

    public Node getArg() {
        return this.arg;
    }

    public List<Node> getArgList() {
        return this.argList;
    }

    public int getArgListSize() {
        return this.argList == null ? -1 : this.argList.size();
    }

    public Node getArg(int index) {
        if (this.argList == null) {
            return null;
        }
        return this.argList.get(index);
    }

    public int hashCode() {
        if (this.isNode()) {
            return this.arg.hashCode();
        }
        return this.argList.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropFuncArg)) {
            return false;
        }
        PropFuncArg pfArg = (PropFuncArg)other;
        if (this.isNode()) {
            return this.arg.equals(pfArg.arg);
        }
        return this.argList.equals(pfArg.argList);
    }

    public boolean isList() {
        return this.argList != null;
    }

    public boolean isNode() {
        return this.arg != null;
    }

    public ExprList asExprList(PropFuncArg pfArg) {
        ExprList exprList = new ExprList();
        if (pfArg.isNode()) {
            Node n = pfArg.getArg();
            Expr expr = ExprUtils.nodeToExpr(n);
            exprList.add(expr);
            return exprList;
        }
        for (Node n : pfArg.getArgList()) {
            Expr expr = ExprUtils.nodeToExpr(n);
            exprList.add(expr);
        }
        return exprList;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        if (this.argList == null && this.arg == null) {
            out.print("<<null>>");
        }
        if (this.argList != null) {
            out.print("(");
            boolean first = true;
            for (Node n : this.argList) {
                if (!first) {
                    out.print(" ");
                }
                String str2 = FmtUtils.stringForNode(n, sCxt);
                out.print(str2);
                first = false;
            }
            out.print(")");
        }
        if (this.arg != null) {
            out.print(FmtUtils.stringForNode(this.arg));
        }
    }
}

