/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.user;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.function.Function;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunction;
import com.hp.hpl.jena.sparql.sse.builders.ExprBuildException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDefinedFunctionDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(UserDefinedFunctionDefinition.class);
    public static boolean warnOnUnusedVariable = true;
    private String uri;
    private Expr expr;
    private List<Var> argList;

    public UserDefinedFunctionDefinition(String uri, Expr e2, List<Var> argList) {
        this.uri = uri;
        this.expr = e2;
        this.argList = new ArrayList<Var>(argList);
        Set<Var> mentioned = this.expr.getVarsMentioned();
        for (Var v : mentioned) {
            if (argList.contains(v)) continue;
            throw new ExprBuildException("Cannot use the variable " + v.toString() + " in the expression since it is not included in the argList argument.  All variables must be arguments to the function");
        }
        if (mentioned.size() > this.argList.size()) {
            throw new ExprBuildException("Mismatch between variables used in expression and number of variables in argument list, expected " + this.argList.size() + " but found " + mentioned.size());
        }
        if (mentioned.size() < this.argList.size()) {
            for (Var v : this.argList) {
                if (mentioned.contains(v) || !warnOnUnusedVariable) continue;
                LOG.warn("Function <" + uri + "> has argument " + v + " which is never used in the expression");
            }
        }
    }

    public Expr getBaseExpr() {
        return this.expr;
    }

    public List<Var> getArgList() {
        return this.argList;
    }

    public String getUri() {
        return this.uri;
    }

    public Function newFunctionInstance() {
        return new UserDefinedFunction(this);
    }
}

