/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.ArrayDeque;
import java.util.Deque;

public class TransformUnionQuery
extends TransformCopy {
    Deque<Node> currentGraph = new ArrayDeque<Node>();

    public static Op transform(Op op) {
        TransformUnionQuery t = new TransformUnionQuery();
        Op op2 = Transformer.transform(t, op, new Pusher(t.currentGraph), new Popper(t.currentGraph));
        return op2;
    }

    public TransformUnionQuery() {
        this.currentGraph.push(Quad.defaultGraphNodeGenerated);
    }

    @Override
    public Op transform(OpQuadPattern quadPattern) {
        if (quadPattern.isDefaultGraph() || quadPattern.isUnionGraph()) {
            OpBGP opBGP = new OpBGP(quadPattern.getBasicPattern());
            return this.union(opBGP);
        }
        return super.transform(quadPattern);
    }

    @Override
    public Op transform(OpBGP opBGP) {
        Node current = this.currentGraph.peek();
        if (current == Quad.defaultGraphNodeGenerated || current == Quad.unionGraph) {
            return this.union(opBGP);
        }
        return super.transform(opBGP);
    }

    private Op union(OpBGP opBGP) {
        Var v = Var.ANON;
        Op op = new OpGraph(v, opBGP);
        op = OpDistinct.create(op);
        return op;
    }

    @Override
    public Op transform(OpGraph opGraph, Op x) {
        return super.transform(opGraph, x);
    }

    static class Popper
    extends OpVisitorBase {
        private Deque<Node> stack;

        Popper(Deque<Node> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            Node n = this.stack.pop();
            if (!opGraph.getNode().equals(n)) {
                throw new ARQInternalErrorException();
            }
        }
    }

    static class Pusher
    extends OpVisitorBase {
        private Deque<Node> stack;

        Pusher(Deque<Node> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            this.stack.push(opGraph.getNode());
        }
    }
}

