/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.parser.odf;

import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPACreditTransferTransaction;
import com.codecamp.sepa.core.SEPANormalizer;
import com.codecamp.sepa.gui.CreditParser;
import com.codecamp.sepa.parser.CreditTransferValidator;
import com.codecamp.sepa.parser.ParserLineResult;
import com.codecamp.sepa.parser.ParserResult;
import com.codecamp.sepa.parser.ParserUtils;
import com.codecamp.sepa.parser.ValidationException;
import com.codecamp.sepa.parser.odf.command.ColumnReaderCommandFactory;
import com.codecamp.sepa.parser.sheet.NoObject;
import com.codecamp.sepa.parser.sheet.command.ColumnReaderCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;

public class ODFCreditParser
implements CreditParser {
    private final Logger logger = Logger.getLogger(ODFCreditParser.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParserResult parse(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15) {
        ParserResult parserResult = new ParserResult();
        SEPACreditTransfer sEPACreditTransfer = new SEPACreditTransfer();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            SpreadsheetDocument spreadsheetDocument = SpreadsheetDocument.loadDocument(fileInputStream);
            boolean bl16 = spreadsheetDocument.getTableList().size() == 1;
            List<SEPACreditTransferTransaction> list = this.readCreditTransferTransactions(spreadsheetDocument.getTableList().get(bl16 ? 0 : 1), parserResult, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl12, bl13, bl14, bl15);
            sEPACreditTransfer.getTransactionList().addAll(list);
            parserResult.setCreditTransfer(sEPACreditTransfer);
            parserResult.setHeaderSuccessfull(true);
            spreadsheetDocument.close();
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Exception while opening ODF file \"" + file.getAbsolutePath() + "\"", exception);
            parserResult.setHeaderSuccessfull(false);
            parserResult.setHeaderMessage(exception.getMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.logger.log(Level.WARNING, "Exception while opening ODF file \"" + file.getAbsolutePath() + "\"", iOException);
                }
            }
        }
        return parserResult;
    }

    protected List<SEPACreditTransferTransaction> readCreditTransferTransactions(Table table, ParserResult parserResult, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15) {
        ArrayList<SEPACreditTransferTransaction> arrayList = new ArrayList<SEPACreditTransferTransaction>();
        SEPACreditTransferTransaction sEPACreditTransferTransaction = null;
        int n = table.getRowCount() - 1;
        int n2 = this.determineStartingRow(table.getRowByIndex(0));
        this.checkBIC(table, n2, parserResult);
        parserResult.setStartingRow(n2);
        for (int i = n2; i <= n; ++i) {
            Row row = table.getRowByIndex(i);
            Cell cell = row.getCellByIndex(0);
            String string = cell.getValueType();
            if (string == null) {
                this.logger.log(Level.WARNING, "Empty cell in row: " + i);
                break;
            }
            List<Field> list = Arrays.asList(SEPACreditTransferTransaction.class.getDeclaredFields());
            sEPACreditTransferTransaction = new SEPACreditTransferTransaction();
            ParserLineResult parserLineResult = new ParserLineResult();
            for (Field field : list) {
                if ("BIC".equals(field.getName()) && !bl || "end2EndId".equals(field.getName()) && !bl2 || "currency".equals(field.getName()) && !bl3 || "countryCode".equals(field.getName()) && !bl4 || "addressLine1".equals(field.getName()) && !bl4 || "addressLine2".equals(field.getName()) && !bl4 || "executionDate".equals(field.getName()) && !bl6 || "additionalInformation".equals(field.getName()) && !bl12 || "kontoinhaberPayerTrx".equals(field.getName()) && !bl13 || "IBANPayerTrx".equals(field.getName()) && !bl13 || "BICPayerTrx".equals(field.getName()) && !bl13 || "regulatoryReportingCode".equals(field.getName()) && !bl15) continue;
                ColumnReaderCommand columnReaderCommand = ColumnReaderCommandFactory.create(field, row);
                try {
                    Object object = columnReaderCommand.getValueFromColumnOrColumns(!bl);
                    if (NoObject.class == object.getClass()) continue;
                    field.setAccessible(true);
                    field.set(sEPACreditTransferTransaction, object);
                }
                catch (InstantiationException instantiationException) {
                    this.logger.log(Level.WARNING, "Cannot read value.", instantiationException);
                    sEPACreditTransferTransaction = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.log(Level.WARNING, "Cannot set value into field.", illegalAccessException);
                    sEPACreditTransferTransaction = null;
                }
            }
            try {
                CreditTransferValidator.validateLine(sEPACreditTransferTransaction.getKontoinhaber(), sEPACreditTransferTransaction.getIBAN(), sEPACreditTransferTransaction.getBIC(), sEPACreditTransferTransaction.getVerwendungszweck(), sEPACreditTransferTransaction.getAmount(), sEPACreditTransferTransaction.getEnd2EndId(), sEPACreditTransferTransaction.getCurrency(), sEPACreditTransferTransaction.getCountryCode(), sEPACreditTransferTransaction.getAddressLine1(), sEPACreditTransferTransaction.getAddressLine2(), sEPACreditTransferTransaction.getExecutionDate(), sEPACreditTransferTransaction.getAdditionalInformation(), sEPACreditTransferTransaction.getKontoinhaberPayerTrx(), sEPACreditTransferTransaction.getIBANPayerTrx(), sEPACreditTransferTransaction.getBICPayerTrx(), sEPACreditTransferTransaction.getRegulatoryReportingCode(), bl && !bl7, bl2, bl3, bl4, bl5 || bl7 || bl8, bl6, bl7, bl9, bl10, bl11, bl12, bl13, bl14, bl15);
                sEPACreditTransferTransaction.setIBAN(sEPACreditTransferTransaction.getIBAN().replaceAll(" ", ""));
                if (bl) {
                    if (bl7) {
                        sEPACreditTransferTransaction.setBIC(sEPACreditTransferTransaction.getBIC());
                    } else {
                        sEPACreditTransferTransaction.setBIC(sEPACreditTransferTransaction.getBIC().replaceAll(" ", ""));
                    }
                }
                sEPACreditTransferTransaction.setVerwendungszweck(sEPACreditTransferTransaction.getVerwendungszweck().trim());
                if (bl2) {
                    sEPACreditTransferTransaction.setEnd2EndId(sEPACreditTransferTransaction.getEnd2EndId().replaceAll(" ", ""));
                }
                if (bl3) {
                    sEPACreditTransferTransaction.setCurrency(sEPACreditTransferTransaction.getCurrency().replaceAll(" ", ""));
                }
                if (bl4) {
                    sEPACreditTransferTransaction.setCountryCode(sEPACreditTransferTransaction.getCountryCode().replaceAll(" ", ""));
                }
                if (bl9) {
                    sEPACreditTransferTransaction.setKontoinhaber(SEPANormalizer.normalize(sEPACreditTransferTransaction.getKontoinhaber()));
                    sEPACreditTransferTransaction.setVerwendungszweck(SEPANormalizer.normalize(sEPACreditTransferTransaction.getVerwendungszweck()));
                    if (sEPACreditTransferTransaction.getAddressLine1() != null) {
                        sEPACreditTransferTransaction.setAddressLine1(SEPANormalizer.normalize(sEPACreditTransferTransaction.getAddressLine1()));
                    }
                    if (sEPACreditTransferTransaction.getAddressLine2() != null) {
                        sEPACreditTransferTransaction.setAddressLine2(SEPANormalizer.normalize(sEPACreditTransferTransaction.getAddressLine2()));
                    }
                }
                if (bl9 && sEPACreditTransferTransaction.getAdditionalInformation() != null) {
                    sEPACreditTransferTransaction.setAdditionalInformation(SEPANormalizer.normalize(sEPACreditTransferTransaction.getAdditionalInformation()));
                }
                if (bl13) {
                    if (bl9) {
                        sEPACreditTransferTransaction.setKontoinhaberPayerTrx(SEPANormalizer.normalize(sEPACreditTransferTransaction.getKontoinhaberPayerTrx()));
                    }
                    sEPACreditTransferTransaction.setIBANPayerTrx(sEPACreditTransferTransaction.getIBANPayerTrx().replaceAll(" ", ""));
                    sEPACreditTransferTransaction.setBICPayerTrx(sEPACreditTransferTransaction.getBICPayerTrx().replaceAll(" ", ""));
                }
                parserLineResult.setSucessfull(true);
                parserLineResult.setLineMessage(sEPACreditTransferTransaction.getKontoinhaber() + ", " + sEPACreditTransferTransaction.getIBAN() + (bl ? ", " + sEPACreditTransferTransaction.getBIC() : "") + ", " + sEPACreditTransferTransaction.getVerwendungszweck() + ", " + ParserUtils.formatBigDecimalForLog(sEPACreditTransferTransaction.getAmount()) + (bl2 ? ", " + sEPACreditTransferTransaction.getEnd2EndId() : "") + (bl3 ? ", " + sEPACreditTransferTransaction.getCurrency() : "") + (bl4 ? ", " + sEPACreditTransferTransaction.getCountryCode() : "") + (bl4 ? ", " + StringUtils.trimToEmpty(sEPACreditTransferTransaction.getAddressLine1()) : "") + (bl4 ? ", " + StringUtils.trimToEmpty(sEPACreditTransferTransaction.getAddressLine2()) : "") + (bl6 ? ", " + ParserUtils.formatDateForLog(sEPACreditTransferTransaction.getExecutionDate()) : "") + (bl12 ? ", " + StringUtils.trimToEmpty(sEPACreditTransferTransaction.getAdditionalInformation()) : "") + (bl13 ? ", " + StringUtils.trimToEmpty(sEPACreditTransferTransaction.getKontoinhaberPayerTrx()) : "") + (bl13 ? ", " + StringUtils.trimToEmpty(sEPACreditTransferTransaction.getIBANPayerTrx()) : "") + (bl13 ? ", " + StringUtils.trimToEmpty(sEPACreditTransferTransaction.getBICPayerTrx()) : "") + (bl15 ? ", " + StringUtils.trimToEmpty(sEPACreditTransferTransaction.getRegulatoryReportingCode()) : ""));
            }
            catch (ValidationException validationException) {
                parserLineResult.setSucessfull(false);
                parserLineResult.setLineMessage(validationException.getMessage() + (validationException.getNotValidatingValue() != null ? " (" + validationException.getNotValidatingValue() + ")" : ""));
                sEPACreditTransferTransaction = null;
                this.logger.log(Level.WARNING, parserLineResult.getLineMessage(), validationException);
            }
            if (sEPACreditTransferTransaction != null) {
                sEPACreditTransferTransaction.setAmount(sEPACreditTransferTransaction.getAmount().setScale(2));
                sEPACreditTransferTransaction.setIBAN(sEPACreditTransferTransaction.getIBAN().toUpperCase());
                if (bl) {
                    sEPACreditTransferTransaction.setBIC(sEPACreditTransferTransaction.getBIC().toUpperCase());
                }
                if (bl2) {
                    sEPACreditTransferTransaction.setEnd2EndId(sEPACreditTransferTransaction.getEnd2EndId().toUpperCase());
                }
                if (bl3) {
                    sEPACreditTransferTransaction.setCurrency(sEPACreditTransferTransaction.getCurrency().toUpperCase());
                }
                if (bl4) {
                    sEPACreditTransferTransaction.setCountryCode(sEPACreditTransferTransaction.getCountryCode().toUpperCase());
                }
                if (bl13) {
                    sEPACreditTransferTransaction.setIBANPayerTrx(sEPACreditTransferTransaction.getIBANPayerTrx().toUpperCase());
                    sEPACreditTransferTransaction.setBICPayerTrx(sEPACreditTransferTransaction.getBICPayerTrx().toUpperCase());
                }
                arrayList.add(sEPACreditTransferTransaction);
                parserResult.setSuccessfull(parserResult.getSuccessfull() + 1);
                parserResult.setSum(parserResult.getSum().add(sEPACreditTransferTransaction.getAmount()));
            } else {
                parserResult.setNotSuccessfull(parserResult.getNotSuccessfull() + 1);
            }
            parserResult.getLineResults().add(parserLineResult);
        }
        return arrayList;
    }

    private int determineStartingRow(Row row) {
        int n = 0;
        try {
            Cell cell = row.getCellByIndex(0);
            if (cell.getValueType().equals("string")) {
                String string = cell.getStringValue();
                if (ParserUtils.isExample(string)) {
                    this.logger.log(Level.INFO, "This is the template with header and example: Start reading from line 2...");
                    n = 2;
                } else if (ParserUtils.isHeader(string)) {
                    this.logger.log(Level.INFO, "This is the template with header: Start reading from line 1...");
                    n = 1;
                } else {
                    this.logger.log(Level.INFO, "This is not the template: Start reading from line 0...");
                }
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Cannot read value.", exception);
        }
        return n;
    }

    private void checkBIC(Table table, int n, ParserResult parserResult) {
        try {
            if (2 == n) {
                String string;
                Row row = table.getRowByIndex(0);
                Cell cell = row.getCellByIndex(2);
                if (cell.getValueType().equals("string") && ParserUtils.isExampleBIC(string = cell.getStringValue())) {
                    this.logger.log(Level.INFO, "This is the template with header and example and column BIC.");
                    parserResult.setBICFound(true);
                }
            } else if (1 == n) {
                String string;
                Row row = table.getRowByIndex(1);
                Cell cell = row.getCellByIndex(2);
                if (cell.getValueType().equals("string") && ParserUtils.isHeaderBIC(string = cell.getStringValue())) {
                    this.logger.log(Level.INFO, "This is the template with header and column BIC.");
                    parserResult.setBICFound(true);
                }
            } else {
                String string;
                Row row = table.getRowByIndex(2);
                Cell cell = row.getCellByIndex(2);
                if (cell.getValueType().equals("string") && ParserUtils.isBIC(string = cell.getStringValue())) {
                    this.logger.log(Level.INFO, "This is presumably a BIC.");
                    parserResult.setBICFound(true);
                }
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Cannot read value.", exception);
        }
    }
}

