/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.parser.csv;

import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPADirectDebitTransaction;
import com.codecamp.sepa.core.SEPANormalizer;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.gui.DebitParser;
import com.codecamp.sepa.parser.ParserLineResult;
import com.codecamp.sepa.parser.ParserResult;
import com.codecamp.sepa.parser.ParserUtils;
import com.codecamp.sepa.parser.ValidationException;
import com.codecamp.sepa.parser.csv.CSVDirectDebitValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSVDirectDebitParser
implements DebitParser {
    private final Logger logger = Logger.getLogger(CSVDirectDebitParser.class.getName());
    private final ParserResult parserResult = new ParserResult();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParserResult parse(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                this.logger.log(Level.INFO, "Reading line: " + (String)object);
                arrayList.add(object);
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while reading CSV file!", exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    this.logger.log(Level.SEVERE, "Exception while reading CSV file!", iOException);
                }
            }
        }
        object = new SEPADirectDebit();
        try {
            if (arrayList == null || arrayList.size() == 0) {
                throw new ValidationException(ApplicationContext.get().text().getString("validation.csv.empty"), (Object)null);
            }
            this.checkBIC((String)arrayList.get(0), ";");
            for (int i = 0; i < arrayList.size(); ++i) {
                ParserLineResult parserLineResult;
                String string = (String)arrayList.get(i);
                SEPADirectDebitTransaction sEPADirectDebitTransaction = this.parseLine(string, parserLineResult = new ParserLineResult(), ";", bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10);
                if (sEPADirectDebitTransaction != null) {
                    sEPADirectDebitTransaction.setAmount(sEPADirectDebitTransaction.getAmount().setScale(2));
                    sEPADirectDebitTransaction.setIBAN(sEPADirectDebitTransaction.getIBAN().toUpperCase());
                    if (bl && !bl10) {
                        sEPADirectDebitTransaction.setBIC(sEPADirectDebitTransaction.getBIC().toUpperCase());
                    }
                    if (bl2) {
                        sEPADirectDebitTransaction.setEnd2EndId(sEPADirectDebitTransaction.getEnd2EndId().toUpperCase());
                    }
                    if (bl4) {
                        sEPADirectDebitTransaction.setCountryCode(sEPADirectDebitTransaction.getCountryCode().toUpperCase());
                    }
                    ((SEPADirectDebit)object).getTransactionList().add(sEPADirectDebitTransaction);
                    this.parserResult.setSuccessfull(this.parserResult.getSuccessfull() + 1);
                    this.parserResult.setSum(this.parserResult.getSum().add(sEPADirectDebitTransaction.getAmount()));
                } else {
                    this.parserResult.setNotSuccessfull(this.parserResult.getNotSuccessfull() + 1);
                }
                this.parserResult.getLineResults().add(parserLineResult);
            }
            this.parserResult.setHeaderSuccessfull(true);
        }
        catch (Exception exception) {
            this.parserResult.setHeaderSuccessfull(false);
            this.parserResult.setHeaderMessage(exception.getMessage());
            this.logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        this.parserResult.setDirectDebit((SEPADirectDebit)object);
        return this.parserResult;
    }

    private void checkBIC(String string, String string2) {
        try {
            String[] stringArray = string.split(string2);
            String string3 = stringArray[2].replaceAll(" ", "");
            this.parserResult.setBICFound(ParserUtils.isBIC(string3));
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while checking if BIC exists.", exception);
        }
    }

    private SEPADirectDebitTransaction parseLine(String string, ParserLineResult parserLineResult, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) {
        SEPADirectDebitTransaction sEPADirectDebitTransaction = null;
        try {
            Comparable<Date> comparable;
            CSVDirectDebitValidator.validateCSVLine(string, string2, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10);
            sEPADirectDebitTransaction = new SEPADirectDebitTransaction();
            string = string.replaceAll("\"", "");
            string = string.replaceAll("'", "");
            String[] stringArray = string.split(string2);
            sEPADirectDebitTransaction.setKontoinhaber(ParserUtils.removeBOM(stringArray[0]));
            sEPADirectDebitTransaction.setIBAN(stringArray[1].replaceAll(" ", ""));
            if (bl && !bl10) {
                sEPADirectDebitTransaction.setBIC(stringArray[2].replaceAll(" ", ""));
            }
            if (!bl10) {
                sEPADirectDebitTransaction.setMandatsReferenzNr(stringArray[bl ? 3 : 2].replaceAll(" ", ""));
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
            try {
                comparable = simpleDateFormat.parse(stringArray[bl ? 4 : 3].replaceAll(" ", ""));
                gregorianCalendar.setTime((Date)comparable);
            }
            catch (ParseException parseException) {
                this.logger.log(Level.SEVERE, "Exception while Parsing date (SignatureDate): " + stringArray[4], parseException);
            }
            sEPADirectDebitTransaction.setSignatureDate(gregorianCalendar);
            sEPADirectDebitTransaction.setVerwendungszweck(stringArray[bl ? 5 : 4].replaceAll(string2, "").trim());
            sEPADirectDebitTransaction.setAmount(new BigDecimal(stringArray[bl ? 6 : 5].replaceAll(",", ".").trim()));
            if (bl2) {
                sEPADirectDebitTransaction.setEnd2EndId(stringArray[bl ? 7 : 6].replaceAll(" ", ""));
            }
            if (bl3) {
                sEPADirectDebitTransaction.setCurrency(stringArray[bl ? 8 : 7].replaceAll(" ", ""));
            }
            if (bl4) {
                sEPADirectDebitTransaction.setCountryCode(stringArray[bl ? 9 : 8].replaceAll(" ", ""));
                sEPADirectDebitTransaction.setAddressLine1(stringArray[bl ? 10 : 9]);
                sEPADirectDebitTransaction.setAddressLine2(stringArray[bl ? 11 : 10]);
            }
            if (bl5) {
                comparable = new GregorianCalendar();
                try {
                    Date date2 = simpleDateFormat.parse(stringArray[bl ? 12 : 11].replaceAll(" ", ""));
                    ((Calendar)comparable).setTime(date2);
                }
                catch (ParseException parseException) {
                    this.logger.log(Level.SEVERE, "Exception while Parsing date (SignatureDate): " + stringArray[4], parseException);
                }
                sEPADirectDebitTransaction.setCollectionDate((GregorianCalendar)comparable);
            }
            if (bl6) {
                sEPADirectDebitTransaction.setType(stringArray[bl ? 13 : 12].replaceAll(" ", ""));
            }
            if (bl7) {
                sEPADirectDebitTransaction.setKontoinhaber(SEPANormalizer.normalize(sEPADirectDebitTransaction.getKontoinhaber()));
                sEPADirectDebitTransaction.setVerwendungszweck(SEPANormalizer.normalize(sEPADirectDebitTransaction.getVerwendungszweck()));
                if (sEPADirectDebitTransaction.getAddressLine1() != null) {
                    sEPADirectDebitTransaction.setAddressLine1(SEPANormalizer.normalize(sEPADirectDebitTransaction.getAddressLine1()));
                }
                if (sEPADirectDebitTransaction.getAddressLine2() != null) {
                    sEPADirectDebitTransaction.setAddressLine2(SEPANormalizer.normalize(sEPADirectDebitTransaction.getAddressLine2()));
                }
            }
            parserLineResult.setSucessfull(true);
            parserLineResult.setLineMessage(ParserUtils.removeBOM(stringArray[0]) + ", " + stringArray[1].replaceAll(" ", "") + (!bl10 ? ", " + stringArray[2].replaceAll(" ", "") : "") + (!bl10 ? ", " + stringArray[3].replaceAll(" ", "") : "") + (!bl10 ? ", " + stringArray[4].replaceAll(" ", "") : "") + ", " + stringArray[5] + (bl ? ", " + stringArray[6].replaceAll(string2, "").trim() : "") + (bl2 ? ", " + stringArray[bl ? 7 : 6] : "") + (bl3 ? ", " + stringArray[bl ? 8 : 7] : "") + (bl4 ? ", " + stringArray[bl ? 9 : 8] + ", " + stringArray[bl ? 10 : 9] + ", " + stringArray[bl ? 11 : 10] : "") + (bl5 ? ", " + stringArray[bl ? 12 : 11] : "") + (bl6 ? ", " + stringArray[bl ? 13 : 12] : ""));
        }
        catch (ValidationException validationException) {
            parserLineResult.setSucessfull(false);
            parserLineResult.setLineMessage(validationException.getMessage() + (validationException.getNotValidatingValue() != null ? " (" + validationException.getNotValidatingValue() + ")" : ""));
            this.logger.log(Level.WARNING, parserLineResult.getLineMessage(), validationException);
        }
        catch (Exception exception) {
            parserLineResult.setSucessfull(false);
            parserLineResult.setLineMessage(exception.getMessage());
            this.logger.log(Level.WARNING, parserLineResult.getLineMessage(), exception);
        }
        return sEPADirectDebitTransaction;
    }
}

