/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.parser;

import com.codecamp.sepa.core.DirectDebitType;
import com.codecamp.sepa.core.SEPAValidator;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.parser.ValidationException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DirectDebitValidator
extends SEPAValidator {
    public static void validateLine(String string, String string2, String string3, String string4, Date date2, String string5, BigDecimal bigDecimal, String string6, String string7, String string8, String string9, String string10, GregorianCalendar gregorianCalendar, String string11, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) throws ValidationException {
        DirectDebitValidator.validateKontoinhaber(string, bl7, bl8, bl9);
        DirectDebitValidator.validateIBAN(string2, false);
        if (bl && !bl10) {
            DirectDebitValidator.validateBIC(string3);
        }
        if (!bl10) {
            DirectDebitValidator.validateMandatsReferenzNr(string4);
        }
        if (!bl10) {
            DirectDebitValidator.validateSignatureDate(date2);
        }
        DirectDebitValidator.validateVerwendungszweck(string5, bl7, bl8, bl9, false, false);
        DirectDebitValidator.validateAmount(bigDecimal);
        if (bl2) {
            DirectDebitValidator.validateIdText(string6);
        }
        if (bl3) {
            DirectDebitValidator.validateCurrency(string7);
        }
        if (bl4) {
            DirectDebitValidator.validateCountryCode(string8);
            DirectDebitValidator.validateAddressLine(string9, bl7, bl8, bl9);
            DirectDebitValidator.validateAddressLine(string10, bl7, bl8, bl9);
        }
        if (bl5) {
            DirectDebitValidator.validateExecutionsDate(gregorianCalendar);
        }
        if (bl6) {
            DirectDebitValidator.validateDDType(string11);
        }
    }

    protected static void validateDDType(String string) throws ValidationException {
        if (string == null || string.replace(" ", "").isEmpty() || DirectDebitType.getTypeFromString(string) == null) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.directDebitType.user.msg"), string);
        }
    }

    protected static void validateSignatureDate(Date date2) throws ValidationException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(14, 0);
        calendar2.set(13, 0);
        calendar2.set(12, 0);
        calendar2.set(10, 0);
        calendar2.set(5, 1);
        calendar2.set(2, 0);
        calendar2.set(1, 1950);
        if (date2 == null) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.signaturedate.user.msg"), date2);
        }
        if (!date2.before(calendar.getTime())) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.signaturedate.expired.user.msg"), date2);
        }
        if (date2.before(calendar2.getTime())) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.signaturedate.tooOld.user.msg"), date2);
        }
    }

    protected static void validateMandatsReferenzNr(String string) throws ValidationException {
        if (string == null || !string.replace(" ", "").matches("([A-Za-z0-9]|[\\+|\\?|/|\\-|:|\\(|\\)|\\.|,|']){1,35}")) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.mandatrefnr.user.msg"), string);
        }
    }
}

