/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui.verifier;

import com.codecamp.sepa.core.SEPAValidator;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.gui.ErrorMessages;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.gui.VerificationStateCallback;
import com.codecamp.sepa.gui.verifier.NotNullVerifier;
import com.codecamp.sepa.parser.ValidationException;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;

public class NotNullBICVerifier
extends NotNullVerifier {
    private boolean useClrSysIdAndMmbId;
    private boolean conditionalNotStrict;
    private boolean conditionalOptional;

    public NotNullBICVerifier(JComponent jComponent, FieldType fieldType, VerificationStateCallback verificationStateCallback, ErrorMessages errorMessages, boolean bl, boolean bl2, boolean bl3) {
        super(jComponent, fieldType, verificationStateCallback, errorMessages);
        this.useClrSysIdAndMmbId = bl;
        this.conditionalNotStrict = bl2;
        this.conditionalOptional = bl3;
    }

    @Override
    public boolean verify(JComponent jComponent) {
        boolean bl = super.verify(jComponent);
        if (bl) {
            try {
                if (!this.conditionalOptional) {
                    if (this.conditionalNotStrict) {
                        if (StringUtils.trimToNull(this.txt) == null) {
                            throw new ValidationException(ApplicationContext.get().text().getString("pleaseFillIn"), this.txt);
                        }
                    } else if (this.useClrSysIdAndMmbId) {
                        SEPAValidator.validateClrSysIdAndMmbId(this.txt);
                    } else {
                        SEPAValidator.validateBIC(this.txt);
                    }
                }
                this.resetMessage();
            }
            catch (ValidationException validationException) {
                this.setErrorMessage(validationException.getMessage());
                bl = false;
            }
        }
        this.callback.toggleVerificationState(this.fieldType, bl);
        return bl;
    }

    public boolean isUseClrSysIdAndMmbId() {
        return this.useClrSysIdAndMmbId;
    }

    public void setUseClrSysIdAndMmbId(boolean bl) {
        this.useClrSysIdAndMmbId = bl;
    }

    public boolean isConditionalNotStrict() {
        return this.conditionalNotStrict;
    }

    public void setConditionalNotStrict(boolean bl) {
        this.conditionalNotStrict = bl;
    }

    public boolean isConditionalOptional() {
        return this.conditionalOptional;
    }

    public void setConditionalOptional(boolean bl) {
        this.conditionalOptional = bl;
    }
}

