/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.gui.SEPAVerificationStateCallback;
import com.codecamp.sepa.gui.Styles;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;

public abstract class SepaTab
extends JPanel {
    public static final String LAST_OPEN_DIR = "last.open.dir";
    private static final long serialVersionUID = 1L;
    protected Logger logger = Logger.getLogger(SepaTab.class.getName());
    protected StyledDocument centerTextPanelDocument;
    protected Styles logPanelStyle;
    protected JButton downloadButton;

    public SepaTab(StyledDocument styledDocument, JButton jButton) {
        this.centerTextPanelDocument = styledDocument;
        this.downloadButton = jButton;
        this.logPanelStyle = new Styles(this.centerTextPanelDocument);
    }

    protected abstract void doSave(Path var1);

    protected abstract void doOpenFile(Path var1);

    public abstract SEPAVerificationStateCallback getDownloadButtonCallback();

    protected void doOpenFileDialog() {
        Object object;
        this.logger.finest("+doOpenFileDialog");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(ApplicationContext.get().text().getString("selectFile"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        SEPAPreferences sEPAPreferences = new SEPAPreferences();
        String string = sEPAPreferences.loadPreference(LAST_OPEN_DIR);
        if (string != null && ((File)(object = new File(string))).exists()) {
            jFileChooser.setCurrentDirectory((File)object);
        }
        object = new FileNameExtensionFilter(".xls, .xlsx, .csv, .ods", "csv", "xls", "xlsx", "ods");
        jFileChooser.addChoosableFileFilter((FileFilter)object);
        int n = jFileChooser.showDialog(null, ApplicationContext.get().text().getString("importFile"));
        switch (n) {
            case 0: {
                sEPAPreferences.savePreference(LAST_OPEN_DIR, jFileChooser.getCurrentDirectory().toString());
                this.doOpenFile(Paths.get(jFileChooser.getSelectedFile().getAbsolutePath(), new String[0]));
                break;
            }
            case 1: {
                this.logger.fine("Cancel pressed.");
                jFileChooser.setVisible(false);
                break;
            }
        }
        this.logger.finest("-doOpenFileDialog");
    }

    public StyledDocument getCenterTextPanelDocument() {
        return this.centerTextPanelDocument;
    }

    public void setCenterTextPanelDocument(StyledDocument styledDocument) {
        this.centerTextPanelDocument = styledDocument;
    }

    protected void writeLogLine(String string, Style style) throws BadLocationException {
        this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), string, style);
        if (!style.getName().contains("icon")) {
            this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "\n", style);
        }
    }

    public void addFirstSteps() {
        try {
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.step1"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.step2"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.step3"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.bicHint"), this.logPanelStyle.getIconWarningStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.bicHint"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
        }
        catch (BadLocationException badLocationException) {
            this.logger.log(Level.SEVERE, "Exception while printing log lines.", badLocationException);
        }
    }

    protected static JPopupMenu getCopyCutPasteMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        jMenuItem.setText(ApplicationContext.get().text().getString("cut"));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        jMenuItem.setText(ApplicationContext.get().text().getString("copy"));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        jMenuItem.setText(ApplicationContext.get().text().getString("paste"));
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public abstract JLabel getUploadLabel();

    public static String getFileChecksum(MessageDigest messageDigest, File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        fileInputStream.close();
        byte[] byArray2 = messageDigest.digest();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray2.length; ++i) {
            stringBuilder.append(Integer.toString((byArray2[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuilder.toString();
    }
}

