/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui;

import com.codecamp.sepa.SEPALogInitializer;
import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.CreditTransferSubformat;
import com.codecamp.sepa.core.DirectDebitKind;
import com.codecamp.sepa.core.DirectDebitSubformat;
import com.codecamp.sepa.core.ServiceLevel;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.gui.LastschriftenTab;
import com.codecamp.sepa.gui.SEPAAppCommandLine;
import com.codecamp.sepa.gui.SepaTab;
import com.codecamp.sepa.gui.UeberweisungenTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.lf5.util.StreamUtils;

public class SEPAApp {
    public static final String LAST_SAVE_DIR = "last.save.dir";
    private static final int LASTSCHRIFT_TAB_INDEX = 0;
    private static final int UEBERWEISUNG_TAB_INDEX = 1;
    public static final String LAST_TAB_KEY = "LAST_TAB_KEY";
    private static Logger logger;
    private JFrame frame;
    private JPanel northPanel;
    private JPanel southPanel;
    private final ImageIcon logo = new ImageIcon(this.getClass().getResource("SEPApp-Logo_SD_en.png"));
    private final ImageIcon lastschriftIcon = new ImageIcon(this.getClass().getResource("safe_into.png"));
    private final ImageIcon ueberweisungIcon = new ImageIcon(this.getClass().getResource("safe_out.png"));
    private JLabel logoContainer;
    private JPanel logoPanel;
    private JPanel centerWestPanel;
    private JPanel centerEastPanel;
    private JTabbedPane tabPanel;
    private UeberweisungenTab ueberweisungTab;
    private LastschriftenTab lastschriftenTab;
    protected JButton downloadBtn;
    protected JButton licenseBtn;
    protected JButton proLicenseBtn;
    protected JScrollPane centerScrollPanel;
    protected JTextPane centerTextPanel;
    private JPanel centerPanel;

    public static void main(String[] stringArray) throws SecurityException, IOException {
        SEPALogInitializer sEPALogInitializer = new SEPALogInitializer();
        sEPALogInitializer.initializeJavaLogging();
        Logger.getGlobal().info("Starting SEPAApp...");
        Logger.getGlobal().info("Version: " + ApplicationContext.get().getCurrentVersion());
        if (stringArray.length > 0) {
            SEPAAppCommandLine sEPAAppCommandLine = new SEPAAppCommandLine();
            sEPAAppCommandLine.doCommandLineInterface(stringArray);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SEPAApp sEPAApp = new SEPAApp();
                    sEPAApp.frame.setVisible(true);
                    SEPAPreferences sEPAPreferences = new SEPAPreferences();
                    if (!sEPAPreferences.hasValidLicense() && !sEPAPreferences.hasValidProLicense()) {
                        if (sEPAPreferences.hasEvaluationPeriodExpired()) {
                            JLabel jLabel = new JLabel();
                            JEditorPane jEditorPane = new JEditorPane("text/html", "<html><body>" + ApplicationContext.get().text().getString("exceededTestPhase") + "<br><span style=\"text-align: center;\">(<a href=\"" + ApplicationContext.get().text().getString("buyURL") + "\">" + ApplicationContext.get().text().getString("buyHint") + "</a>)</span></body></html>");
                            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                                @Override
                                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                                    if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                                        try {
                                            SEPAApp.openWebpage(new URL(ApplicationContext.get().text().getString("buyURL")).toURI());
                                        }
                                        catch (MalformedURLException | URISyntaxException exception) {
                                            logger.log(Level.WARNING, "Could not open connection to www.sepaapp.eu", exception);
                                        }
                                    }
                                }
                            });
                            jEditorPane.setEditable(false);
                            jEditorPane.setBackground(jLabel.getBackground());
                            String string = ApplicationContext.get().text().getString("enterLicenceKeyHeadline");
                            String string2 = SEPAApp.showInputDialog(sEPAApp.frame, jEditorPane, string);
                            if (string2 != null) {
                                if (sEPAPreferences.isValidLicense(string2)) {
                                    sEPAPreferences.saveLicense(string2);
                                    sEPAApp.licenseBtn.setEnabled(Boolean.FALSE);
                                } else if (sEPAPreferences.isValidProLicense(string2)) {
                                    sEPAPreferences.saveProLicense(string2);
                                    sEPAApp.licenseBtn.setEnabled(Boolean.FALSE);
                                    sEPAApp.proLicenseBtn.setEnabled(Boolean.FALSE);
                                } else {
                                    JOptionPane.showMessageDialog(null, ApplicationContext.get().text().getString("licenceInvalid"));
                                    System.exit(0);
                                }
                            } else {
                                System.exit(0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(sEPAApp.frame, MessageFormat.format(ApplicationContext.get().text().getString("exceededTestPhaseInXDays"), sEPAPreferences.daysLeftUntilEvaluationPeriodExceeds()));
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getGlobal().log(Level.SEVERE, "Exception while initializing SEPAApp GUI.", exception);
                    System.exit(0);
                }
            }
        });
    }

    private void isUpdateAvailable() {
        try {
            URL uRL = new URL("https://www.sepaapp.eu/sepaapp_version");
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            String string = new String(StreamUtils.getBytes(inputStream)).replaceAll("\n", "");
            inputStream.close();
            ApplicationContext.get().setAvailableVersion(string);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "No Internet Connection available. Can't look for updates.", exception);
        }
    }

    public SEPAApp() {
        logger = Logger.getLogger(SEPAApp.class.getName());
        this.isUpdateAvailable();
        this.cleanUpPreferences();
        this.initialize();
    }

    private void cleanUpPreferences() {
        SEPAPreferences sEPAPreferences = new SEPAPreferences();
        if (sEPAPreferences.loadPreference("CAT_PUP_SUPP_UEBERWEISUNG") != null && sEPAPreferences.loadPreference("CAT_PUP_SUPP_UEBERWEISUNG").equals("true")) {
            sEPAPreferences.savePreference(FieldType.CATEGORY_PURPOSE_UEBERWEISUNG.name(), CategoryPurpose.SUPP.name());
        }
        sEPAPreferences.removePreference("CAT_PUP_SUPP_UEBERWEISUNG");
        if (sEPAPreferences.loadPreference("USE001_LASTSCHRIFT") != null && sEPAPreferences.loadPreference("USE001_LASTSCHRIFT").equals("true")) {
            sEPAPreferences.savePreference(FieldType.SUBFORMAT_LASTSCHRIFT.name(), DirectDebitSubformat.PAIN_008_001_02.name());
        }
        sEPAPreferences.removePreference("USE001_LASTSCHRIFT");
        if (sEPAPreferences.loadPreference("USE003_LASTSCHRIFT") != null && sEPAPreferences.loadPreference("USE003_LASTSCHRIFT").equals("true")) {
            sEPAPreferences.savePreference(FieldType.SUBFORMAT_LASTSCHRIFT.name(), DirectDebitSubformat.PAIN_008_003_02.name());
        }
        sEPAPreferences.removePreference("USE003_LASTSCHRIFT");
        if (sEPAPreferences.loadPreference("USE001_UEBERWEISUNG") != null && sEPAPreferences.loadPreference("USE001_UEBERWEISUNG").equals("true")) {
            sEPAPreferences.savePreference(FieldType.SUBFORMAT_UEBERWEISUNG.name(), CreditTransferSubformat.PAIN_001_001_03.name());
        }
        sEPAPreferences.removePreference("USE001_UEBERWEISUNG");
        if (sEPAPreferences.loadPreference("USE003_UEBERWEISUNG") != null && sEPAPreferences.loadPreference("USE003_UEBERWEISUNG").equals("true")) {
            sEPAPreferences.savePreference(FieldType.SUBFORMAT_UEBERWEISUNG.name(), CreditTransferSubformat.PAIN_001_003_03.name());
        }
        sEPAPreferences.removePreference("USE003_UEBERWEISUNG");
        if (sEPAPreferences.loadPreference("OPTIONS_LASTSCHRIFT") != null) {
            sEPAPreferences.removePreference("OPTIONS_LASTSCHRIFT");
        }
        if (sEPAPreferences.loadPreference("OPTIONS_UEBERWEISUNG") != null) {
            sEPAPreferences.removePreference("OPTIONS_UEBERWEISUNG");
        }
        if (sEPAPreferences.loadPreference("CORE_LASTSCHRIFT") != null && sEPAPreferences.loadPreference("CORE_LASTSCHRIFT").equals("true")) {
            sEPAPreferences.savePreference(FieldType.ART_LASTSCHRIFT.name(), DirectDebitKind.CORE.name());
        }
        sEPAPreferences.removePreference("CORE_LASTSCHRIFT");
        if (sEPAPreferences.loadPreference("COR1_LASTSCHRIFT") != null && sEPAPreferences.loadPreference("COR1_LASTSCHRIFT").equals("true")) {
            sEPAPreferences.savePreference(FieldType.ART_LASTSCHRIFT.name(), DirectDebitKind.COR1.name());
        }
        sEPAPreferences.removePreference("COR1_LASTSCHRIFT");
        if (sEPAPreferences.loadPreference("B2B_LASTSCHRIFT") != null && sEPAPreferences.loadPreference("B2B_LASTSCHRIFT").equals("true")) {
            sEPAPreferences.savePreference(FieldType.ART_LASTSCHRIFT.name(), DirectDebitKind.B2B.name());
        }
        sEPAPreferences.removePreference("B2B_LASTSCHRIFT");
        if (sEPAPreferences.loadPreference("CHRGB_SLEV_UEBERWEISUNG") != null && sEPAPreferences.loadPreference("CHRGB_SLEV_UEBERWEISUNG").equals("true") && (sEPAPreferences.loadPreference(FieldType.CHARGEBEARER_UEBERWEISUNG.name()) == null || sEPAPreferences.loadPreference(FieldType.CHARGEBEARER_UEBERWEISUNG.name()).equals(ChargeBearer.EMPTY.name()))) {
            sEPAPreferences.savePreference(FieldType.CHARGEBEARER_UEBERWEISUNG.name(), ChargeBearer.SLEV.name());
        }
        sEPAPreferences.removePreference("CHRGB_SLEV_UEBERWEISUNG");
        if (sEPAPreferences.loadPreference("CHRGB_SLEV_LASTSCHRIFT") != null && sEPAPreferences.loadPreference("CHRGB_SLEV_LASTSCHRIFT").equals("true") && (sEPAPreferences.loadPreference(FieldType.CHARGEBEARER_LASTSCHRIFT.name()) == null || sEPAPreferences.loadPreference(FieldType.CHARGEBEARER_LASTSCHRIFT.name()).equals(ChargeBearer.EMPTY.name()))) {
            sEPAPreferences.savePreference(FieldType.CHARGEBEARER_LASTSCHRIFT.name(), ChargeBearer.SLEV.name());
        }
        sEPAPreferences.removePreference("CHRGB_SLEV_LASTSCHRIFT");
        if (sEPAPreferences.loadPreference("BATCH_BOOKING_UEBERWEISUNG") != null && sEPAPreferences.loadPreference("BATCH_BOOKING_UEBERWEISUNG").equals("true") && sEPAPreferences.loadPreference("BATCH_BOOKING_TRUE_EXPLICIT_UEBERWEISUNG") != null && sEPAPreferences.loadPreference("BATCH_BOOKING_TRUE_EXPLICIT_UEBERWEISUNG").equals("true")) {
            sEPAPreferences.savePreference(FieldType.BATCH_BOOKING_SELECT_UEBERWEISUNG.name(), BatchBooking.YES.name());
        }
        if (sEPAPreferences.loadPreference("BATCH_BOOKING_UEBERWEISUNG") != null && sEPAPreferences.loadPreference("BATCH_BOOKING_UEBERWEISUNG").equals("false")) {
            sEPAPreferences.savePreference(FieldType.BATCH_BOOKING_SELECT_UEBERWEISUNG.name(), BatchBooking.NO.name());
        }
        sEPAPreferences.removePreference("BATCH_BOOKING_UEBERWEISUNG");
        sEPAPreferences.removePreference("BATCH_BOOKING_TRUE_EXPLICIT_UEBERWEISUNG");
        if (sEPAPreferences.loadPreference("BATCH_BOOKING_LASTSCHRIFT") != null && sEPAPreferences.loadPreference("BATCH_BOOKING_LASTSCHRIFT").equals("true") && sEPAPreferences.loadPreference("BATCH_BOOKING_TRUE_EXPLICIT_LASTSCHRIFT") != null && sEPAPreferences.loadPreference("BATCH_BOOKING_TRUE_EXPLICIT_LASTSCHRIFT").equals("true")) {
            sEPAPreferences.savePreference(FieldType.BATCH_BOOKING_SELECT_LASTSCHRIFT.name(), BatchBooking.YES.name());
        }
        if (sEPAPreferences.loadPreference("BATCH_BOOKING_LASTSCHRIFT") != null && sEPAPreferences.loadPreference("BATCH_BOOKING_LASTSCHRIFT").equals("false")) {
            sEPAPreferences.savePreference(FieldType.BATCH_BOOKING_SELECT_LASTSCHRIFT.name(), BatchBooking.NO.name());
        }
        sEPAPreferences.removePreference("BATCH_BOOKING_LASTSCHRIFT");
        sEPAPreferences.removePreference("BATCH_BOOKING_TRUE_EXPLICIT_LASTSCHRIFT");
        if (sEPAPreferences.loadPreference("USE_URGP_UEBERWEISUNG") != null && sEPAPreferences.loadPreference("USE_URGP_UEBERWEISUNG").equals("true") && sEPAPreferences.loadPreference(FieldType.FAST_CREDIT_TRANSFER_UEBERWEISUNG.name()) != null && sEPAPreferences.loadPreference(FieldType.FAST_CREDIT_TRANSFER_UEBERWEISUNG.name()).equals("true") && sEPAPreferences.loadPreference(FieldType.USE_BANKGIRO_UEBERWEISUNG.name()) != null && sEPAPreferences.loadPreference(FieldType.USE_BANKGIRO_UEBERWEISUNG.name()).equals("false") && sEPAPreferences.loadPreference(FieldType.SPLIT_PAYMENT_UEBERWEISUNG.name()) != null && sEPAPreferences.loadPreference(FieldType.SPLIT_PAYMENT_UEBERWEISUNG.name()).equals("false")) {
            sEPAPreferences.savePreference(FieldType.SERVICE_LEVEL_UEBERWEISUNG.name(), ServiceLevel.URGP.name());
        }
        sEPAPreferences.removePreference("USE_URGP_UEBERWEISUNG");
        if (sEPAPreferences.loadPreference("SET_SERVICE_LEVEL_SEPA_UEBERWEISUNG") != null && sEPAPreferences.loadPreference("SET_SERVICE_LEVEL_SEPA_UEBERWEISUNG").equals("true")) {
            if (sEPAPreferences.loadPreference(FieldType.USE_BANKGIRO_UEBERWEISUNG.name()) != null && sEPAPreferences.loadPreference(FieldType.USE_BANKGIRO_UEBERWEISUNG.name()).equals("true")) {
                sEPAPreferences.savePreference(FieldType.SERVICE_LEVEL_UEBERWEISUNG.name(), ServiceLevel.MPNS.name());
            } else if (sEPAPreferences.loadPreference(FieldType.SPLIT_PAYMENT_UEBERWEISUNG.name()) != null && sEPAPreferences.loadPreference(FieldType.SPLIT_PAYMENT_UEBERWEISUNG.name()).equals("true")) {
                sEPAPreferences.savePreference(FieldType.SERVICE_LEVEL_UEBERWEISUNG.name(), ServiceLevel.NORM.name());
            } else {
                sEPAPreferences.savePreference(FieldType.SERVICE_LEVEL_UEBERWEISUNG.name(), ServiceLevel.SEPA.name());
            }
        }
        sEPAPreferences.removePreference("SET_SERVICE_LEVEL_SEPA_UEBERWEISUNG");
        String string = sEPAPreferences.loadPreference(FieldType.SERVICE_LEVEL_UEBERWEISUNG.name());
        if (string != null) {
            ServiceLevel[] serviceLevelArray = ServiceLevel.values();
            boolean bl = false;
            for (ServiceLevel serviceLevel : serviceLevelArray) {
                if (!serviceLevel.name().equals(string)) continue;
                bl = true;
            }
            if (!bl) {
                sEPAPreferences.savePreference(FieldType.SERVICE_LEVEL_UEBERWEISUNG.name(), ServiceLevel.SEPA.name());
            }
        }
        if (sEPAPreferences.loadPreference("CATEGORY_PURP_ON_TRX_LEVEL_UEBERWEISUNG") != null && sEPAPreferences.loadPreference("CATEGORY_PURP_ON_TRX_LEVEL_UEBERWEISUNG").equals("true")) {
            sEPAPreferences.savePreference(FieldType.PAYMENT_TYPE_INFORMATION_ON_TRX_LEVEL_UEBERWEISUNG.name(), "true");
        }
        sEPAPreferences.removePreference("CATEGORY_PURP_ON_TRX_LEVEL_UEBERWEISUNG");
    }

    private void initialize() {
        this.frame = new JFrame("SEPAApp");
        this.frame.setBounds(100, 100, 1024, 768);
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout(0, 0));
        Image image = new ImageIcon(this.getClass().getResource("sepaapp_favicon.png")).getImage();
        this.frame.setIconImage(image);
        this.frame.setLocation(0, 0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width < 1152 || dimension.height < 803) {
            this.frame.setExtendedState(6);
        }
        this.initNorthPanel();
        this.initSouthPanel();
        this.initCenterPanel();
        this.centerWestPanel = new JPanel();
        this.frame.getContentPane().add((Component)this.centerWestPanel, "West");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{10, 0};
        gridBagLayout.rowHeights = new int[]{39, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.centerWestPanel.setLayout(gridBagLayout);
        this.centerEastPanel = new JPanel();
        this.frame.getContentPane().add((Component)this.centerEastPanel, "East");
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout2.columnWidths = new int[]{10, 0};
        gridBagLayout2.rowHeights = new int[]{39, 0};
        gridBagLayout2.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.centerEastPanel.setLayout(gridBagLayout2);
    }

    public static void openWebpage(URI uRI) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uRI);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Could not open webpage.", exception);
            }
        }
    }

    protected void initSouthPanel() {
        this.southPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                int n = this.getWidth();
                int n2 = this.getHeight();
                Color color = new Color(18, 113, 179);
                Color color2 = new Color(18, 113, 179);
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, 0.0f, n2, color);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, n, n2);
            }
        };
        this.frame.getContentPane().add((Component)this.southPanel, "South");
        this.downloadBtn = new JButton(ApplicationContext.get().text().getString("downloadSepaFile"));
        this.downloadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SEPAApp.this.doSaveDialog();
            }
        });
        this.downloadBtn.setEnabled(Boolean.FALSE);
        this.downloadBtn.setToolTipText(ApplicationContext.get().text().getString("buttonHint"));
        this.southPanel.add(this.downloadBtn);
        SEPAPreferences sEPAPreferences = new SEPAPreferences();
        this.licenseBtn = new JButton(ApplicationContext.get().text().getString("enterLicenceKey"));
        this.licenseBtn.setToolTipText(sEPAPreferences.hasValidLicense() ? sEPAPreferences.getLicense() : "-");
        this.licenseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SEPAApp.this.licenseBtn.isEnabled()) {
                    SEPAApp.this.doLicenseDialog();
                }
            }
        });
        this.southPanel.add(this.licenseBtn);
        this.licenseBtn.setEnabled(!sEPAPreferences.hasValidLicense() && !sEPAPreferences.hasValidProLicense());
        this.proLicenseBtn = new JButton(ApplicationContext.get().text().getString("enterProLicenceKey"));
        this.proLicenseBtn.setToolTipText(sEPAPreferences.hasValidProLicense() ? sEPAPreferences.getProLicense() : "-");
        this.proLicenseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SEPAApp.this.proLicenseBtn.isEnabled()) {
                    SEPAApp.this.doProLicenseDialog();
                }
            }
        });
        this.southPanel.add(this.proLicenseBtn);
        this.proLicenseBtn.setEnabled(!sEPAPreferences.hasValidProLicense());
        String string = ApplicationContext.get().text().getString("sepaappVersion") + " " + ApplicationContext.get().getCurrentVersion() + (sEPAPreferences.hasValidProLicense() ? " Pro" : "");
        JLabel jLabel = new JLabel(string);
        this.southPanel.add(jLabel);
        if (ApplicationContext.get().getAvailableVersion() != null && !ApplicationContext.get().getCurrentVersion().equals(ApplicationContext.get().getAvailableVersion())) {
            logger.info("Version local: '" + ApplicationContext.get().getCurrentVersion() + "'");
            logger.info("Version remote: '" + ApplicationContext.get().getAvailableVersion() + "'");
            JButton jButton = new JButton(MessageFormat.format(ApplicationContext.get().text().getString("updateAvailabe"), ApplicationContext.get().getAvailableVersion()));
            jButton.setIcon(new ImageIcon(this.getClass().getResource("led_green.png")));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SEPAApp.openWebpage(new URL(ApplicationContext.get().text().getString("downloadURL")).toURI());
                    }
                    catch (MalformedURLException | URISyntaxException exception) {
                        logger.log(Level.WARNING, "Could not open connection to www.sepaapp.eu", exception);
                    }
                }
            });
            this.southPanel.add(jButton);
        }
    }

    protected void initCenterPanel() {
        final SEPAPreferences sEPAPreferences = new SEPAPreferences();
        this.centerTextPanel = new JTextPane();
        this.centerTextPanel.setMargin(new Insets(4, 4, 4, 4));
        this.centerTextPanel.setEditable(false);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.frame.getContentPane().add((Component)this.centerPanel, "Center");
        this.tabPanel = new JTabbedPane(1);
        this.lastschriftenTab = new LastschriftenTab(this.centerTextPanel.getStyledDocument(), this.downloadBtn);
        JScrollPane jScrollPane = new JScrollPane(this.lastschriftenTab, 20, 30);
        this.tabPanel.addTab(ApplicationContext.get().text().getString("lastschriften"), this.lastschriftIcon, jScrollPane, null);
        this.ueberweisungTab = new UeberweisungenTab(this.centerTextPanel.getStyledDocument(), this.downloadBtn);
        JScrollPane jScrollPane2 = new JScrollPane(this.ueberweisungTab, 20, 30);
        this.tabPanel.addTab(ApplicationContext.get().text().getString("ueberweisungen"), this.ueberweisungIcon, jScrollPane2, null);
        this.tabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                SepaTab sepaTab = SEPAApp.this.getSelectedSepaTab(jTabbedPane);
                sepaTab.getDownloadButtonCallback().refreshVerification();
                sEPAPreferences.savePreference(SEPAApp.LAST_TAB_KEY, String.valueOf(jTabbedPane.getSelectedIndex()));
            }
        });
        this.tabPanel.setMinimumSize(new Dimension(1000, 430));
        this.tabPanel.setMaximumSize(new Dimension(1000, 430));
        this.centerPanel.add(this.tabPanel);
        this.centerScrollPanel = new JScrollPane(this.centerTextPanel);
        this.centerScrollPanel.setMinimumSize(new Dimension(1000, 170));
        this.centerScrollPanel.setMaximumSize(new Dimension(1000, 170));
        this.centerPanel.add(this.centerScrollPanel);
        String string = sEPAPreferences.loadPreference(LAST_TAB_KEY);
        int n = 0;
        if (string != null && !string.isEmpty()) {
            n = Integer.valueOf(string);
        }
        this.tabPanel.setSelectedIndex(n);
        SepaTab sepaTab = this.getSelectedSepaTab(this.tabPanel);
        sepaTab.addFirstSteps();
    }

    protected void initNorthPanel() {
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new BoxLayout(this.northPanel, 3));
        this.logoPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                int n = this.getWidth();
                int n2 = this.getHeight();
                Color color = new Color(238, 238, 238);
                Color color2 = new Color(238, 238, 238);
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, n2, color2);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, n, n2);
            }
        };
        this.northPanel.add(this.logoPanel);
        this.logoContainer = new JLabel(this.logo);
        this.logoContainer.setBackground(Color.WHITE);
        this.logoContainer.setCursor(new Cursor(12));
        this.logoContainer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                try {
                    SEPAApp.openWebpage(new URL(ApplicationContext.get().text().getString("defaultURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    logger.log(Level.WARNING, "Could not open connection to www.sepaapp.eu", exception);
                }
            }
        });
        this.logoPanel.add(this.logoContainer);
        this.logoContainer.setText("");
        this.frame.getContentPane().add((Component)this.northPanel, "North");
    }

    protected void doLicenseDialog() {
        logger.finest("+doLicenseDialog");
        SEPAPreferences sEPAPreferences = new SEPAPreferences();
        String string = ApplicationContext.get().text().getString("enterLicenceKeyHeadline");
        String string2 = SEPAApp.showInputDialog(null, string);
        if (string2 != null) {
            if (sEPAPreferences.isValidLicense(string2)) {
                sEPAPreferences.saveLicense(string2);
                this.licenseBtn.setEnabled(Boolean.FALSE);
            } else {
                JOptionPane.showMessageDialog(null, ApplicationContext.get().text().getString("licenceInvalid"));
            }
        }
        logger.finest("-doLicenseDialog");
    }

    protected void doProLicenseDialog() {
        logger.finest("+doProLicenseDialog");
        SEPAPreferences sEPAPreferences = new SEPAPreferences();
        String string = ApplicationContext.get().text().getString("enterProLicenceKeyHeadline");
        String string2 = SEPAApp.showInputDialog(null, string);
        if (string2 != null) {
            if (sEPAPreferences.isValidProLicense(string2)) {
                sEPAPreferences.saveProLicense(string2);
                this.proLicenseBtn.setEnabled(Boolean.FALSE);
            } else {
                JOptionPane.showMessageDialog(null, ApplicationContext.get().text().getString("proLicenceInvalid"));
            }
        }
        logger.finest("-doProLicenseDialog");
    }

    protected void doSaveDialog() {
        Object object;
        logger.finest("+doSaveDialog");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(ApplicationContext.get().text().getString("saveAs"));
        SEPAPreferences sEPAPreferences = new SEPAPreferences();
        String string = sEPAPreferences.loadPreference(LAST_SAVE_DIR);
        if (string != null && ((File)(object = new File(string))).exists()) {
            jFileChooser.setCurrentDirectory((File)object);
        }
        object = new FileNameExtensionFilter("xml", "xml");
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.setFileFilter((FileFilter)object);
        SepaTab sepaTab = this.getSelectedSepaTab(this.tabPanel);
        String string2 = sepaTab.getUploadLabel().getText();
        String string3 = string2.substring(0, string2.lastIndexOf(46));
        File file = new File(string3);
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showDialog(null, ApplicationContext.get().text().getString("saveFile"));
        switch (n) {
            case 0: {
                sEPAPreferences.savePreference(LAST_SAVE_DIR, jFileChooser.getCurrentDirectory().toString());
                sepaTab.doSave(Paths.get(jFileChooser.getSelectedFile().getAbsolutePath(), new String[0]));
                break;
            }
            case 1: {
                jFileChooser.setVisible(false);
                logger.fine("cancel pressed.");
                break;
            }
        }
        logger.finest("-doSaveDialog");
    }

    private SepaTab getSelectedSepaTab(JTabbedPane jTabbedPane) {
        switch (jTabbedPane.getSelectedIndex()) {
            case 0: {
                return this.lastschriftenTab;
            }
            case 1: {
                return this.ueberweisungTab;
            }
        }
        return null;
    }

    public static String showInputDialog(Component component, String string) {
        JTextField jTextField = new JTextField();
        jTextField.setComponentPopupMenu(SepaTab.getCopyCutPasteMenu());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0);
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jTextField, gridBagConstraints);
        int n = JOptionPane.showConfirmDialog(component, jPanel, string, 2, -1);
        if (n == 0) {
            return jTextField.getText();
        }
        return null;
    }

    protected static String showInputDialog(Component component, JEditorPane jEditorPane, String string) {
        JTextField jTextField = new JTextField();
        jTextField.setComponentPopupMenu(SepaTab.getCopyCutPasteMenu());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0);
        jPanel.add((Component)jEditorPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jTextField, gridBagConstraints);
        int n = JOptionPane.showConfirmDialog(component, jPanel, string, 2, -1);
        if (n == 0) {
            return jTextField.getText();
        }
        return null;
    }
}

