/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.DirectDebitKind;
import com.codecamp.sepa.core.DirectDebitSubformat;
import com.codecamp.sepa.core.DirectDebitType;
import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPAWriter;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.gui.DebitParser;
import com.codecamp.sepa.gui.DirectDebitParserFactory;
import com.codecamp.sepa.gui.ErrorMessages;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.gui.LastschriftAccountDialog;
import com.codecamp.sepa.gui.LastschriftVerificationStateCallback;
import com.codecamp.sepa.gui.LastschriftenOptionsDialog;
import com.codecamp.sepa.gui.SEPAApp;
import com.codecamp.sepa.gui.SEPAVerificationStateCallback;
import com.codecamp.sepa.gui.SepaTab;
import com.codecamp.sepa.gui.verifier.NotNullBICVerifier;
import com.codecamp.sepa.gui.verifier.NotNullDateTodayOrInFutureVerifier;
import com.codecamp.sepa.gui.verifier.NotNullGlaeubigerIdVerifier;
import com.codecamp.sepa.gui.verifier.NotNullIBANVerifier;
import com.codecamp.sepa.gui.verifier.NotNullKontoinhaberVerifier;
import com.codecamp.sepa.gui.verifier.SaveOnlyVerifier;
import com.codecamp.sepa.gui.verifier.TypedSaveOnlyVerifier;
import com.codecamp.sepa.parser.ParserLineResult;
import com.codecamp.sepa.parser.ParserResult;
import com.codecamp.sepa.parser.ParserUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang3.StringUtils;

public class LastschriftenTab
extends SepaTab {
    private static final long serialVersionUID = 1L;
    private final JLabel uploadLabel = new JLabel(ApplicationContext.get().text().getString("noFileSelected"));
    private JButton uploadBtn;
    private JLabel kontoinhaberLabel;
    private JTextField kontoinhaberField;
    private JLabel ibanLabel;
    private JTextField ibanField;
    private JLabel bicLabel;
    private JTextField bicField;
    private JLabel glaeubigerIdLabel;
    private JTextField glaeubigerIdField;
    private JLabel abbuchungsdatumLabel;
    private JTextField abbuchungsdatumField;
    private JLabel lastschriftTypLabel;
    private JComboBox<DirectDebitType> lastschriftTypCombo;
    private JLabel lastschriftArtLabel;
    private JComboBox<DirectDebitKind> lastschriftArtCombo;
    private JLabel importBICLabel;
    private JCheckBox importBICCheckbox;
    private JLabel subformatLabel;
    private JComboBox<DirectDebitSubformat> subformatComboBox;
    private SEPADirectDebit debit;
    private ErrorMessages errorMessages;
    private JLabel errorLabel;
    private JButton optionsButton;
    private JButton openAccountDialog;
    private JButton openManual;
    private JButton openFAQ;
    private JButton openSupportEMail;
    private NotNullBICVerifier bicVerifier;
    private NotNullGlaeubigerIdVerifier glaeubigeridVerifier;
    private final LastschriftVerificationStateCallback callback = new LastschriftVerificationStateCallback(this.downloadButton);
    SEPAPreferences preferences = new SEPAPreferences();

    public LastschriftenTab(StyledDocument styledDocument, JButton jButton) {
        super(styledDocument, jButton);
        this.init();
    }

    private void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{28, 28, 28, 28, 0};
        gridBagLayout.rowHeights = new int[]{28, 28, 28, 28, 0, 28, 28, 28};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.setLayout(gridBagLayout);
        this.kontoinhaberLabel = new JLabel(ApplicationContext.get().text().getString("accountHolder"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.kontoinhaberLabel, gridBagConstraints);
        this.kontoinhaberField = new JTextField();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        this.add((Component)this.kontoinhaberField, gridBagConstraints2);
        this.kontoinhaberField.setColumns(10);
        this.kontoinhaberField.setText(this.preferences.loadPreference(FieldType.KONTOINHABER_LASTSCHRIFT.name()));
        this.kontoinhaberField.setComponentPopupMenu(LastschriftenTab.getCopyCutPasteMenu());
        this.openAccountDialog = new JButton(ApplicationContext.get().text().getString("lastschriftenTab.openAccountDialog"));
        this.openAccountDialog.setToolTipText(ApplicationContext.get().text().getString("lastschriftenTab.chooseAccountDialogTooltip"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.gridy = 0;
        this.add((Component)this.openAccountDialog, gridBagConstraints3);
        this.openAccountDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new LastschriftAccountDialog(LastschriftenTab.this.kontoinhaberField, LastschriftenTab.this.ibanField, LastschriftenTab.this.bicField, LastschriftenTab.this.glaeubigerIdField);
                LastschriftenTab.this.kontoinhaberField.getInputVerifier().verify(LastschriftenTab.this.kontoinhaberField);
                LastschriftenTab.this.ibanField.getInputVerifier().verify(LastschriftenTab.this.ibanField);
                LastschriftenTab.this.bicField.getInputVerifier().verify(LastschriftenTab.this.bicField);
                LastschriftenTab.this.glaeubigerIdField.getInputVerifier().verify(LastschriftenTab.this.glaeubigerIdField);
            }
        });
        this.ibanLabel = new JLabel("IBAN");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        this.add((Component)this.ibanLabel, gridBagConstraints4);
        this.ibanField = new JTextField();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 11;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 1;
        this.add((Component)this.ibanField, gridBagConstraints5);
        this.ibanField.setColumns(10);
        this.ibanField.setText(this.preferences.loadPreference(FieldType.IBAN_LASTSCHRIFT.name()));
        this.ibanField.setComponentPopupMenu(LastschriftenTab.getCopyCutPasteMenu());
        this.bicLabel = new JLabel("BIC");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.anchor = 13;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 2;
        this.add((Component)this.bicLabel, gridBagConstraints6);
        this.bicField = new JTextField();
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 11;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints7.gridx = 2;
        gridBagConstraints7.gridy = 2;
        this.add((Component)this.bicField, gridBagConstraints7);
        this.bicField.setColumns(10);
        this.bicField.setText(this.preferences.loadPreference(FieldType.BIC_LASTSCHRIFT.name()));
        this.bicField.setComponentPopupMenu(LastschriftenTab.getCopyCutPasteMenu());
        this.glaeubigerIdLabel = new JLabel(ApplicationContext.get().text().getString("lastschriftenTab.glaeubigerId"));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.anchor = 13;
        gridBagConstraints8.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 3;
        this.add((Component)this.glaeubigerIdLabel, gridBagConstraints8);
        this.glaeubigerIdField = new JTextField();
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.anchor = 11;
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints9.gridx = 2;
        gridBagConstraints9.gridy = 3;
        this.add((Component)this.glaeubigerIdField, gridBagConstraints9);
        this.glaeubigerIdField.setColumns(10);
        this.glaeubigerIdField.setText(this.preferences.loadPreference(FieldType.GLAEUBIGERID_LASTSCHRIFT.name()));
        this.glaeubigerIdField.setComponentPopupMenu(LastschriftenTab.getCopyCutPasteMenu());
        this.abbuchungsdatumLabel = new JLabel(ApplicationContext.get().text().getString("lastschriftenTab.abbuchungsdatum"));
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.anchor = 13;
        gridBagConstraints10.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.gridy = 4;
        this.add((Component)this.abbuchungsdatumLabel, gridBagConstraints10);
        this.abbuchungsdatumField = new JTextField();
        this.abbuchungsdatumField.setToolTipText(ApplicationContext.get().text().getString("lastschriftenTab.abbuchungsdatum.tooltip"));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 11;
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints11.gridx = 2;
        gridBagConstraints11.gridy = 4;
        this.add((Component)this.abbuchungsdatumField, gridBagConstraints11);
        this.abbuchungsdatumField.setColumns(10);
        this.abbuchungsdatumField.setText(this.preferences.loadPreference(FieldType.ABBUCHUNGSDATUM_LASTSCHRIFT.name()));
        this.abbuchungsdatumField.setComponentPopupMenu(LastschriftenTab.getCopyCutPasteMenu());
        this.lastschriftTypLabel = new JLabel(ApplicationContext.get().text().getString("lastschriftenTab.lastschriftTyp"));
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.anchor = 13;
        gridBagConstraints12.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints12.gridx = 1;
        gridBagConstraints12.gridy = 5;
        this.add((Component)this.lastschriftTypLabel, gridBagConstraints12);
        DirectDebitType[] directDebitTypeArray = new DirectDebitType[]{DirectDebitType.EINMAL, DirectDebitType.ERST, DirectDebitType.FOLGE, DirectDebitType.LETZT};
        this.lastschriftTypCombo = new JComboBox<DirectDebitType>(directDebitTypeArray);
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.anchor = 11;
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints13.gridx = 2;
        gridBagConstraints13.gridy = 5;
        this.add(this.lastschriftTypCombo, gridBagConstraints13);
        String string = this.preferences.loadPreference(FieldType.TYP_LASTSCHRIFT.name());
        this.lastschriftTypCombo.setSelectedItem((Object)(string != null ? DirectDebitType.valueOf(string) : DirectDebitType.EINMAL));
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.anchor = 13;
        gridBagConstraints14.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints14.gridx = 1;
        gridBagConstraints14.gridy = 6;
        this.add((Component)this.uploadLabel, gridBagConstraints14);
        this.uploadBtn = new JButton(ApplicationContext.get().text().getString("selectFile"));
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.anchor = 18;
        gridBagConstraints15.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints15.gridx = 2;
        gridBagConstraints15.gridy = 6;
        this.add((Component)this.uploadBtn, gridBagConstraints15);
        this.uploadBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                LastschriftenTab.this.doOpenFileDialog();
            }
        });
        this.importBICLabel = new JLabel(ApplicationContext.get().text().getString("lastschriftenTab.noBIC"));
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.anchor = 13;
        gridBagConstraints16.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints16.gridx = 1;
        gridBagConstraints16.gridy = 7;
        this.add((Component)this.importBICLabel, gridBagConstraints16);
        this.importBICCheckbox = new JCheckBox();
        this.importBICCheckbox.setSelected(this.preferences.loadPreference(FieldType.IMPORTBIC_LASTSCHRIFT.name(), false));
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints17.fill = 2;
        gridBagConstraints17.gridx = 2;
        gridBagConstraints17.gridy = 7;
        this.add((Component)this.importBICCheckbox, gridBagConstraints17);
        this.lastschriftArtLabel = new JLabel(ApplicationContext.get().text().getString("lastschriftenTab.lastschriftArt"));
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.anchor = 13;
        gridBagConstraints18.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints18.gridx = 1;
        gridBagConstraints18.gridy = 8;
        this.add((Component)this.lastschriftArtLabel, gridBagConstraints18);
        DirectDebitKind[] directDebitKindArray = new DirectDebitKind[]{DirectDebitKind.CORE, DirectDebitKind.COR1, DirectDebitKind.B2B};
        this.lastschriftArtCombo = new JComboBox<DirectDebitKind>(directDebitKindArray);
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.anchor = 11;
        gridBagConstraints19.fill = 2;
        gridBagConstraints19.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints19.gridx = 2;
        gridBagConstraints19.gridy = 8;
        this.add(this.lastschriftArtCombo, gridBagConstraints19);
        String string2 = this.preferences.loadPreference(FieldType.ART_LASTSCHRIFT.name());
        this.lastschriftArtCombo.setSelectedItem((Object)(string2 != null ? DirectDebitKind.valueOf(string2) : DirectDebitKind.CORE));
        this.subformatLabel = new JLabel(ApplicationContext.get().text().getString("lastschriftenTab.subformat"));
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.anchor = 13;
        gridBagConstraints20.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints20.gridx = 1;
        gridBagConstraints20.gridy = 9;
        this.add((Component)this.subformatLabel, gridBagConstraints20);
        this.subformatComboBox = new JComboBox<DirectDebitSubformat>(DirectDebitSubformat.values());
        String string3 = this.preferences.loadPreference(FieldType.SUBFORMAT_LASTSCHRIFT.name());
        this.subformatComboBox.setSelectedItem((Object)(string3 != null ? DirectDebitSubformat.valueOf(string3) : DirectDebitSubformat.getDefaultByCountry(Locale.getDefault())));
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.gridx = 2;
        gridBagConstraints21.gridy = 9;
        this.add(this.subformatComboBox, gridBagConstraints21);
        this.subformatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LastschriftenTab.this.adjustBICFieldAndValidationIfNecessary();
            }
        });
        this.optionsButton = new JButton(ApplicationContext.get().text().getString("lastschriftenTab.options"));
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints22.anchor = 11;
        gridBagConstraints22.gridx = 2;
        gridBagConstraints22.gridy = 10;
        this.add((Component)this.optionsButton, gridBagConstraints22);
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new LastschriftenOptionsDialog(LastschriftenTab.this.kontoinhaberField, LastschriftenTab.this.ibanField, LastschriftenTab.this.bicField, LastschriftenTab.this.glaeubigerIdField, LastschriftenTab.this.abbuchungsdatumField, LastschriftenTab.this.lastschriftTypCombo, LastschriftenTab.this.lastschriftArtCombo, LastschriftenTab.this.importBICCheckbox, LastschriftenTab.this.subformatComboBox, LastschriftenTab.this.centerTextPanelDocument, LastschriftenTab.this.logPanelStyle);
            }
        });
        this.openManual = new JButton(ApplicationContext.get().text().getString("lastschriftenTab.openManual"));
        this.openManual.setToolTipText(ApplicationContext.get().text().getString("lastschriftenTab.openManualTooltip"));
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints23.fill = 2;
        gridBagConstraints23.gridx = 3;
        gridBagConstraints23.gridy = 10;
        this.add((Component)this.openManual, gridBagConstraints23);
        this.openManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SEPAApp.openWebpage(new URL(ApplicationContext.get().text().getString("manualURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    LastschriftenTab.this.logger.log(Level.WARNING, "Could not open connection to www.sepaapp.eu", exception);
                }
            }
        });
        this.openFAQ = new JButton(ApplicationContext.get().text().getString("lastschriftenTab.openFAQ"));
        this.openFAQ.setToolTipText(ApplicationContext.get().text().getString("lastschriftenTab.openFAQTooltip"));
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints24.fill = 2;
        gridBagConstraints24.gridx = 4;
        gridBagConstraints24.gridy = 10;
        this.add((Component)this.openFAQ, gridBagConstraints24);
        this.openFAQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SEPAApp.openWebpage(new URL(ApplicationContext.get().text().getString("faqURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    LastschriftenTab.this.logger.log(Level.WARNING, "Could not open connection to www.sepaapp.eu", exception);
                }
            }
        });
        this.openSupportEMail = new JButton(ApplicationContext.get().text().getString("lastschriftenTab.openSupportEMail"));
        this.openSupportEMail.setToolTipText(ApplicationContext.get().text().getString("lastschriftenTab.openSupportEMailTooltip"));
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints25.fill = 2;
        gridBagConstraints25.gridx = 3;
        gridBagConstraints25.gridy = 11;
        this.add((Component)this.openSupportEMail, gridBagConstraints25);
        this.openSupportEMail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SEPAApp.openWebpage(new URL(ApplicationContext.get().text().getString("supportEMailURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    LastschriftenTab.this.logger.log(Level.WARNING, "Could not open connection to www.sepaapp.eu", exception);
                }
            }
        });
        this.errorLabel = new JLabel("");
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints26.gridx = 2;
        gridBagConstraints26.gridy = 11;
        this.add((Component)this.errorLabel, gridBagConstraints26);
        this.errorMessages = new ErrorMessages(this.errorLabel);
        String string4 = this.preferences.loadPreference(FieldType.SUBFORMAT_LASTSCHRIFT.name());
        NotNullKontoinhaberVerifier notNullKontoinhaberVerifier = new NotNullKontoinhaberVerifier(this.kontoinhaberField, FieldType.KONTOINHABER_LASTSCHRIFT, this.callback, this.errorMessages);
        NotNullIBANVerifier notNullIBANVerifier = new NotNullIBANVerifier(this.ibanField, FieldType.IBAN_LASTSCHRIFT, this.callback, this.errorMessages, false);
        this.bicVerifier = new NotNullBICVerifier(this.bicField, FieldType.BIC_LASTSCHRIFT, this.callback, this.errorMessages, false, false, string4 != null && DirectDebitSubformat.PAIN_008_001_02_CH_03.equals((Object)DirectDebitSubformat.valueOf(string4)) && !this.preferences.loadPreference(FieldType.BDD_LASTSCHRIFT.name(), false));
        this.glaeubigeridVerifier = new NotNullGlaeubigerIdVerifier(this.glaeubigerIdField, FieldType.GLAEUBIGERID_LASTSCHRIFT, this.callback, this.errorMessages, string4 != null && DirectDebitSubformat.PAIN_008_001_02_CH_03.equals((Object)DirectDebitSubformat.valueOf(string4)));
        NotNullDateTodayOrInFutureVerifier notNullDateTodayOrInFutureVerifier = new NotNullDateTodayOrInFutureVerifier(this.abbuchungsdatumField, FieldType.ABBUCHUNGSDATUM_LASTSCHRIFT, this.callback, this.errorMessages);
        TypedSaveOnlyVerifier typedSaveOnlyVerifier = new TypedSaveOnlyVerifier(this.lastschriftTypCombo, FieldType.TYP_LASTSCHRIFT);
        TypedSaveOnlyVerifier typedSaveOnlyVerifier2 = new TypedSaveOnlyVerifier(this.lastschriftArtCombo, FieldType.ART_LASTSCHRIFT);
        SaveOnlyVerifier saveOnlyVerifier = new SaveOnlyVerifier(this.importBICCheckbox, FieldType.IMPORTBIC_LASTSCHRIFT);
        TypedSaveOnlyVerifier typedSaveOnlyVerifier3 = new TypedSaveOnlyVerifier(this.subformatComboBox, FieldType.SUBFORMAT_LASTSCHRIFT);
        this.kontoinhaberField.setInputVerifier(notNullKontoinhaberVerifier);
        this.ibanField.setInputVerifier(notNullIBANVerifier);
        this.bicField.setInputVerifier(this.bicVerifier);
        this.glaeubigerIdField.setInputVerifier(this.glaeubigeridVerifier);
        this.abbuchungsdatumField.setInputVerifier(notNullDateTodayOrInFutureVerifier);
        this.lastschriftTypCombo.setInputVerifier(typedSaveOnlyVerifier);
        this.importBICCheckbox.setInputVerifier(saveOnlyVerifier);
        this.lastschriftArtCombo.setInputVerifier(typedSaveOnlyVerifier2);
        this.subformatComboBox.setInputVerifier(typedSaveOnlyVerifier3);
        ((InputVerifier)notNullKontoinhaberVerifier).verify(this.kontoinhaberField);
        ((InputVerifier)notNullIBANVerifier).verify(this.ibanField);
        this.bicVerifier.verify(this.bicField);
        this.glaeubigeridVerifier.verify(this.glaeubigerIdField);
        ((InputVerifier)notNullDateTodayOrInFutureVerifier).verify(this.abbuchungsdatumField);
        ((InputVerifier)typedSaveOnlyVerifier).verify(this.lastschriftTypCombo);
        ((InputVerifier)saveOnlyVerifier).verify(this.importBICCheckbox);
        ((InputVerifier)typedSaveOnlyVerifier2).verify(this.lastschriftArtCombo);
        ((InputVerifier)typedSaveOnlyVerifier3).verify(this.subformatComboBox);
        if (!this.preferences.hasValidProLicense() && this.preferences.hasEvaluationPeriodExpired()) {
            this.openAccountDialog.setEnabled(Boolean.FALSE);
        }
        if (this.preferences.loadPreference(FieldType.DIRECT_DEBIT_TYPE_FROM_FILE.name(), false)) {
            this.lastschriftTypCombo.setSelectedItem(null);
            this.lastschriftTypCombo.setEnabled(false);
        }
        this.adjustBICFieldAndValidationIfNecessary();
    }

    protected void adjustBICFieldAndValidationIfNecessary() {
        if (DirectDebitSubformat.PAIN_008_001_02_CH_03.equals(this.subformatComboBox.getSelectedItem())) {
            System.out.println("PAIN_008_001_02_CH_03");
            if (this.preferences.loadPreference(FieldType.BDD_LASTSCHRIFT.name(), false)) {
                this.bicVerifier.setConditionalNotStrict(true);
                this.bicVerifier.setConditionalOptional(false);
                this.bicField.setEnabled(true);
                this.bicLabel.setText("ClearingSystemId");
            } else {
                this.bicVerifier.setConditionalNotStrict(false);
                this.bicVerifier.setConditionalOptional(true);
                this.bicField.setEnabled(false);
                this.bicLabel.setText("BIC");
            }
            this.bicVerifier.verify(this.bicField);
            this.glaeubigeridVerifier.setConditionalNotStrict(true);
            this.glaeubigeridVerifier.verify(this.glaeubigerIdField);
        } else {
            this.bicVerifier.setConditionalNotStrict(false);
            this.bicVerifier.setConditionalOptional(false);
            this.bicField.setEnabled(true);
            this.bicLabel.setText("BIC");
            this.bicVerifier.verify(this.bicField);
            this.glaeubigeridVerifier.setConditionalNotStrict(false);
            this.glaeubigeridVerifier.verify(this.glaeubigerIdField);
        }
    }

    protected void getGuiValues() {
        this.debit.setKontoinhaber(StringUtils.trimToNull(this.kontoinhaberField.getText()));
        this.debit.setIBAN(StringUtils.trimToNull(this.ibanField.getText()).replace(" ", "").toUpperCase());
        this.debit.setBIC(StringUtils.trimToNull(this.bicField.getText()).replace(" ", "").toUpperCase());
        this.debit.setGlaeubigerId(StringUtils.trimToNull(this.glaeubigerIdField.getText()).replace(" ", ""));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
        try {
            Date date2 = simpleDateFormat.parse(StringUtils.trimToNull(this.abbuchungsdatumField.getText()));
            gregorianCalendar.setTime(date2);
        }
        catch (ParseException parseException) {
            this.logger.log(Level.SEVERE, "Exception while Parsing date (CollectionDate): " + this.abbuchungsdatumField.getText(), parseException);
        }
        this.debit.setCollectionDate(gregorianCalendar);
        this.debit.setType((DirectDebitType)((Object)this.lastschriftTypCombo.getSelectedItem()));
        this.debit.setKind((DirectDebitKind)((Object)this.lastschriftArtCombo.getSelectedItem()));
        this.debit.setSubformat((DirectDebitSubformat)((Object)this.subformatComboBox.getSelectedItem()));
        this.debit.setCategoryPurpose(this.preferences.loadPreference(FieldType.CATEGORY_PURPOSE_LASTSCHRIFT.name()) != null ? CategoryPurpose.valueOf(this.preferences.loadPreference(FieldType.CATEGORY_PURPOSE_LASTSCHRIFT.name())) : CategoryPurpose.EMPTY);
        this.debit.setIdentificationID(this.preferences.loadPreference(FieldType.SPANISH_NUMBER_LASTSCHRIFT.name()));
        this.debit.setIdentIdOrg(this.preferences.loadPreference(FieldType.USE_ORG_ID_LASTSCHRIFT.name(), false));
        this.debit.setIdentIdPrv(this.preferences.loadPreference(FieldType.USE_PRV_ID_LASTSCHRIFT.name(), true));
        this.debit.setGenerateEnd2EndId(this.preferences.loadPreference(FieldType.GENERATE_END2END_ID_LASTSCHRIFT.name(), true));
        this.debit.setEnd2EndIdFromFile(this.preferences.loadPreference(FieldType.END2END_ID_FROM_FILE_LASTSCHRIFT.name(), false));
        this.debit.setEnd2EndId(this.preferences.loadPreference(FieldType.END2ENDID_LASTSCHRIFT.name()));
        this.debit.setBatchBooking(this.preferences.loadPreference(FieldType.BATCH_BOOKING_SELECT_LASTSCHRIFT.name()) != null ? BatchBooking.valueOf(this.preferences.loadPreference(FieldType.BATCH_BOOKING_SELECT_LASTSCHRIFT.name())) : BatchBooking.EMPTY);
        this.debit.setSetTxNo(this.preferences.loadPreference(FieldType.TX_NO_LASTSCHRIFT.name(), false));
        this.debit.setUsePIIforEachTrx(this.preferences.loadPreference(FieldType.PII_FOR_EACH_TRX_LASTSCHRIFT.name(), false));
        this.debit.setCurrency(StringUtils.upperCase(this.preferences.loadPreference(FieldType.CURRENCY_LASTSCHRIFT.name(), "EUR")));
        this.debit.setChargeBearer(this.preferences.loadPreference(FieldType.CHARGEBEARER_LASTSCHRIFT.name()) != null ? ChargeBearer.valueOf(this.preferences.loadPreference(FieldType.CHARGEBEARER_LASTSCHRIFT.name())) : ChargeBearer.EMPTY);
        this.debit.setPmtInfId(this.preferences.loadPreference(FieldType.PMTID_LASTSCHRIFT.name()));
        this.debit.setCollectionDateFromFile(this.preferences.loadPreference(FieldType.IMPORT_EXECUTIONDATE_FROM_FILE_LASTSCHRIFT.name(), false));
        this.debit.setXmlHeaderWithSchemaLocation(this.preferences.loadPreference(FieldType.XML_HEADER_WITH_SCHEMA_LOCATION_LASTSCHRIFT.name(), false));
        this.debit.setDirectDebitTypeFromFile(this.preferences.loadPreference(FieldType.DIRECT_DEBIT_TYPE_FROM_FILE.name(), false));
        this.debit.setBDD(this.preferences.loadPreference(FieldType.BDD_LASTSCHRIFT.name(), false));
        this.debit.setAddSoftwareNameAndVendor(this.preferences.loadPreference(FieldType.ADD_SOFTWARE_NAME_AND_VENDOR_LASTSCHRIFT.name(), false));
        ApplicationContext.get().setUseTimeZoneFor001(this.preferences.loadPreference(FieldType.USE_TZ_001_LASTSCHRIFT.name(), true));
    }

    @Override
    protected void doOpenFile(Path path) {
        this.logger.finest("+doOpenFile");
        try {
            this.downloadButton.setEnabled(Boolean.FALSE);
            this.uploadLabel.setText(path.toFile().getName());
            Locale locale = Locale.getDefault();
            String string = locale.getCountry();
            DebitParser debitParser = DirectDebitParserFactory.create(path);
            ParserResult parserResult = debitParser.parse(path.toFile(), this.importBICCheckbox.isSelected(), this.preferences.loadPreference(FieldType.END2END_ID_FROM_FILE_LASTSCHRIFT.name(), false), this.preferences.loadPreference(FieldType.CURRENCY_FROM_FILE_LASTSCHRIFT.name(), false), this.preferences.loadPreference(FieldType.ADDRESS_FROM_FILE_LASTSCHRIFT.name(), false), this.preferences.loadPreference(FieldType.IMPORT_EXECUTIONDATE_FROM_FILE_LASTSCHRIFT.name(), false), this.preferences.loadPreference(FieldType.DIRECT_DEBIT_TYPE_FROM_FILE.name(), false), this.preferences.loadPreference(FieldType.NORMALIZE_LASTSCHRIFT.name(), !"DE".equals(string) || !"AT".equals(string)), this.preferences.loadPreference(FieldType.UMLAUTS_LASTSCHRIFT.name(), "DE".equals(string) || "AT".equals(string)), this.preferences.loadPreference(FieldType.SPECIAL_CHARACTERS_CH_LASTSCHRIFT.name(), false), DirectDebitSubformat.PAIN_008_001_02_CH_03.equals(this.subformatComboBox.getSelectedItem()));
            this.debit = parserResult.getDirectDebit();
            this.writeLogLine(this.uploadLabel.getText(), this.logPanelStyle.getRegularStyle());
            this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
            int n = 0;
            for (ParserLineResult parserLineResult : parserResult.getLineResults()) {
                this.logger.log(Level.FINEST, String.format("Parsing %s", parserLineResult.getLineMessage()));
                ++n;
                if (parserLineResult.isSucessfull()) {
                    this.writeLogLine(parserLineResult.getLineMessage(), this.logPanelStyle.getIconOkStyle());
                    this.writeLogLine(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n + (parserResult.getStartingRow() > 0 ? " (" + ApplicationContext.get().text().getString("row") + " " + (n + parserResult.getStartingRow()) + ")" : "") + " - " + parserLineResult.getLineMessage(), this.logPanelStyle.getRegularStyle());
                    continue;
                }
                this.writeLogLine(parserLineResult.getLineMessage(), this.logPanelStyle.getIconErrorStyle());
                this.writeLogLine(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n + (parserResult.getStartingRow() > 0 ? " (" + ApplicationContext.get().text().getString("row") + " " + (n + parserResult.getStartingRow()) + ")" : "") + " - " + parserLineResult.getLineMessage(), this.logPanelStyle.getErrorStyle());
            }
            this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("successfullyImported") + parserResult.getSuccessfull() + ", " + ApplicationContext.get().text().getString("sumImported") + ParserUtils.formatBigDecimalForLog(parserResult.getSum()), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("errorImported") + parserResult.getNotSuccessfull(), this.logPanelStyle.getRegularStyle());
            if (!parserResult.isHeaderSuccessfull()) {
                this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("unknownError"), this.logPanelStyle.getErrorStyle());
            }
            if (this.importBICCheckbox.isSelected() && !parserResult.isBICFound() || !this.importBICCheckbox.isSelected() && parserResult.isBICFound()) {
                this.writeLogLine(ApplicationContext.get().text().getString("bicWarning"), this.logPanelStyle.getIconWarningStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("bicWarning"), this.logPanelStyle.getRegularStyle());
            }
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
            this.callback.setExternalVerification(parserResult.isHeaderSuccessfull() && parserResult.getSuccessfull() > 0);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while opening file.", exception);
        }
        this.logger.finest("-doOpenFile");
    }

    @Override
    protected void doSave(Path path) {
        this.logger.finest("+doSave");
        try {
            SEPAWriter sEPAWriter = new SEPAWriter();
            this.getGuiValues();
            if (!path.toString().toLowerCase().endsWith("xml")) {
                path = Paths.get(path.toAbsolutePath().toString() + ".xml", new String[0]);
                this.logger.fine("adding file extension \".xml\"");
            }
            String string = this.preferences.loadPreference(FieldType.SPLIT_LASTSCHRIFT.name());
            int n = 0;
            if (string != null && !string.isEmpty()) {
                n = Integer.parseInt(string);
            }
            if (n > 0) {
                int n2;
                String string2 = path.toString();
                if (path.toString().endsWith(".xml") || path.toString().endsWith(".XML")) {
                    string2 = path.toString().substring(0, path.toString().lastIndexOf(46));
                }
                ArrayList<SEPADirectDebit> arrayList = new ArrayList<SEPADirectDebit>();
                SEPADirectDebit sEPADirectDebit = null;
                int n3 = 0;
                for (n2 = 0; n2 < this.debit.getTransactionList().size(); ++n2) {
                    if (n3 % n == 0) {
                        sEPADirectDebit = this.debit.clone();
                        arrayList.add(sEPADirectDebit);
                    }
                    sEPADirectDebit.getTransactionList().add(this.debit.getTransactionList().get(n3));
                    ++n3;
                }
                n2 = 1;
                for (SEPADirectDebit sEPADirectDebit2 : arrayList) {
                    Path path2 = Paths.get(string2 + "_" + n2 + ".xml", new String[0]);
                    sEPAWriter.createSEPADirectDebitXMLFile(sEPADirectDebit2, path2.toFile());
                    this.logger.log(Level.INFO, String.format("SEPA XML file created: %s", path2.toAbsolutePath().toString()));
                    this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-------------------------------\n", this.logPanelStyle.getRegularStyle());
                    this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-", this.logPanelStyle.getIconSaveStyle());
                    this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), path2.toAbsolutePath().toString()) + "\n", path2.toAbsolutePath().toString()), this.logPanelStyle.getRegularStyle());
                    ++n2;
                }
            } else {
                sEPAWriter.createSEPADirectDebitXMLFile(this.debit, path.toFile());
                this.logger.log(Level.INFO, String.format("SEPA XML file created: %s", path.toAbsolutePath().toString()));
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-------------------------------\n", this.logPanelStyle.getRegularStyle());
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-", this.logPanelStyle.getIconSaveStyle());
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), path.toAbsolutePath().toString()) + "\n", path.toAbsolutePath().toString()), this.logPanelStyle.getRegularStyle());
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while saving file.", exception);
            try {
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-------------------------------\n", this.logPanelStyle.getErrorStyle());
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-", this.logPanelStyle.getIconErrorStyle());
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("errorWhileSaving"), exception.getMessage(), path.toAbsolutePath().toString()) + "\n", path.toAbsolutePath().toString()), this.logPanelStyle.getErrorStyle());
            }
            catch (BadLocationException badLocationException) {
                this.logger.log(Level.SEVERE, "Exception while saving file.", badLocationException);
            }
        }
        this.logger.finest("-doSave");
    }

    @Override
    public SEPAVerificationStateCallback getDownloadButtonCallback() {
        return this.callback;
    }

    @Override
    public JLabel getUploadLabel() {
        return this.uploadLabel;
    }
}

