/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPADirectDebitTransaction;
import com.codecamp.sepa.core.SEPAUtils;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.pain008_001_02_ch_03.AccountIdentification4Choice;
import com.codecamp.sepa.pain008_001_02_ch_03.ActiveOrHistoricCurrencyAndAmount;
import com.codecamp.sepa.pain008_001_02_ch_03.BranchAndFinancialInstitutionIdentification4;
import com.codecamp.sepa.pain008_001_02_ch_03.CashAccount16;
import com.codecamp.sepa.pain008_001_02_ch_03.CategoryPurpose1Choice;
import com.codecamp.sepa.pain008_001_02_ch_03.ClearingSystemMemberIdentification2;
import com.codecamp.sepa.pain008_001_02_ch_03.ContactDetails2;
import com.codecamp.sepa.pain008_001_02_ch_03.CreditorReferenceInformation2;
import com.codecamp.sepa.pain008_001_02_ch_03.CreditorReferenceType1Choice;
import com.codecamp.sepa.pain008_001_02_ch_03.CreditorReferenceType2;
import com.codecamp.sepa.pain008_001_02_ch_03.CustomerDirectDebitInitiationV02;
import com.codecamp.sepa.pain008_001_02_ch_03.DirectDebitTransactionInformation9;
import com.codecamp.sepa.pain008_001_02_ch_03.Document;
import com.codecamp.sepa.pain008_001_02_ch_03.FinancialInstitutionIdentification7;
import com.codecamp.sepa.pain008_001_02_ch_03.GenericFinancialIdentification1;
import com.codecamp.sepa.pain008_001_02_ch_03.GenericOrganisationIdentification1;
import com.codecamp.sepa.pain008_001_02_ch_03.GenericPersonIdentification1;
import com.codecamp.sepa.pain008_001_02_ch_03.GroupHeader39;
import com.codecamp.sepa.pain008_001_02_ch_03.LocalInstrument2Choice;
import com.codecamp.sepa.pain008_001_02_ch_03.OrganisationIdentification4;
import com.codecamp.sepa.pain008_001_02_ch_03.Party6Choice;
import com.codecamp.sepa.pain008_001_02_ch_03.PartyIdentification32;
import com.codecamp.sepa.pain008_001_02_ch_03.PaymentIdentification1;
import com.codecamp.sepa.pain008_001_02_ch_03.PaymentInstructionInformation4;
import com.codecamp.sepa.pain008_001_02_ch_03.PaymentMethod2Code;
import com.codecamp.sepa.pain008_001_02_ch_03.PaymentTypeInformation20;
import com.codecamp.sepa.pain008_001_02_ch_03.PersonIdentification5;
import com.codecamp.sepa.pain008_001_02_ch_03.PersonIdentificationSchemeName1Choice;
import com.codecamp.sepa.pain008_001_02_ch_03.PostalAddress6;
import com.codecamp.sepa.pain008_001_02_ch_03.RemittanceInformation5;
import com.codecamp.sepa.pain008_001_02_ch_03.ServiceLevel8Choice;
import com.codecamp.sepa.pain008_001_02_ch_03.StructuredRemittanceInformation7;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLDirectDebitBuilder001CH3 {
    private final Logger logger = Logger.getLogger(SEPAXMLDirectDebitBuilder001CH3.class.getName());

    protected Document getDirectDebit(SEPADirectDebit sEPADirectDebit) {
        Object object;
        Object object2;
        Document document = new Document();
        CustomerDirectDebitInitiationV02 customerDirectDebitInitiationV02 = new CustomerDirectDebitInitiationV02();
        document.setCstmrDrctDbtInitn(customerDirectDebitInitiationV02);
        GroupHeader39 groupHeader39 = new GroupHeader39();
        customerDirectDebitInitiationV02.setGrpHdr(groupHeader39);
        groupHeader39.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            groupHeader39.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPADirectDebit.getTransactionList().size());
        groupHeader39.setNbOfTxs(string);
        PartyIdentification32 partyIdentification32 = new PartyIdentification32();
        groupHeader39.setInitgPty(partyIdentification32);
        if (sEPADirectDebit.isAddSoftwareNameAndVendor()) {
            object2 = new ContactDetails2();
            partyIdentification32.setCtctDtls((ContactDetails2)object2);
            object = new SEPAPreferences();
            ((ContactDetails2)object2).setNm(((SEPAPreferences)object).loadPreference(FieldType.SOFTWARE_NAME_AND_VENDOR.name(), "SEPAApp/Janus Software Solutions"));
        }
        object2 = customerDirectDebitInitiationV02.getPmtInf();
        object = new BigDecimal(0).setScale(2);
        object = sEPADirectDebit.getUsePIIforEachTrx() || sEPADirectDebit.isCollectionDateFromFile() || sEPADirectDebit.isDirectDebitTypeFromFile() ? this.addPIIForEachTrx(sEPADirectDebit, (List<PaymentInstructionInformation4>)object2, partyIdentification32) : this.addSinglePII(sEPADirectDebit, (List<PaymentInstructionInformation4>)object2, string, partyIdentification32);
        groupHeader39.setCtrlSum(((BigDecimal)object).setScale(2));
        return document;
    }

    private BigDecimal addPIIForEachTrx(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformation4> list, PartyIdentification32 partyIdentification32) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            PaymentInstructionInformation4 paymentInstructionInformation4 = new PaymentInstructionInformation4();
            list.add(paymentInstructionInformation4);
            if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdOrg()) {
                object5 = new PartyIdentification32();
                object4 = new Party6Choice();
                ((PartyIdentification32)object5).setId((Party6Choice)object4);
                paymentInstructionInformation4.setUltmtCdtr((PartyIdentification32)object5);
                object3 = new GenericOrganisationIdentification1();
                ((GenericOrganisationIdentification1)object3).setId(sEPADirectDebit.getIdentificationID());
                object2 = new OrganisationIdentification4();
                ((OrganisationIdentification4)object2).setOthr((GenericOrganisationIdentification1)object3);
                ((Party6Choice)object4).setOrgId((OrganisationIdentification4)object2);
            }
            if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdPrv()) {
                object5 = new PartyIdentification32();
                object4 = new Party6Choice();
                ((PartyIdentification32)object5).setId((Party6Choice)object4);
                paymentInstructionInformation4.setUltmtCdtr((PartyIdentification32)object5);
                object3 = new GenericPersonIdentification1();
                ((GenericPersonIdentification1)object3).setId(sEPADirectDebit.getIdentificationID());
                object2 = new PersonIdentification5();
                ((PersonIdentification5)object2).setOthr((GenericPersonIdentification1)object3);
                ((Party6Choice)object4).setPrvtId((PersonIdentification5)object2);
            }
            partyIdentification32.setNm(sEPADirectDebit.getKontoinhaber());
            object5 = new Party6Choice();
            object4 = new OrganisationIdentification4();
            object3 = new GenericOrganisationIdentification1();
            ((GenericOrganisationIdentification1)object3).setId(sEPADirectDebit.getGlaeubigerId());
            ((OrganisationIdentification4)object4).setOthr((GenericOrganisationIdentification1)object3);
            ((Party6Choice)object5).setOrgId((OrganisationIdentification4)object4);
            partyIdentification32.setId((Party6Choice)object5);
            paymentInstructionInformation4.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformation4.setPmtMtd(PaymentMethod2Code.DD);
            object2 = new PaymentTypeInformation20();
            paymentInstructionInformation4.setPmtTpInf((PaymentTypeInformation20)object2);
            ServiceLevel8Choice serviceLevel8Choice = new ServiceLevel8Choice();
            serviceLevel8Choice.setPrtry(sEPADirectDebit.isBDD() ? "CHTA" : "CHDD");
            ((PaymentTypeInformation20)object2).setSvcLvl(serviceLevel8Choice);
            LocalInstrument2Choice localInstrument2Choice = new LocalInstrument2Choice();
            localInstrument2Choice.setPrtry(sEPADirectDebit.isBDD() ? "BDD" : "DDCOR1");
            try {
                XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.isCollectionDateFromFile() ? sEPADirectDebitTransaction.getCollectionDate() : sEPADirectDebit.getCollectionDate());
                paymentInstructionInformation4.setReqdColltnDt(xMLGregorianCalendar);
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender(collectionDate)!", datatypeConfigurationException);
            }
            PartyIdentification32 partyIdentification322 = new PartyIdentification32();
            partyIdentification322.setNm(sEPADirectDebit.getKontoinhaber());
            paymentInstructionInformation4.setCdtr(partyIdentification322);
            CashAccount16 cashAccount16 = new CashAccount16();
            AccountIdentification4Choice accountIdentification4Choice = new AccountIdentification4Choice();
            accountIdentification4Choice.setIBAN(sEPADirectDebit.getIBAN());
            cashAccount16.setId(accountIdentification4Choice);
            paymentInstructionInformation4.setCdtrAcct(cashAccount16);
            BranchAndFinancialInstitutionIdentification4 branchAndFinancialInstitutionIdentification4 = new BranchAndFinancialInstitutionIdentification4();
            FinancialInstitutionIdentification7 financialInstitutionIdentification7 = new FinancialInstitutionIdentification7();
            ClearingSystemMemberIdentification2 clearingSystemMemberIdentification2 = new ClearingSystemMemberIdentification2();
            clearingSystemMemberIdentification2.setMmbId(SEPAUtils.extractMemberIdFromIBAN(sEPADirectDebit.getIBAN(), sEPADirectDebit.isBDD()));
            financialInstitutionIdentification7.setClrSysMmbId(clearingSystemMemberIdentification2);
            branchAndFinancialInstitutionIdentification4.setFinInstnId(financialInstitutionIdentification7);
            if (sEPADirectDebit.isBDD()) {
                object = new GenericFinancialIdentification1();
                ((GenericFinancialIdentification1)object).setId(sEPADirectDebit.getBIC());
                financialInstitutionIdentification7.setOthr((GenericFinancialIdentification1)object);
            }
            paymentInstructionInformation4.setCdtrAgt(branchAndFinancialInstitutionIdentification4);
            object = new PartyIdentification32();
            Party6Choice party6Choice = new Party6Choice();
            PersonIdentification5 personIdentification5 = new PersonIdentification5();
            GenericPersonIdentification1 genericPersonIdentification1 = new GenericPersonIdentification1();
            genericPersonIdentification1.setId(sEPADirectDebit.getGlaeubigerId());
            PersonIdentificationSchemeName1Choice personIdentificationSchemeName1Choice = new PersonIdentificationSchemeName1Choice();
            personIdentificationSchemeName1Choice.setPrtry(sEPADirectDebit.isBDD() ? "CHLS" : "CHDD");
            genericPersonIdentification1.setSchmeNm(personIdentificationSchemeName1Choice);
            personIdentification5.setOthr(genericPersonIdentification1);
            party6Choice.setPrvtId(personIdentification5);
            ((PartyIdentification32)object).setId(party6Choice);
            paymentInstructionInformation4.setCdtrSchmeId((PartyIdentification32)object);
            if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
                CategoryPurpose1Choice categoryPurpose1Choice = new CategoryPurpose1Choice();
                categoryPurpose1Choice.setCd(sEPADirectDebit.getCategoryPurpose().name());
                ((PaymentTypeInformation20)object2).setCtgyPurp(categoryPurpose1Choice);
            }
            bigDecimal = bigDecimal.add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformation4.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), 1, sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2(), sEPADirectDebit.getCurrency(), sEPADirectDebitTransaction.getCurrency(), sEPADirectDebit.isBDD()));
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformation4> list, String string, PartyIdentification32 partyIdentification32) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        PaymentInstructionInformation4 paymentInstructionInformation4 = new PaymentInstructionInformation4();
        list.add(paymentInstructionInformation4);
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdOrg()) {
            object6 = new PartyIdentification32();
            object5 = new Party6Choice();
            ((PartyIdentification32)object6).setId((Party6Choice)object5);
            paymentInstructionInformation4.setUltmtCdtr((PartyIdentification32)object6);
            object4 = new GenericOrganisationIdentification1();
            ((GenericOrganisationIdentification1)object4).setId(sEPADirectDebit.getIdentificationID());
            object3 = new OrganisationIdentification4();
            ((OrganisationIdentification4)object3).setOthr((GenericOrganisationIdentification1)object4);
            ((Party6Choice)object5).setOrgId((OrganisationIdentification4)object3);
        }
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdPrv()) {
            object6 = new PartyIdentification32();
            object5 = new Party6Choice();
            ((PartyIdentification32)object6).setId((Party6Choice)object5);
            paymentInstructionInformation4.setUltmtCdtr((PartyIdentification32)object6);
            object4 = new GenericPersonIdentification1();
            ((GenericPersonIdentification1)object4).setId(sEPADirectDebit.getIdentificationID());
            object3 = new PersonIdentification5();
            ((PersonIdentification5)object3).setOthr((GenericPersonIdentification1)object4);
            ((Party6Choice)object5).setPrvtId((PersonIdentification5)object3);
        }
        partyIdentification32.setNm(sEPADirectDebit.getKontoinhaber());
        object6 = new Party6Choice();
        object5 = new OrganisationIdentification4();
        object4 = new GenericOrganisationIdentification1();
        ((GenericOrganisationIdentification1)object4).setId(sEPADirectDebit.getGlaeubigerId());
        ((OrganisationIdentification4)object5).setOthr((GenericOrganisationIdentification1)object4);
        ((Party6Choice)object6).setOrgId((OrganisationIdentification4)object5);
        partyIdentification32.setId((Party6Choice)object6);
        paymentInstructionInformation4.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformation4.setPmtMtd(PaymentMethod2Code.DD);
        object3 = new PaymentTypeInformation20();
        paymentInstructionInformation4.setPmtTpInf((PaymentTypeInformation20)object3);
        ServiceLevel8Choice serviceLevel8Choice = new ServiceLevel8Choice();
        serviceLevel8Choice.setPrtry(sEPADirectDebit.isBDD() ? "CHTA" : "CHDD");
        ((PaymentTypeInformation20)object3).setSvcLvl(serviceLevel8Choice);
        LocalInstrument2Choice localInstrument2Choice = new LocalInstrument2Choice();
        localInstrument2Choice.setPrtry(sEPADirectDebit.isBDD() ? "BDD" : "DDCOR1");
        ((PaymentTypeInformation20)object3).setLclInstrm(localInstrument2Choice);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.getCollectionDate());
            paymentInstructionInformation4.setReqdColltnDt(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (collectionDate)!", datatypeConfigurationException);
        }
        PartyIdentification32 partyIdentification322 = new PartyIdentification32();
        partyIdentification322.setNm(sEPADirectDebit.getKontoinhaber());
        paymentInstructionInformation4.setCdtr(partyIdentification322);
        CashAccount16 cashAccount16 = new CashAccount16();
        AccountIdentification4Choice accountIdentification4Choice = new AccountIdentification4Choice();
        accountIdentification4Choice.setIBAN(sEPADirectDebit.getIBAN());
        cashAccount16.setId(accountIdentification4Choice);
        paymentInstructionInformation4.setCdtrAcct(cashAccount16);
        BranchAndFinancialInstitutionIdentification4 branchAndFinancialInstitutionIdentification4 = new BranchAndFinancialInstitutionIdentification4();
        FinancialInstitutionIdentification7 financialInstitutionIdentification7 = new FinancialInstitutionIdentification7();
        ClearingSystemMemberIdentification2 clearingSystemMemberIdentification2 = new ClearingSystemMemberIdentification2();
        clearingSystemMemberIdentification2.setMmbId(SEPAUtils.extractMemberIdFromIBAN(sEPADirectDebit.getIBAN(), sEPADirectDebit.isBDD()));
        financialInstitutionIdentification7.setClrSysMmbId(clearingSystemMemberIdentification2);
        branchAndFinancialInstitutionIdentification4.setFinInstnId(financialInstitutionIdentification7);
        if (sEPADirectDebit.isBDD()) {
            object2 = new GenericFinancialIdentification1();
            ((GenericFinancialIdentification1)object2).setId(sEPADirectDebit.getBIC());
            financialInstitutionIdentification7.setOthr((GenericFinancialIdentification1)object2);
        }
        paymentInstructionInformation4.setCdtrAgt(branchAndFinancialInstitutionIdentification4);
        object2 = new PartyIdentification32();
        Party6Choice party6Choice = new Party6Choice();
        PersonIdentification5 personIdentification5 = new PersonIdentification5();
        GenericPersonIdentification1 genericPersonIdentification1 = new GenericPersonIdentification1();
        genericPersonIdentification1.setId(sEPADirectDebit.getGlaeubigerId());
        PersonIdentificationSchemeName1Choice personIdentificationSchemeName1Choice = new PersonIdentificationSchemeName1Choice();
        personIdentificationSchemeName1Choice.setPrtry(sEPADirectDebit.isBDD() ? "CHLS" : "CHDD");
        genericPersonIdentification1.setSchmeNm(personIdentificationSchemeName1Choice);
        personIdentification5.setOthr(genericPersonIdentification1);
        party6Choice.setPrvtId(personIdentification5);
        ((PartyIdentification32)object2).setId(party6Choice);
        paymentInstructionInformation4.setCdtrSchmeId((PartyIdentification32)object2);
        if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
            object = new CategoryPurpose1Choice();
            ((CategoryPurpose1Choice)object).setCd(sEPADirectDebit.getCategoryPurpose().name());
            ((PaymentTypeInformation20)object3).setCtgyPurp((CategoryPurpose1Choice)object);
        }
        object = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            object = ((BigDecimal)object).add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformation4.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), ++n, sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2(), sEPADirectDebit.getCurrency(), sEPADirectDebitTransaction.getCurrency(), sEPADirectDebit.isBDD()));
        }
        return object;
    }

    private DirectDebitTransactionInformation9 getDirectDebitTransaction(BigDecimal bigDecimal, String string, String string2, String string3, String string4, GregorianCalendar gregorianCalendar, boolean bl, int n, String string5, boolean bl2, String string6, String string7, String string8, String string9, String string10, String string11, boolean bl3) {
        Object object;
        DirectDebitTransactionInformation9 directDebitTransactionInformation9 = new DirectDebitTransactionInformation9();
        PaymentIdentification1 paymentIdentification1 = new PaymentIdentification1();
        if (bl) {
            paymentIdentification1.setEndToEndId(IDGenerator.generateId());
        } else if (bl2 && StringUtils.trimToNull(string6) != null) {
            paymentIdentification1.setEndToEndId(string6);
        } else if (StringUtils.trimToNull(string5) != null) {
            paymentIdentification1.setEndToEndId(string5);
        } else {
            paymentIdentification1.setEndToEndId("NOTPROVIDED");
        }
        paymentIdentification1.setInstrId(String.valueOf(n));
        directDebitTransactionInformation9.setPmtId(paymentIdentification1);
        ActiveOrHistoricCurrencyAndAmount activeOrHistoricCurrencyAndAmount = new ActiveOrHistoricCurrencyAndAmount();
        activeOrHistoricCurrencyAndAmount.setCcy(string11 != null ? string11 : string10);
        activeOrHistoricCurrencyAndAmount.setValue(bigDecimal);
        directDebitTransactionInformation9.setInstdAmt(activeOrHistoricCurrencyAndAmount);
        BranchAndFinancialInstitutionIdentification4 branchAndFinancialInstitutionIdentification4 = new BranchAndFinancialInstitutionIdentification4();
        FinancialInstitutionIdentification7 financialInstitutionIdentification7 = new FinancialInstitutionIdentification7();
        ClearingSystemMemberIdentification2 clearingSystemMemberIdentification2 = new ClearingSystemMemberIdentification2();
        clearingSystemMemberIdentification2.setMmbId(SEPAUtils.extractMemberIdFromIBAN(string2, bl3));
        financialInstitutionIdentification7.setClrSysMmbId(clearingSystemMemberIdentification2);
        branchAndFinancialInstitutionIdentification4.setFinInstnId(financialInstitutionIdentification7);
        directDebitTransactionInformation9.setDbtrAgt(branchAndFinancialInstitutionIdentification4);
        PartyIdentification32 partyIdentification32 = new PartyIdentification32();
        partyIdentification32.setNm(string);
        if (string7 != null || string8 != null || string9 != null) {
            object = new PostalAddress6();
            partyIdentification32.setPstlAdr((PostalAddress6)object);
            if (!string7.isEmpty()) {
                ((PostalAddress6)object).setCtry(string7);
            }
            if (string8 != null && !string8.isEmpty()) {
                ((PostalAddress6)object).getAdrLine().add(string8);
            }
            if (string9 != null && !string9.isEmpty()) {
                ((PostalAddress6)object).getAdrLine().add(string9);
            }
        }
        directDebitTransactionInformation9.setDbtr(partyIdentification32);
        object = new CashAccount16();
        AccountIdentification4Choice accountIdentification4Choice = new AccountIdentification4Choice();
        accountIdentification4Choice.setIBAN(string2);
        ((CashAccount16)object).setId(accountIdentification4Choice);
        directDebitTransactionInformation9.setDbtrAcct((CashAccount16)object);
        RemittanceInformation5 remittanceInformation5 = new RemittanceInformation5();
        if (bl3) {
            StructuredRemittanceInformation7 structuredRemittanceInformation7 = new StructuredRemittanceInformation7();
            remittanceInformation5.setStrd(structuredRemittanceInformation7);
            CreditorReferenceInformation2 creditorReferenceInformation2 = new CreditorReferenceInformation2();
            structuredRemittanceInformation7.setCdtrRefInf(creditorReferenceInformation2);
            CreditorReferenceType2 creditorReferenceType2 = new CreditorReferenceType2();
            creditorReferenceInformation2.setTp(creditorReferenceType2);
            CreditorReferenceType1Choice creditorReferenceType1Choice = new CreditorReferenceType1Choice();
            creditorReferenceType2.setCdOrPrtry(creditorReferenceType1Choice);
            creditorReferenceType1Choice.setPrtry("ESR");
            creditorReferenceInformation2.setRef(string4);
        } else {
            remittanceInformation5.setUstrd(string4);
        }
        directDebitTransactionInformation9.setRmtInf(remittanceInformation5);
        return directDebitTransactionInformation9;
    }
}

