/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.AccountIdentification3Choice;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.ActiveOrHistoricCurrencyAndAmount;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIBranchAndFinancialInstitutionIdentification1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIBranchAndFinancialInstitutionIdentification3;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBICashAccount7;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIChargeBearerTypeCode;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIClearingSystemMemberIdentification1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIFinancialInstitutionIdentification1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIFinancialInstitutionIdentification5Choice;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIGenericIdentification1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIGenericIdentification2;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIGroupHeader2;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIIdType1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIOrganisationIdentification1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIParty4Choice;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIPartyIdentification1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIPartyIdentification2;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIPartyIdentification3;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIPartyIdentification4;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIPaymentIdentification1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIPaymentTypeInformation21;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIPersonIdentification2;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIPostalAddress6;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIPurpose1Choice;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIRegulatoryReporting1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIRegulatoryReportingType2Code;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBISDDReqLogMsg000100;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIServiceLevel2Code;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.CBIServiceLevel3Choice;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.DirectDebitTransaction1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.DirectDebitTransactionInformation1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.LocalInstrument1Choice;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.MandateRelatedInformation1;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.PaymentInstructionInformation2;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.PaymentMethod2Code;
import com.codecamp.sepa.cbiSDDReqLogMsg_00_01_00.RemittanceInformation5;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.DirectDebitKind;
import com.codecamp.sepa.core.DirectDebitType;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPADirectDebitTransaction;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLDirectDebitBuilder001CBI {
    private final Logger logger = Logger.getLogger(SEPAXMLDirectDebitBuilder001CBI.class.getName());

    protected CBISDDReqLogMsg000100 getDirectDebit(SEPADirectDebit sEPADirectDebit) {
        CBISDDReqLogMsg000100 cBISDDReqLogMsg000100 = new CBISDDReqLogMsg000100();
        CBIGroupHeader2 cBIGroupHeader2 = new CBIGroupHeader2();
        cBISDDReqLogMsg000100.setGrpHdr(cBIGroupHeader2);
        cBIGroupHeader2.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            cBIGroupHeader2.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPADirectDebit.getTransactionList().size());
        cBIGroupHeader2.setNbOfTxs(string);
        CBIPartyIdentification1 cBIPartyIdentification1 = new CBIPartyIdentification1();
        cBIGroupHeader2.setInitgPty(cBIPartyIdentification1);
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        bigDecimal = sEPADirectDebit.getUsePIIforEachTrx() || sEPADirectDebit.isCollectionDateFromFile() || sEPADirectDebit.isDirectDebitTypeFromFile() ? this.addPIIForEachTrx(sEPADirectDebit, cBISDDReqLogMsg000100.getPmtInf(), cBIPartyIdentification1) : this.addSinglePII(sEPADirectDebit, cBISDDReqLogMsg000100.getPmtInf(), string, cBIPartyIdentification1);
        cBIGroupHeader2.setCtrlSum(bigDecimal.setScale(2));
        return cBISDDReqLogMsg000100;
    }

    private BigDecimal addPIIForEachTrx(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformation2> list, CBIPartyIdentification1 cBIPartyIdentification1) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            Object object;
            Object object2;
            Object object3;
            PaymentInstructionInformation2 paymentInstructionInformation2 = new PaymentInstructionInformation2();
            list.add(paymentInstructionInformation2);
            if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdOrg()) {
                object3 = new CBIGenericIdentification1();
                ((CBIGenericIdentification1)object3).setIssr("CBI");
                ((CBIGenericIdentification1)object3).setId(sEPADirectDebit.getIdentificationID());
                object2 = new CBIOrganisationIdentification1();
                ((CBIOrganisationIdentification1)object2).getOthr().add((CBIGenericIdentification1)object3);
                object = new CBIIdType1();
                ((CBIIdType1)object).setOrgId((CBIOrganisationIdentification1)object2);
                cBIPartyIdentification1.setId((CBIIdType1)object);
            }
            if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdPrv()) {
                object3 = new CBIGenericIdentification1();
                ((CBIGenericIdentification1)object3).setIssr("CBI");
                ((CBIGenericIdentification1)object3).setId(sEPADirectDebit.getIdentificationID());
                object2 = new CBIOrganisationIdentification1();
                ((CBIOrganisationIdentification1)object2).getOthr().add((CBIGenericIdentification1)object3);
                object = new CBIIdType1();
                ((CBIIdType1)object).setOrgId((CBIOrganisationIdentification1)object2);
                cBIPartyIdentification1.setId((CBIIdType1)object);
            }
            cBIPartyIdentification1.setNm(sEPADirectDebit.getKontoinhaber());
            paymentInstructionInformation2.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformation2.setPmtMtd(PaymentMethod2Code.DD);
            if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.YES)) {
                paymentInstructionInformation2.setBtchBookg(Boolean.TRUE);
            } else if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.NO)) {
                paymentInstructionInformation2.setBtchBookg(Boolean.FALSE);
            }
            object3 = new CBIPaymentTypeInformation21();
            object2 = new CBIServiceLevel3Choice();
            ((CBIServiceLevel3Choice)object2).setCd(CBIServiceLevel2Code.SEPA);
            ((CBIPaymentTypeInformation21)object3).setSvcLvl((CBIServiceLevel3Choice)object2);
            object = new LocalInstrument1Choice();
            if (DirectDebitKind.B2B.equals((Object)sEPADirectDebit.getKind())) {
                ((LocalInstrument1Choice)object).setCd("B2B");
            } else if (DirectDebitKind.COR1.equals((Object)sEPADirectDebit.getKind())) {
                ((LocalInstrument1Choice)object).setCd("COR1");
            } else {
                ((LocalInstrument1Choice)object).setCd("CORE");
            }
            ((CBIPaymentTypeInformation21)object3).setLclInstrm((LocalInstrument1Choice)object);
            ((CBIPaymentTypeInformation21)object3).setSeqTp(sEPADirectDebit.isDirectDebitTypeFromFile() ? DirectDebitType.getSequenceTypeCBI(sEPADirectDebitTransaction.getDirectDebitType()) : DirectDebitType.getSequenceTypeCBI(sEPADirectDebit.getType()));
            paymentInstructionInformation2.setPmtTpInf((CBIPaymentTypeInformation21)object3);
            try {
                XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.isCollectionDateFromFile() ? sEPADirectDebitTransaction.getCollectionDate() : sEPADirectDebit.getCollectionDate());
                paymentInstructionInformation2.setReqdColltnDt(xMLGregorianCalendar);
                xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (collectionDate)!", datatypeConfigurationException);
            }
            CBIPartyIdentification3 cBIPartyIdentification3 = new CBIPartyIdentification3();
            cBIPartyIdentification3.setNm(sEPADirectDebit.getKontoinhaber());
            paymentInstructionInformation2.setCdtr(cBIPartyIdentification3);
            CBICashAccount7 cBICashAccount7 = new CBICashAccount7();
            AccountIdentification3Choice accountIdentification3Choice = new AccountIdentification3Choice();
            accountIdentification3Choice.setIBAN(sEPADirectDebit.getIBAN());
            cBICashAccount7.setId(accountIdentification3Choice);
            paymentInstructionInformation2.setCdtrAcct(cBICashAccount7);
            CBIBranchAndFinancialInstitutionIdentification1 cBIBranchAndFinancialInstitutionIdentification1 = new CBIBranchAndFinancialInstitutionIdentification1();
            CBIFinancialInstitutionIdentification1 cBIFinancialInstitutionIdentification1 = new CBIFinancialInstitutionIdentification1();
            CBIClearingSystemMemberIdentification1 cBIClearingSystemMemberIdentification1 = new CBIClearingSystemMemberIdentification1();
            cBIClearingSystemMemberIdentification1.setMmbId(sEPADirectDebit.getIBAN().substring(5, 10));
            cBIFinancialInstitutionIdentification1.setClrSysMmbId(cBIClearingSystemMemberIdentification1);
            cBIBranchAndFinancialInstitutionIdentification1.setFinInstnId(cBIFinancialInstitutionIdentification1);
            paymentInstructionInformation2.setCdtrAgt(cBIBranchAndFinancialInstitutionIdentification1);
            if (sEPADirectDebit.getChargeBearer() != null && !sEPADirectDebit.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
                paymentInstructionInformation2.setChrgBr(CBIChargeBearerTypeCode.fromValue(sEPADirectDebit.getChargeBearer().name()));
            }
            CBIPartyIdentification2 cBIPartyIdentification2 = new CBIPartyIdentification2();
            CBIParty4Choice cBIParty4Choice = new CBIParty4Choice();
            CBIPersonIdentification2 cBIPersonIdentification2 = new CBIPersonIdentification2();
            CBIGenericIdentification2 cBIGenericIdentification2 = new CBIGenericIdentification2();
            cBIGenericIdentification2.setId(sEPADirectDebit.getGlaeubigerId());
            cBIPersonIdentification2.setOthr(cBIGenericIdentification2);
            cBIParty4Choice.setPrvtId(cBIPersonIdentification2);
            cBIPartyIdentification2.setId(cBIParty4Choice);
            paymentInstructionInformation2.setCdtrSchmeId(cBIPartyIdentification2);
            cBIPartyIdentification2.setNm(sEPADirectDebit.getKontoinhaber());
            bigDecimal = bigDecimal.add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformation2.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), 1, sEPADirectDebit, sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), sEPADirectDebit.getCurrency(), sEPADirectDebitTransaction.getCurrency(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2()));
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPADirectDebit sEPADirectDebit, List<PaymentInstructionInformation2> list, String string, CBIPartyIdentification1 cBIPartyIdentification1) {
        Object object;
        Object object2;
        Object object3;
        PaymentInstructionInformation2 paymentInstructionInformation2 = new PaymentInstructionInformation2();
        list.add(paymentInstructionInformation2);
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdOrg()) {
            object3 = new CBIGenericIdentification1();
            ((CBIGenericIdentification1)object3).setIssr("CBI");
            ((CBIGenericIdentification1)object3).setId(sEPADirectDebit.getIdentificationID());
            object2 = new CBIOrganisationIdentification1();
            ((CBIOrganisationIdentification1)object2).getOthr().add((CBIGenericIdentification1)object3);
            object = new CBIIdType1();
            ((CBIIdType1)object).setOrgId((CBIOrganisationIdentification1)object2);
            cBIPartyIdentification1.setId((CBIIdType1)object);
        }
        if (sEPADirectDebit.getIdentificationID() != null && !sEPADirectDebit.getIdentificationID().isEmpty() && sEPADirectDebit.isIdentIdPrv()) {
            object3 = new CBIGenericIdentification1();
            ((CBIGenericIdentification1)object3).setIssr("CBI");
            ((CBIGenericIdentification1)object3).setId(sEPADirectDebit.getIdentificationID());
            object2 = new CBIOrganisationIdentification1();
            ((CBIOrganisationIdentification1)object2).getOthr().add((CBIGenericIdentification1)object3);
            object = new CBIIdType1();
            ((CBIIdType1)object).setOrgId((CBIOrganisationIdentification1)object2);
            cBIPartyIdentification1.setId((CBIIdType1)object);
        }
        cBIPartyIdentification1.setNm(sEPADirectDebit.getKontoinhaber());
        paymentInstructionInformation2.setPmtInfId(StringUtils.trimToNull(sEPADirectDebit.getPmtInfId()) != null ? sEPADirectDebit.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformation2.setPmtMtd(PaymentMethod2Code.DD);
        if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.YES)) {
            paymentInstructionInformation2.setBtchBookg(Boolean.TRUE);
        } else if (sEPADirectDebit.getBatchBooking() != null && sEPADirectDebit.getBatchBooking().equals((Object)BatchBooking.NO)) {
            paymentInstructionInformation2.setBtchBookg(Boolean.FALSE);
        }
        object3 = new CBIPaymentTypeInformation21();
        object2 = new CBIServiceLevel3Choice();
        ((CBIServiceLevel3Choice)object2).setCd(CBIServiceLevel2Code.SEPA);
        ((CBIPaymentTypeInformation21)object3).setSvcLvl((CBIServiceLevel3Choice)object2);
        object = new LocalInstrument1Choice();
        if (DirectDebitKind.B2B.equals((Object)sEPADirectDebit.getKind())) {
            ((LocalInstrument1Choice)object).setCd("B2B");
        } else if (DirectDebitKind.COR1.equals((Object)sEPADirectDebit.getKind())) {
            ((LocalInstrument1Choice)object).setCd("COR1");
        } else {
            ((LocalInstrument1Choice)object).setCd("CORE");
        }
        ((CBIPaymentTypeInformation21)object3).setLclInstrm((LocalInstrument1Choice)object);
        ((CBIPaymentTypeInformation21)object3).setSeqTp(DirectDebitType.getSequenceTypeCBI(sEPADirectDebit.getType()));
        paymentInstructionInformation2.setPmtTpInf((CBIPaymentTypeInformation21)object3);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPADirectDebit.getCollectionDate());
            paymentInstructionInformation2.setReqdColltnDt(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (collectionDate)!", datatypeConfigurationException);
        }
        CBIPartyIdentification3 cBIPartyIdentification3 = new CBIPartyIdentification3();
        cBIPartyIdentification3.setNm(sEPADirectDebit.getKontoinhaber());
        paymentInstructionInformation2.setCdtr(cBIPartyIdentification3);
        CBICashAccount7 cBICashAccount7 = new CBICashAccount7();
        AccountIdentification3Choice accountIdentification3Choice = new AccountIdentification3Choice();
        accountIdentification3Choice.setIBAN(sEPADirectDebit.getIBAN());
        cBICashAccount7.setId(accountIdentification3Choice);
        paymentInstructionInformation2.setCdtrAcct(cBICashAccount7);
        CBIBranchAndFinancialInstitutionIdentification1 cBIBranchAndFinancialInstitutionIdentification1 = new CBIBranchAndFinancialInstitutionIdentification1();
        CBIFinancialInstitutionIdentification1 cBIFinancialInstitutionIdentification1 = new CBIFinancialInstitutionIdentification1();
        CBIClearingSystemMemberIdentification1 cBIClearingSystemMemberIdentification1 = new CBIClearingSystemMemberIdentification1();
        cBIClearingSystemMemberIdentification1.setMmbId(sEPADirectDebit.getIBAN().substring(5, 10));
        cBIFinancialInstitutionIdentification1.setClrSysMmbId(cBIClearingSystemMemberIdentification1);
        cBIBranchAndFinancialInstitutionIdentification1.setFinInstnId(cBIFinancialInstitutionIdentification1);
        paymentInstructionInformation2.setCdtrAgt(cBIBranchAndFinancialInstitutionIdentification1);
        if (sEPADirectDebit.getChargeBearer() != null && !sEPADirectDebit.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            paymentInstructionInformation2.setChrgBr(CBIChargeBearerTypeCode.fromValue(sEPADirectDebit.getChargeBearer().name()));
        }
        CBIPartyIdentification2 cBIPartyIdentification2 = new CBIPartyIdentification2();
        CBIParty4Choice cBIParty4Choice = new CBIParty4Choice();
        CBIPersonIdentification2 cBIPersonIdentification2 = new CBIPersonIdentification2();
        CBIGenericIdentification2 cBIGenericIdentification2 = new CBIGenericIdentification2();
        cBIGenericIdentification2.setId(sEPADirectDebit.getGlaeubigerId());
        cBIPersonIdentification2.setOthr(cBIGenericIdentification2);
        cBIParty4Choice.setPrvtId(cBIPersonIdentification2);
        cBIPartyIdentification2.setId(cBIParty4Choice);
        paymentInstructionInformation2.setCdtrSchmeId(cBIPartyIdentification2);
        cBIPartyIdentification2.setNm(sEPADirectDebit.getKontoinhaber());
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPADirectDebitTransaction sEPADirectDebitTransaction : sEPADirectDebit.getTransactionList()) {
            bigDecimal = bigDecimal.add(sEPADirectDebitTransaction.getAmount());
            paymentInstructionInformation2.getDrctDbtTxInf().add(this.getDirectDebitTransaction(sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getSignatureDate(), sEPADirectDebit.isGenerateEnd2EndId(), ++n, sEPADirectDebit, sEPADirectDebit.getEnd2EndId(), sEPADirectDebit.isEnd2EndIdFromFile(), sEPADirectDebitTransaction.getEnd2EndId(), sEPADirectDebit.getCurrency(), sEPADirectDebitTransaction.getCurrency(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2()));
        }
        return bigDecimal;
    }

    private DirectDebitTransactionInformation1 getDirectDebitTransaction(BigDecimal bigDecimal, String string, String string2, String string3, String string4, String string5, GregorianCalendar gregorianCalendar, boolean bl, int n, SEPADirectDebit sEPADirectDebit, String string6, boolean bl2, String string7, String string8, String string9, String string10, String string11, String string12) {
        Object object;
        Object object2;
        Object object3;
        DirectDebitTransactionInformation1 directDebitTransactionInformation1 = new DirectDebitTransactionInformation1();
        CBIPaymentIdentification1 cBIPaymentIdentification1 = new CBIPaymentIdentification1();
        if (bl) {
            cBIPaymentIdentification1.setEndToEndId(IDGenerator.generateId());
        } else if (bl2 && StringUtils.trimToNull(string7) != null) {
            cBIPaymentIdentification1.setEndToEndId(string7);
        } else if (StringUtils.trimToNull(string6) != null) {
            cBIPaymentIdentification1.setEndToEndId(string6);
        } else {
            cBIPaymentIdentification1.setEndToEndId("NOTPROVIDED");
        }
        cBIPaymentIdentification1.setInstrId(String.valueOf(n));
        directDebitTransactionInformation1.setPmtId(cBIPaymentIdentification1);
        ActiveOrHistoricCurrencyAndAmount activeOrHistoricCurrencyAndAmount = new ActiveOrHistoricCurrencyAndAmount();
        activeOrHistoricCurrencyAndAmount.setCcy(string9 != null ? string9 : string8);
        activeOrHistoricCurrencyAndAmount.setValue(bigDecimal);
        directDebitTransactionInformation1.setInstdAmt(activeOrHistoricCurrencyAndAmount);
        DirectDebitTransaction1 directDebitTransaction1 = new DirectDebitTransaction1();
        MandateRelatedInformation1 mandateRelatedInformation1 = new MandateRelatedInformation1();
        mandateRelatedInformation1.setMndtId(string4);
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            mandateRelatedInformation1.setDtOfSgntr(xMLGregorianCalendar);
            xMLGregorianCalendar.setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (dateOfSignature)!", datatypeConfigurationException);
        }
        mandateRelatedInformation1.setAmdmntInd(false);
        directDebitTransaction1.setMndtRltdInf(mandateRelatedInformation1);
        directDebitTransactionInformation1.setDrctDbtTx(directDebitTransaction1);
        if (string2 != null && !string2.isEmpty()) {
            object3 = new CBIBranchAndFinancialInstitutionIdentification3();
            object2 = new CBIFinancialInstitutionIdentification5Choice();
            ((CBIFinancialInstitutionIdentification5Choice)object2).setBIC(string2);
            ((CBIBranchAndFinancialInstitutionIdentification3)object3).setFinInstnId((CBIFinancialInstitutionIdentification5Choice)object2);
            object = new CBIRegulatoryReporting1();
            ((CBIRegulatoryReporting1)object).setDbtCdtRptgInd(CBIRegulatoryReportingType2Code.CRED);
            directDebitTransactionInformation1.getRgltryRptg().add((CBIRegulatoryReporting1)object);
            directDebitTransactionInformation1.setDbtrAgt((CBIBranchAndFinancialInstitutionIdentification3)object3);
        }
        object3 = new CBIPartyIdentification4();
        ((CBIPartyIdentification4)object3).setNm(string);
        if (string10 != null || string11 != null || string12 != null) {
            object2 = new CBIPostalAddress6();
            ((CBIPartyIdentification4)object3).setPstlAdr((CBIPostalAddress6)object2);
            if (!string10.isEmpty()) {
                ((CBIPostalAddress6)object2).setCtry(string10);
            }
            if (string11 != null && !string11.isEmpty()) {
                ((CBIPostalAddress6)object2).getAdrLine().add(string11);
            }
            if (string12 != null && !string12.isEmpty()) {
                ((CBIPostalAddress6)object2).getAdrLine().add(string12);
            }
        }
        directDebitTransactionInformation1.setDbtr((CBIPartyIdentification4)object3);
        object2 = new CBICashAccount7();
        object = new AccountIdentification3Choice();
        ((AccountIdentification3Choice)object).setIBAN(string3);
        ((CBICashAccount7)object2).setId((AccountIdentification3Choice)object);
        directDebitTransactionInformation1.setDbtrAcct((CBICashAccount7)object2);
        RemittanceInformation5 remittanceInformation5 = new RemittanceInformation5();
        remittanceInformation5.getUstrd().add(string5);
        directDebitTransactionInformation1.setRmtInf(remittanceInformation5);
        if (sEPADirectDebit.getCategoryPurpose() != null && sEPADirectDebit.getCategoryPurpose() != CategoryPurpose.EMPTY) {
            CBIPurpose1Choice cBIPurpose1Choice = new CBIPurpose1Choice();
            cBIPurpose1Choice.setCd(sEPADirectDebit.getCategoryPurpose().name());
            directDebitTransactionInformation1.setPurp(cBIPurpose1Choice);
        }
        return directDebitTransactionInformation1;
    }
}

