/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPACreditTransferTransaction;
import com.codecamp.sepa.core.ServiceLevel;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.pain001_001_03.namespace.AccountIdentification4Choice;
import com.codecamp.sepa.pain001_001_03.namespace.AccountSchemeName1Choice;
import com.codecamp.sepa.pain001_001_03.namespace.ActiveOrHistoricCurrencyAndAmount;
import com.codecamp.sepa.pain001_001_03.namespace.AmountType3Choice;
import com.codecamp.sepa.pain001_001_03.namespace.BranchAndFinancialInstitutionIdentification4;
import com.codecamp.sepa.pain001_001_03.namespace.CashAccount16;
import com.codecamp.sepa.pain001_001_03.namespace.CategoryPurpose1Choice;
import com.codecamp.sepa.pain001_001_03.namespace.ChargeBearerType1Code;
import com.codecamp.sepa.pain001_001_03.namespace.ClearingSystemIdentification2Choice;
import com.codecamp.sepa.pain001_001_03.namespace.ClearingSystemMemberIdentification2;
import com.codecamp.sepa.pain001_001_03.namespace.ContactDetails2;
import com.codecamp.sepa.pain001_001_03.namespace.CreditTransferTransactionInformation10;
import com.codecamp.sepa.pain001_001_03.namespace.CreditorReferenceInformation2;
import com.codecamp.sepa.pain001_001_03.namespace.CreditorReferenceType1Choice;
import com.codecamp.sepa.pain001_001_03.namespace.CreditorReferenceType2;
import com.codecamp.sepa.pain001_001_03.namespace.CustomerCreditTransferInitiationV03;
import com.codecamp.sepa.pain001_001_03.namespace.Document;
import com.codecamp.sepa.pain001_001_03.namespace.DocumentType3Code;
import com.codecamp.sepa.pain001_001_03.namespace.FinancialInstitutionIdentification7;
import com.codecamp.sepa.pain001_001_03.namespace.GenericAccountIdentification1;
import com.codecamp.sepa.pain001_001_03.namespace.GenericOrganisationIdentification1;
import com.codecamp.sepa.pain001_001_03.namespace.GenericPersonIdentification1;
import com.codecamp.sepa.pain001_001_03.namespace.GroupHeader32;
import com.codecamp.sepa.pain001_001_03.namespace.LocalInstrument2Choice;
import com.codecamp.sepa.pain001_001_03.namespace.OrganisationIdentification4;
import com.codecamp.sepa.pain001_001_03.namespace.Party6Choice;
import com.codecamp.sepa.pain001_001_03.namespace.PartyIdentification32;
import com.codecamp.sepa.pain001_001_03.namespace.PaymentIdentification1;
import com.codecamp.sepa.pain001_001_03.namespace.PaymentInstructionInformation3;
import com.codecamp.sepa.pain001_001_03.namespace.PaymentMethod3Code;
import com.codecamp.sepa.pain001_001_03.namespace.PaymentTypeInformation19;
import com.codecamp.sepa.pain001_001_03.namespace.PersonIdentification5;
import com.codecamp.sepa.pain001_001_03.namespace.PostalAddress6;
import com.codecamp.sepa.pain001_001_03.namespace.Priority2Code;
import com.codecamp.sepa.pain001_001_03.namespace.RegulatoryReporting3;
import com.codecamp.sepa.pain001_001_03.namespace.RemittanceAmount1;
import com.codecamp.sepa.pain001_001_03.namespace.RemittanceInformation5;
import com.codecamp.sepa.pain001_001_03.namespace.ServiceLevel8Choice;
import com.codecamp.sepa.pain001_001_03.namespace.StructuredRegulatoryReporting3;
import com.codecamp.sepa.pain001_001_03.namespace.StructuredRemittanceInformation7;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLCreditTransferBuilder001Namespace {
    private final Logger logger = Logger.getLogger(SEPAXMLCreditTransferBuilder001Namespace.class.getName());

    public Document getCreditTransfer(SEPACreditTransfer sEPACreditTransfer) {
        Object object;
        Document document = new Document();
        CustomerCreditTransferInitiationV03 customerCreditTransferInitiationV03 = new CustomerCreditTransferInitiationV03();
        document.setCstmrCdtTrfInitn(customerCreditTransferInitiationV03);
        GroupHeader32 groupHeader32 = new GroupHeader32();
        customerCreditTransferInitiationV03.setGrpHdr(groupHeader32);
        groupHeader32.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            groupHeader32.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPACreditTransfer.getTransactionList().size());
        groupHeader32.setNbOfTxs(string);
        if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty() || sEPACreditTransfer.isNameInInitParty() || sEPACreditTransfer.isAddSoftwareNameAndVendor()) {
            Object object2;
            Object object3;
            object = new PartyIdentification32();
            groupHeader32.setInitgPty((PartyIdentification32)object);
            if (sEPACreditTransfer.isNameInInitParty()) {
                ((PartyIdentification32)object).setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.isAddSoftwareNameAndVendor()) {
                object3 = new ContactDetails2();
                ((PartyIdentification32)object).setCtctDtls((ContactDetails2)object3);
                object2 = new SEPAPreferences();
                ((ContactDetails2)object3).setNm(((SEPAPreferences)object2).loadPreference(FieldType.SOFTWARE_NAME_AND_VENDOR.name(), "SEPAApp/Janus Software Solutions"));
            }
            if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty()) {
                Party6Choice party6Choice;
                if (sEPACreditTransfer.isIdentIdOrg()) {
                    object3 = new GenericOrganisationIdentification1();
                    ((GenericOrganisationIdentification1)object3).setId(sEPACreditTransfer.getIdentificationID());
                    object2 = new OrganisationIdentification4();
                    ((OrganisationIdentification4)object2).getOthr().add((GenericOrganisationIdentification1)object3);
                    party6Choice = new Party6Choice();
                    party6Choice.setOrgId((OrganisationIdentification4)object2);
                    ((PartyIdentification32)object).setId(party6Choice);
                }
                if (sEPACreditTransfer.isIdentIdPrv()) {
                    object3 = new GenericPersonIdentification1();
                    ((GenericPersonIdentification1)object3).setId(sEPACreditTransfer.getIdentificationID());
                    object2 = new PersonIdentification5();
                    ((PersonIdentification5)object2).getOthr().add((GenericPersonIdentification1)object3);
                    party6Choice = new Party6Choice();
                    party6Choice.setPrvtId((PersonIdentification5)object2);
                    ((PartyIdentification32)object).setId(party6Choice);
                }
            }
        }
        object = new BigDecimal(0).setScale(2);
        object = sEPACreditTransfer.getUsePIIforEachTrx() || sEPACreditTransfer.isExecutionDateFromFile() || sEPACreditTransfer.isPayerFromFile() ? this.addPIIForEachTrx(sEPACreditTransfer, customerCreditTransferInitiationV03) : this.addSinglePII(sEPACreditTransfer, customerCreditTransferInitiationV03, string);
        groupHeader32.setCtrlSum(((BigDecimal)object).setScale(2));
        sEPACreditTransfer.setSumOfTx(((BigDecimal)object).setScale(2));
        return document;
    }

    private BigDecimal addPIIForEachTrx(SEPACreditTransfer sEPACreditTransfer, CustomerCreditTransferInitiationV03 customerCreditTransferInitiationV03) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            Object object;
            Object object2;
            String[] stringArray;
            Object object3;
            Object object4;
            Object object5;
            PaymentInstructionInformation3 paymentInstructionInformation3 = new PaymentInstructionInformation3();
            customerCreditTransferInitiationV03.getPmtInf().add(paymentInstructionInformation3);
            paymentInstructionInformation3.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformation3.setPmtMtd(PaymentMethod3Code.TRF);
            if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.YES)) {
                paymentInstructionInformation3.setBtchBookg(Boolean.TRUE);
            } else if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.NO)) {
                paymentInstructionInformation3.setBtchBookg(Boolean.FALSE);
            }
            paymentInstructionInformation3.setNbOfTxs("1");
            if (!sEPACreditTransfer.isPaymentTypeInformationOnTrxLevel()) {
                object5 = new PaymentTypeInformation19();
                if (sEPACreditTransfer.isUseFastCreditTransfer()) {
                    ((PaymentTypeInformation19)object5).setInstrPrty(Priority2Code.HIGH);
                }
                if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
                    object4 = new ServiceLevel8Choice();
                    ((ServiceLevel8Choice)object4).setCd(sEPACreditTransfer.getServiceLevel().name());
                    ((PaymentTypeInformation19)object5).setSvcLvl((ServiceLevel8Choice)object4);
                }
                if (sEPACreditTransfer.isInstantCT()) {
                    object4 = new LocalInstrument2Choice();
                    ((LocalInstrument2Choice)object4).setCd("INST");
                    ((PaymentTypeInformation19)object5).setLclInstrm((LocalInstrument2Choice)object4);
                }
                if (sEPACreditTransfer.isSetLocalInstrumentCore()) {
                    object4 = new LocalInstrument2Choice();
                    ((LocalInstrument2Choice)object4).setCd("CORE");
                    ((PaymentTypeInformation19)object5).setLclInstrm((LocalInstrument2Choice)object4);
                }
                if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY) {
                    object4 = new CategoryPurpose1Choice();
                    ((CategoryPurpose1Choice)object4).setCd(sEPACreditTransfer.getCategoryPurpose().name());
                    ((PaymentTypeInformation19)object5).setCtgyPurp((CategoryPurpose1Choice)object4);
                }
                if ((sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY || sEPACreditTransfer.isUseFastCreditTransfer() || sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY || sEPACreditTransfer.isInstantCT() || sEPACreditTransfer.isSetLocalInstrumentCore() || sEPACreditTransfer.isUseBankgiro()) && !sEPACreditTransfer.isSplitPayment()) {
                    paymentInstructionInformation3.setPmtTpInf((PaymentTypeInformation19)object5);
                }
            }
            try {
                object5 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.isExecutionDateFromFile() ? sEPACreditTransferTransaction.getExecutionDate() : sEPACreditTransfer.getExecutionDate());
                paymentInstructionInformation3.setReqdExctnDt((XMLGregorianCalendar)object5);
                ((XMLGregorianCalendar)object5).setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
            }
            object4 = new PartyIdentification32();
            paymentInstructionInformation3.setDbtr((PartyIdentification32)object4);
            if (sEPACreditTransfer.isPayerFromFile()) {
                ((PartyIdentification32)object4).setNm(sEPACreditTransferTransaction.getKontoinhaberPayerTrx());
            } else {
                ((PartyIdentification32)object4).setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                object3 = new PostalAddress6();
                ((PartyIdentification32)object4).setPstlAdr((PostalAddress6)object3);
                if (sEPACreditTransfer.getCountryCode() != null) {
                    ((PostalAddress6)object3).setCtry(sEPACreditTransfer.getCountryCode());
                }
                if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                    if (sEPACreditTransfer.isUseStructuredAddress()) {
                        ((PostalAddress6)object3).setStrtNm(sEPACreditTransfer.getAddressLine1());
                    } else {
                        ((PostalAddress6)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
                    }
                }
                if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                    if (sEPACreditTransfer.isUseStructuredAddress()) {
                        stringArray = sEPACreditTransfer.getAddressLine2().split(" ");
                        ((PostalAddress6)object3).setPstCd(stringArray[0]);
                        if (stringArray.length > 1) {
                            object2 = "";
                            for (int i = 1; i < stringArray.length; ++i) {
                                object = stringArray[i];
                                object2 = i > 1 ? (String)object2 + " " + (String)object : (String)object2 + (String)object;
                            }
                            ((PostalAddress6)object3).setTwnNm((String)object2);
                        }
                    } else {
                        ((PostalAddress6)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
                    }
                }
            }
            object3 = new CashAccount16();
            paymentInstructionInformation3.setDbtrAcct((CashAccount16)object3);
            if (sEPACreditTransfer.isSetDebitorCurrency()) {
                ((CashAccount16)object3).setCcy(sEPACreditTransfer.getCurrency());
            }
            stringArray = new AccountIdentification4Choice();
            ((CashAccount16)object3).setId((AccountIdentification4Choice)stringArray);
            if (sEPACreditTransfer.isUseBankgiro() || sEPACreditTransfer.isAccountNoInsteadOfIBANGUI()) {
                object2 = new GenericAccountIdentification1();
                if (sEPACreditTransfer.isUseBankgiro()) {
                    AccountSchemeName1Choice accountSchemeName1Choice = new AccountSchemeName1Choice();
                    accountSchemeName1Choice.setPrtry("BGNR");
                    ((GenericAccountIdentification1)object2).setSchmeNm(accountSchemeName1Choice);
                }
                ((GenericAccountIdentification1)object2).setId(sEPACreditTransfer.getIBAN());
                stringArray.setOthr((GenericAccountIdentification1)object2);
            } else if (sEPACreditTransfer.isPayerFromFile()) {
                stringArray.setIBAN(sEPACreditTransferTransaction.getIBANPayerTrx());
            } else {
                stringArray.setIBAN(sEPACreditTransfer.getIBAN());
            }
            object2 = new BranchAndFinancialInstitutionIdentification4();
            paymentInstructionInformation3.setDbtrAgt((BranchAndFinancialInstitutionIdentification4)object2);
            FinancialInstitutionIdentification7 financialInstitutionIdentification7 = new FinancialInstitutionIdentification7();
            ((BranchAndFinancialInstitutionIdentification4)object2).setFinInstnId(financialInstitutionIdentification7);
            if (sEPACreditTransfer.isUseBankgiro()) {
                object = new ClearingSystemMemberIdentification2();
                ClearingSystemIdentification2Choice clearingSystemIdentification2Choice = new ClearingSystemIdentification2Choice();
                clearingSystemIdentification2Choice.setCd(sEPACreditTransfer.getClrSysId());
                ((ClearingSystemMemberIdentification2)object).setClrSysId(clearingSystemIdentification2Choice);
                ((ClearingSystemMemberIdentification2)object).setMmbId(sEPACreditTransfer.getMmbId());
                financialInstitutionIdentification7.setClrSysMmbId((ClearingSystemMemberIdentification2)object);
            } else if (sEPACreditTransfer.isPayerFromFile()) {
                financialInstitutionIdentification7.setBIC(sEPACreditTransferTransaction.getBICPayerTrx());
                if (sEPACreditTransfer.isAddCountryCodeFromIBANToBIC()) {
                    object = new PostalAddress6();
                    financialInstitutionIdentification7.setPstlAdr((PostalAddress6)object);
                    ((PostalAddress6)object).setCtry(sEPACreditTransferTransaction.getIBANPayerTrx().substring(0, 2));
                }
            } else {
                financialInstitutionIdentification7.setBIC(sEPACreditTransfer.getBIC());
                if (sEPACreditTransfer.isAddCountryCodeFromIBANToBIC()) {
                    object = new PostalAddress6();
                    financialInstitutionIdentification7.setPstlAdr((PostalAddress6)object);
                    ((PostalAddress6)object).setCtry(sEPACreditTransfer.getIBAN().substring(0, 2));
                }
            }
            if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
                paymentInstructionInformation3.setChrgBr(ChargeBearerType1Code.fromValue(sEPACreditTransfer.getChargeBearer().name()));
            }
            bigDecimal = bigDecimal.add(sEPACreditTransferTransaction.getAmount().setScale(2));
            paymentInstructionInformation3.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), sEPACreditTransfer.getEnd2EndId(), 1, sEPACreditTransfer.isSetTxNo()));
            paymentInstructionInformation3.setCtrlSum(sEPACreditTransferTransaction.getAmount().setScale(2));
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPACreditTransfer sEPACreditTransfer, CustomerCreditTransferInitiationV03 customerCreditTransferInitiationV03, String string) {
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object4;
        Object object5;
        PaymentInstructionInformation3 paymentInstructionInformation3 = new PaymentInstructionInformation3();
        customerCreditTransferInitiationV03.getPmtInf().add(paymentInstructionInformation3);
        paymentInstructionInformation3.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformation3.setPmtMtd(PaymentMethod3Code.TRF);
        sEPACreditTransfer.setPmtInfId(paymentInstructionInformation3.getPmtInfId());
        if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.YES)) {
            paymentInstructionInformation3.setBtchBookg(Boolean.TRUE);
        } else if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.NO)) {
            paymentInstructionInformation3.setBtchBookg(Boolean.FALSE);
        }
        paymentInstructionInformation3.setNbOfTxs(string);
        if (!sEPACreditTransfer.isPaymentTypeInformationOnTrxLevel()) {
            object5 = new PaymentTypeInformation19();
            if (sEPACreditTransfer.isUseFastCreditTransfer()) {
                ((PaymentTypeInformation19)object5).setInstrPrty(Priority2Code.HIGH);
            }
            if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
                object4 = new ServiceLevel8Choice();
                ((ServiceLevel8Choice)object4).setCd(sEPACreditTransfer.getServiceLevel().name());
                ((PaymentTypeInformation19)object5).setSvcLvl((ServiceLevel8Choice)object4);
            }
            if (sEPACreditTransfer.isInstantCT()) {
                object4 = new LocalInstrument2Choice();
                ((LocalInstrument2Choice)object4).setCd("INST");
                ((PaymentTypeInformation19)object5).setLclInstrm((LocalInstrument2Choice)object4);
            }
            if (sEPACreditTransfer.isSetLocalInstrumentCore()) {
                object4 = new LocalInstrument2Choice();
                ((LocalInstrument2Choice)object4).setCd("CORE");
                ((PaymentTypeInformation19)object5).setLclInstrm((LocalInstrument2Choice)object4);
            }
            if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY) {
                object4 = new CategoryPurpose1Choice();
                ((CategoryPurpose1Choice)object4).setCd(sEPACreditTransfer.getCategoryPurpose().name());
                ((PaymentTypeInformation19)object5).setCtgyPurp((CategoryPurpose1Choice)object4);
            }
            if ((sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY || sEPACreditTransfer.isUseFastCreditTransfer() || sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY || sEPACreditTransfer.isInstantCT() || sEPACreditTransfer.isSetLocalInstrumentCore() || sEPACreditTransfer.isUseBankgiro()) && !sEPACreditTransfer.isSplitPayment()) {
                paymentInstructionInformation3.setPmtTpInf((PaymentTypeInformation19)object5);
            }
        }
        try {
            object5 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.getExecutionDate());
            paymentInstructionInformation3.setReqdExctnDt((XMLGregorianCalendar)object5);
            ((XMLGregorianCalendar)object5).setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
        }
        object4 = new PartyIdentification32();
        paymentInstructionInformation3.setDbtr((PartyIdentification32)object4);
        ((PartyIdentification32)object4).setNm(sEPACreditTransfer.getKontoinhaber());
        if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
            object3 = new PostalAddress6();
            ((PartyIdentification32)object4).setPstlAdr((PostalAddress6)object3);
            if (sEPACreditTransfer.getCountryCode() != null) {
                ((PostalAddress6)object3).setCtry(sEPACreditTransfer.getCountryCode());
            }
            if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    ((PostalAddress6)object3).setStrtNm(sEPACreditTransfer.getAddressLine1());
                } else {
                    ((PostalAddress6)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
                }
            }
            if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    stringArray = sEPACreditTransfer.getAddressLine2().split(" ");
                    ((PostalAddress6)object3).setPstCd(stringArray[0]);
                    if (stringArray.length > 1) {
                        object2 = "";
                        for (int i = 1; i < stringArray.length; ++i) {
                            object = stringArray[i];
                            object2 = i > 1 ? (String)object2 + " " + (String)object : (String)object2 + (String)object;
                        }
                        ((PostalAddress6)object3).setTwnNm((String)object2);
                    }
                } else {
                    ((PostalAddress6)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
                }
            }
        }
        object3 = new CashAccount16();
        paymentInstructionInformation3.setDbtrAcct((CashAccount16)object3);
        if (sEPACreditTransfer.isSetDebitorCurrency()) {
            ((CashAccount16)object3).setCcy(sEPACreditTransfer.getCurrency());
        }
        stringArray = new AccountIdentification4Choice();
        ((CashAccount16)object3).setId((AccountIdentification4Choice)stringArray);
        if (sEPACreditTransfer.isUseBankgiro() || sEPACreditTransfer.isAccountNoInsteadOfIBANGUI()) {
            object2 = new GenericAccountIdentification1();
            if (sEPACreditTransfer.isUseBankgiro()) {
                AccountSchemeName1Choice accountSchemeName1Choice = new AccountSchemeName1Choice();
                accountSchemeName1Choice.setPrtry("BGNR");
                ((GenericAccountIdentification1)object2).setSchmeNm(accountSchemeName1Choice);
            }
            ((GenericAccountIdentification1)object2).setId(sEPACreditTransfer.getIBAN());
            stringArray.setOthr((GenericAccountIdentification1)object2);
        } else {
            stringArray.setIBAN(sEPACreditTransfer.getIBAN());
        }
        object2 = new BranchAndFinancialInstitutionIdentification4();
        paymentInstructionInformation3.setDbtrAgt((BranchAndFinancialInstitutionIdentification4)object2);
        FinancialInstitutionIdentification7 financialInstitutionIdentification7 = new FinancialInstitutionIdentification7();
        ((BranchAndFinancialInstitutionIdentification4)object2).setFinInstnId(financialInstitutionIdentification7);
        if (sEPACreditTransfer.isUseBankgiro()) {
            object = new ClearingSystemMemberIdentification2();
            ClearingSystemIdentification2Choice clearingSystemIdentification2Choice = new ClearingSystemIdentification2Choice();
            clearingSystemIdentification2Choice.setCd(sEPACreditTransfer.getClrSysId());
            ((ClearingSystemMemberIdentification2)object).setClrSysId(clearingSystemIdentification2Choice);
            ((ClearingSystemMemberIdentification2)object).setMmbId(sEPACreditTransfer.getMmbId());
            financialInstitutionIdentification7.setClrSysMmbId((ClearingSystemMemberIdentification2)object);
        } else {
            financialInstitutionIdentification7.setBIC(sEPACreditTransfer.getBIC());
            if (sEPACreditTransfer.isAddCountryCodeFromIBANToBIC()) {
                object = new PostalAddress6();
                financialInstitutionIdentification7.setPstlAdr((PostalAddress6)object);
                ((PostalAddress6)object).setCtry(sEPACreditTransfer.getIBAN().substring(0, 2));
            }
        }
        if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            paymentInstructionInformation3.setChrgBr(ChargeBearerType1Code.fromValue(sEPACreditTransfer.getChargeBearer().name()));
        }
        object = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            object = ((BigDecimal)object).add(sEPACreditTransferTransaction.getAmount());
            paymentInstructionInformation3.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), sEPACreditTransfer.getEnd2EndId(), ++n, sEPACreditTransfer.isSetTxNo()));
        }
        paymentInstructionInformation3.setCtrlSum(((BigDecimal)object).setScale(2));
        return object;
    }

    private CreditTransferTransactionInformation10 getCreditTransferTransaction(SEPACreditTransferTransaction sEPACreditTransferTransaction, SEPACreditTransfer sEPACreditTransfer, boolean bl, String string, int n, boolean bl2) {
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        CreditTransferTransactionInformation10 creditTransferTransactionInformation10 = new CreditTransferTransactionInformation10();
        PaymentIdentification1 paymentIdentification1 = new PaymentIdentification1();
        creditTransferTransactionInformation10.setPmtId(paymentIdentification1);
        if (bl) {
            paymentIdentification1.setEndToEndId(IDGenerator.generateId());
        } else if (sEPACreditTransfer.isEnd2EndIdFromFile() && StringUtils.trimToNull(sEPACreditTransferTransaction.getEnd2EndId()) != null) {
            paymentIdentification1.setEndToEndId(sEPACreditTransferTransaction.getEnd2EndId());
        } else if (StringUtils.trimToNull(string) != null) {
            paymentIdentification1.setEndToEndId(string);
        } else {
            paymentIdentification1.setEndToEndId("NOTPROVIDED");
        }
        sEPACreditTransferTransaction.setEnd2EndId(paymentIdentification1.getEndToEndId());
        if (bl2) {
            paymentIdentification1.setInstrId(String.valueOf(n));
        }
        if (sEPACreditTransfer.isPaymentTypeInformationOnTrxLevel()) {
            object6 = new PaymentTypeInformation19();
            if (sEPACreditTransfer.isUseFastCreditTransfer()) {
                ((PaymentTypeInformation19)object6).setInstrPrty(Priority2Code.HIGH);
            }
            if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
                object5 = new ServiceLevel8Choice();
                ((ServiceLevel8Choice)object5).setCd(sEPACreditTransfer.getServiceLevel().name());
                ((PaymentTypeInformation19)object6).setSvcLvl((ServiceLevel8Choice)object5);
            }
            if (sEPACreditTransfer.isInstantCT()) {
                object5 = new LocalInstrument2Choice();
                ((LocalInstrument2Choice)object5).setCd("INST");
                ((PaymentTypeInformation19)object6).setLclInstrm((LocalInstrument2Choice)object5);
            }
            if (sEPACreditTransfer.isSetLocalInstrumentCore()) {
                object5 = new LocalInstrument2Choice();
                ((LocalInstrument2Choice)object5).setCd("CORE");
                ((PaymentTypeInformation19)object6).setLclInstrm((LocalInstrument2Choice)object5);
            }
            if (sEPACreditTransfer.isSplitPayment()) {
                object5 = new LocalInstrument2Choice();
                ((LocalInstrument2Choice)object5).setCd("OTHR/VAT53");
                ((PaymentTypeInformation19)object6).setLclInstrm((LocalInstrument2Choice)object5);
            }
            if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY || sEPACreditTransfer.isSplitPayment()) {
                object5 = new CategoryPurpose1Choice();
                ((CategoryPurpose1Choice)object5).setCd(sEPACreditTransfer.getCategoryPurpose().name());
                ((PaymentTypeInformation19)object6).setCtgyPurp((CategoryPurpose1Choice)object5);
                if (sEPACreditTransfer.isSplitPayment()) {
                    ((CategoryPurpose1Choice)object5).setCd("SPLI");
                    ((PaymentTypeInformation19)object6).setCtgyPurp((CategoryPurpose1Choice)object5);
                }
            }
            if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY || sEPACreditTransfer.isUseFastCreditTransfer() || sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY || sEPACreditTransfer.isInstantCT() || sEPACreditTransfer.isSetLocalInstrumentCore() || sEPACreditTransfer.isSplitPayment()) {
                creditTransferTransactionInformation10.setPmtTpInf((PaymentTypeInformation19)object6);
            }
        }
        object6 = new AmountType3Choice();
        creditTransferTransactionInformation10.setAmt((AmountType3Choice)object6);
        object5 = new ActiveOrHistoricCurrencyAndAmount();
        ((AmountType3Choice)object6).setInstdAmt((ActiveOrHistoricCurrencyAndAmount)object5);
        String string2 = sEPACreditTransfer.getCurrency();
        if (sEPACreditTransferTransaction.getCurrency() != null) {
            string2 = sEPACreditTransferTransaction.getCurrency();
        }
        ((ActiveOrHistoricCurrencyAndAmount)object5).setValue(sEPACreditTransferTransaction.getAmount());
        ((ActiveOrHistoricCurrencyAndAmount)object5).setCcy(string2);
        if (sEPACreditTransferTransaction.getBIC() != null && !sEPACreditTransferTransaction.getBIC().isEmpty()) {
            object4 = new BranchAndFinancialInstitutionIdentification4();
            creditTransferTransactionInformation10.setCdtrAgt((BranchAndFinancialInstitutionIdentification4)object4);
            object3 = new FinancialInstitutionIdentification7();
            ((BranchAndFinancialInstitutionIdentification4)object4).setFinInstnId((FinancialInstitutionIdentification7)object3);
            if (sEPACreditTransfer.isUseBankgiro()) {
                stringArray = new ClearingSystemMemberIdentification2();
                object2 = new ClearingSystemIdentification2Choice();
                ((ClearingSystemIdentification2Choice)object2).setCd(sEPACreditTransferTransaction.getClrSysId());
                stringArray.setClrSysId((ClearingSystemIdentification2Choice)object2);
                stringArray.setMmbId(sEPACreditTransferTransaction.getMmbId());
                ((FinancialInstitutionIdentification7)object3).setClrSysMmbId((ClearingSystemMemberIdentification2)stringArray);
            } else {
                ((FinancialInstitutionIdentification7)object3).setBIC(sEPACreditTransferTransaction.getBIC());
                if (sEPACreditTransfer.isAddCountryCodeFromIBANToBIC()) {
                    stringArray = new PostalAddress6();
                    ((FinancialInstitutionIdentification7)object3).setPstlAdr((PostalAddress6)stringArray);
                    stringArray.setCtry(sEPACreditTransferTransaction.getIBAN().substring(0, 2));
                }
            }
        }
        object4 = new PartyIdentification32();
        creditTransferTransactionInformation10.setCdtr((PartyIdentification32)object4);
        ((PartyIdentification32)object4).setNm(sEPACreditTransferTransaction.getKontoinhaber());
        if (sEPACreditTransferTransaction.getCountryCode() != null || sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty() || sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
            object3 = new PostalAddress6();
            ((PartyIdentification32)object4).setPstlAdr((PostalAddress6)object3);
            if (!sEPACreditTransferTransaction.getCountryCode().isEmpty()) {
                ((PostalAddress6)object3).setCtry(sEPACreditTransferTransaction.getCountryCode());
            }
            if (sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    ((PostalAddress6)object3).setStrtNm(sEPACreditTransferTransaction.getAddressLine1());
                } else {
                    ((PostalAddress6)object3).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine1());
                }
            }
            if (sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    stringArray = sEPACreditTransferTransaction.getAddressLine2().split(" ");
                    ((PostalAddress6)object3).setPstCd(stringArray[0]);
                    if (stringArray.length > 1) {
                        object2 = "";
                        for (int i = 1; i < stringArray.length; ++i) {
                            object = stringArray[i];
                            object2 = i > 1 ? (String)object2 + " " + (String)object : (String)object2 + (String)object;
                        }
                        ((PostalAddress6)object3).setTwnNm((String)object2);
                    }
                } else {
                    ((PostalAddress6)object3).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine2());
                }
            }
        }
        object3 = new CashAccount16();
        creditTransferTransactionInformation10.setCdtrAcct((CashAccount16)object3);
        stringArray = new AccountIdentification4Choice();
        ((CashAccount16)object3).setId((AccountIdentification4Choice)stringArray);
        if (sEPACreditTransfer.isUseBankgiro()) {
            object2 = new GenericAccountIdentification1();
            AccountSchemeName1Choice accountSchemeName1Choice = new AccountSchemeName1Choice();
            accountSchemeName1Choice.setPrtry("BGNR");
            ((GenericAccountIdentification1)object2).setSchmeNm(accountSchemeName1Choice);
            ((GenericAccountIdentification1)object2).setId(sEPACreditTransferTransaction.getIBAN());
            stringArray.setOthr((GenericAccountIdentification1)object2);
        } else if (sEPACreditTransfer.isAccountNoInsteadOfIBAN()) {
            object2 = new GenericAccountIdentification1();
            ((GenericAccountIdentification1)object2).setId(sEPACreditTransferTransaction.getIBAN());
            stringArray.setOthr((GenericAccountIdentification1)object2);
        } else {
            stringArray.setIBAN(sEPACreditTransferTransaction.getIBAN());
        }
        if (sEPACreditTransfer.isSwiftConf()) {
            creditTransferTransactionInformation10.setInstrForDbtrAgt("ADEB");
        }
        if (sEPACreditTransfer.getRegulatoryReportingCode() != null && !sEPACreditTransfer.getRegulatoryReportingCode().isEmpty() && !sEPACreditTransfer.isRegulatoryReportingCodeFromFile() || sEPACreditTransferTransaction.getRegulatoryReportingCode() != null && !sEPACreditTransferTransaction.getRegulatoryReportingCode().isEmpty() && sEPACreditTransfer.isRegulatoryReportingCodeFromFile()) {
            object2 = new RegulatoryReporting3();
            StructuredRegulatoryReporting3 structuredRegulatoryReporting3 = new StructuredRegulatoryReporting3();
            structuredRegulatoryReporting3.setCd(sEPACreditTransfer.isRegulatoryReportingCodeFromFile() ? sEPACreditTransferTransaction.getRegulatoryReportingCode() : sEPACreditTransfer.getRegulatoryReportingCode());
            ((RegulatoryReporting3)object2).getDtls().add(structuredRegulatoryReporting3);
            creditTransferTransactionInformation10.getRgltryRptg().add((RegulatoryReporting3)object2);
        }
        object2 = new RemittanceInformation5();
        creditTransferTransactionInformation10.setRmtInf((RemittanceInformation5)object2);
        if (sEPACreditTransfer.isUseSCOR()) {
            StructuredRemittanceInformation7 structuredRemittanceInformation7 = new StructuredRemittanceInformation7();
            object = new RemittanceAmount1();
            ActiveOrHistoricCurrencyAndAmount activeOrHistoricCurrencyAndAmount = new ActiveOrHistoricCurrencyAndAmount();
            activeOrHistoricCurrencyAndAmount.setCcy(string2);
            activeOrHistoricCurrencyAndAmount.setValue(sEPACreditTransferTransaction.getAmount());
            ((RemittanceAmount1)object).setRmtdAmt(activeOrHistoricCurrencyAndAmount);
            structuredRemittanceInformation7.setRfrdDocAmt((RemittanceAmount1)object);
            CreditorReferenceInformation2 creditorReferenceInformation2 = new CreditorReferenceInformation2();
            CreditorReferenceType2 creditorReferenceType2 = new CreditorReferenceType2();
            CreditorReferenceType1Choice creditorReferenceType1Choice = new CreditorReferenceType1Choice();
            creditorReferenceType1Choice.setCd(DocumentType3Code.SCOR);
            creditorReferenceType2.setCdOrPrtry(creditorReferenceType1Choice);
            creditorReferenceInformation2.setTp(creditorReferenceType2);
            creditorReferenceInformation2.setRef(sEPACreditTransferTransaction.getVerwendungszweck());
            structuredRemittanceInformation7.setCdtrRefInf(creditorReferenceInformation2);
            ((RemittanceInformation5)object2).getStrd().add(structuredRemittanceInformation7);
        } else {
            ((RemittanceInformation5)object2).getUstrd().add(sEPACreditTransferTransaction.getVerwendungszweck());
        }
        return creditTransferTransactionInformation10;
    }
}

