/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPACreditTransferTransaction;
import com.codecamp.sepa.core.ServiceLevel;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.pain001_001_03_ch_02.AccountIdentification4ChoiceCH;
import com.codecamp.sepa.pain001_001_03_ch_02.ActiveOrHistoricCurrencyAndAmount;
import com.codecamp.sepa.pain001_001_03_ch_02.AmountType3Choice;
import com.codecamp.sepa.pain001_001_03_ch_02.BranchAndFinancialInstitutionIdentification4CH;
import com.codecamp.sepa.pain001_001_03_ch_02.BranchAndFinancialInstitutionIdentification4CHBicOrClrId;
import com.codecamp.sepa.pain001_001_03_ch_02.CashAccount16CHId;
import com.codecamp.sepa.pain001_001_03_ch_02.CashAccount16CHIdTpCcy;
import com.codecamp.sepa.pain001_001_03_ch_02.CategoryPurpose1CHCode;
import com.codecamp.sepa.pain001_001_03_ch_02.ChargeBearerType1Code;
import com.codecamp.sepa.pain001_001_03_ch_02.ContactDetails2CH;
import com.codecamp.sepa.pain001_001_03_ch_02.CreditTransferTransactionInformation10CH;
import com.codecamp.sepa.pain001_001_03_ch_02.CreditorReferenceInformation2;
import com.codecamp.sepa.pain001_001_03_ch_02.CreditorReferenceType1Choice;
import com.codecamp.sepa.pain001_001_03_ch_02.CreditorReferenceType2;
import com.codecamp.sepa.pain001_001_03_ch_02.CustomerCreditTransferInitiationV03CH;
import com.codecamp.sepa.pain001_001_03_ch_02.Document;
import com.codecamp.sepa.pain001_001_03_ch_02.FinancialInstitutionIdentification7CH;
import com.codecamp.sepa.pain001_001_03_ch_02.FinancialInstitutionIdentification7CHBicOrClrId;
import com.codecamp.sepa.pain001_001_03_ch_02.GenericAccountIdentification1CH;
import com.codecamp.sepa.pain001_001_03_ch_02.GenericOrganisationIdentification1;
import com.codecamp.sepa.pain001_001_03_ch_02.GenericPersonIdentification1;
import com.codecamp.sepa.pain001_001_03_ch_02.GroupHeader32CH;
import com.codecamp.sepa.pain001_001_03_ch_02.LocalInstrument2Choice;
import com.codecamp.sepa.pain001_001_03_ch_02.OrganisationIdentification4CH;
import com.codecamp.sepa.pain001_001_03_ch_02.Party6ChoiceCH;
import com.codecamp.sepa.pain001_001_03_ch_02.PartyIdentification32CH;
import com.codecamp.sepa.pain001_001_03_ch_02.PartyIdentification32CHName;
import com.codecamp.sepa.pain001_001_03_ch_02.PartyIdentification32CHNameAndId;
import com.codecamp.sepa.pain001_001_03_ch_02.PaymentIdentification1;
import com.codecamp.sepa.pain001_001_03_ch_02.PaymentInstructionInformation3CH;
import com.codecamp.sepa.pain001_001_03_ch_02.PaymentMethod3Code;
import com.codecamp.sepa.pain001_001_03_ch_02.PaymentTypeInformation19CH;
import com.codecamp.sepa.pain001_001_03_ch_02.PersonIdentification5CH;
import com.codecamp.sepa.pain001_001_03_ch_02.PostalAddress6CH;
import com.codecamp.sepa.pain001_001_03_ch_02.Priority2Code;
import com.codecamp.sepa.pain001_001_03_ch_02.RegulatoryReporting3;
import com.codecamp.sepa.pain001_001_03_ch_02.RemittanceInformation5CH;
import com.codecamp.sepa.pain001_001_03_ch_02.ServiceLevel8Choice;
import com.codecamp.sepa.pain001_001_03_ch_02.StructuredRegulatoryReporting3;
import com.codecamp.sepa.pain001_001_03_ch_02.StructuredRemittanceInformation7;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLCreditTransferBuilder001CH {
    private final Logger logger = Logger.getLogger(SEPAXMLCreditTransferBuilder001CH.class.getName());

    public Document getCreditTransfer(SEPACreditTransfer sEPACreditTransfer) {
        Object object;
        String string = sEPACreditTransfer.getCurrency();
        Document document = new Document();
        CustomerCreditTransferInitiationV03CH customerCreditTransferInitiationV03CH = new CustomerCreditTransferInitiationV03CH();
        document.setCstmrCdtTrfInitn(customerCreditTransferInitiationV03CH);
        GroupHeader32CH groupHeader32CH = new GroupHeader32CH();
        customerCreditTransferInitiationV03CH.setGrpHdr(groupHeader32CH);
        groupHeader32CH.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            groupHeader32CH.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string2 = String.valueOf(sEPACreditTransfer.getTransactionList().size());
        groupHeader32CH.setNbOfTxs(string2);
        if (sEPACreditTransfer.isNameInInitParty() || sEPACreditTransfer.isAddSoftwareNameAndVendor()) {
            object = new PartyIdentification32CHNameAndId();
            groupHeader32CH.setInitgPty((PartyIdentification32CHNameAndId)object);
            if (sEPACreditTransfer.isNameInInitParty()) {
                ((PartyIdentification32CHNameAndId)object).setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.isAddSoftwareNameAndVendor()) {
                ContactDetails2CH contactDetails2CH = new ContactDetails2CH();
                ((PartyIdentification32CHNameAndId)object).setCtctDtls(contactDetails2CH);
                SEPAPreferences sEPAPreferences = new SEPAPreferences();
                contactDetails2CH.setNm(sEPAPreferences.loadPreference(FieldType.SOFTWARE_NAME_AND_VENDOR.name(), "SEPAApp/Janus Software Solutions"));
            }
        }
        object = new BigDecimal(0).setScale(2);
        object = sEPACreditTransfer.getUsePIIforEachTrx() || sEPACreditTransfer.isExecutionDateFromFile() || sEPACreditTransfer.isPayerFromFile() ? this.addPIIForEachTrx(sEPACreditTransfer, customerCreditTransferInitiationV03CH, string) : this.addSinglePII(sEPACreditTransfer, customerCreditTransferInitiationV03CH, string2, string);
        groupHeader32CH.setCtrlSum(((BigDecimal)object).setScale(2));
        sEPACreditTransfer.setSumOfTx(((BigDecimal)object).setScale(2));
        return document;
    }

    private BigDecimal addPIIForEachTrx(SEPACreditTransfer sEPACreditTransfer, CustomerCreditTransferInitiationV03CH customerCreditTransferInitiationV03CH, String string) {
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            Object object;
            String[] stringArray;
            Object object2;
            Object object3;
            Object object4;
            PaymentInstructionInformation3CH paymentInstructionInformation3CH = new PaymentInstructionInformation3CH();
            customerCreditTransferInitiationV03CH.getPmtInf().add(paymentInstructionInformation3CH);
            if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty() && sEPACreditTransfer.isIdentIdOrg()) {
                object4 = new PartyIdentification32CH();
                object3 = new Party6ChoiceCH();
                ((PartyIdentification32CH)object4).setId((Party6ChoiceCH)object3);
                paymentInstructionInformation3CH.setUltmtDbtr((PartyIdentification32CH)object4);
                object2 = new GenericOrganisationIdentification1();
                ((GenericOrganisationIdentification1)object2).setId(sEPACreditTransfer.getIdentificationID());
                stringArray = new OrganisationIdentification4CH();
                stringArray.setOthr((GenericOrganisationIdentification1)object2);
                ((Party6ChoiceCH)object3).setOrgId((OrganisationIdentification4CH)stringArray);
            }
            if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty() && sEPACreditTransfer.isIdentIdPrv()) {
                object4 = new PartyIdentification32CH();
                object3 = new Party6ChoiceCH();
                ((PartyIdentification32CH)object4).setId((Party6ChoiceCH)object3);
                paymentInstructionInformation3CH.setUltmtDbtr((PartyIdentification32CH)object4);
                object2 = new GenericPersonIdentification1();
                ((GenericPersonIdentification1)object2).setId(sEPACreditTransfer.getIdentificationID());
                stringArray = new PersonIdentification5CH();
                stringArray.setOthr((GenericPersonIdentification1)object2);
                ((Party6ChoiceCH)object3).setPrvtId((PersonIdentification5CH)stringArray);
            }
            paymentInstructionInformation3CH.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
            paymentInstructionInformation3CH.setPmtMtd(PaymentMethod3Code.TRF);
            if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.YES)) {
                paymentInstructionInformation3CH.setBtchBookg(Boolean.TRUE);
            } else if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.NO)) {
                paymentInstructionInformation3CH.setBtchBookg(Boolean.FALSE);
            }
            paymentInstructionInformation3CH.setNbOfTxs("1");
            if (!sEPACreditTransfer.isNationalPayment()) {
                object4 = new PaymentTypeInformation19CH();
                if (sEPACreditTransfer.isUseFastCreditTransfer()) {
                    ((PaymentTypeInformation19CH)object4).setInstrPrty(Priority2Code.HIGH);
                }
                if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
                    object3 = new ServiceLevel8Choice();
                    ((ServiceLevel8Choice)object3).setCd(sEPACreditTransfer.getServiceLevel().name());
                    ((PaymentTypeInformation19CH)object4).setSvcLvl((ServiceLevel8Choice)object3);
                }
                if (sEPACreditTransfer.isInstantCT()) {
                    object3 = new LocalInstrument2Choice();
                    ((LocalInstrument2Choice)object3).setCd("INST");
                    ((PaymentTypeInformation19CH)object4).setLclInstrm((LocalInstrument2Choice)object3);
                }
                if (sEPACreditTransfer.isSetLocalInstrumentCore()) {
                    object3 = new LocalInstrument2Choice();
                    ((LocalInstrument2Choice)object3).setCd("CORE");
                    ((PaymentTypeInformation19CH)object4).setLclInstrm((LocalInstrument2Choice)object3);
                }
                if (sEPACreditTransfer.isUseFastCreditTransfer() || sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY || sEPACreditTransfer.isInstantCT() || sEPACreditTransfer.isSetLocalInstrumentCore()) {
                    paymentInstructionInformation3CH.setPmtTpInf((PaymentTypeInformation19CH)object4);
                }
            } else {
                string = "CHF";
            }
            if (sEPACreditTransfer.isUseESRKtoNo()) {
                object4 = new PaymentTypeInformation19CH();
                paymentInstructionInformation3CH.setPmtTpInf((PaymentTypeInformation19CH)object4);
                object3 = new LocalInstrument2Choice();
                ((LocalInstrument2Choice)object3).setPrtry("CH01");
                ((PaymentTypeInformation19CH)object4).setLclInstrm((LocalInstrument2Choice)object3);
            }
            if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY) {
                object4 = new PaymentTypeInformation19CH();
                paymentInstructionInformation3CH.setPmtTpInf((PaymentTypeInformation19CH)object4);
                object3 = new CategoryPurpose1CHCode();
                ((CategoryPurpose1CHCode)object3).setCd(sEPACreditTransfer.getCategoryPurpose().name());
                ((PaymentTypeInformation19CH)object4).setCtgyPurp((CategoryPurpose1CHCode)object3);
            }
            try {
                object4 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.isExecutionDateFromFile() ? sEPACreditTransferTransaction.getExecutionDate() : sEPACreditTransfer.getExecutionDate());
                paymentInstructionInformation3CH.setReqdExctnDt((XMLGregorianCalendar)object4);
                ((XMLGregorianCalendar)object4).setTimezone(Integer.MIN_VALUE);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
            }
            object3 = new PartyIdentification32CH();
            paymentInstructionInformation3CH.setDbtr((PartyIdentification32CH)object3);
            if (sEPACreditTransfer.isPayerFromFile()) {
                ((PartyIdentification32CH)object3).setNm(sEPACreditTransferTransaction.getKontoinhaberPayerTrx());
            } else {
                ((PartyIdentification32CH)object3).setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                object2 = new PostalAddress6CH();
                ((PartyIdentification32CH)object3).setPstlAdr((PostalAddress6CH)object2);
                if (sEPACreditTransfer.getCountryCode() != null) {
                    ((PostalAddress6CH)object2).setCtry(sEPACreditTransfer.getCountryCode());
                }
                if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                    if (sEPACreditTransfer.isUseStructuredAddress()) {
                        ((PostalAddress6CH)object2).setStrtNm(sEPACreditTransfer.getAddressLine1());
                    } else {
                        ((PostalAddress6CH)object2).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
                    }
                }
                if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                    if (sEPACreditTransfer.isUseStructuredAddress()) {
                        stringArray = sEPACreditTransfer.getAddressLine2().split(" ");
                        ((PostalAddress6CH)object2).setPstCd(stringArray[0]);
                        if (stringArray.length > 1) {
                            object = "";
                            for (int i = 1; i < stringArray.length; ++i) {
                                String string2 = stringArray[i];
                                object = i > 1 ? (String)object + " " + string2 : (String)object + string2;
                            }
                            ((PostalAddress6CH)object2).setTwnNm((String)object);
                        }
                    } else {
                        ((PostalAddress6CH)object2).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
                    }
                }
            }
            object2 = new CashAccount16CHIdTpCcy();
            paymentInstructionInformation3CH.setDbtrAcct((CashAccount16CHIdTpCcy)object2);
            if (sEPACreditTransfer.isSetDebitorCurrency()) {
                ((CashAccount16CHIdTpCcy)object2).setCcy(string);
            }
            stringArray = new AccountIdentification4ChoiceCH();
            ((CashAccount16CHIdTpCcy)object2).setId((AccountIdentification4ChoiceCH)stringArray);
            if (sEPACreditTransfer.isPayerFromFile()) {
                stringArray.setIBAN(sEPACreditTransferTransaction.getIBANPayerTrx());
            } else {
                stringArray.setIBAN(sEPACreditTransfer.getIBAN());
            }
            object = new BranchAndFinancialInstitutionIdentification4CHBicOrClrId();
            paymentInstructionInformation3CH.setDbtrAgt((BranchAndFinancialInstitutionIdentification4CHBicOrClrId)object);
            FinancialInstitutionIdentification7CHBicOrClrId financialInstitutionIdentification7CHBicOrClrId = new FinancialInstitutionIdentification7CHBicOrClrId();
            ((BranchAndFinancialInstitutionIdentification4CHBicOrClrId)object).setFinInstnId(financialInstitutionIdentification7CHBicOrClrId);
            if (sEPACreditTransfer.isPayerFromFile()) {
                financialInstitutionIdentification7CHBicOrClrId.setBIC(sEPACreditTransferTransaction.getBICPayerTrx());
            } else {
                financialInstitutionIdentification7CHBicOrClrId.setBIC(sEPACreditTransfer.getBIC());
            }
            if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
                paymentInstructionInformation3CH.setChrgBr(ChargeBearerType1Code.fromValue(sEPACreditTransfer.getChargeBearer().name()));
            }
            bigDecimal = bigDecimal.add(sEPACreditTransferTransaction.getAmount());
            paymentInstructionInformation3CH.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), 1, sEPACreditTransfer.getEnd2EndId(), string));
        }
        return bigDecimal;
    }

    private BigDecimal addSinglePII(SEPACreditTransfer sEPACreditTransfer, CustomerCreditTransferInitiationV03CH customerCreditTransferInitiationV03CH, String string, String string2) {
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object4;
        Object object5;
        PaymentInstructionInformation3CH paymentInstructionInformation3CH = new PaymentInstructionInformation3CH();
        customerCreditTransferInitiationV03CH.getPmtInf().add(paymentInstructionInformation3CH);
        if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty() && sEPACreditTransfer.isIdentIdOrg()) {
            object5 = new PartyIdentification32CH();
            object4 = new Party6ChoiceCH();
            ((PartyIdentification32CH)object5).setId((Party6ChoiceCH)object4);
            paymentInstructionInformation3CH.setUltmtDbtr((PartyIdentification32CH)object5);
            object3 = new GenericOrganisationIdentification1();
            ((GenericOrganisationIdentification1)object3).setId(sEPACreditTransfer.getIdentificationID());
            stringArray = new OrganisationIdentification4CH();
            stringArray.setOthr((GenericOrganisationIdentification1)object3);
            ((Party6ChoiceCH)object4).setOrgId((OrganisationIdentification4CH)stringArray);
        }
        if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty() && sEPACreditTransfer.isIdentIdPrv()) {
            object5 = new PartyIdentification32CH();
            object4 = new Party6ChoiceCH();
            ((PartyIdentification32CH)object5).setId((Party6ChoiceCH)object4);
            paymentInstructionInformation3CH.setUltmtDbtr((PartyIdentification32CH)object5);
            object3 = new GenericPersonIdentification1();
            ((GenericPersonIdentification1)object3).setId(sEPACreditTransfer.getIdentificationID());
            stringArray = new PersonIdentification5CH();
            stringArray.setOthr((GenericPersonIdentification1)object3);
            ((Party6ChoiceCH)object4).setPrvtId((PersonIdentification5CH)stringArray);
        }
        paymentInstructionInformation3CH.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
        paymentInstructionInformation3CH.setPmtMtd(PaymentMethod3Code.TRF);
        sEPACreditTransfer.setPmtInfId(paymentInstructionInformation3CH.getPmtInfId());
        if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.YES)) {
            paymentInstructionInformation3CH.setBtchBookg(Boolean.TRUE);
        } else if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.NO)) {
            paymentInstructionInformation3CH.setBtchBookg(Boolean.FALSE);
        }
        paymentInstructionInformation3CH.setNbOfTxs(string);
        if (!sEPACreditTransfer.isNationalPayment()) {
            object5 = new PaymentTypeInformation19CH();
            if (sEPACreditTransfer.isUseFastCreditTransfer()) {
                ((PaymentTypeInformation19CH)object5).setInstrPrty(Priority2Code.HIGH);
            }
            if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
                object4 = new ServiceLevel8Choice();
                ((ServiceLevel8Choice)object4).setCd(sEPACreditTransfer.getServiceLevel().name());
                ((PaymentTypeInformation19CH)object5).setSvcLvl((ServiceLevel8Choice)object4);
            }
            if (sEPACreditTransfer.isInstantCT()) {
                object4 = new LocalInstrument2Choice();
                ((LocalInstrument2Choice)object4).setCd("INST");
                ((PaymentTypeInformation19CH)object5).setLclInstrm((LocalInstrument2Choice)object4);
            }
            if (sEPACreditTransfer.isSetLocalInstrumentCore()) {
                object4 = new LocalInstrument2Choice();
                ((LocalInstrument2Choice)object4).setCd("CORE");
                ((PaymentTypeInformation19CH)object5).setLclInstrm((LocalInstrument2Choice)object4);
            }
            if (sEPACreditTransfer.isUseFastCreditTransfer() || sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY || sEPACreditTransfer.isInstantCT() || sEPACreditTransfer.isSetLocalInstrumentCore()) {
                paymentInstructionInformation3CH.setPmtTpInf((PaymentTypeInformation19CH)object5);
            }
        } else {
            string2 = "CHF";
        }
        if (sEPACreditTransfer.isUseESRKtoNo()) {
            object5 = new PaymentTypeInformation19CH();
            paymentInstructionInformation3CH.setPmtTpInf((PaymentTypeInformation19CH)object5);
            object4 = new LocalInstrument2Choice();
            ((LocalInstrument2Choice)object4).setPrtry("CH01");
            ((PaymentTypeInformation19CH)object5).setLclInstrm((LocalInstrument2Choice)object4);
        }
        if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY) {
            object5 = new PaymentTypeInformation19CH();
            paymentInstructionInformation3CH.setPmtTpInf((PaymentTypeInformation19CH)object5);
            object4 = new CategoryPurpose1CHCode();
            ((CategoryPurpose1CHCode)object4).setCd(sEPACreditTransfer.getCategoryPurpose().name());
            ((PaymentTypeInformation19CH)object5).setCtgyPurp((CategoryPurpose1CHCode)object4);
        }
        try {
            object5 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.getExecutionDate());
            paymentInstructionInformation3CH.setReqdExctnDt((XMLGregorianCalendar)object5);
            ((XMLGregorianCalendar)object5).setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
        }
        object4 = new PartyIdentification32CH();
        paymentInstructionInformation3CH.setDbtr((PartyIdentification32CH)object4);
        ((PartyIdentification32CH)object4).setNm(sEPACreditTransfer.getKontoinhaber());
        if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
            object3 = new PostalAddress6CH();
            ((PartyIdentification32CH)object4).setPstlAdr((PostalAddress6CH)object3);
            if (sEPACreditTransfer.getCountryCode() != null) {
                ((PostalAddress6CH)object3).setCtry(sEPACreditTransfer.getCountryCode());
            }
            if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    ((PostalAddress6CH)object3).setStrtNm(sEPACreditTransfer.getAddressLine1());
                } else {
                    ((PostalAddress6CH)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
                }
            }
            if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    stringArray = sEPACreditTransfer.getAddressLine2().split(" ");
                    ((PostalAddress6CH)object3).setPstCd(stringArray[0]);
                    if (stringArray.length > 1) {
                        object2 = "";
                        for (int i = 1; i < stringArray.length; ++i) {
                            object = stringArray[i];
                            object2 = i > 1 ? (String)object2 + " " + (String)object : (String)object2 + (String)object;
                        }
                        ((PostalAddress6CH)object3).setTwnNm((String)object2);
                    }
                } else {
                    ((PostalAddress6CH)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
                }
            }
        }
        object3 = new CashAccount16CHIdTpCcy();
        paymentInstructionInformation3CH.setDbtrAcct((CashAccount16CHIdTpCcy)object3);
        if (sEPACreditTransfer.isSetDebitorCurrency()) {
            ((CashAccount16CHIdTpCcy)object3).setCcy(string2);
        }
        stringArray = new AccountIdentification4ChoiceCH();
        ((CashAccount16CHIdTpCcy)object3).setId((AccountIdentification4ChoiceCH)stringArray);
        stringArray.setIBAN(sEPACreditTransfer.getIBAN());
        object2 = new BranchAndFinancialInstitutionIdentification4CHBicOrClrId();
        paymentInstructionInformation3CH.setDbtrAgt((BranchAndFinancialInstitutionIdentification4CHBicOrClrId)object2);
        FinancialInstitutionIdentification7CHBicOrClrId financialInstitutionIdentification7CHBicOrClrId = new FinancialInstitutionIdentification7CHBicOrClrId();
        ((BranchAndFinancialInstitutionIdentification4CHBicOrClrId)object2).setFinInstnId(financialInstitutionIdentification7CHBicOrClrId);
        financialInstitutionIdentification7CHBicOrClrId.setBIC(sEPACreditTransfer.getBIC());
        if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            paymentInstructionInformation3CH.setChrgBr(ChargeBearerType1Code.fromValue(sEPACreditTransfer.getChargeBearer().name()));
        }
        object = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            object = ((BigDecimal)object).add(sEPACreditTransferTransaction.getAmount());
            paymentInstructionInformation3CH.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), ++n, sEPACreditTransfer.getEnd2EndId(), string2));
        }
        return object;
    }

    private CreditTransferTransactionInformation10CH getCreditTransferTransaction(SEPACreditTransferTransaction sEPACreditTransferTransaction, SEPACreditTransfer sEPACreditTransfer, boolean bl, int n, String string, String string2) {
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object4;
        CreditTransferTransactionInformation10CH creditTransferTransactionInformation10CH = new CreditTransferTransactionInformation10CH();
        PaymentIdentification1 paymentIdentification1 = new PaymentIdentification1();
        creditTransferTransactionInformation10CH.setPmtId(paymentIdentification1);
        if (bl) {
            paymentIdentification1.setEndToEndId(IDGenerator.generateId());
        } else if (sEPACreditTransfer.isEnd2EndIdFromFile() && StringUtils.trimToNull(sEPACreditTransferTransaction.getEnd2EndId()) != null) {
            paymentIdentification1.setEndToEndId(sEPACreditTransferTransaction.getEnd2EndId());
        } else if (StringUtils.trimToNull(string) != null) {
            paymentIdentification1.setEndToEndId(string);
        } else {
            paymentIdentification1.setEndToEndId("NOTPROVIDED");
        }
        sEPACreditTransferTransaction.setEnd2EndId(paymentIdentification1.getEndToEndId());
        paymentIdentification1.setInstrId(String.valueOf(n));
        AmountType3Choice amountType3Choice = new AmountType3Choice();
        creditTransferTransactionInformation10CH.setAmt(amountType3Choice);
        ActiveOrHistoricCurrencyAndAmount activeOrHistoricCurrencyAndAmount = new ActiveOrHistoricCurrencyAndAmount();
        amountType3Choice.setInstdAmt(activeOrHistoricCurrencyAndAmount);
        String string3 = string2;
        if (sEPACreditTransferTransaction.getCurrency() != null) {
            string3 = sEPACreditTransferTransaction.getCurrency();
        }
        activeOrHistoricCurrencyAndAmount.setValue(sEPACreditTransferTransaction.getAmount());
        activeOrHistoricCurrencyAndAmount.setCcy(string3);
        if (sEPACreditTransferTransaction.getBIC() != null && !sEPACreditTransferTransaction.getBIC().isEmpty()) {
            object4 = new BranchAndFinancialInstitutionIdentification4CH();
            creditTransferTransactionInformation10CH.setCdtrAgt((BranchAndFinancialInstitutionIdentification4CH)object4);
            object3 = new FinancialInstitutionIdentification7CH();
            ((BranchAndFinancialInstitutionIdentification4CH)object4).setFinInstnId((FinancialInstitutionIdentification7CH)object3);
            ((FinancialInstitutionIdentification7CH)object3).setBIC(sEPACreditTransferTransaction.getBIC());
            if (sEPACreditTransfer.isAddCountryCodeFromIBANToBIC()) {
                stringArray = new PostalAddress6CH();
                ((FinancialInstitutionIdentification7CH)object3).setPstlAdr((PostalAddress6CH)stringArray);
                stringArray.setCtry(sEPACreditTransferTransaction.getIBAN().substring(0, 2));
            }
        }
        object4 = new PartyIdentification32CHName();
        creditTransferTransactionInformation10CH.setCdtr((PartyIdentification32CHName)object4);
        ((PartyIdentification32CHName)object4).setNm(sEPACreditTransferTransaction.getKontoinhaber());
        if (sEPACreditTransferTransaction.getCountryCode() != null || sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty() || sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
            object3 = new PostalAddress6CH();
            ((PartyIdentification32CHName)object4).setPstlAdr((PostalAddress6CH)object3);
            if (!sEPACreditTransferTransaction.getCountryCode().isEmpty()) {
                ((PostalAddress6CH)object3).setCtry(sEPACreditTransferTransaction.getCountryCode());
            }
            if (sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    ((PostalAddress6CH)object3).setStrtNm(sEPACreditTransferTransaction.getAddressLine1());
                } else {
                    ((PostalAddress6CH)object3).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine1());
                }
            }
            if (sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    stringArray = sEPACreditTransferTransaction.getAddressLine2().split(" ");
                    ((PostalAddress6CH)object3).setPstCd(stringArray[0]);
                    if (stringArray.length > 1) {
                        object2 = "";
                        for (int i = 1; i < stringArray.length; ++i) {
                            object = stringArray[i];
                            object2 = i > 1 ? (String)object2 + " " + (String)object : (String)object2 + (String)object;
                        }
                        ((PostalAddress6CH)object3).setTwnNm((String)object2);
                    }
                } else {
                    ((PostalAddress6CH)object3).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine2());
                }
            }
        }
        object3 = new CashAccount16CHId();
        creditTransferTransactionInformation10CH.setCdtrAcct((CashAccount16CHId)object3);
        stringArray = new AccountIdentification4ChoiceCH();
        ((CashAccount16CHId)object3).setId((AccountIdentification4ChoiceCH)stringArray);
        if (sEPACreditTransfer.isUseESRKtoNo()) {
            object2 = new GenericAccountIdentification1CH();
            ((GenericAccountIdentification1CH)object2).setId(sEPACreditTransferTransaction.getIBAN());
            stringArray.setOthr((GenericAccountIdentification1CH)object2);
        } else if (sEPACreditTransfer.isAccountNoInsteadOfIBAN()) {
            object2 = new GenericAccountIdentification1CH();
            ((GenericAccountIdentification1CH)object2).setId(sEPACreditTransferTransaction.getIBAN());
            stringArray.setOthr((GenericAccountIdentification1CH)object2);
        } else {
            stringArray.setIBAN(sEPACreditTransferTransaction.getIBAN());
        }
        if (sEPACreditTransfer.getRegulatoryReportingCode() != null && !sEPACreditTransfer.getRegulatoryReportingCode().isEmpty() && !sEPACreditTransfer.isRegulatoryReportingCodeFromFile() || sEPACreditTransferTransaction.getRegulatoryReportingCode() != null && !sEPACreditTransferTransaction.getRegulatoryReportingCode().isEmpty() && sEPACreditTransfer.isRegulatoryReportingCodeFromFile()) {
            object2 = new RegulatoryReporting3();
            StructuredRegulatoryReporting3 structuredRegulatoryReporting3 = new StructuredRegulatoryReporting3();
            structuredRegulatoryReporting3.setCd(sEPACreditTransfer.isRegulatoryReportingCodeFromFile() ? sEPACreditTransferTransaction.getRegulatoryReportingCode() : sEPACreditTransfer.getRegulatoryReportingCode());
            ((RegulatoryReporting3)object2).getDtls().add(structuredRegulatoryReporting3);
            creditTransferTransactionInformation10CH.getRgltryRptg().add((RegulatoryReporting3)object2);
        }
        object2 = new RemittanceInformation5CH();
        creditTransferTransactionInformation10CH.setRmtInf((RemittanceInformation5CH)object2);
        if (sEPACreditTransfer.isUseESRReferenceNo()) {
            StructuredRemittanceInformation7 structuredRemittanceInformation7 = new StructuredRemittanceInformation7();
            object = new CreditorReferenceInformation2();
            ((CreditorReferenceInformation2)object).setRef(sEPACreditTransferTransaction.getVerwendungszweck());
            structuredRemittanceInformation7.setCdtrRefInf((CreditorReferenceInformation2)object);
            ((RemittanceInformation5CH)object2).setStrd(structuredRemittanceInformation7);
        } else if (sEPACreditTransfer.isQrRechnung()) {
            StructuredRemittanceInformation7 structuredRemittanceInformation7 = new StructuredRemittanceInformation7();
            object = new CreditorReferenceInformation2();
            ((CreditorReferenceInformation2)object).setRef(sEPACreditTransferTransaction.getVerwendungszweck());
            CreditorReferenceType2 creditorReferenceType2 = new CreditorReferenceType2();
            ((CreditorReferenceInformation2)object).setTp(creditorReferenceType2);
            CreditorReferenceType1Choice creditorReferenceType1Choice = new CreditorReferenceType1Choice();
            creditorReferenceType2.setCdOrPrtry(creditorReferenceType1Choice);
            creditorReferenceType1Choice.setPrtry("QRR");
            structuredRemittanceInformation7.getAddtlRmtInf().add(sEPACreditTransferTransaction.getAdditionalInformation());
            structuredRemittanceInformation7.setCdtrRefInf((CreditorReferenceInformation2)object);
            ((RemittanceInformation5CH)object2).setStrd(structuredRemittanceInformation7);
        } else {
            ((RemittanceInformation5CH)object2).setUstrd(sEPACreditTransferTransaction.getVerwendungszweck());
        }
        return creditTransferTransactionInformation10CH;
    }
}

