/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.cbiPaymentRequest_00_04_00.ActiveOrHistoricCurrencyAndAmount;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIAccountIdentification1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIAmountType1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIBranchAndFinancialInstitutionIdentification2;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIBranchAndFinancialInstitutionIdentification3;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBICashAccount1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBICashAccount2;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIChargeBearerTypeCode;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIClearingSystemMemberIdentification1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBICreditTransferTransactionInformation;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIFinancialInstitutionIdentification2;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIFinancialInstitutionIdentification3;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIGenericIdentification1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIGroupHeader;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIIdType1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIOrganisationIdentification1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIPartyIdentification1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIPartyIdentification3;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIPartyIdentification4;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIPaymentInstructionInformation;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIPaymentRequest000400;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIPaymentTypeInformation1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIPaymentTypeInformation2;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIPostalAddress6;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIRegulatoryReporting1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIServiceLevel1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIServiceLevel1Code;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CBIStructuredRegulatoryReporting1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.CategoryPurpose1Choice;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.PaymentIdentification1;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.PaymentMethod3Code;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.Priority2Code;
import com.codecamp.sepa.cbiPaymentRequest_00_04_00.RemittanceInformation5;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.IDGenerator;
import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPACreditTransferTransaction;
import com.codecamp.sepa.core.ServiceLevel;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class SEPAXMLCreditTransferBuilder001CBI {
    private final Logger logger = Logger.getLogger(SEPAXMLCreditTransferBuilder001CBI.class.getName());

    public CBIPaymentRequest000400 getCreditTransfer(SEPACreditTransfer sEPACreditTransfer) {
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        CBIPaymentRequest000400 cBIPaymentRequest000400 = new CBIPaymentRequest000400();
        CBIPaymentInstructionInformation cBIPaymentInstructionInformation = new CBIPaymentInstructionInformation();
        cBIPaymentRequest000400.setPmtInf(cBIPaymentInstructionInformation);
        CBIGroupHeader cBIGroupHeader = new CBIGroupHeader();
        cBIPaymentRequest000400.setGrpHdr(cBIGroupHeader);
        cBIGroupHeader.setMsgId(IDGenerator.generateId());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            cBIGroupHeader.setCreDtTm(xMLGregorianCalendar);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (generationDate)!", datatypeConfigurationException);
        }
        String string = String.valueOf(sEPACreditTransfer.getTransactionList().size());
        cBIGroupHeader.setNbOfTxs(string);
        if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty() || sEPACreditTransfer.isNameInInitParty()) {
            object6 = new CBIPartyIdentification1();
            cBIGroupHeader.setInitgPty((CBIPartyIdentification1)object6);
            if (sEPACreditTransfer.isNameInInitParty()) {
                ((CBIPartyIdentification1)object6).setNm(sEPACreditTransfer.getKontoinhaber());
            }
            if (sEPACreditTransfer.getIdentificationID() != null && !sEPACreditTransfer.getIdentificationID().isEmpty()) {
                if (sEPACreditTransfer.isIdentIdOrg()) {
                    object5 = new CBIGenericIdentification1();
                    ((CBIGenericIdentification1)object5).setIssr("CBI");
                    ((CBIGenericIdentification1)object5).setId(sEPACreditTransfer.getIdentificationID());
                    object4 = new CBIOrganisationIdentification1();
                    ((CBIOrganisationIdentification1)object4).getOthr().add((CBIGenericIdentification1)object5);
                    object3 = new CBIIdType1();
                    ((CBIIdType1)object3).setOrgId((CBIOrganisationIdentification1)object4);
                    ((CBIPartyIdentification1)object6).setId((CBIIdType1)object3);
                }
                if (sEPACreditTransfer.isIdentIdPrv()) {
                    object5 = new CBIGenericIdentification1();
                    ((CBIGenericIdentification1)object5).setIssr("CBI");
                    ((CBIGenericIdentification1)object5).setId(sEPACreditTransfer.getIdentificationID());
                    object4 = new CBIOrganisationIdentification1();
                    ((CBIOrganisationIdentification1)object4).getOthr().add((CBIGenericIdentification1)object5);
                    object3 = new CBIIdType1();
                    ((CBIIdType1)object3).setOrgId((CBIOrganisationIdentification1)object4);
                    ((CBIPartyIdentification1)object6).setId((CBIIdType1)object3);
                }
            }
        }
        cBIPaymentInstructionInformation.setPmtInfId(StringUtils.trimToNull(sEPACreditTransfer.getPmtInfId()) != null ? sEPACreditTransfer.getPmtInfId() : IDGenerator.generateId());
        cBIPaymentInstructionInformation.setPmtMtd(PaymentMethod3Code.TRF);
        sEPACreditTransfer.setPmtInfId(cBIPaymentInstructionInformation.getPmtInfId());
        if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.YES)) {
            cBIPaymentInstructionInformation.setBtchBookg(Boolean.TRUE);
        } else if (sEPACreditTransfer.getBatchBooking() != null && sEPACreditTransfer.getBatchBooking().equals((Object)BatchBooking.NO)) {
            cBIPaymentInstructionInformation.setBtchBookg(Boolean.FALSE);
        }
        cBIGroupHeader.setNbOfTxs(string);
        object6 = new CBIPaymentTypeInformation1();
        if (sEPACreditTransfer.isUseFastCreditTransfer()) {
            ((CBIPaymentTypeInformation1)object6).setInstrPrty(Priority2Code.HIGH);
        }
        if (sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
            object5 = new CBIServiceLevel1();
            ((CBIServiceLevel1)object5).setCd(CBIServiceLevel1Code.SEPA);
            ((CBIPaymentTypeInformation1)object6).setSvcLvl((CBIServiceLevel1)object5);
        }
        if (sEPACreditTransfer.isUseFastCreditTransfer() || sEPACreditTransfer.getServiceLevel() != null && sEPACreditTransfer.getServiceLevel() != ServiceLevel.EMPTY) {
            cBIPaymentInstructionInformation.setPmtTpInf((CBIPaymentTypeInformation1)object6);
        }
        try {
            object5 = DatatypeFactory.newInstance().newXMLGregorianCalendar(sEPACreditTransfer.getExecutionDate());
            cBIPaymentInstructionInformation.setReqdExctnDt((XMLGregorianCalendar)object5);
            ((XMLGregorianCalendar)object5).setTimezone(Integer.MIN_VALUE);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.log(Level.SEVERE, "Exception while creating XMLGregorianCalender (executionDate)!", datatypeConfigurationException);
        }
        object4 = new CBIPartyIdentification4();
        cBIPaymentInstructionInformation.setDbtr((CBIPartyIdentification4)object4);
        ((CBIPartyIdentification4)object4).setNm(sEPACreditTransfer.getKontoinhaber());
        if (sEPACreditTransfer.getCountryCode() != null || sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty() || sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
            object3 = new CBIPostalAddress6();
            ((CBIPartyIdentification4)object4).setPstlAdr((CBIPostalAddress6)object3);
            if (sEPACreditTransfer.getCountryCode() != null) {
                ((CBIPostalAddress6)object3).setCtry(sEPACreditTransfer.getCountryCode());
            }
            if (sEPACreditTransfer.getAddressLine1() != null && !sEPACreditTransfer.getAddressLine1().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    ((CBIPostalAddress6)object3).setStrtNm(sEPACreditTransfer.getAddressLine1());
                } else {
                    ((CBIPostalAddress6)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine1());
                }
            }
            if (sEPACreditTransfer.getAddressLine2() != null && !sEPACreditTransfer.getAddressLine2().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    stringArray = sEPACreditTransfer.getAddressLine2().split(" ");
                    ((CBIPostalAddress6)object3).setPstCd(stringArray[0]);
                    if (stringArray.length > 1) {
                        object2 = "";
                        for (int i = 1; i < stringArray.length; ++i) {
                            object = stringArray[i];
                            object2 = i > 1 ? (String)object2 + " " + (String)object : (String)object2 + (String)object;
                        }
                        ((CBIPostalAddress6)object3).setTwnNm((String)object2);
                    }
                } else {
                    ((CBIPostalAddress6)object3).getAdrLine().add(sEPACreditTransfer.getAddressLine2());
                }
            }
        }
        object3 = new CBICashAccount1();
        cBIPaymentInstructionInformation.setDbtrAcct((CBICashAccount1)object3);
        stringArray = new CBIAccountIdentification1();
        ((CBICashAccount1)object3).setId((CBIAccountIdentification1)stringArray);
        stringArray.setIBAN(sEPACreditTransfer.getIBAN());
        object2 = new CBIBranchAndFinancialInstitutionIdentification2();
        cBIPaymentInstructionInformation.setDbtrAgt((CBIBranchAndFinancialInstitutionIdentification2)object2);
        CBIFinancialInstitutionIdentification3 cBIFinancialInstitutionIdentification3 = new CBIFinancialInstitutionIdentification3();
        ((CBIBranchAndFinancialInstitutionIdentification2)object2).setFinInstnId(cBIFinancialInstitutionIdentification3);
        cBIFinancialInstitutionIdentification3.setBIC(sEPACreditTransfer.getBIC());
        object = new CBIClearingSystemMemberIdentification1();
        ((CBIClearingSystemMemberIdentification1)object).setMmbId(sEPACreditTransfer.getIBAN().substring(5, 10));
        cBIFinancialInstitutionIdentification3.setClrSysMmbId((CBIClearingSystemMemberIdentification1)object);
        if (sEPACreditTransfer.getChargeBearer() != null && !sEPACreditTransfer.getChargeBearer().equals((Object)ChargeBearer.EMPTY)) {
            cBIPaymentInstructionInformation.setChrgBr(CBIChargeBearerTypeCode.fromValue(sEPACreditTransfer.getChargeBearer().name()));
        }
        BigDecimal bigDecimal = new BigDecimal(0).setScale(2);
        int n = 0;
        for (SEPACreditTransferTransaction sEPACreditTransferTransaction : sEPACreditTransfer.getTransactionList()) {
            bigDecimal = bigDecimal.add(sEPACreditTransferTransaction.getAmount());
            cBIPaymentInstructionInformation.getCdtTrfTxInf().add(this.getCreditTransferTransaction(sEPACreditTransferTransaction, sEPACreditTransfer, sEPACreditTransfer.isGenerateEnd2EndId(), ++n, sEPACreditTransfer.getEnd2EndId()));
        }
        cBIGroupHeader.setCtrlSum(bigDecimal.setScale(2));
        sEPACreditTransfer.setSumOfTx(bigDecimal.setScale(2));
        return cBIPaymentRequest000400;
    }

    private CBICreditTransferTransactionInformation getCreditTransferTransaction(SEPACreditTransferTransaction sEPACreditTransferTransaction, SEPACreditTransfer sEPACreditTransfer, boolean bl, int n, String string) {
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object4;
        CBICreditTransferTransactionInformation cBICreditTransferTransactionInformation = new CBICreditTransferTransactionInformation();
        PaymentIdentification1 paymentIdentification1 = new PaymentIdentification1();
        cBICreditTransferTransactionInformation.setPmtId(paymentIdentification1);
        if (bl) {
            paymentIdentification1.setEndToEndId(IDGenerator.generateId());
        } else if (sEPACreditTransfer.isEnd2EndIdFromFile() && StringUtils.trimToNull(sEPACreditTransferTransaction.getEnd2EndId()) != null) {
            paymentIdentification1.setEndToEndId(sEPACreditTransferTransaction.getEnd2EndId());
        } else if (StringUtils.trimToNull(string) != null) {
            paymentIdentification1.setEndToEndId(string);
        } else {
            paymentIdentification1.setEndToEndId("NOTPROVIDED");
        }
        sEPACreditTransferTransaction.setEnd2EndId(paymentIdentification1.getEndToEndId());
        paymentIdentification1.setInstrId(String.valueOf(n));
        CBIAmountType1 cBIAmountType1 = new CBIAmountType1();
        cBICreditTransferTransactionInformation.setAmt(cBIAmountType1);
        ActiveOrHistoricCurrencyAndAmount activeOrHistoricCurrencyAndAmount = new ActiveOrHistoricCurrencyAndAmount();
        cBIAmountType1.setInstdAmt(activeOrHistoricCurrencyAndAmount);
        String string2 = sEPACreditTransfer.getCurrency();
        if (sEPACreditTransferTransaction.getCurrency() != null) {
            string2 = sEPACreditTransferTransaction.getCurrency();
        }
        activeOrHistoricCurrencyAndAmount.setValue(sEPACreditTransferTransaction.getAmount());
        activeOrHistoricCurrencyAndAmount.setCcy(string2);
        if (sEPACreditTransferTransaction.getBIC() != null && !sEPACreditTransferTransaction.getBIC().isEmpty()) {
            object4 = new CBIBranchAndFinancialInstitutionIdentification3();
            cBICreditTransferTransactionInformation.setCdtrAgt((CBIBranchAndFinancialInstitutionIdentification3)object4);
            object3 = new CBIFinancialInstitutionIdentification2();
            ((CBIBranchAndFinancialInstitutionIdentification3)object4).setFinInstnId((CBIFinancialInstitutionIdentification2)object3);
            ((CBIFinancialInstitutionIdentification2)object3).setBIC(sEPACreditTransferTransaction.getBIC());
        }
        object4 = new CBIPartyIdentification3();
        cBICreditTransferTransactionInformation.setCdtr((CBIPartyIdentification3)object4);
        ((CBIPartyIdentification3)object4).setNm(sEPACreditTransferTransaction.getKontoinhaber());
        if (sEPACreditTransferTransaction.getCountryCode() != null || sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty() || sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
            object3 = new CBIPostalAddress6();
            ((CBIPartyIdentification3)object4).setPstlAdr((CBIPostalAddress6)object3);
            if (!sEPACreditTransferTransaction.getCountryCode().isEmpty()) {
                ((CBIPostalAddress6)object3).setCtry(sEPACreditTransferTransaction.getCountryCode());
            }
            if (sEPACreditTransferTransaction.getAddressLine1() != null && !sEPACreditTransferTransaction.getAddressLine1().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    ((CBIPostalAddress6)object3).setStrtNm(sEPACreditTransferTransaction.getAddressLine1());
                } else {
                    ((CBIPostalAddress6)object3).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine1());
                }
            }
            if (sEPACreditTransferTransaction.getAddressLine2() != null && !sEPACreditTransferTransaction.getAddressLine2().isEmpty()) {
                if (sEPACreditTransfer.isUseStructuredAddress()) {
                    stringArray = sEPACreditTransferTransaction.getAddressLine2().split(" ");
                    ((CBIPostalAddress6)object3).setPstCd(stringArray[0]);
                    if (stringArray.length > 1) {
                        object2 = "";
                        for (int i = 1; i < stringArray.length; ++i) {
                            object = stringArray[i];
                            object2 = i > 1 ? (String)object2 + " " + (String)object : (String)object2 + (String)object;
                        }
                        ((CBIPostalAddress6)object3).setTwnNm((String)object2);
                    }
                } else {
                    ((CBIPostalAddress6)object3).getAdrLine().add(sEPACreditTransferTransaction.getAddressLine2());
                }
            }
        }
        object3 = new CBICashAccount2();
        cBICreditTransferTransactionInformation.setCdtrAcct((CBICashAccount2)object3);
        stringArray = new CBIAccountIdentification1();
        ((CBICashAccount2)object3).setId((CBIAccountIdentification1)stringArray);
        stringArray.setIBAN(sEPACreditTransferTransaction.getIBAN());
        if (sEPACreditTransfer.getRegulatoryReportingCode() != null && !sEPACreditTransfer.getRegulatoryReportingCode().isEmpty() && !sEPACreditTransfer.isRegulatoryReportingCodeFromFile() || sEPACreditTransferTransaction.getRegulatoryReportingCode() != null && !sEPACreditTransferTransaction.getRegulatoryReportingCode().isEmpty() && sEPACreditTransfer.isRegulatoryReportingCodeFromFile()) {
            object2 = new CBIRegulatoryReporting1();
            CBIStructuredRegulatoryReporting1 cBIStructuredRegulatoryReporting1 = new CBIStructuredRegulatoryReporting1();
            cBIStructuredRegulatoryReporting1.setCd(sEPACreditTransfer.isRegulatoryReportingCodeFromFile() ? sEPACreditTransferTransaction.getRegulatoryReportingCode() : sEPACreditTransfer.getRegulatoryReportingCode());
            ((CBIRegulatoryReporting1)object2).setDtls(cBIStructuredRegulatoryReporting1);
            cBICreditTransferTransactionInformation.getRgltryRptg().add((CBIRegulatoryReporting1)object2);
        }
        object2 = new RemittanceInformation5();
        cBICreditTransferTransactionInformation.setRmtInf((RemittanceInformation5)object2);
        ((RemittanceInformation5)object2).getUstrd().add(sEPACreditTransferTransaction.getVerwendungszweck());
        CBIPaymentTypeInformation2 cBIPaymentTypeInformation2 = new CBIPaymentTypeInformation2();
        if (sEPACreditTransfer.getCategoryPurpose() != null && sEPACreditTransfer.getCategoryPurpose() != CategoryPurpose.EMPTY) {
            object = new CategoryPurpose1Choice();
            ((CategoryPurpose1Choice)object).setCd(sEPACreditTransfer.getCategoryPurpose().name());
            cBIPaymentTypeInformation2.setCtgyPurp((CategoryPurpose1Choice)object);
            cBICreditTransferTransactionInformation.setPmtTpInf(cBIPaymentTypeInformation2);
        }
        return cBICreditTransferTransactionInformation;
    }
}

