/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.core;

import com.codecamp.sepa.gui.ApplicationContext;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateTimeNoTimezoneSerializer
extends XmlAdapter<String, XMLGregorianCalendar> {
    private SimpleDateFormat dateFormat;

    @Override
    public String marshal(XMLGregorianCalendar xMLGregorianCalendar) throws Exception {
        this.dateFormat = ApplicationContext.get().isUseTimeZoneFor001() ? new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SXXX") : new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        return this.dateFormat.format(xMLGregorianCalendar.toGregorianCalendar().getTime());
    }

    @Override
    public XMLGregorianCalendar unmarshal(String string) throws Exception {
        this.dateFormat = ApplicationContext.get().isUseTimeZoneFor001() ? new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SXXX") : new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.dateFormat.parse(string));
        XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
        return xMLGregorianCalendar;
    }
}

