/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa;

import com.codecamp.sepa.BCrypt;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class SEPAPreferences {
    private static final String NODE_DATE = "java/lang/prefs";
    private static final String NODE_SEPA_APP = "com/codecamp/sepa";
    private static final String OBFUSCODE_1 = "165";
    private static final String OBFUSCODE_2 = "458";
    private static final String LICENSENO_KEY = "licNoKey";
    private static final String LICENSENOPRO_KEY = "licNoKeyPro";
    public static final String ENCODED_DATE_KEY = "jre_key_2807-2979-1402-1014";
    public static final String LICENSE_NO = "XhBhJI4545HGzf907237JJKJK";
    public static final String LICENSE_NO_PRO = "XhBhXS1234HGzf907987LJKJK";
    private final Logger logger = Logger.getLogger(SEPAPreferences.class.getName());

    public boolean hasEvaluationPeriodExpired() {
        this.logger.log(Level.INFO, "Checking evaluation period...");
        boolean bl = true;
        Preferences preferences = Preferences.userRoot().node(NODE_DATE);
        String string = preferences.get(ENCODED_DATE_KEY, null);
        this.logger.log(Level.FINE, "Checking evaluation period: " + string);
        if (string == null) {
            bl = false;
            this.logger.log(Level.INFO, "Saving evaluation period...");
            preferences.put(ENCODED_DATE_KEY, this.generateEncodedDate(new Date()));
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                bl = true;
                this.logger.log(Level.SEVERE, "Exception while saving evaluation period!", backingStoreException);
            }
        } else {
            this.logger.log(Level.INFO, "Checking found evaluation period...");
            if (this.isEncodedDateValid(string, new Date())) {
                bl = false;
                this.logger.log(Level.INFO, "Found evaluation period valid.");
            } else {
                this.logger.log(Level.WARNING, "Found evaluation period NOT valid.");
            }
        }
        return bl;
    }

    protected boolean isEncodedDateValid(String string, Date date2) {
        Calendar calendar = this.getDateFromEncodedDate(string);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        calendar2.add(5, -60);
        return calendar.after(calendar2);
    }

    private Calendar getDateFromEncodedDate(String string) {
        String string2 = string.substring(9, 11);
        String string3 = string.substring(7, 9);
        String string4 = string.substring(3, 7);
        int n = Integer.valueOf(string2);
        int n2 = Integer.valueOf(string3);
        int n3 = Integer.valueOf(string4);
        int n4 = n - 60;
        int n5 = n2 - 30;
        int n6 = n3 - 3000;
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, n4);
        calendar.set(2, n5 - 1);
        calendar.set(1, n6);
        return calendar;
    }

    protected String generateEncodedDate(Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        int n = calendar.get(5);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(1);
        int n4 = n + 60;
        int n5 = (n2 + 30) * 100;
        int n6 = (n3 + 3000) * 10000;
        return OBFUSCODE_1 + (n4 + n5 + n6) + OBFUSCODE_2;
    }

    public boolean hasValidLicense() {
        this.logger.log(Level.FINE, "Checking standard license...");
        return this.isValidLicense(this.getLicense());
    }

    public boolean hasValidProLicense() {
        this.logger.log(Level.FINE, "Checking pro license...");
        return this.isValidProLicense(this.getProLicense());
    }

    public String getLicense() {
        this.logger.log(Level.FINE, "Loading standard license...");
        Preferences preferences = Preferences.userRoot().node(NODE_SEPA_APP);
        String string = preferences.get(LICENSENO_KEY, null);
        return string;
    }

    public String getProLicense() {
        this.logger.log(Level.FINE, "Loading pro license...");
        Preferences preferences = Preferences.userRoot().node(NODE_SEPA_APP);
        String string = preferences.get(LICENSENOPRO_KEY, null);
        return string;
    }

    public boolean isValidLicense(String string) {
        this.logger.log(Level.INFO, "Checking standard license: " + string);
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        boolean bl = false;
        try {
            bl = BCrypt.checkpw(LICENSE_NO, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.log(Level.SEVERE, "Exception while checking standard license!", illegalArgumentException);
        }
        return bl;
    }

    public boolean isValidProLicense(String string) {
        this.logger.log(Level.INFO, "Checking pro license: " + string);
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        boolean bl = false;
        try {
            bl = BCrypt.checkpw(LICENSE_NO_PRO, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.log(Level.SEVERE, "Exception while checking pro license!", illegalArgumentException);
        }
        return bl;
    }

    public void saveLicense(String string) {
        this.logger.log(Level.FINE, "Saving standard license: " + string);
        Preferences preferences = Preferences.userRoot().node(NODE_SEPA_APP);
        preferences.put(LICENSENO_KEY, string);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            this.logger.log(Level.SEVERE, "Exception while saving standard license!", backingStoreException);
        }
    }

    public void saveProLicense(String string) {
        this.logger.log(Level.FINE, "Saving pro license: " + string);
        Preferences preferences = Preferences.userRoot().node(NODE_SEPA_APP);
        preferences.put(LICENSENOPRO_KEY, string);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            this.logger.log(Level.SEVERE, "Exception while saving pro license!", backingStoreException);
        }
    }

    public boolean loadPreference(String string, boolean bl) {
        this.logger.log(Level.FINE, "Loading " + string + "...");
        Preferences preferences = Preferences.userRoot().node(NODE_SEPA_APP);
        String string2 = preferences.get(string, null);
        return string2 != null ? Boolean.valueOf(string2) : bl;
    }

    public String loadPreference(String string, String string2) {
        this.logger.log(Level.FINE, "Loading " + string + "...");
        Preferences preferences = Preferences.userRoot().node(NODE_SEPA_APP);
        String string3 = preferences.get(string, null);
        return string3 != null ? string3 : string2;
    }

    public String loadPreference(String string) {
        this.logger.log(Level.FINE, "Loading " + string + "...");
        Preferences preferences = Preferences.userRoot().node(NODE_SEPA_APP);
        String string2 = preferences.get(string, null);
        this.logger.log(Level.FINE, "Value=" + string2 + "...");
        return string2;
    }

    public void savePreference(String string, String string2) {
        this.logger.log(Level.FINE, "Saving " + string + " with value=" + string2);
        Preferences preferences = Preferences.userRoot().node(NODE_SEPA_APP);
        preferences.put(string, string2);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            this.logger.log(Level.SEVERE, "Excpetion while saving preferences!", backingStoreException);
        }
    }

    public void removePreference(String string) {
        this.logger.log(Level.FINE, "Removing " + string + "...");
        Preferences preferences = Preferences.userRoot().node(NODE_SEPA_APP);
        preferences.remove(string);
    }

    public long daysLeftUntilEvaluationPeriodExceeds() {
        Preferences preferences = Preferences.userRoot().node(NODE_DATE);
        String string = preferences.get(ENCODED_DATE_KEY, null);
        Calendar calendar = this.getDateFromEncodedDate(string);
        Calendar calendar2 = Calendar.getInstance();
        long l = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
        long l2 = 60L - l / 86400000L;
        return l2;
    }
}

