/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class QNameCache {
    protected Map noNamespaceCache = Collections.synchronizedMap(new WeakHashMap());
    protected Map namespaceCache = Collections.synchronizedMap(new WeakHashMap());
    private DocumentFactory documentFactory;

    public QNameCache() {
    }

    public QNameCache(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public List getQNames() {
        ArrayList answer = new ArrayList();
        answer.addAll(this.noNamespaceCache.values());
        Iterator it = this.namespaceCache.values().iterator();
        while (it.hasNext()) {
            Map map = (Map)it.next();
            answer.addAll(map.values());
        }
        return answer;
    }

    public QName get(String name) {
        QName answer = null;
        if (name != null) {
            answer = (QName)this.noNamespaceCache.get(name);
        } else {
            name = "";
        }
        if (answer == null) {
            answer = this.createQName(name);
            answer.setDocumentFactory(this.documentFactory);
            this.noNamespaceCache.put(name, answer);
        }
        return answer;
    }

    public QName get(String name, Namespace namespace2) {
        Map cache = this.getNamespaceCache(namespace2);
        QName answer = null;
        if (name != null) {
            answer = (QName)cache.get(name);
        } else {
            name = "";
        }
        if (answer == null) {
            answer = this.createQName(name, namespace2);
            answer.setDocumentFactory(this.documentFactory);
            cache.put(name, answer);
        }
        return answer;
    }

    public QName get(String localName, Namespace namespace2, String qName) {
        Map cache = this.getNamespaceCache(namespace2);
        QName answer = null;
        if (localName != null) {
            answer = (QName)cache.get(localName);
        } else {
            localName = "";
        }
        if (answer == null) {
            answer = this.createQName(localName, namespace2, qName);
            answer.setDocumentFactory(this.documentFactory);
            cache.put(localName, answer);
        }
        return answer;
    }

    public QName get(String qualifiedName, String uri) {
        int index = qualifiedName.indexOf(58);
        if (index < 0) {
            return this.get(qualifiedName, Namespace.get(uri));
        }
        String name = qualifiedName.substring(index + 1);
        String prefix = qualifiedName.substring(0, index);
        return this.get(name, Namespace.get(prefix, uri));
    }

    public QName intern(QName qname2) {
        return this.get(qname2.getName(), qname2.getNamespace(), qname2.getQualifiedName());
    }

    protected Map getNamespaceCache(Namespace namespace2) {
        if (namespace2 == Namespace.NO_NAMESPACE) {
            return this.noNamespaceCache;
        }
        Map answer = null;
        if (namespace2 != null) {
            answer = (Map)this.namespaceCache.get(namespace2);
        }
        if (answer == null) {
            answer = this.createMap();
            this.namespaceCache.put(namespace2, answer);
        }
        return answer;
    }

    protected Map createMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    protected QName createQName(String name) {
        return new QName(name);
    }

    protected QName createQName(String name, Namespace namespace2) {
        return new QName(name, namespace2);
    }

    protected QName createQName(String name, Namespace namespace2, String qualifiedName) {
        return new QName(name, namespace2, qualifiedName);
    }
}

