/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hslf.blip.Metafile;
import org.apache.poi.hslf.exceptions.HSLFException;

public final class PICT
extends Metafile {
    public byte[] getData() {
        byte[] rawdata = this.getRawData();
        try {
            byte[] pict;
            byte[] macheader = new byte[512];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(macheader);
            int pos = 16;
            try {
                pict = this.read(rawdata, pos);
            }
            catch (IOException e2) {
                pict = this.read(rawdata, pos + 16);
            }
            out.write(pict);
            return out.toByteArray();
        }
        catch (IOException e3) {
            throw new HSLFException(e3);
        }
    }

    private byte[] read(byte[] data, int pos) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Metafile.Header header = new Metafile.Header();
        header.read(data, pos);
        bis.skip(pos + header.getSize());
        InflaterInputStream inflater = new InflaterInputStream(bis);
        byte[] chunk = new byte[4096];
        while ((count = inflater.read(chunk)) >= 0) {
            out.write(chunk, 0, count);
        }
        inflater.close();
        return out.toByteArray();
    }

    public void setData(byte[] data) throws IOException {
        int pos = 512;
        byte[] compressed = this.compress(data, pos, data.length - pos);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = data.length - 512;
        header.bounds = new Rectangle(0, 0, 200, 200);
        header.size = new Dimension(header.bounds.width * 12700, header.bounds.height * 12700);
        header.zipsize = compressed.length;
        byte[] checksum = PICT.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(checksum);
        out.write(new byte[16]);
        header.write(out);
        out.write(compressed);
        this.setRawData(out.toByteArray());
    }

    public int getType() {
        return 4;
    }

    public int getSignature() {
        return 21552;
    }
}

