/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.bitmap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.reflect.InvocationTargetException;
import org.apache.fop.util.bitmap.DefaultMonochromeBitmapConverter;
import org.apache.fop.util.bitmap.MonochromeBitmapConverter;

public final class BitmapImageUtil {
    private BitmapImageUtil() {
    }

    public static boolean isMonochromeImage(RenderedImage img) {
        return BitmapImageUtil.getColorIndexSize(img) == 2;
    }

    public static boolean isZeroBlack(RenderedImage img) {
        int gray1;
        if (!BitmapImageUtil.isMonochromeImage(img)) {
            throw new IllegalArgumentException("Image is not a monochrome image!");
        }
        IndexColorModel icm = (IndexColorModel)img.getColorModel();
        int gray0 = BitmapImageUtil.convertToGray(icm.getRGB(0));
        return gray0 < (gray1 = BitmapImageUtil.convertToGray(icm.getRGB(1)));
    }

    public static int convertToGray(int r, int g, int b) {
        return (r * 30 + g * 59 + b * 11) / 100;
    }

    public static int convertToGray(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return BitmapImageUtil.convertToGray(r, g, b);
    }

    public static int getColorIndexSize(RenderedImage img) {
        ColorModel cm = img.getColorModel();
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            return icm.getMapSize();
        }
        return 0;
    }

    public static boolean isGrayscaleImage(RenderedImage img) {
        return img.getColorModel().getColorSpace().getNumComponents() == 1;
    }

    public static BufferedImage convertTosRGB(RenderedImage img, Dimension targetDimension) {
        return BitmapImageUtil.convertAndScaleImage(img, targetDimension, 1);
    }

    public static BufferedImage convertToGrayscale(RenderedImage img, Dimension targetDimension) {
        return BitmapImageUtil.convertAndScaleImage(img, targetDimension, 10);
    }

    public static BufferedImage convertToMonochrome(RenderedImage img, Dimension targetDimension) {
        return BitmapImageUtil.toBufferedImage(BitmapImageUtil.convertToMonochrome(img, targetDimension, 0.0f));
    }

    public static RenderedImage convertToMonochrome(RenderedImage img, Dimension targetDimension, float quality) {
        if (!BitmapImageUtil.isMonochromeImage(img) && quality >= 0.5f) {
            BufferedImage bi;
            Dimension orgDim = new Dimension(img.getWidth(), img.getHeight());
            if (targetDimension != null && !orgDim.equals(targetDimension)) {
                ColorModel cm = img.getColorModel();
                BufferedImage tgt = new BufferedImage(cm, cm.createCompatibleWritableRaster(targetDimension.width, targetDimension.height), cm.isAlphaPremultiplied(), null);
                BitmapImageUtil.transferImage(img, tgt);
                bi = tgt;
            } else {
                bi = BitmapImageUtil.toBufferedImage(img);
            }
            MonochromeBitmapConverter converter = BitmapImageUtil.createDefaultMonochromeBitmapConverter();
            if (quality >= 0.8f) {
                converter.setHint("quality", Boolean.TRUE.toString());
                bi = BitmapImageUtil.convertToGrayscale(bi, targetDimension);
            }
            try {
                return converter.convertToMonochrome(bi);
            }
            catch (Exception e2) {
                bi = BitmapImageUtil.convertToGrayscale(bi, targetDimension);
                return converter.convertToMonochrome(bi);
            }
        }
        return BitmapImageUtil.convertAndScaleImage(img, targetDimension, 12);
    }

    private static BufferedImage convertAndScaleImage(RenderedImage img, Dimension targetDimension, int imageType) {
        Dimension bmpDimension = targetDimension;
        if (bmpDimension == null) {
            bmpDimension = new Dimension(img.getWidth(), img.getHeight());
        }
        BufferedImage target = new BufferedImage(bmpDimension.width, bmpDimension.height, imageType);
        BitmapImageUtil.transferImage(img, target);
        return target;
    }

    public static BufferedImage toBufferedImage(RenderedImage img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        WritableRaster wr = img.getColorModel().createCompatibleWritableRaster(img.getWidth(), img.getHeight());
        boolean premult = img.getColorModel().isAlphaPremultiplied();
        BufferedImage buf = new BufferedImage(img.getColorModel(), wr, premult, null);
        BitmapImageUtil.transferImage(img, buf);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferImage(RenderedImage source, BufferedImage target) {
        Graphics2D g2d = target.createGraphics();
        try {
            g2d.setBackground(Color.white);
            g2d.setColor(Color.black);
            g2d.clearRect(0, 0, target.getWidth(), target.getHeight());
            AffineTransform at = new AffineTransform();
            if (source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight()) {
                double sx = (double)target.getWidth() / (double)source.getWidth();
                double sy = (double)target.getHeight() / (double)source.getHeight();
                at.scale(sx, sy);
            }
            g2d.drawRenderedImage(source, at);
        }
        finally {
            g2d.dispose();
        }
    }

    public static MonochromeBitmapConverter createDefaultMonochromeBitmapConverter() {
        MonochromeBitmapConverter converter = null;
        try {
            String clName = "org.apache.fop.util.bitmap.JAIMonochromeBitmapConverter";
            Class<?> clazz = Class.forName(clName);
            converter = (MonochromeBitmapConverter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (converter == null) {
            converter = new DefaultMonochromeBitmapConverter();
        }
        return converter;
    }
}

