/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.txt.border;

import java.util.Arrays;
import org.apache.fop.render.txt.border.AbstractBorderElement;
import org.apache.fop.render.txt.border.SolidAndDoubleBorderElement;

public class DashedBorderElement
extends AbstractBorderElement {
    private static final char DASH_HORIZONTAL = '-';
    private static final char DASH_VERTICAL = '|';
    private static final char UNDEFINED = '?';
    private static final int UP2 = 1;
    private static final int RIGHT2 = 2;
    private static final int DOWN2 = 4;
    private static final int LEFT2 = 8;
    private static char[] map = new char[20];

    public DashedBorderElement(int type) {
        super(type);
    }

    private AbstractBorderElement mergeSolid(SolidAndDoubleBorderElement sdb) {
        SolidAndDoubleBorderElement e2 = new SolidAndDoubleBorderElement(133, 0);
        for (int i = 0; i < 4; ++i) {
            e2.setData(i, Math.max(this.data[i], sdb.getData(i)));
        }
        return e2;
    }

    private AbstractBorderElement mergeDashed(DashedBorderElement dbe) {
        for (int i = 0; i < 4; ++i) {
            this.data[i] = Math.max(this.data[i], dbe.getData(i));
        }
        return this;
    }

    private AbstractBorderElement toSolidAndDouble() {
        SolidAndDoubleBorderElement e2 = new SolidAndDoubleBorderElement(133, 0);
        for (int i = 0; i < 4; ++i) {
            e2.setData(i, this.data[i]);
        }
        return e2;
    }

    @Override
    public AbstractBorderElement merge(AbstractBorderElement e2) {
        AbstractBorderElement abe = this;
        abe = e2 instanceof SolidAndDoubleBorderElement ? this.mergeSolid((SolidAndDoubleBorderElement)e2) : (e2 instanceof DashedBorderElement ? this.mergeDashed((DashedBorderElement)e2) : e2);
        return abe;
    }

    @Override
    public char convert2Char() {
        int key = 0;
        key += this.data[0] * 1;
        key += this.data[2] * 4;
        key += this.data[3] * 8;
        char ch = map[key += this.data[1] * 2];
        if (ch == '?') {
            ch = this.toSolidAndDouble().convert2Char();
        }
        return ch;
    }

    static {
        Arrays.fill(map, '?');
        DashedBorderElement.map[0] = 32;
        DashedBorderElement.map[1] = 124;
        DashedBorderElement.map[4] = 124;
        DashedBorderElement.map[5] = 124;
        DashedBorderElement.map[8] = 45;
        DashedBorderElement.map[2] = 45;
        DashedBorderElement.map[10] = 45;
    }
}

