/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfLineBreak;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfText;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTextrun;

public class RtfHyperLink
extends RtfContainer
implements IRtfTextContainer,
IRtfTextrunContainer {
    protected String url;
    protected RtfText mText;

    public RtfHyperLink(IRtfTextContainer parent, Writer writer, String str2, RtfAttributes attr) throws IOException {
        super((RtfContainer)((Object)parent), writer, attr);
        new RtfText(this, writer, str2, attr);
    }

    public RtfHyperLink(RtfTextrun parent, Writer writer, RtfAttributes attr) throws IOException {
        super(parent, writer, attr);
    }

    @Override
    public void writeRtfPrefix() throws IOException {
        super.writeGroupMark(true);
        super.writeControlWord("field");
        super.writeGroupMark(true);
        super.writeStarControlWord("fldinst");
        this.writer.write("HYPERLINK \"" + this.url + "\" ");
        super.writeGroupMark(false);
        super.writeGroupMark(true);
        super.writeControlWord("fldrslt");
        if (this.attrib != null && this.attrib.isSet("cs")) {
            this.writeGroupMark(true);
            this.writeAttributes(this.attrib, new String[]{"cs"});
        }
    }

    @Override
    public void writeRtfSuffix() throws IOException {
        if (this.attrib != null && this.attrib.isSet("cs")) {
            this.writeGroupMark(false);
        }
        super.writeGroupMark(false);
        super.writeGroupMark(false);
    }

    @Override
    public RtfText newText(String str2) throws IOException {
        return this.newText(str2, null);
    }

    @Override
    public RtfText newText(String str2, RtfAttributes attr) throws IOException {
        this.closeAll();
        this.mText = new RtfText(this, this.writer, str2, attr);
        return this.mText;
    }

    @Override
    public RtfAttributes getTextContainerAttributes() throws FOPException {
        if (this.attrib == null) {
            return null;
        }
        try {
            return (RtfAttributes)this.attrib.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new FOPException(e2);
        }
    }

    @Override
    public void newLineBreak() throws IOException {
        new RtfLineBreak(this, this.writer);
    }

    private void closeCurrentText() throws IOException {
        if (this.mText != null) {
            this.mText.close();
        }
    }

    private void closeAll() throws IOException {
        this.closeCurrentText();
    }

    public void setExternalURL(String url) {
        this.url = url;
    }

    public void setInternalURL(String jumpTo) {
        int now2 = jumpTo.length();
        int max2 = 40;
        this.url = "#" + jumpTo.substring(0, now2 > max2 ? max2 : now2);
        this.url = this.url.replace('.', '_');
        this.url = this.url.replace(' ', '_');
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public RtfTextrun getTextrun() throws IOException {
        RtfTextrun textrun = RtfTextrun.getTextrun(this, this.writer, null);
        return textrun;
    }
}

