/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.render.rtf.rtflib.exceptions.RtfStructureException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFile;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfOptions;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfText;

public class RtfContainer
extends RtfElement {
    private LinkedList children;
    private RtfOptions options = new RtfOptions();
    private RtfElement lastChild;

    RtfContainer(RtfContainer parent, Writer w) throws IOException {
        this(parent, w, null);
    }

    RtfContainer(RtfContainer parent, Writer w, RtfAttributes attr) throws IOException {
        super(parent, w, attr);
        this.children = new LinkedList();
    }

    public void setOptions(RtfOptions opt) {
        this.options = opt;
    }

    protected void addChild(RtfElement e2) throws RtfStructureException {
        if (this.isClosed()) {
            StringBuffer sb = new StringBuffer();
            sb.append("addChild: container already closed (parent=");
            sb.append(this.getClass().getName());
            sb.append(" child=");
            sb.append(e2.getClass().getName());
            sb.append(")");
            String msg = sb.toString();
            RtfFile rtfFile = this.getRtfFile();
        }
        this.children.add(e2);
        this.lastChild = e2;
    }

    public List getChildren() {
        return (List)this.children.clone();
    }

    public int getChildCount() {
        return this.children.size();
    }

    private int findChildren(RtfElement aChild, int iStart) {
        for (Object o : this.getChildren()) {
            int iFound;
            RtfElement e2 = (RtfElement)o;
            if (aChild == e2) {
                return iStart;
            }
            if (!(e2 instanceof RtfContainer) || (iFound = ((RtfContainer)e2).findChildren(aChild, iStart + 1)) == -1) continue;
            return iFound;
        }
        return -1;
    }

    public int findChildren(RtfElement aChild) {
        return this.findChildren(aChild, 0);
    }

    public boolean setChildren(List list) {
        if (list instanceof LinkedList) {
            this.children = (LinkedList)list;
            return true;
        }
        return false;
    }

    @Override
    protected void writeRtfContent() throws IOException {
        for (Object aChildren : this.children) {
            RtfElement e2 = (RtfElement)aChildren;
            e2.writeRtf();
        }
    }

    RtfOptions getOptions() {
        return this.options;
    }

    boolean containsText() {
        boolean result = false;
        for (Object aChildren : this.children) {
            RtfElement e2 = (RtfElement)aChildren;
            if (e2 instanceof RtfText) {
                result = !e2.isEmpty();
            } else if (e2 instanceof RtfContainer && ((RtfContainer)e2).containsText()) {
                result = true;
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    @Override
    void dump(Writer w, int indent) throws IOException {
        super.dump(w, indent);
        for (Object aChildren : this.children) {
            RtfElement e2 = (RtfElement)aChildren;
            e2.dump(w, indent + 1);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.getChildCount() + " children)";
    }

    @Override
    protected boolean okToWriteRtf() {
        boolean result;
        boolean bl = result = super.okToWriteRtf() && !this.isEmpty();
        if (result && !this.options.renderContainer(this)) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = true;
        for (Object aChildren : this.children) {
            RtfElement e2 = (RtfElement)aChildren;
            if (e2.isEmpty()) continue;
            result = false;
            break;
        }
        return result;
    }
}

