/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

public enum PDFDictionaryType {
    Action("action", true),
    Catalog("catalog"),
    Dictionary("dictionary"),
    Layer("layer", true),
    Navigator("navigator", true),
    Page("page"),
    Info("info"),
    VT("vt"),
    PagePiece("pagepiece");

    private String elementName;
    private boolean usesIDAttribute;

    private PDFDictionaryType(String elementName, boolean usesIDAttribute) {
        this.elementName = elementName;
        this.usesIDAttribute = usesIDAttribute;
    }

    private PDFDictionaryType(String elementName) {
        this(elementName, false);
    }

    public String elementName() {
        return this.elementName;
    }

    public boolean usesIDAttribute() {
        return this.usesIDAttribute;
    }

    static PDFDictionaryType valueOfElementName(String elementName) {
        for (PDFDictionaryType type : PDFDictionaryType.values()) {
            if (!type.elementName.equals(elementName)) continue;
            return type;
        }
        throw new IllegalArgumentException();
    }

    static boolean hasValueOfElementName(String elementName) {
        try {
            return PDFDictionaryType.valueOfElementName(elementName) != null;
        }
        catch (Exception e2) {
            return false;
        }
    }
}

