/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.render.pdf.extensions.AbstractPDFExtensionElement;
import org.apache.fop.render.pdf.extensions.PDFCollectionEntryExtension;
import org.apache.fop.render.pdf.extensions.PDFDictionaryElement;
import org.apache.fop.render.pdf.extensions.PDFDictionaryType;
import org.apache.fop.render.pdf.extensions.PDFObjectType;
import org.apache.fop.render.pdf.extensions.PDFReferenceExtension;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class PDFCollectionEntryElement
extends AbstractPDFExtensionElement {
    public static final String ATT_KEY = "key";
    private PDFCollectionEntryExtension extension;
    private StringBuffer characters;

    PDFCollectionEntryElement(FONode parent, PDFObjectType type, PDFCollectionEntryExtension extension) {
        super(parent);
        this.extension = extension;
    }

    PDFCollectionEntryElement(FONode parent, PDFObjectType type) {
        this(parent, type, PDFCollectionEntryElement.createExtension(type));
    }

    private static PDFCollectionEntryExtension createExtension(PDFObjectType type) {
        if (type == PDFObjectType.Reference) {
            return new PDFReferenceExtension();
        }
        return new PDFCollectionEntryExtension(type);
    }

    public PDFCollectionEntryExtension getExtension() {
        return this.extension;
    }

    @Override
    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        if (this.parent instanceof PDFDictionaryElement) {
            String key = attlist.getValue(ATT_KEY);
            if (key == null) {
                this.missingPropertyError(ATT_KEY);
            } else if (key.length() == 0) {
                this.invalidPropertyValueError(ATT_KEY, key, null);
            } else {
                this.extension.setKey(key);
            }
        }
    }

    @Override
    public void startOfNode() throws FOPException {
        super.startOfNode();
        if (this.parent instanceof PDFDictionaryElement && !PDFDictionaryType.hasValueOfElementName(this.parent.getLocalName())) {
            this.invalidChildError(this.getLocator(), this.parent.getName(), this.getNamespaceURI(), this.getName(), null);
        }
    }

    @Override
    protected void characters(char[] data, int start, int length, PropertyList pList, Locator locator) throws FOPException {
        if (this.capturePCData(this.extension.getType())) {
            if (this.characters == null) {
                this.characters = new StringBuffer(length < 16 ? 16 : length);
            }
            this.characters.append(data, start, length);
        }
    }

    private boolean capturePCData(PDFObjectType type) {
        if (type == PDFObjectType.Array) {
            return false;
        }
        if (type == PDFObjectType.Dictionary) {
            return false;
        }
        return type != PDFObjectType.Reference;
    }

    @Override
    public void endOfNode() throws FOPException {
        block13: {
            if (this.capturePCData(this.extension.getType())) {
                if (this.extension.getType() == PDFObjectType.Boolean) {
                    String value;
                    String string = value = this.characters != null ? this.characters.toString() : "";
                    if (!value.equals("true") && !value.equals("false")) {
                        this.invalidPropertyValueError("<value>", value, null);
                    }
                    this.extension.setValue(Boolean.valueOf(value));
                } else if (this.extension.getType() == PDFObjectType.Name) {
                    String value;
                    String string = value = this.characters != null ? this.characters.toString() : "";
                    if (value.length() == 0) {
                        this.invalidPropertyValueError("<value>", value, null);
                    }
                    this.extension.setValue(value);
                } else if (this.extension.getType() == PDFObjectType.Number) {
                    String value = this.characters != null ? this.characters.toString() : "";
                    try {
                        double d = Double.parseDouble(value);
                        if (Math.abs(Math.floor(d) - d) < 1.0E-10) {
                            this.extension.setValue((long)d);
                            break block13;
                        }
                        this.extension.setValue(d);
                    }
                    catch (NumberFormatException e2) {
                        this.invalidPropertyValueError("<value>", value, null);
                    }
                } else if (this.extension.getType() == PDFObjectType.String) {
                    String value = this.characters != null ? this.characters.toString() : "";
                    this.extension.setValue(value);
                }
            }
        }
        super.endOfNode();
    }

    @Override
    public String getLocalName() {
        return this.extension.getType().elementName();
    }
}

