/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.DefaultRendererConfigurator;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractXMLWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFConstants;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFDocumentNavigationHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.intermediate.IFRendererConfig;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFStructureTreeBuilder;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.Bookmark;
import org.apache.fop.render.intermediate.extensions.BookmarkTree;
import org.apache.fop.render.intermediate.extensions.DocumentNavigationExtensionConstants;
import org.apache.fop.render.intermediate.extensions.Link;
import org.apache.fop.render.intermediate.extensions.NamedDestination;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.DOM2SAX;
import org.apache.fop.util.LanguageTags;
import org.apache.fop.util.XMLConstants;
import org.apache.fop.util.XMLUtil;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.util.XMLizable;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IFSerializer
extends AbstractXMLWritingIFDocumentHandler
implements IFConstants,
IFPainter,
IFDocumentNavigationHandler {
    public static final String VERSION = "2.0";
    private IFDocumentHandler mimicHandler;
    private int pageSequenceIndex;
    private IFState state;
    private String currentID = "";
    private IFStructureTreeBuilder structureTreeBuilder;
    private Map incompleteActions = new HashMap();
    private List completeActions = new LinkedList();

    public IFSerializer(IFContext context) {
        super(context);
    }

    @Override
    protected String getMainNamespace() {
        return "http://xmlgraphics.apache.org/fop/intermediate";
    }

    @Override
    public boolean supportsPagesOutOfOrder() {
        return false;
    }

    @Override
    public String getMimeType() {
        return "application/X-fop-intermediate-format";
    }

    @Override
    public IFDocumentHandlerConfigurator getConfigurator() {
        if (this.mimicHandler != null) {
            return this.getMimickedDocumentHandler().getConfigurator();
        }
        return new DefaultRendererConfigurator(this.getUserAgent(), new IFRendererConfig.IFRendererConfigParser());
    }

    @Override
    public IFDocumentNavigationHandler getDocumentNavigationHandler() {
        return this;
    }

    public void mimicDocumentHandler(IFDocumentHandler targetHandler) {
        this.mimicHandler = targetHandler;
    }

    public IFDocumentHandler getMimickedDocumentHandler() {
        return this.mimicHandler;
    }

    @Override
    public FontInfo getFontInfo() {
        if (this.mimicHandler != null) {
            return this.mimicHandler.getFontInfo();
        }
        return null;
    }

    @Override
    public void setFontInfo(FontInfo fontInfo) {
        if (this.mimicHandler != null) {
            this.mimicHandler.setFontInfo(fontInfo);
        }
    }

    @Override
    public void setDefaultFontInfo(FontInfo fontInfo) {
        if (this.mimicHandler != null) {
            this.mimicHandler.setDefaultFontInfo(fontInfo);
        }
    }

    @Override
    public StructureTreeEventHandler getStructureTreeEventHandler() {
        if (this.structureTreeBuilder == null) {
            this.structureTreeBuilder = new IFStructureTreeBuilder();
        }
        return this.structureTreeBuilder;
    }

    @Override
    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.handler.startDocument();
            this.handler.startPrefixMapping("", "http://xmlgraphics.apache.org/fop/intermediate");
            this.handler.startPrefixMapping("xlink", "http://www.w3.org/1999/xlink");
            this.handler.startPrefixMapping("nav", "http://xmlgraphics.apache.org/fop/intermediate/document-navigation");
            this.handler.startPrefixMapping("foi", "http://xmlgraphics.apache.org/fop/internal");
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "version", VERSION);
            this.handler.startElement("document", (Attributes)atts);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startDocument()", e2);
        }
    }

    @Override
    public void setDocumentLocale(Locale locale) {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", LanguageTags.toLanguageTag(locale));
        try {
            this.handler.startElement("locale", (Attributes)atts);
            this.handler.endElement("locale");
        }
        catch (SAXException e2) {
            throw new RuntimeException("Unable to create the locale element.", e2);
        }
    }

    @Override
    public void startDocumentHeader() throws IFException {
        try {
            this.handler.startElement("header");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startDocumentHeader()", e2);
        }
    }

    @Override
    public void endDocumentHeader() throws IFException {
        try {
            this.handler.endElement("header");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startDocumentHeader()", e2);
        }
    }

    @Override
    public void startDocumentTrailer() throws IFException {
        try {
            this.handler.startElement("trailer");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startDocumentTrailer()", e2);
        }
    }

    @Override
    public void endDocumentTrailer() throws IFException {
        try {
            this.handler.endElement("trailer");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in endDocumentTrailer()", e2);
        }
    }

    @Override
    public void endDocument() throws IFException {
        try {
            this.handler.endElement("document");
            this.handler.endDocument();
            this.finishDocumentNavigation();
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in endDocument()", e2);
        }
    }

    @Override
    public void startPageSequence(String id) throws IFException {
        try {
            Locale lang;
            AttributesImpl atts = new AttributesImpl();
            if (id != null) {
                atts.addAttribute("http://www.w3.org/XML/1998/namespace", "id", "xml:id", "CDATA", id);
            }
            if ((lang = this.getContext().getLanguage()) != null) {
                atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", LanguageTags.toLanguageTag(lang));
            }
            XMLUtil.addAttribute(atts, XMLConstants.XML_SPACE, "preserve");
            this.addForeignAttributes(atts);
            this.handler.startElement("page-sequence", (Attributes)atts);
            if (this.getUserAgent().isAccessibilityEnabled()) {
                assert (this.structureTreeBuilder != null);
                this.structureTreeBuilder.replayEventsForPageSequence(this.handler, this.pageSequenceIndex++);
            }
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startPageSequence()", e2);
        }
    }

    @Override
    public void endPageSequence() throws IFException {
        try {
            this.handler.endElement("page-sequence");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in endPageSequence()", e2);
        }
    }

    @Override
    public void startPage(int index, String name, String pageMasterName, Dimension size) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "index", Integer.toString(index));
            this.addAttribute(atts, "name", name);
            if (pageMasterName != null) {
                this.addAttribute(atts, "page-master-name", pageMasterName);
            }
            this.addAttribute(atts, "width", Integer.toString(size.width));
            this.addAttribute(atts, "height", Integer.toString(size.height));
            this.addForeignAttributes(atts);
            this.getContext().setPageIndex(index);
            this.handler.startElement("page", (Attributes)atts);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startPage()", e2);
        }
    }

    @Override
    public void startPageHeader() throws IFException {
        try {
            this.handler.startElement("page-header");
            if (this.getUserAgent().isAccessibilityEnabled()) {
                this.structureTreeBuilder.replayEventsForRetrievedMarkers(this.handler);
            }
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startPageHeader()", e2);
        }
    }

    @Override
    public void endPageHeader() throws IFException {
        try {
            this.handler.endElement("page-header");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in endPageHeader()", e2);
        }
    }

    @Override
    public IFPainter startPageContent() throws IFException {
        try {
            this.handler.startElement("content");
            this.state = IFState.create();
            return this;
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startPageContent()", e2);
        }
    }

    @Override
    public void endPageContent() throws IFException {
        try {
            this.state = null;
            this.currentID = "";
            this.handler.endElement("content");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in endPageContent()", e2);
        }
    }

    @Override
    public void startPageTrailer() throws IFException {
        try {
            this.handler.startElement("page-trailer");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startPageTrailer()", e2);
        }
    }

    @Override
    public void endPageTrailer() throws IFException {
        try {
            this.commitNavigation();
            this.handler.endElement("page-trailer");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in endPageTrailer()", e2);
        }
    }

    @Override
    public void endPage() throws IFException {
        try {
            this.handler.endElement("page");
            this.getContext().setPageIndex(-1);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in endPage()", e2);
        }
    }

    @Override
    public void startViewport(AffineTransform transform, Dimension size, Rectangle clipRect) throws IFException {
        this.startViewport(IFUtil.toString(transform), size, clipRect);
    }

    @Override
    public void startViewport(AffineTransform[] transforms, Dimension size, Rectangle clipRect) throws IFException {
        this.startViewport(IFUtil.toString(transforms), size, clipRect);
    }

    private void startViewport(String transform, Dimension size, Rectangle clipRect) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            if (transform != null && transform.length() > 0) {
                this.addAttribute(atts, "transform", transform);
            }
            this.addAttribute(atts, "width", Integer.toString(size.width));
            this.addAttribute(atts, "height", Integer.toString(size.height));
            if (clipRect != null) {
                this.addAttribute(atts, "clip-rect", IFUtil.toString(clipRect));
            }
            this.handler.startElement("viewport", (Attributes)atts);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startViewport()", e2);
        }
    }

    @Override
    public void endViewport() throws IFException {
        try {
            this.handler.endElement("viewport");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in endViewport()", e2);
        }
    }

    @Override
    public void startGroup(AffineTransform[] transforms, String layer) throws IFException {
        this.startGroup(IFUtil.toString(transforms), layer);
    }

    @Override
    public void startGroup(AffineTransform transform, String layer) throws IFException {
        this.startGroup(IFUtil.toString(transform), layer);
    }

    private void startGroup(String transform, String layer) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            if (transform != null && transform.length() > 0) {
                this.addAttribute(atts, "transform", transform);
            }
            if (layer != null && layer.length() > 0) {
                this.addAttribute(atts, "layer", layer);
            }
            this.handler.startElement("g", (Attributes)atts);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startGroup()", e2);
        }
    }

    @Override
    public void endGroup() throws IFException {
        try {
            this.handler.endElement("g");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in endGroup()", e2);
        }
    }

    @Override
    public void drawImage(String uri, Rectangle rect) throws IFException {
        try {
            this.addID();
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, XLINK_HREF, uri);
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            this.addForeignAttributes(atts);
            this.addStructureReference(atts);
            this.handler.element("image", (Attributes)atts);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startGroup()", e2);
        }
        finally {
            ImageSessionContext session = this.getUserAgent().getImageSessionContext();
            ImageManager imageManager = this.getUserAgent().getImageManager();
            imageManager.closeImage(uri, session);
        }
    }

    private void addForeignAttributes(AttributesImpl atts) throws SAXException {
        Map foreignAttributes2 = this.getContext().getForeignAttributes();
        if (!foreignAttributes2.isEmpty()) {
            Iterator i$ = foreignAttributes2.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                this.addAttribute(atts, (QName)entry.getKey(), entry.getValue().toString());
            }
        }
    }

    @Override
    public void drawImage(Document doc, Rectangle rect) throws IFException {
        try {
            this.addID();
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            this.addForeignAttributes(atts);
            this.addStructureReference(atts);
            this.handler.startElement("image", (Attributes)atts);
            new DOM2SAX(this.handler).writeDocument(doc, true);
            this.handler.endElement("image");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in startGroup()", e2);
        }
    }

    private static String toString(Paint paint) {
        if (paint instanceof Color) {
            return org.apache.fop.util.ColorUtil.colorToString((Color)paint);
        }
        throw new UnsupportedOperationException("Paint not supported: " + paint);
    }

    @Override
    public void clipRect(Rectangle rect) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            this.handler.element("clip-rect", (Attributes)atts);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in clipRect()", e2);
        }
    }

    @Override
    public void clipBackground(Rectangle rect, BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            if (this.hasRoundedCorners(bpsBefore, bpsAfter, bpsStart, bpsEnd)) {
                if (bpsBefore != null) {
                    this.addAttribute(atts, "top", bpsBefore.toString());
                }
                if (bpsAfter != null) {
                    this.addAttribute(atts, "bottom", bpsAfter.toString());
                }
                if (bpsStart != null) {
                    this.addAttribute(atts, "left", bpsStart.toString());
                }
                if (bpsEnd != null) {
                    this.addAttribute(atts, "right", bpsEnd.toString());
                }
            }
            this.handler.element("clip-rect", (Attributes)atts);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in clipRect()", e2);
        }
    }

    @Override
    public void fillRect(Rectangle rect, Paint fill) throws IFException {
        if (fill == null) {
            return;
        }
        try {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            this.addAttribute(atts, "fill", IFSerializer.toString(fill));
            this.handler.element("rect", (Attributes)atts);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in fillRect()", e2);
        }
    }

    private boolean hasRoundedCorners(BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) {
        boolean rtn = false;
        if (bpsBefore != null && bpsBefore.getRadiusStart() > 0 && bpsStart != null && bpsStart.getRadiusStart() > 0) {
            rtn = true;
        }
        if (bpsBefore != null && bpsBefore.getRadiusEnd() > 0 && bpsEnd != null && bpsEnd.getRadiusStart() > 0) {
            rtn = true;
        }
        if (bpsEnd != null && bpsEnd.getRadiusEnd() > 0 && bpsAfter != null && bpsAfter.getRadiusEnd() > 0) {
            rtn = true;
        }
        if (bpsAfter != null && bpsAfter.getRadiusStart() > 0 && bpsStart != null && bpsStart.getRadiusEnd() > 0) {
            rtn = true;
        }
        return rtn;
    }

    @Override
    public void drawBorderRect(Rectangle rect, BorderProps top, BorderProps bottom, BorderProps left, BorderProps right, Color innerBackgroundColor) throws IFException {
        if (top == null && bottom == null && left == null && right == null) {
            return;
        }
        try {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(rect.x));
            this.addAttribute(atts, "y", Integer.toString(rect.y));
            this.addAttribute(atts, "width", Integer.toString(rect.width));
            this.addAttribute(atts, "height", Integer.toString(rect.height));
            if (top != null) {
                this.addAttribute(atts, "top", top.toString());
            }
            if (bottom != null) {
                this.addAttribute(atts, "bottom", bottom.toString());
            }
            if (left != null) {
                this.addAttribute(atts, "left", left.toString());
            }
            if (right != null) {
                this.addAttribute(atts, "right", right.toString());
            }
            if (innerBackgroundColor != null) {
                this.addAttribute(atts, "inner-background-color", org.apache.fop.util.ColorUtil.colorToString(innerBackgroundColor));
            }
            this.handler.element("border-rect", (Attributes)atts);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in drawBorderRect()", e2);
        }
    }

    @Override
    public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) throws IFException {
        try {
            this.addID();
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x1", Integer.toString(start.x));
            this.addAttribute(atts, "y1", Integer.toString(start.y));
            this.addAttribute(atts, "x2", Integer.toString(end.x));
            this.addAttribute(atts, "y2", Integer.toString(end.y));
            this.addAttribute(atts, "stroke-width", Integer.toString(width));
            this.addAttribute(atts, "color", org.apache.fop.util.ColorUtil.colorToString(color));
            this.addAttribute(atts, "style", style.getName());
            this.handler.element("line", (Attributes)atts);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in drawLine()", e2);
        }
    }

    @Override
    public void drawText(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text) throws IFException {
        this.drawText(x, y, letterSpacing, wordSpacing, dp, text, false);
    }

    @Override
    public void drawText(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text, boolean nextIsSpace) throws IFException {
        try {
            this.addID();
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "x", Integer.toString(x));
            this.addAttribute(atts, "y", Integer.toString(y));
            if (nextIsSpace) {
                this.addAttribute(atts, "next-is-space", "true");
            }
            if (letterSpacing != 0) {
                this.addAttribute(atts, "letter-spacing", Integer.toString(letterSpacing));
            }
            if (wordSpacing != 0) {
                this.addAttribute(atts, "word-spacing", Integer.toString(wordSpacing));
            }
            if (dp != null && !IFUtil.isDPIdentity(dp)) {
                if (IFUtil.isDPOnlyDX(dp)) {
                    int[] dx = IFUtil.convertDPToDX(dp);
                    this.addAttribute(atts, "dx", IFUtil.toString(dx));
                } else {
                    this.addAttribute(atts, "dp", XMLUtil.encodePositionAdjustments(dp));
                }
            }
            this.addStructureReference(atts);
            if (this.getContext().isHyphenated()) {
                this.addAttribute(atts, "hyphenated", "true");
            }
            this.handler.startElement("text", (Attributes)atts);
            char[] chars = text.toCharArray();
            this.handler.characters(chars, 0, chars.length);
            this.handler.endElement("text");
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in setFont()", e2);
        }
    }

    @Override
    public void setFont(String family, String style, Integer weight, String variant, Integer size, Color color) throws IFException {
        try {
            boolean changed;
            AttributesImpl atts = new AttributesImpl();
            if (family != null) {
                boolean bl = changed = !family.equals(this.state.getFontFamily());
                if (changed) {
                    this.state.setFontFamily(family);
                    this.addAttribute(atts, "family", family);
                }
            }
            if (style != null) {
                boolean bl = changed = !style.equals(this.state.getFontStyle());
                if (changed) {
                    this.state.setFontStyle(style);
                    this.addAttribute(atts, "style", style);
                }
            }
            if (weight != null) {
                boolean bl = changed = weight.intValue() != this.state.getFontWeight();
                if (changed) {
                    this.state.setFontWeight(weight);
                    this.addAttribute(atts, "weight", weight.toString());
                }
            }
            if (variant != null) {
                boolean bl = changed = !variant.equals(this.state.getFontVariant());
                if (changed) {
                    this.state.setFontVariant(variant);
                    this.addAttribute(atts, "variant", variant);
                }
            }
            if (size != null) {
                boolean bl = changed = size.intValue() != this.state.getFontSize();
                if (changed) {
                    this.state.setFontSize(size);
                    this.addAttribute(atts, "size", size.toString());
                }
            }
            if (color != null) {
                boolean bl = changed = !ColorUtil.isSameColor(color, this.state.getTextColor());
                if (changed) {
                    this.state.setTextColor(color);
                    this.addAttribute(atts, "color", IFSerializer.toString(color));
                }
            }
            if (atts.getLength() > 0) {
                this.handler.element("font", (Attributes)atts);
            }
        }
        catch (SAXException e2) {
            throw new IFException("SAX error in setFont()", e2);
        }
    }

    @Override
    public void handleExtensionObject(Object extension) throws IFException {
        if (extension instanceof XMLizable) {
            try {
                ((XMLizable)extension).toSAX(this.handler);
            }
            catch (SAXException e2) {
                throw new IFException("SAX error while handling extension object", e2);
            }
        } else {
            throw new UnsupportedOperationException("Extension must implement XMLizable: " + extension + " (" + extension.getClass().getName() + ")");
        }
    }

    protected RenderingContext createRenderingContext() throws IllegalStateException {
        throw new IllegalStateException("Should never be called!");
    }

    private void addAttribute(AttributesImpl atts, QName attribute, String value) throws SAXException {
        this.handler.startPrefixMapping(attribute.getPrefix(), attribute.getNamespaceURI());
        XMLUtil.addAttribute(atts, attribute, value);
    }

    private void addAttribute(AttributesImpl atts, String localName, String value) {
        XMLUtil.addAttribute(atts, localName, value);
    }

    private void addStructureReference(AttributesImpl atts) {
        IFStructureTreeBuilder.IFStructureTreeElement structureTreeElement = (IFStructureTreeBuilder.IFStructureTreeElement)this.getContext().getStructureTreeElement();
        if (structureTreeElement != null) {
            this.addStructRefAttribute(atts, structureTreeElement.getId());
        }
    }

    private void addStructRefAttribute(AttributesImpl atts, String id) {
        atts.addAttribute("http://xmlgraphics.apache.org/fop/internal", "struct-ref", "foi:struct-ref", "CDATA", id);
    }

    private void addID() throws SAXException {
        String id = this.getContext().getID();
        if (!this.currentID.equals(id)) {
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, "name", id);
            this.handler.startElement("id", (Attributes)atts);
            this.handler.endElement("id");
            this.currentID = id;
        }
    }

    private void noteAction(AbstractAction action) {
        if (action == null) {
            throw new NullPointerException("action must not be null");
        }
        if (!action.isComplete()) {
            assert (action.hasID());
            this.incompleteActions.put(action.getID(), action);
        }
    }

    @Override
    public void renderNamedDestination(NamedDestination destination) throws IFException {
        this.noteAction(destination.getAction());
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "name", "name", "CDATA", destination.getName());
        try {
            this.handler.startElement(DocumentNavigationExtensionConstants.NAMED_DESTINATION, (Attributes)atts);
            this.serializeXMLizable(destination.getAction());
            this.handler.endElement(DocumentNavigationExtensionConstants.NAMED_DESTINATION);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error serializing named destination", e2);
        }
    }

    @Override
    public void renderBookmarkTree(BookmarkTree tree) throws IFException {
        AttributesImpl atts = new AttributesImpl();
        try {
            this.handler.startElement(DocumentNavigationExtensionConstants.BOOKMARK_TREE, (Attributes)atts);
            for (Object o : tree.getBookmarks()) {
                Bookmark b = (Bookmark)o;
                if (b.getAction() == null) continue;
                this.serializeBookmark(b);
            }
            this.handler.endElement(DocumentNavigationExtensionConstants.BOOKMARK_TREE);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error serializing bookmark tree", e2);
        }
    }

    private void serializeBookmark(Bookmark bookmark) throws SAXException, IFException {
        this.noteAction(bookmark.getAction());
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "title", "title", "CDATA", bookmark.getTitle());
        atts.addAttribute("", "starting-state", "starting-state", "CDATA", bookmark.isShown() ? "show" : "hide");
        this.handler.startElement(DocumentNavigationExtensionConstants.BOOKMARK, (Attributes)atts);
        this.serializeXMLizable(bookmark.getAction());
        for (Object o : bookmark.getChildBookmarks()) {
            Bookmark b = (Bookmark)o;
            if (b.getAction() == null) continue;
            this.serializeBookmark(b);
        }
        this.handler.endElement(DocumentNavigationExtensionConstants.BOOKMARK);
    }

    @Override
    public void renderLink(Link link) throws IFException {
        this.noteAction(link.getAction());
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "rect", "rect", "CDATA", IFUtil.toString(link.getTargetRect()));
        if (this.getUserAgent().isAccessibilityEnabled()) {
            this.addStructRefAttribute(atts, ((IFStructureTreeBuilder.IFStructureTreeElement)link.getAction().getStructureTreeElement()).getId());
        }
        try {
            this.handler.startElement(DocumentNavigationExtensionConstants.LINK, (Attributes)atts);
            this.serializeXMLizable(link.getAction());
            this.handler.endElement(DocumentNavigationExtensionConstants.LINK);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error serializing link", e2);
        }
    }

    @Override
    public void addResolvedAction(AbstractAction action) throws IFException {
        assert (action.isComplete());
        assert (action.hasID());
        AbstractAction noted = (AbstractAction)this.incompleteActions.remove(action.getID());
        if (noted != null) {
            this.completeActions.add(action);
        }
    }

    @Override
    public int getPageIndex() {
        return -1;
    }

    private void commitNavigation() throws IFException {
        Iterator iter = this.completeActions.iterator();
        while (iter.hasNext()) {
            AbstractAction action = (AbstractAction)iter.next();
            iter.remove();
            this.serializeXMLizable(action);
        }
        assert (this.completeActions.size() == 0);
    }

    private void finishDocumentNavigation() {
        assert (this.incompleteActions.size() == 0) : "Still holding incomplete actions!";
    }

    private void serializeXMLizable(XMLizable object) throws IFException {
        try {
            object.toSAX(this.handler);
        }
        catch (SAXException e2) {
            throw new IFException("SAX error serializing object", e2);
        }
    }

    @Override
    public boolean isBackgroundRequired(BorderProps bpsTop, BorderProps bpsBottom, BorderProps bpsLeft, BorderProps bpsRight) {
        return true;
    }
}

