/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class TimesBoldItalic
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Times-BoldItalic";
    private static final String fullName = "Times Bold Italic";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 669;
    private static final int xHeight = 462;
    private static final int ascender = 699;
    private static final int descender = -205;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning;

    public TimesBoldItalic() {
        this(false);
    }

    public TimesBoldItalic(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    @Override
    public String getEncodingName() {
        return encoding;
    }

    @Override
    public URI getFontURI() {
        return fontFileURI;
    }

    @Override
    public String getFontName() {
        return fontName;
    }

    @Override
    public String getEmbedFontName() {
        return this.getFontName();
    }

    @Override
    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    @Override
    public FontType getFontType() {
        return FontType.TYPE1;
    }

    @Override
    public int getAscender(int size) {
        return size * 699;
    }

    @Override
    public int getCapHeight(int size) {
        return size * 669;
    }

    @Override
    public int getDescender(int size) {
        return size * -205;
    }

    @Override
    public int getXHeight(int size) {
        return size * 462;
    }

    @Override
    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    @Override
    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    @Override
    public int getWidth(int i, int size) {
        return size * width[i];
    }

    @Override
    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    @Override
    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    @Override
    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    @Override
    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    @Override
    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + fontName.toLowerCase());
        }
        catch (URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        TimesBoldItalic.width[65] = 667;
        TimesBoldItalic.boundingBoxes[65] = new Rectangle(-67, 0, 660, 683);
        TimesBoldItalic.width[198] = 944;
        TimesBoldItalic.boundingBoxes[198] = new Rectangle(-64, 0, 982, 669);
        TimesBoldItalic.width[193] = 667;
        TimesBoldItalic.boundingBoxes[193] = new Rectangle(-67, 0, 660, 904);
        TimesBoldItalic.width[194] = 667;
        TimesBoldItalic.boundingBoxes[194] = new Rectangle(-67, 0, 660, 897);
        TimesBoldItalic.width[196] = 667;
        TimesBoldItalic.boundingBoxes[196] = new Rectangle(-67, 0, 660, 862);
        TimesBoldItalic.width[192] = 667;
        TimesBoldItalic.boundingBoxes[192] = new Rectangle(-67, 0, 660, 904);
        TimesBoldItalic.width[197] = 667;
        TimesBoldItalic.boundingBoxes[197] = new Rectangle(-67, 0, 660, 921);
        TimesBoldItalic.width[195] = 667;
        TimesBoldItalic.boundingBoxes[195] = new Rectangle(-67, 0, 660, 862);
        TimesBoldItalic.width[66] = 667;
        TimesBoldItalic.boundingBoxes[66] = new Rectangle(-24, 0, 648, 669);
        TimesBoldItalic.width[67] = 667;
        TimesBoldItalic.boundingBoxes[67] = new Rectangle(32, -18, 645, 703);
        TimesBoldItalic.width[199] = 667;
        TimesBoldItalic.boundingBoxes[199] = new Rectangle(32, -218, 645, 903);
        TimesBoldItalic.width[68] = 722;
        TimesBoldItalic.boundingBoxes[68] = new Rectangle(-46, 0, 731, 669);
        TimesBoldItalic.width[69] = 667;
        TimesBoldItalic.boundingBoxes[69] = new Rectangle(-27, 0, 680, 669);
        TimesBoldItalic.width[201] = 667;
        TimesBoldItalic.boundingBoxes[201] = new Rectangle(-27, 0, 680, 904);
        TimesBoldItalic.width[202] = 667;
        TimesBoldItalic.boundingBoxes[202] = new Rectangle(-27, 0, 680, 897);
        TimesBoldItalic.width[203] = 667;
        TimesBoldItalic.boundingBoxes[203] = new Rectangle(-27, 0, 680, 862);
        TimesBoldItalic.width[200] = 667;
        TimesBoldItalic.boundingBoxes[200] = new Rectangle(-27, 0, 680, 904);
        TimesBoldItalic.width[208] = 722;
        TimesBoldItalic.boundingBoxes[208] = new Rectangle(-31, 0, 731, 669);
        TimesBoldItalic.width[128] = 500;
        TimesBoldItalic.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        TimesBoldItalic.width[70] = 667;
        TimesBoldItalic.boundingBoxes[70] = new Rectangle(-13, 0, 673, 669);
        TimesBoldItalic.width[71] = 722;
        TimesBoldItalic.boundingBoxes[71] = new Rectangle(21, -18, 685, 703);
        TimesBoldItalic.width[72] = 778;
        TimesBoldItalic.boundingBoxes[72] = new Rectangle(-24, 0, 823, 669);
        TimesBoldItalic.width[73] = 389;
        TimesBoldItalic.boundingBoxes[73] = new Rectangle(-32, 0, 438, 669);
        TimesBoldItalic.width[205] = 389;
        TimesBoldItalic.boundingBoxes[205] = new Rectangle(-32, 0, 464, 904);
        TimesBoldItalic.width[206] = 389;
        TimesBoldItalic.boundingBoxes[206] = new Rectangle(-32, 0, 482, 897);
        TimesBoldItalic.width[207] = 389;
        TimesBoldItalic.boundingBoxes[207] = new Rectangle(-32, 0, 482, 862);
        TimesBoldItalic.width[204] = 389;
        TimesBoldItalic.boundingBoxes[204] = new Rectangle(-32, 0, 438, 904);
        TimesBoldItalic.width[74] = 500;
        TimesBoldItalic.boundingBoxes[74] = new Rectangle(-46, -99, 570, 768);
        TimesBoldItalic.width[75] = 667;
        TimesBoldItalic.boundingBoxes[75] = new Rectangle(-21, 0, 723, 669);
        TimesBoldItalic.width[76] = 611;
        TimesBoldItalic.boundingBoxes[76] = new Rectangle(-22, 0, 612, 669);
        TimesBoldItalic.width[77] = 889;
        TimesBoldItalic.boundingBoxes[77] = new Rectangle(-29, -12, 946, 681);
        TimesBoldItalic.width[78] = 722;
        TimesBoldItalic.boundingBoxes[78] = new Rectangle(-27, -15, 775, 684);
        TimesBoldItalic.width[209] = 722;
        TimesBoldItalic.boundingBoxes[209] = new Rectangle(-27, -15, 775, 877);
        TimesBoldItalic.width[79] = 722;
        TimesBoldItalic.boundingBoxes[79] = new Rectangle(27, -18, 664, 703);
        TimesBoldItalic.width[140] = 944;
        TimesBoldItalic.boundingBoxes[140] = new Rectangle(23, -8, 923, 685);
        TimesBoldItalic.width[211] = 722;
        TimesBoldItalic.boundingBoxes[211] = new Rectangle(27, -18, 664, 922);
        TimesBoldItalic.width[212] = 722;
        TimesBoldItalic.boundingBoxes[212] = new Rectangle(27, -18, 664, 915);
        TimesBoldItalic.width[214] = 722;
        TimesBoldItalic.boundingBoxes[214] = new Rectangle(27, -18, 664, 880);
        TimesBoldItalic.width[210] = 722;
        TimesBoldItalic.boundingBoxes[210] = new Rectangle(27, -18, 664, 922);
        TimesBoldItalic.width[216] = 722;
        TimesBoldItalic.boundingBoxes[216] = new Rectangle(27, -125, 664, 889);
        TimesBoldItalic.width[213] = 722;
        TimesBoldItalic.boundingBoxes[213] = new Rectangle(27, -18, 664, 880);
        TimesBoldItalic.width[80] = 611;
        TimesBoldItalic.boundingBoxes[80] = new Rectangle(-27, 0, 640, 669);
        TimesBoldItalic.width[81] = 722;
        TimesBoldItalic.boundingBoxes[81] = new Rectangle(27, -208, 664, 893);
        TimesBoldItalic.width[82] = 667;
        TimesBoldItalic.boundingBoxes[82] = new Rectangle(-29, 0, 652, 669);
        TimesBoldItalic.width[83] = 556;
        TimesBoldItalic.boundingBoxes[83] = new Rectangle(2, -18, 524, 703);
        TimesBoldItalic.width[138] = 556;
        TimesBoldItalic.boundingBoxes[138] = new Rectangle(2, -18, 551, 915);
        TimesBoldItalic.width[84] = 611;
        TimesBoldItalic.boundingBoxes[84] = new Rectangle(50, 0, 600, 669);
        TimesBoldItalic.width[222] = 611;
        TimesBoldItalic.boundingBoxes[222] = new Rectangle(-27, 0, 600, 669);
        TimesBoldItalic.width[85] = 722;
        TimesBoldItalic.boundingBoxes[85] = new Rectangle(67, -18, 677, 687);
        TimesBoldItalic.width[218] = 722;
        TimesBoldItalic.boundingBoxes[218] = new Rectangle(67, -18, 677, 922);
        TimesBoldItalic.width[219] = 722;
        TimesBoldItalic.boundingBoxes[219] = new Rectangle(67, -18, 677, 915);
        TimesBoldItalic.width[220] = 722;
        TimesBoldItalic.boundingBoxes[220] = new Rectangle(67, -18, 677, 880);
        TimesBoldItalic.width[217] = 722;
        TimesBoldItalic.boundingBoxes[217] = new Rectangle(67, -18, 677, 922);
        TimesBoldItalic.width[86] = 667;
        TimesBoldItalic.boundingBoxes[86] = new Rectangle(65, -18, 650, 687);
        TimesBoldItalic.width[87] = 889;
        TimesBoldItalic.boundingBoxes[87] = new Rectangle(65, -18, 875, 687);
        TimesBoldItalic.width[88] = 667;
        TimesBoldItalic.boundingBoxes[88] = new Rectangle(-24, 0, 718, 669);
        TimesBoldItalic.width[89] = 611;
        TimesBoldItalic.boundingBoxes[89] = new Rectangle(73, 0, 586, 669);
        TimesBoldItalic.width[221] = 611;
        TimesBoldItalic.boundingBoxes[221] = new Rectangle(73, 0, 586, 904);
        TimesBoldItalic.width[159] = 611;
        TimesBoldItalic.boundingBoxes[159] = new Rectangle(73, 0, 586, 862);
        TimesBoldItalic.width[90] = 611;
        TimesBoldItalic.boundingBoxes[90] = new Rectangle(-11, 0, 601, 669);
        TimesBoldItalic.width[142] = 611;
        TimesBoldItalic.boundingBoxes[142] = new Rectangle(-11, 0, 601, 897);
        TimesBoldItalic.width[97] = 500;
        TimesBoldItalic.boundingBoxes[97] = new Rectangle(-21, -14, 476, 476);
        TimesBoldItalic.width[225] = 500;
        TimesBoldItalic.boundingBoxes[225] = new Rectangle(-21, -14, 484, 711);
        TimesBoldItalic.width[226] = 500;
        TimesBoldItalic.boundingBoxes[226] = new Rectangle(-21, -14, 476, 704);
        TimesBoldItalic.width[180] = 333;
        TimesBoldItalic.boundingBoxes[180] = new Rectangle(139, 516, 240, 181);
        TimesBoldItalic.width[228] = 500;
        TimesBoldItalic.boundingBoxes[228] = new Rectangle(-21, -14, 497, 669);
        TimesBoldItalic.width[230] = 722;
        TimesBoldItalic.boundingBoxes[230] = new Rectangle(-5, -13, 678, 475);
        TimesBoldItalic.width[224] = 500;
        TimesBoldItalic.boundingBoxes[224] = new Rectangle(-21, -14, 476, 711);
        TimesBoldItalic.width[38] = 778;
        TimesBoldItalic.boundingBoxes[38] = new Rectangle(5, -19, 694, 701);
        TimesBoldItalic.width[229] = 500;
        TimesBoldItalic.boundingBoxes[229] = new Rectangle(-21, -14, 476, 743);
        TimesBoldItalic.width[94] = 570;
        TimesBoldItalic.boundingBoxes[94] = new Rectangle(67, 304, 436, 365);
        TimesBoldItalic.width[126] = 570;
        TimesBoldItalic.boundingBoxes[126] = new Rectangle(54, 173, 462, 160);
        TimesBoldItalic.width[42] = 500;
        TimesBoldItalic.boundingBoxes[42] = new Rectangle(65, 249, 391, 436);
        TimesBoldItalic.width[64] = 832;
        TimesBoldItalic.boundingBoxes[64] = new Rectangle(63, -18, 707, 703);
        TimesBoldItalic.width[227] = 500;
        TimesBoldItalic.boundingBoxes[227] = new Rectangle(-21, -14, 512, 669);
        TimesBoldItalic.width[98] = 500;
        TimesBoldItalic.boundingBoxes[98] = new Rectangle(-14, -13, 458, 712);
        TimesBoldItalic.width[92] = 278;
        TimesBoldItalic.boundingBoxes[92] = new Rectangle(-1, -18, 280, 703);
        TimesBoldItalic.width[124] = 220;
        TimesBoldItalic.boundingBoxes[124] = new Rectangle(66, -218, 88, 1000);
        TimesBoldItalic.width[123] = 348;
        TimesBoldItalic.boundingBoxes[123] = new Rectangle(5, -187, 431, 873);
        TimesBoldItalic.width[125] = 348;
        TimesBoldItalic.boundingBoxes[125] = new Rectangle(-129, -187, 431, 873);
        TimesBoldItalic.width[91] = 333;
        TimesBoldItalic.boundingBoxes[91] = new Rectangle(-37, -159, 399, 833);
        TimesBoldItalic.width[93] = 333;
        TimesBoldItalic.boundingBoxes[93] = new Rectangle(-56, -157, 399, 831);
        TimesBoldItalic.width[166] = 220;
        TimesBoldItalic.boundingBoxes[166] = new Rectangle(66, -143, 88, 850);
        TimesBoldItalic.width[149] = 350;
        TimesBoldItalic.boundingBoxes[149] = new Rectangle(0, 175, 350, 350);
        TimesBoldItalic.width[99] = 444;
        TimesBoldItalic.boundingBoxes[99] = new Rectangle(-5, -13, 397, 475);
        TimesBoldItalic.width[231] = 444;
        TimesBoldItalic.boundingBoxes[231] = new Rectangle(-5, -218, 397, 680);
        TimesBoldItalic.width[184] = 333;
        TimesBoldItalic.boundingBoxes[184] = new Rectangle(-80, -218, 236, 223);
        TimesBoldItalic.width[162] = 500;
        TimesBoldItalic.boundingBoxes[162] = new Rectangle(42, -143, 397, 719);
        TimesBoldItalic.width[136] = 333;
        TimesBoldItalic.boundingBoxes[136] = new Rectangle(40, 516, 327, 174);
        TimesBoldItalic.width[58] = 333;
        TimesBoldItalic.boundingBoxes[58] = new Rectangle(23, -13, 241, 472);
        TimesBoldItalic.width[44] = 250;
        TimesBoldItalic.boundingBoxes[44] = new Rectangle(-60, -182, 204, 316);
        TimesBoldItalic.width[169] = 747;
        TimesBoldItalic.boundingBoxes[169] = new Rectangle(30, -18, 688, 703);
        TimesBoldItalic.width[164] = 500;
        TimesBoldItalic.boundingBoxes[164] = new Rectangle(-26, 34, 552, 552);
        TimesBoldItalic.width[100] = 500;
        TimesBoldItalic.boundingBoxes[100] = new Rectangle(-21, -13, 538, 712);
        TimesBoldItalic.width[134] = 500;
        TimesBoldItalic.boundingBoxes[134] = new Rectangle(91, -145, 403, 830);
        TimesBoldItalic.width[135] = 500;
        TimesBoldItalic.boundingBoxes[135] = new Rectangle(10, -139, 483, 824);
        TimesBoldItalic.width[176] = 400;
        TimesBoldItalic.boundingBoxes[176] = new Rectangle(83, 397, 286, 286);
        TimesBoldItalic.width[168] = 333;
        TimesBoldItalic.boundingBoxes[168] = new Rectangle(55, 550, 347, 134);
        TimesBoldItalic.width[247] = 570;
        TimesBoldItalic.boundingBoxes[247] = new Rectangle(33, -29, 504, 564);
        TimesBoldItalic.width[36] = 500;
        TimesBoldItalic.boundingBoxes[36] = new Rectangle(-20, -100, 517, 833);
        TimesBoldItalic.width[101] = 444;
        TimesBoldItalic.boundingBoxes[101] = new Rectangle(5, -13, 393, 475);
        TimesBoldItalic.width[233] = 444;
        TimesBoldItalic.boundingBoxes[233] = new Rectangle(5, -13, 430, 710);
        TimesBoldItalic.width[234] = 444;
        TimesBoldItalic.boundingBoxes[234] = new Rectangle(5, -13, 418, 703);
        TimesBoldItalic.width[235] = 444;
        TimesBoldItalic.boundingBoxes[235] = new Rectangle(5, -13, 443, 668);
        TimesBoldItalic.width[232] = 444;
        TimesBoldItalic.boundingBoxes[232] = new Rectangle(5, -13, 393, 710);
        TimesBoldItalic.width[56] = 500;
        TimesBoldItalic.boundingBoxes[56] = new Rectangle(3, -13, 473, 696);
        TimesBoldItalic.width[133] = 1000;
        TimesBoldItalic.boundingBoxes[133] = new Rectangle(40, -13, 812, 148);
        TimesBoldItalic.width[151] = 1000;
        TimesBoldItalic.boundingBoxes[151] = new Rectangle(-40, 178, 1017, 91);
        TimesBoldItalic.width[150] = 500;
        TimesBoldItalic.boundingBoxes[150] = new Rectangle(-40, 178, 517, 91);
        TimesBoldItalic.width[61] = 570;
        TimesBoldItalic.boundingBoxes[61] = new Rectangle(33, 107, 504, 292);
        TimesBoldItalic.width[240] = 500;
        TimesBoldItalic.boundingBoxes[240] = new Rectangle(-3, -13, 457, 712);
        TimesBoldItalic.width[33] = 389;
        TimesBoldItalic.boundingBoxes[33] = new Rectangle(67, -13, 303, 697);
        TimesBoldItalic.width[161] = 389;
        TimesBoldItalic.boundingBoxes[161] = new Rectangle(19, -205, 303, 697);
        TimesBoldItalic.width[102] = 333;
        TimesBoldItalic.boundingBoxes[102] = new Rectangle(-169, -205, 615, 903);
        TimesBoldItalic.width[53] = 500;
        TimesBoldItalic.boundingBoxes[53] = new Rectangle(-11, -13, 498, 682);
        TimesBoldItalic.width[131] = 500;
        TimesBoldItalic.boundingBoxes[131] = new Rectangle(-87, -156, 624, 863);
        TimesBoldItalic.width[52] = 500;
        TimesBoldItalic.boundingBoxes[52] = new Rectangle(-15, 0, 518, 683);
        TimesBoldItalic.width[103] = 500;
        TimesBoldItalic.boundingBoxes[103] = new Rectangle(-52, -203, 530, 665);
        TimesBoldItalic.width[223] = 500;
        TimesBoldItalic.boundingBoxes[223] = new Rectangle(-200, -200, 673, 905);
        TimesBoldItalic.width[96] = 333;
        TimesBoldItalic.boundingBoxes[96] = new Rectangle(85, 516, 212, 181);
        TimesBoldItalic.width[62] = 570;
        TimesBoldItalic.boundingBoxes[62] = new Rectangle(31, -8, 508, 522);
        TimesBoldItalic.width[171] = 500;
        TimesBoldItalic.boundingBoxes[171] = new Rectangle(12, 32, 456, 383);
        TimesBoldItalic.width[187] = 500;
        TimesBoldItalic.boundingBoxes[187] = new Rectangle(12, 32, 456, 383);
        TimesBoldItalic.width[139] = 333;
        TimesBoldItalic.boundingBoxes[139] = new Rectangle(32, 32, 271, 383);
        TimesBoldItalic.width[155] = 333;
        TimesBoldItalic.boundingBoxes[155] = new Rectangle(10, 32, 271, 383);
        TimesBoldItalic.width[104] = 556;
        TimesBoldItalic.boundingBoxes[104] = new Rectangle(-13, -9, 511, 708);
        TimesBoldItalic.width[45] = 333;
        TimesBoldItalic.boundingBoxes[45] = new Rectangle(2, 166, 269, 116);
        TimesBoldItalic.width[105] = 278;
        TimesBoldItalic.boundingBoxes[105] = new Rectangle(2, -9, 261, 693);
        TimesBoldItalic.width[237] = 278;
        TimesBoldItalic.boundingBoxes[237] = new Rectangle(2, -9, 350, 706);
        TimesBoldItalic.width[238] = 278;
        TimesBoldItalic.boundingBoxes[238] = new Rectangle(-3, -9, 327, 699);
        TimesBoldItalic.width[239] = 278;
        TimesBoldItalic.boundingBoxes[239] = new Rectangle(2, -9, 362, 664);
        TimesBoldItalic.width[236] = 278;
        TimesBoldItalic.boundingBoxes[236] = new Rectangle(2, -9, 257, 706);
        TimesBoldItalic.width[106] = 278;
        TimesBoldItalic.boundingBoxes[106] = new Rectangle(-189, -207, 468, 891);
        TimesBoldItalic.width[107] = 500;
        TimesBoldItalic.boundingBoxes[107] = new Rectangle(-23, -8, 506, 707);
        TimesBoldItalic.width[108] = 278;
        TimesBoldItalic.boundingBoxes[108] = new Rectangle(2, -9, 288, 708);
        TimesBoldItalic.width[60] = 570;
        TimesBoldItalic.boundingBoxes[60] = new Rectangle(31, -8, 508, 522);
        TimesBoldItalic.width[172] = 606;
        TimesBoldItalic.boundingBoxes[172] = new Rectangle(51, 108, 504, 291);
        TimesBoldItalic.width[109] = 778;
        TimesBoldItalic.boundingBoxes[109] = new Rectangle(-14, -9, 736, 471);
        TimesBoldItalic.width[175] = 333;
        TimesBoldItalic.boundingBoxes[175] = new Rectangle(51, 553, 342, 70);
        TimesBoldItalic.width[181] = 576;
        TimesBoldItalic.boundingBoxes[181] = new Rectangle(-60, -207, 576, 656);
        TimesBoldItalic.width[215] = 570;
        TimesBoldItalic.boundingBoxes[215] = new Rectangle(48, 16, 474, 474);
        TimesBoldItalic.width[110] = 556;
        TimesBoldItalic.boundingBoxes[110] = new Rectangle(-6, -9, 499, 471);
        TimesBoldItalic.width[57] = 500;
        TimesBoldItalic.boundingBoxes[57] = new Rectangle(-12, -10, 487, 693);
        TimesBoldItalic.width[241] = 556;
        TimesBoldItalic.boundingBoxes[241] = new Rectangle(-6, -9, 510, 664);
        TimesBoldItalic.width[35] = 500;
        TimesBoldItalic.boundingBoxes[35] = new Rectangle(-33, 0, 566, 700);
        TimesBoldItalic.width[111] = 500;
        TimesBoldItalic.boundingBoxes[111] = new Rectangle(-3, -13, 444, 475);
        TimesBoldItalic.width[243] = 500;
        TimesBoldItalic.boundingBoxes[243] = new Rectangle(-3, -13, 466, 710);
        TimesBoldItalic.width[244] = 500;
        TimesBoldItalic.boundingBoxes[244] = new Rectangle(-3, -13, 454, 703);
        TimesBoldItalic.width[246] = 500;
        TimesBoldItalic.boundingBoxes[246] = new Rectangle(-3, -13, 474, 668);
        TimesBoldItalic.width[156] = 722;
        TimesBoldItalic.boundingBoxes[156] = new Rectangle(6, -13, 668, 475);
        TimesBoldItalic.width[242] = 500;
        TimesBoldItalic.boundingBoxes[242] = new Rectangle(-3, -13, 444, 710);
        TimesBoldItalic.width[49] = 500;
        TimesBoldItalic.boundingBoxes[49] = new Rectangle(5, 0, 414, 683);
        TimesBoldItalic.width[189] = 750;
        TimesBoldItalic.boundingBoxes[189] = new Rectangle(-9, -14, 732, 697);
        TimesBoldItalic.width[188] = 750;
        TimesBoldItalic.boundingBoxes[188] = new Rectangle(7, -14, 714, 697);
        TimesBoldItalic.width[185] = 300;
        TimesBoldItalic.boundingBoxes[185] = new Rectangle(30, 274, 271, 409);
        TimesBoldItalic.width[170] = 266;
        TimesBoldItalic.boundingBoxes[170] = new Rectangle(16, 399, 314, 286);
        TimesBoldItalic.width[186] = 300;
        TimesBoldItalic.boundingBoxes[186] = new Rectangle(56, 400, 291, 285);
        TimesBoldItalic.width[248] = 500;
        TimesBoldItalic.boundingBoxes[248] = new Rectangle(-3, -119, 444, 679);
        TimesBoldItalic.width[245] = 500;
        TimesBoldItalic.boundingBoxes[245] = new Rectangle(-3, -13, 494, 668);
        TimesBoldItalic.width[112] = 500;
        TimesBoldItalic.boundingBoxes[112] = new Rectangle(-120, -205, 566, 667);
        TimesBoldItalic.width[182] = 500;
        TimesBoldItalic.boundingBoxes[182] = new Rectangle(-57, -193, 619, 862);
        TimesBoldItalic.width[40] = 333;
        TimesBoldItalic.boundingBoxes[40] = new Rectangle(28, -179, 316, 864);
        TimesBoldItalic.width[41] = 333;
        TimesBoldItalic.boundingBoxes[41] = new Rectangle(-44, -179, 315, 864);
        TimesBoldItalic.width[37] = 833;
        TimesBoldItalic.boundingBoxes[37] = new Rectangle(39, -10, 754, 702);
        TimesBoldItalic.width[46] = 250;
        TimesBoldItalic.boundingBoxes[46] = new Rectangle(-9, -13, 148, 148);
        TimesBoldItalic.width[183] = 250;
        TimesBoldItalic.boundingBoxes[183] = new Rectangle(51, 257, 148, 148);
        TimesBoldItalic.width[137] = 1000;
        TimesBoldItalic.boundingBoxes[137] = new Rectangle(7, -29, 989, 735);
        TimesBoldItalic.width[43] = 570;
        TimesBoldItalic.boundingBoxes[43] = new Rectangle(33, 0, 504, 506);
        TimesBoldItalic.width[177] = 570;
        TimesBoldItalic.boundingBoxes[177] = new Rectangle(33, 0, 504, 506);
        TimesBoldItalic.width[113] = 500;
        TimesBoldItalic.boundingBoxes[113] = new Rectangle(1, -205, 470, 667);
        TimesBoldItalic.width[63] = 500;
        TimesBoldItalic.boundingBoxes[63] = new Rectangle(79, -13, 391, 697);
        TimesBoldItalic.width[191] = 500;
        TimesBoldItalic.boundingBoxes[191] = new Rectangle(30, -205, 391, 697);
        TimesBoldItalic.width[34] = 555;
        TimesBoldItalic.boundingBoxes[34] = new Rectangle(136, 398, 400, 287);
        TimesBoldItalic.width[132] = 500;
        TimesBoldItalic.boundingBoxes[132] = new Rectangle(-57, -182, 460, 316);
        TimesBoldItalic.width[147] = 500;
        TimesBoldItalic.boundingBoxes[147] = new Rectangle(53, 369, 460, 316);
        TimesBoldItalic.width[148] = 500;
        TimesBoldItalic.boundingBoxes[148] = new Rectangle(53, 369, 460, 316);
        TimesBoldItalic.width[145] = 333;
        TimesBoldItalic.boundingBoxes[145] = new Rectangle(128, 369, 204, 316);
        TimesBoldItalic.width[146] = 333;
        TimesBoldItalic.boundingBoxes[146] = new Rectangle(98, 369, 204, 316);
        TimesBoldItalic.width[130] = 333;
        TimesBoldItalic.boundingBoxes[130] = new Rectangle(-5, -182, 204, 316);
        TimesBoldItalic.width[39] = 278;
        TimesBoldItalic.boundingBoxes[39] = new Rectangle(128, 398, 140, 287);
        TimesBoldItalic.width[114] = 389;
        TimesBoldItalic.boundingBoxes[114] = new Rectangle(-21, 0, 410, 462);
        TimesBoldItalic.width[174] = 747;
        TimesBoldItalic.boundingBoxes[174] = new Rectangle(30, -18, 688, 703);
        TimesBoldItalic.width[115] = 389;
        TimesBoldItalic.boundingBoxes[115] = new Rectangle(-19, -13, 352, 475);
        TimesBoldItalic.width[154] = 389;
        TimesBoldItalic.boundingBoxes[154] = new Rectangle(-19, -13, 443, 703);
        TimesBoldItalic.width[167] = 500;
        TimesBoldItalic.boundingBoxes[167] = new Rectangle(36, -143, 423, 828);
        TimesBoldItalic.width[59] = 333;
        TimesBoldItalic.boundingBoxes[59] = new Rectangle(-25, -183, 289, 642);
        TimesBoldItalic.width[55] = 500;
        TimesBoldItalic.boundingBoxes[55] = new Rectangle(52, 0, 473, 669);
        TimesBoldItalic.width[54] = 500;
        TimesBoldItalic.boundingBoxes[54] = new Rectangle(23, -15, 486, 694);
        TimesBoldItalic.width[47] = 278;
        TimesBoldItalic.boundingBoxes[47] = new Rectangle(-64, -18, 406, 703);
        TimesBoldItalic.width[32] = 250;
        TimesBoldItalic.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        TimesBoldItalic.width[163] = 500;
        TimesBoldItalic.boundingBoxes[163] = new Rectangle(-32, -12, 542, 695);
        TimesBoldItalic.width[116] = 278;
        TimesBoldItalic.boundingBoxes[116] = new Rectangle(-11, -9, 292, 603);
        TimesBoldItalic.width[254] = 500;
        TimesBoldItalic.boundingBoxes[254] = new Rectangle(-120, -205, 566, 904);
        TimesBoldItalic.width[51] = 500;
        TimesBoldItalic.boundingBoxes[51] = new Rectangle(-15, -13, 465, 696);
        TimesBoldItalic.width[190] = 750;
        TimesBoldItalic.boundingBoxes[190] = new Rectangle(7, -14, 719, 697);
        TimesBoldItalic.width[179] = 300;
        TimesBoldItalic.boundingBoxes[179] = new Rectangle(17, 265, 304, 418);
        TimesBoldItalic.width[152] = 333;
        TimesBoldItalic.boundingBoxes[152] = new Rectangle(48, 536, 359, 119);
        TimesBoldItalic.width[153] = 1000;
        TimesBoldItalic.boundingBoxes[153] = new Rectangle(32, 263, 936, 406);
        TimesBoldItalic.width[50] = 500;
        TimesBoldItalic.boundingBoxes[50] = new Rectangle(-27, 0, 473, 683);
        TimesBoldItalic.width[178] = 300;
        TimesBoldItalic.boundingBoxes[178] = new Rectangle(2, 274, 311, 409);
        TimesBoldItalic.width[117] = 556;
        TimesBoldItalic.boundingBoxes[117] = new Rectangle(15, -9, 477, 471);
        TimesBoldItalic.width[250] = 556;
        TimesBoldItalic.boundingBoxes[250] = new Rectangle(15, -9, 477, 706);
        TimesBoldItalic.width[251] = 556;
        TimesBoldItalic.boundingBoxes[251] = new Rectangle(15, -9, 477, 699);
        TimesBoldItalic.width[252] = 556;
        TimesBoldItalic.boundingBoxes[252] = new Rectangle(15, -9, 484, 664);
        TimesBoldItalic.width[249] = 556;
        TimesBoldItalic.boundingBoxes[249] = new Rectangle(15, -9, 477, 706);
        TimesBoldItalic.width[95] = 500;
        TimesBoldItalic.boundingBoxes[95] = new Rectangle(0, -125, 500, 50);
        TimesBoldItalic.width[118] = 444;
        TimesBoldItalic.boundingBoxes[118] = new Rectangle(16, -13, 385, 475);
        TimesBoldItalic.width[119] = 667;
        TimesBoldItalic.boundingBoxes[119] = new Rectangle(16, -13, 598, 475);
        TimesBoldItalic.width[120] = 500;
        TimesBoldItalic.boundingBoxes[120] = new Rectangle(-46, -13, 515, 475);
        TimesBoldItalic.width[121] = 444;
        TimesBoldItalic.boundingBoxes[121] = new Rectangle(-94, -205, 486, 667);
        TimesBoldItalic.width[253] = 444;
        TimesBoldItalic.boundingBoxes[253] = new Rectangle(-94, -205, 529, 902);
        TimesBoldItalic.width[255] = 444;
        TimesBoldItalic.boundingBoxes[255] = new Rectangle(-94, -205, 537, 860);
        TimesBoldItalic.width[165] = 500;
        TimesBoldItalic.boundingBoxes[165] = new Rectangle(33, 0, 595, 669);
        TimesBoldItalic.width[122] = 389;
        TimesBoldItalic.boundingBoxes[122] = new Rectangle(-43, -78, 411, 527);
        TimesBoldItalic.width[158] = 389;
        TimesBoldItalic.boundingBoxes[158] = new Rectangle(-43, -78, 467, 768);
        TimesBoldItalic.width[48] = 500;
        TimesBoldItalic.boundingBoxes[48] = new Rectangle(17, -14, 460, 697);
        familyNames = new HashSet();
        familyNames.add("Times");
        kerning = new HashMap();
        Integer first = 79;
        Map<Integer, Integer> pairs = (HashMap<Integer, Integer>)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap<Integer, Integer>();
            kerning.put(first, pairs);
        }
        Integer second = 65;
        pairs.put(second, -40);
        second = 87;
        pairs.put(second, -50);
        second = 89;
        pairs.put(second, -50);
        second = 84;
        pairs.put(second, -40);
        second = 46;
        pairs.put(second, 0);
        second = 86;
        pairs.put(second, -50);
        second = 88;
        pairs.put(second, -40);
        second = 44;
        pairs.put(second, 0);
        first = 107;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -10);
        second = 121;
        pairs.put(second, 0);
        second = 101;
        pairs.put(second, -30);
        first = 112;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 121;
        pairs.put(second, 0);
        first = 80;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -55);
        second = 97;
        pairs.put(second, -40);
        second = 65;
        pairs.put(second, -85);
        second = 46;
        pairs.put(second, -129);
        second = 101;
        pairs.put(second, -50);
        second = 44;
        pairs.put(second, -129);
        first = 86;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -111);
        second = 79;
        pairs.put(second, -30);
        second = 58;
        pairs.put(second, -74);
        second = 71;
        pairs.put(second, -10);
        second = 44;
        pairs.put(second, -129);
        second = 59;
        pairs.put(second, -74);
        second = 45;
        pairs.put(second, -70);
        second = 105;
        pairs.put(second, -55);
        second = 65;
        pairs.put(second, -85);
        second = 97;
        pairs.put(second, -111);
        second = 117;
        pairs.put(second, -55);
        second = 46;
        pairs.put(second, -129);
        second = 101;
        pairs.put(second, -111);
        first = 118;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -15);
        second = 97;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, -37);
        second = 101;
        pairs.put(second, -15);
        second = 44;
        pairs.put(second, -37);
        first = 32;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -37);
        second = 87;
        pairs.put(second, -70);
        second = 147;
        pairs.put(second, 0);
        second = 89;
        pairs.put(second, -70);
        second = 84;
        pairs.put(second, 0);
        second = 145;
        pairs.put(second, 0);
        second = 86;
        pairs.put(second, -70);
        first = 97;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, 0);
        second = 116;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        second = 112;
        pairs.put(second, 0);
        second = 103;
        pairs.put(second, 0);
        second = 98;
        pairs.put(second, 0);
        second = 118;
        pairs.put(second, 0);
        first = 70;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -70);
        second = 105;
        pairs.put(second, -40);
        second = 114;
        pairs.put(second, -50);
        second = 97;
        pairs.put(second, -95);
        second = 65;
        pairs.put(second, -100);
        second = 46;
        pairs.put(second, -129);
        second = 101;
        pairs.put(second, -100);
        second = 44;
        pairs.put(second, -129);
        first = 85;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -45);
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 100;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 100;
        pairs.put(second, 0);
        second = 119;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, 0);
        second = 118;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 83;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 122;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, 0);
        second = 101;
        pairs.put(second, 0);
        first = 68;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -25);
        second = 87;
        pairs.put(second, -40);
        second = 89;
        pairs.put(second, -50);
        second = 46;
        pairs.put(second, 0);
        second = 86;
        pairs.put(second, -50);
        second = 44;
        pairs.put(second, 0);
        first = 146;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, 0);
        second = 100;
        pairs.put(second, -15);
        second = 32;
        pairs.put(second, -74);
        second = 146;
        pairs.put(second, -74);
        second = 114;
        pairs.put(second, -15);
        second = 116;
        pairs.put(second, -37);
        second = 108;
        pairs.put(second, 0);
        second = 115;
        pairs.put(second, -74);
        second = 118;
        pairs.put(second, -15);
        first = 58;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 32;
        pairs.put(second, 0);
        first = 119;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -15);
        second = 97;
        pairs.put(second, -10);
        second = 104;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, -37);
        second = 101;
        pairs.put(second, -10);
        second = 44;
        pairs.put(second, -37);
        first = 75;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -25);
        second = 79;
        pairs.put(second, -30);
        second = 117;
        pairs.put(second, -20);
        second = 121;
        pairs.put(second, -20);
        second = 101;
        pairs.put(second, -25);
        first = 82;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 79;
        pairs.put(second, -40);
        second = 87;
        pairs.put(second, -18);
        second = 85;
        pairs.put(second, -40);
        second = 89;
        pairs.put(second, -18);
        second = 84;
        pairs.put(second, -30);
        second = 86;
        pairs.put(second, -18);
        first = 145;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, 0);
        second = 145;
        pairs.put(second, -74);
        first = 103;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, 0);
        second = 105;
        pairs.put(second, 0);
        second = 114;
        pairs.put(second, 0);
        second = 97;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, 0);
        second = 103;
        pairs.put(second, 0);
        second = 101;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 66;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -25);
        second = 85;
        pairs.put(second, -10);
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 98;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 117;
        pairs.put(second, -20);
        second = 121;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, -40);
        second = 108;
        pairs.put(second, 0);
        second = 98;
        pairs.put(second, -10);
        second = 118;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 81;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 85;
        pairs.put(second, -10);
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 44;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, -95);
        second = 32;
        pairs.put(second, 0);
        second = 146;
        pairs.put(second, -95);
        first = 102;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, 0);
        second = 111;
        pairs.put(second, -10);
        second = 105;
        pairs.put(second, 0);
        second = 146;
        pairs.put(second, 55);
        second = 97;
        pairs.put(second, 0);
        second = 102;
        pairs.put(second, -18);
        second = 46;
        pairs.put(second, -10);
        second = 108;
        pairs.put(second, 0);
        second = 101;
        pairs.put(second, -10);
        second = 44;
        pairs.put(second, -10);
        first = 84;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -95);
        second = 79;
        pairs.put(second, -18);
        second = 119;
        pairs.put(second, -37);
        second = 58;
        pairs.put(second, -74);
        second = 114;
        pairs.put(second, -37);
        second = 104;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -92);
        second = 59;
        pairs.put(second, -74);
        second = 45;
        pairs.put(second, -92);
        second = 105;
        pairs.put(second, -37);
        second = 65;
        pairs.put(second, -55);
        second = 97;
        pairs.put(second, -92);
        second = 117;
        pairs.put(second, -37);
        second = 121;
        pairs.put(second, -37);
        second = 46;
        pairs.put(second, -92);
        second = 101;
        pairs.put(second, -92);
        first = 121;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, 0);
        second = 97;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, -37);
        second = 101;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -37);
        first = 120;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 101;
        pairs.put(second, -10);
        first = 101;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        second = 112;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, 0);
        second = 103;
        pairs.put(second, 0);
        second = 98;
        pairs.put(second, -10);
        second = 120;
        pairs.put(second, 0);
        second = 118;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 99;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 107;
        pairs.put(second, -10);
        second = 104;
        pairs.put(second, -10);
        second = 121;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, 0);
        second = 108;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 87;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -80);
        second = 79;
        pairs.put(second, -15);
        second = 58;
        pairs.put(second, -55);
        second = 104;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -74);
        second = 59;
        pairs.put(second, -55);
        second = 45;
        pairs.put(second, -50);
        second = 105;
        pairs.put(second, -37);
        second = 65;
        pairs.put(second, -74);
        second = 97;
        pairs.put(second, -85);
        second = 117;
        pairs.put(second, -55);
        second = 121;
        pairs.put(second, -55);
        second = 46;
        pairs.put(second, -74);
        second = 101;
        pairs.put(second, -90);
        first = 104;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 121;
        pairs.put(second, 0);
        first = 71;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 105;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 118;
        pairs.put(second, 0);
        first = 65;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 79;
        pairs.put(second, -50);
        second = 146;
        pairs.put(second, -74);
        second = 119;
        pairs.put(second, -74);
        second = 87;
        pairs.put(second, -100);
        second = 67;
        pairs.put(second, -65);
        second = 112;
        pairs.put(second, 0);
        second = 81;
        pairs.put(second, -55);
        second = 71;
        pairs.put(second, -60);
        second = 86;
        pairs.put(second, -95);
        second = 118;
        pairs.put(second, -74);
        second = 148;
        pairs.put(second, 0);
        second = 85;
        pairs.put(second, -50);
        second = 117;
        pairs.put(second, -30);
        second = 89;
        pairs.put(second, -70);
        second = 121;
        pairs.put(second, -74);
        second = 84;
        pairs.put(second, -55);
        first = 147;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, 0);
        second = 145;
        pairs.put(second, 0);
        first = 78;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -30);
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 115;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, 0);
        first = 111;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, -25);
        second = 121;
        pairs.put(second, -10);
        second = 103;
        pairs.put(second, 0);
        second = 120;
        pairs.put(second, -10);
        second = 118;
        pairs.put(second, -15);
        first = 114;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, 0);
        second = 100;
        pairs.put(second, 0);
        second = 107;
        pairs.put(second, 0);
        second = 114;
        pairs.put(second, 0);
        second = 99;
        pairs.put(second, 0);
        second = 112;
        pairs.put(second, 0);
        second = 103;
        pairs.put(second, 0);
        second = 108;
        pairs.put(second, 0);
        second = 113;
        pairs.put(second, 0);
        second = 118;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -65);
        second = 45;
        pairs.put(second, 0);
        second = 105;
        pairs.put(second, 0);
        second = 109;
        pairs.put(second, 0);
        second = 97;
        pairs.put(second, 0);
        second = 117;
        pairs.put(second, 0);
        second = 116;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, -65);
        second = 110;
        pairs.put(second, 0);
        second = 115;
        pairs.put(second, 0);
        second = 101;
        pairs.put(second, 0);
        first = 108;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        first = 76;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, 0);
        second = 146;
        pairs.put(second, -55);
        second = 87;
        pairs.put(second, -37);
        second = 89;
        pairs.put(second, -37);
        second = 121;
        pairs.put(second, -37);
        second = 84;
        pairs.put(second, -18);
        second = 86;
        pairs.put(second, -37);
        first = 148;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 32;
        pairs.put(second, 0);
        first = 109;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 117;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        first = 89;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -111);
        second = 45;
        pairs.put(second, -92);
        second = 105;
        pairs.put(second, -55);
        second = 79;
        pairs.put(second, -25);
        second = 58;
        pairs.put(second, -92);
        second = 97;
        pairs.put(second, -92);
        second = 65;
        pairs.put(second, -74);
        second = 117;
        pairs.put(second, -92);
        second = 46;
        pairs.put(second, -74);
        second = 101;
        pairs.put(second, -111);
        second = 59;
        pairs.put(second, -92);
        second = 44;
        pairs.put(second, -92);
        first = 74;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -40);
        second = 97;
        pairs.put(second, -40);
        second = 65;
        pairs.put(second, -25);
        second = 117;
        pairs.put(second, -40);
        second = 46;
        pairs.put(second, -10);
        second = 101;
        pairs.put(second, -40);
        second = 44;
        pairs.put(second, -10);
        first = 46;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, -95);
        second = 146;
        pairs.put(second, -95);
        first = 110;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 117;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        second = 118;
        pairs.put(second, -40);
    }
}

