/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class CourierBold
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Courier-Bold";
    private static final String fullName = "Courier Bold";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 562;
    private static final int xHeight = 439;
    private static final int ascender = 626;
    private static final int descender = -142;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private boolean enableKerning;

    public CourierBold() {
        this(false);
    }

    public CourierBold(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    @Override
    public String getEncodingName() {
        return encoding;
    }

    @Override
    public URI getFontURI() {
        return fontFileURI;
    }

    @Override
    public String getFontName() {
        return fontName;
    }

    @Override
    public String getEmbedFontName() {
        return this.getFontName();
    }

    @Override
    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    @Override
    public FontType getFontType() {
        return FontType.TYPE1;
    }

    @Override
    public int getAscender(int size) {
        return size * 626;
    }

    @Override
    public int getCapHeight(int size) {
        return size * 562;
    }

    @Override
    public int getDescender(int size) {
        return size * -142;
    }

    @Override
    public int getXHeight(int size) {
        return size * 439;
    }

    @Override
    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    @Override
    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    @Override
    public int getWidth(int i, int size) {
        return size * width[i];
    }

    @Override
    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    @Override
    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    @Override
    public boolean hasKerningInfo() {
        return false;
    }

    public Map getKerningInfo() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    @Override
    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + fontName.toLowerCase());
        }
        catch (URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        CourierBold.width[65] = 600;
        CourierBold.boundingBoxes[65] = new Rectangle(-9, 0, 618, 562);
        CourierBold.width[198] = 600;
        CourierBold.boundingBoxes[198] = new Rectangle(-29, 0, 631, 562);
        CourierBold.width[193] = 600;
        CourierBold.boundingBoxes[193] = new Rectangle(-9, 0, 618, 784);
        CourierBold.width[194] = 600;
        CourierBold.boundingBoxes[194] = new Rectangle(-9, 0, 618, 780);
        CourierBold.width[196] = 600;
        CourierBold.boundingBoxes[196] = new Rectangle(-9, 0, 618, 761);
        CourierBold.width[192] = 600;
        CourierBold.boundingBoxes[192] = new Rectangle(-9, 0, 618, 784);
        CourierBold.width[197] = 600;
        CourierBold.boundingBoxes[197] = new Rectangle(-9, 0, 618, 801);
        CourierBold.width[195] = 600;
        CourierBold.boundingBoxes[195] = new Rectangle(-9, 0, 618, 759);
        CourierBold.width[66] = 600;
        CourierBold.boundingBoxes[66] = new Rectangle(30, 0, 543, 562);
        CourierBold.width[67] = 600;
        CourierBold.boundingBoxes[67] = new Rectangle(22, -18, 538, 598);
        CourierBold.width[199] = 600;
        CourierBold.boundingBoxes[199] = new Rectangle(22, -206, 538, 786);
        CourierBold.width[68] = 600;
        CourierBold.boundingBoxes[68] = new Rectangle(30, 0, 564, 562);
        CourierBold.width[69] = 600;
        CourierBold.boundingBoxes[69] = new Rectangle(25, 0, 535, 562);
        CourierBold.width[201] = 600;
        CourierBold.boundingBoxes[201] = new Rectangle(25, 0, 535, 784);
        CourierBold.width[202] = 600;
        CourierBold.boundingBoxes[202] = new Rectangle(25, 0, 535, 780);
        CourierBold.width[203] = 600;
        CourierBold.boundingBoxes[203] = new Rectangle(25, 0, 535, 761);
        CourierBold.width[200] = 600;
        CourierBold.boundingBoxes[200] = new Rectangle(25, 0, 535, 784);
        CourierBold.width[208] = 600;
        CourierBold.boundingBoxes[208] = new Rectangle(30, 0, 564, 562);
        CourierBold.width[128] = 600;
        CourierBold.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        CourierBold.width[70] = 600;
        CourierBold.boundingBoxes[70] = new Rectangle(39, 0, 531, 562);
        CourierBold.width[71] = 600;
        CourierBold.boundingBoxes[71] = new Rectangle(22, -18, 572, 598);
        CourierBold.width[72] = 600;
        CourierBold.boundingBoxes[72] = new Rectangle(20, 0, 560, 562);
        CourierBold.width[73] = 600;
        CourierBold.boundingBoxes[73] = new Rectangle(77, 0, 446, 562);
        CourierBold.width[205] = 600;
        CourierBold.boundingBoxes[205] = new Rectangle(77, 0, 446, 784);
        CourierBold.width[206] = 600;
        CourierBold.boundingBoxes[206] = new Rectangle(77, 0, 446, 780);
        CourierBold.width[207] = 600;
        CourierBold.boundingBoxes[207] = new Rectangle(77, 0, 446, 761);
        CourierBold.width[204] = 600;
        CourierBold.boundingBoxes[204] = new Rectangle(77, 0, 446, 784);
        CourierBold.width[74] = 600;
        CourierBold.boundingBoxes[74] = new Rectangle(37, -18, 564, 580);
        CourierBold.width[75] = 600;
        CourierBold.boundingBoxes[75] = new Rectangle(21, 0, 578, 562);
        CourierBold.width[76] = 600;
        CourierBold.boundingBoxes[76] = new Rectangle(39, 0, 539, 562);
        CourierBold.width[77] = 600;
        CourierBold.boundingBoxes[77] = new Rectangle(-2, 0, 604, 562);
        CourierBold.width[78] = 600;
        CourierBold.boundingBoxes[78] = new Rectangle(8, -12, 602, 574);
        CourierBold.width[209] = 600;
        CourierBold.boundingBoxes[209] = new Rectangle(8, -12, 602, 771);
        CourierBold.width[79] = 600;
        CourierBold.boundingBoxes[79] = new Rectangle(22, -18, 556, 598);
        CourierBold.width[140] = 600;
        CourierBold.boundingBoxes[140] = new Rectangle(-25, 0, 620, 562);
        CourierBold.width[211] = 600;
        CourierBold.boundingBoxes[211] = new Rectangle(22, -18, 556, 802);
        CourierBold.width[212] = 600;
        CourierBold.boundingBoxes[212] = new Rectangle(22, -18, 556, 798);
        CourierBold.width[214] = 600;
        CourierBold.boundingBoxes[214] = new Rectangle(22, -18, 556, 779);
        CourierBold.width[210] = 600;
        CourierBold.boundingBoxes[210] = new Rectangle(22, -18, 556, 802);
        CourierBold.width[216] = 600;
        CourierBold.boundingBoxes[216] = new Rectangle(22, -22, 556, 606);
        CourierBold.width[213] = 600;
        CourierBold.boundingBoxes[213] = new Rectangle(22, -18, 556, 777);
        CourierBold.width[80] = 600;
        CourierBold.boundingBoxes[80] = new Rectangle(48, 0, 511, 562);
        CourierBold.width[81] = 600;
        CourierBold.boundingBoxes[81] = new Rectangle(32, -138, 546, 718);
        CourierBold.width[82] = 600;
        CourierBold.boundingBoxes[82] = new Rectangle(24, 0, 575, 562);
        CourierBold.width[83] = 600;
        CourierBold.boundingBoxes[83] = new Rectangle(47, -22, 506, 604);
        CourierBold.width[138] = 600;
        CourierBold.boundingBoxes[138] = new Rectangle(47, -22, 506, 812);
        CourierBold.width[84] = 600;
        CourierBold.boundingBoxes[84] = new Rectangle(21, 0, 558, 562);
        CourierBold.width[222] = 600;
        CourierBold.boundingBoxes[222] = new Rectangle(48, 0, 509, 562);
        CourierBold.width[85] = 600;
        CourierBold.boundingBoxes[85] = new Rectangle(4, -18, 592, 580);
        CourierBold.width[218] = 600;
        CourierBold.boundingBoxes[218] = new Rectangle(4, -18, 592, 802);
        CourierBold.width[219] = 600;
        CourierBold.boundingBoxes[219] = new Rectangle(4, -18, 592, 798);
        CourierBold.width[220] = 600;
        CourierBold.boundingBoxes[220] = new Rectangle(4, -18, 592, 779);
        CourierBold.width[217] = 600;
        CourierBold.boundingBoxes[217] = new Rectangle(4, -18, 592, 802);
        CourierBold.width[86] = 600;
        CourierBold.boundingBoxes[86] = new Rectangle(-13, 0, 626, 562);
        CourierBold.width[87] = 600;
        CourierBold.boundingBoxes[87] = new Rectangle(-18, 0, 636, 562);
        CourierBold.width[88] = 600;
        CourierBold.boundingBoxes[88] = new Rectangle(12, 0, 576, 562);
        CourierBold.width[89] = 600;
        CourierBold.boundingBoxes[89] = new Rectangle(12, 0, 577, 562);
        CourierBold.width[221] = 600;
        CourierBold.boundingBoxes[221] = new Rectangle(12, 0, 577, 784);
        CourierBold.width[159] = 600;
        CourierBold.boundingBoxes[159] = new Rectangle(12, 0, 577, 761);
        CourierBold.width[90] = 600;
        CourierBold.boundingBoxes[90] = new Rectangle(62, 0, 477, 562);
        CourierBold.width[142] = 600;
        CourierBold.boundingBoxes[142] = new Rectangle(62, 0, 477, 790);
        CourierBold.width[97] = 600;
        CourierBold.boundingBoxes[97] = new Rectangle(35, -15, 535, 469);
        CourierBold.width[225] = 600;
        CourierBold.boundingBoxes[225] = new Rectangle(35, -15, 535, 676);
        CourierBold.width[226] = 600;
        CourierBold.boundingBoxes[226] = new Rectangle(35, -15, 535, 672);
        CourierBold.width[180] = 600;
        CourierBold.boundingBoxes[180] = new Rectangle(205, 508, 263, 153);
        CourierBold.width[228] = 600;
        CourierBold.boundingBoxes[228] = new Rectangle(35, -15, 535, 653);
        CourierBold.width[230] = 600;
        CourierBold.boundingBoxes[230] = new Rectangle(-4, -15, 605, 469);
        CourierBold.width[224] = 600;
        CourierBold.boundingBoxes[224] = new Rectangle(35, -15, 535, 676);
        CourierBold.width[38] = 600;
        CourierBold.boundingBoxes[38] = new Rectangle(36, -15, 510, 558);
        CourierBold.width[229] = 600;
        CourierBold.boundingBoxes[229] = new Rectangle(35, -15, 535, 693);
        CourierBold.width[94] = 600;
        CourierBold.boundingBoxes[94] = new Rectangle(108, 250, 384, 366);
        CourierBold.width[126] = 600;
        CourierBold.boundingBoxes[126] = new Rectangle(71, 153, 459, 203);
        CourierBold.width[42] = 600;
        CourierBold.boundingBoxes[42] = new Rectangle(91, 219, 418, 382);
        CourierBold.width[64] = 600;
        CourierBold.boundingBoxes[64] = new Rectangle(16, -15, 568, 631);
        CourierBold.width[227] = 600;
        CourierBold.boundingBoxes[227] = new Rectangle(35, -15, 535, 651);
        CourierBold.width[98] = 600;
        CourierBold.boundingBoxes[98] = new Rectangle(0, -15, 584, 641);
        CourierBold.width[92] = 600;
        CourierBold.boundingBoxes[92] = new Rectangle(99, -77, 404, 703);
        CourierBold.width[124] = 600;
        CourierBold.boundingBoxes[124] = new Rectangle(255, -250, 90, 1000);
        CourierBold.width[123] = 600;
        CourierBold.boundingBoxes[123] = new Rectangle(160, -102, 304, 718);
        CourierBold.width[125] = 600;
        CourierBold.boundingBoxes[125] = new Rectangle(136, -102, 304, 718);
        CourierBold.width[91] = 600;
        CourierBold.boundingBoxes[91] = new Rectangle(245, -102, 230, 718);
        CourierBold.width[93] = 600;
        CourierBold.boundingBoxes[93] = new Rectangle(125, -102, 230, 718);
        CourierBold.width[166] = 600;
        CourierBold.boundingBoxes[166] = new Rectangle(255, -175, 90, 850);
        CourierBold.width[149] = 600;
        CourierBold.boundingBoxes[149] = new Rectangle(140, 132, 320, 298);
        CourierBold.width[99] = 600;
        CourierBold.boundingBoxes[99] = new Rectangle(40, -15, 505, 474);
        CourierBold.width[231] = 600;
        CourierBold.boundingBoxes[231] = new Rectangle(40, -206, 505, 665);
        CourierBold.width[184] = 600;
        CourierBold.boundingBoxes[184] = new Rectangle(205, -206, 182, 206);
        CourierBold.width[162] = 600;
        CourierBold.boundingBoxes[162] = new Rectangle(66, -49, 452, 663);
        CourierBold.width[136] = 600;
        CourierBold.boundingBoxes[136] = new Rectangle(103, 483, 394, 174);
        CourierBold.width[58] = 600;
        CourierBold.boundingBoxes[58] = new Rectangle(191, -15, 216, 440);
        CourierBold.width[44] = 600;
        CourierBold.boundingBoxes[44] = new Rectangle(123, -111, 270, 285);
        CourierBold.width[169] = 600;
        CourierBold.boundingBoxes[169] = new Rectangle(0, -18, 600, 598);
        CourierBold.width[164] = 600;
        CourierBold.boundingBoxes[164] = new Rectangle(54, 49, 492, 468);
        CourierBold.width[100] = 600;
        CourierBold.boundingBoxes[100] = new Rectangle(20, -15, 571, 641);
        CourierBold.width[134] = 600;
        CourierBold.boundingBoxes[134] = new Rectangle(106, -70, 388, 650);
        CourierBold.width[135] = 600;
        CourierBold.boundingBoxes[135] = new Rectangle(106, -70, 388, 650);
        CourierBold.width[176] = 600;
        CourierBold.boundingBoxes[176] = new Rectangle(86, 243, 388, 373);
        CourierBold.width[168] = 600;
        CourierBold.boundingBoxes[168] = new Rectangle(128, 498, 344, 140);
        CourierBold.width[247] = 600;
        CourierBold.boundingBoxes[247] = new Rectangle(71, 16, 458, 484);
        CourierBold.width[36] = 600;
        CourierBold.boundingBoxes[36] = new Rectangle(82, -126, 437, 792);
        CourierBold.width[101] = 600;
        CourierBold.boundingBoxes[101] = new Rectangle(40, -15, 523, 469);
        CourierBold.width[233] = 600;
        CourierBold.boundingBoxes[233] = new Rectangle(40, -15, 523, 676);
        CourierBold.width[234] = 600;
        CourierBold.boundingBoxes[234] = new Rectangle(40, -15, 523, 672);
        CourierBold.width[235] = 600;
        CourierBold.boundingBoxes[235] = new Rectangle(40, -15, 523, 653);
        CourierBold.width[232] = 600;
        CourierBold.boundingBoxes[232] = new Rectangle(40, -15, 523, 676);
        CourierBold.width[56] = 600;
        CourierBold.boundingBoxes[56] = new Rectangle(83, -15, 434, 631);
        CourierBold.width[133] = 600;
        CourierBold.boundingBoxes[133] = new Rectangle(26, -15, 548, 131);
        CourierBold.width[151] = 600;
        CourierBold.boundingBoxes[151] = new Rectangle(-10, 203, 620, 110);
        CourierBold.width[150] = 600;
        CourierBold.boundingBoxes[150] = new Rectangle(65, 203, 470, 110);
        CourierBold.width[61] = 600;
        CourierBold.boundingBoxes[61] = new Rectangle(71, 118, 458, 280);
        CourierBold.width[240] = 600;
        CourierBold.boundingBoxes[240] = new Rectangle(58, -27, 485, 653);
        CourierBold.width[33] = 600;
        CourierBold.boundingBoxes[33] = new Rectangle(202, -15, 196, 587);
        CourierBold.width[161] = 600;
        CourierBold.boundingBoxes[161] = new Rectangle(202, -146, 196, 595);
        CourierBold.width[102] = 600;
        CourierBold.boundingBoxes[102] = new Rectangle(83, 0, 464, 626);
        CourierBold.width[53] = 600;
        CourierBold.boundingBoxes[53] = new Rectangle(70, -15, 451, 616);
        CourierBold.width[131] = 600;
        CourierBold.boundingBoxes[131] = new Rectangle(-30, -131, 602, 747);
        CourierBold.width[52] = 600;
        CourierBold.boundingBoxes[52] = new Rectangle(53, 0, 454, 616);
        CourierBold.width[103] = 600;
        CourierBold.boundingBoxes[103] = new Rectangle(30, -146, 550, 600);
        CourierBold.width[223] = 600;
        CourierBold.boundingBoxes[223] = new Rectangle(22, -15, 574, 641);
        CourierBold.width[96] = 600;
        CourierBold.boundingBoxes[96] = new Rectangle(132, 508, 263, 153);
        CourierBold.width[62] = 600;
        CourierBold.boundingBoxes[62] = new Rectangle(77, 15, 457, 486);
        CourierBold.width[171] = 600;
        CourierBold.boundingBoxes[171] = new Rectangle(8, 70, 545, 376);
        CourierBold.width[187] = 600;
        CourierBold.boundingBoxes[187] = new Rectangle(47, 70, 545, 376);
        CourierBold.width[139] = 600;
        CourierBold.boundingBoxes[139] = new Rectangle(141, 70, 318, 376);
        CourierBold.width[155] = 600;
        CourierBold.boundingBoxes[155] = new Rectangle(141, 70, 318, 376);
        CourierBold.width[104] = 600;
        CourierBold.boundingBoxes[104] = new Rectangle(5, 0, 587, 626);
        CourierBold.width[45] = 600;
        CourierBold.boundingBoxes[45] = new Rectangle(100, 203, 400, 110);
        CourierBold.width[105] = 600;
        CourierBold.boundingBoxes[105] = new Rectangle(77, 0, 446, 658);
        CourierBold.width[237] = 600;
        CourierBold.boundingBoxes[237] = new Rectangle(77, 0, 446, 661);
        CourierBold.width[238] = 600;
        CourierBold.boundingBoxes[238] = new Rectangle(73, 0, 450, 657);
        CourierBold.width[239] = 600;
        CourierBold.boundingBoxes[239] = new Rectangle(77, 0, 446, 618);
        CourierBold.width[236] = 600;
        CourierBold.boundingBoxes[236] = new Rectangle(77, 0, 446, 661);
        CourierBold.width[106] = 600;
        CourierBold.boundingBoxes[106] = new Rectangle(63, -146, 377, 804);
        CourierBold.width[107] = 600;
        CourierBold.boundingBoxes[107] = new Rectangle(20, 0, 565, 626);
        CourierBold.width[108] = 600;
        CourierBold.boundingBoxes[108] = new Rectangle(77, 0, 446, 626);
        CourierBold.width[60] = 600;
        CourierBold.boundingBoxes[60] = new Rectangle(66, 15, 457, 486);
        CourierBold.width[172] = 600;
        CourierBold.boundingBoxes[172] = new Rectangle(71, 103, 458, 310);
        CourierBold.width[109] = 600;
        CourierBold.boundingBoxes[109] = new Rectangle(-22, 0, 648, 454);
        CourierBold.width[175] = 600;
        CourierBold.boundingBoxes[175] = new Rectangle(88, 505, 424, 80);
        CourierBold.width[181] = 600;
        CourierBold.boundingBoxes[181] = new Rectangle(-1, -142, 570, 581);
        CourierBold.width[215] = 600;
        CourierBold.boundingBoxes[215] = new Rectangle(81, 39, 439, 439);
        CourierBold.width[110] = 600;
        CourierBold.boundingBoxes[110] = new Rectangle(18, 0, 574, 454);
        CourierBold.width[57] = 600;
        CourierBold.boundingBoxes[57] = new Rectangle(79, -15, 431, 631);
        CourierBold.width[241] = 600;
        CourierBold.boundingBoxes[241] = new Rectangle(18, 0, 574, 636);
        CourierBold.width[35] = 600;
        CourierBold.boundingBoxes[35] = new Rectangle(56, -45, 488, 696);
        CourierBold.width[111] = 600;
        CourierBold.boundingBoxes[111] = new Rectangle(30, -15, 540, 469);
        CourierBold.width[243] = 600;
        CourierBold.boundingBoxes[243] = new Rectangle(30, -15, 540, 676);
        CourierBold.width[244] = 600;
        CourierBold.boundingBoxes[244] = new Rectangle(30, -15, 540, 672);
        CourierBold.width[246] = 600;
        CourierBold.boundingBoxes[246] = new Rectangle(30, -15, 540, 653);
        CourierBold.width[156] = 600;
        CourierBold.boundingBoxes[156] = new Rectangle(-18, -15, 629, 469);
        CourierBold.width[242] = 600;
        CourierBold.boundingBoxes[242] = new Rectangle(30, -15, 540, 676);
        CourierBold.width[49] = 600;
        CourierBold.boundingBoxes[49] = new Rectangle(81, 0, 458, 616);
        CourierBold.width[189] = 600;
        CourierBold.boundingBoxes[189] = new Rectangle(-47, -60, 695, 721);
        CourierBold.width[188] = 600;
        CourierBold.boundingBoxes[188] = new Rectangle(-56, -60, 712, 721);
        CourierBold.width[185] = 600;
        CourierBold.boundingBoxes[185] = new Rectangle(153, 230, 294, 386);
        CourierBold.width[170] = 600;
        CourierBold.boundingBoxes[170] = new Rectangle(147, 196, 306, 384);
        CourierBold.width[186] = 600;
        CourierBold.boundingBoxes[186] = new Rectangle(147, 196, 306, 384);
        CourierBold.width[248] = 600;
        CourierBold.boundingBoxes[248] = new Rectangle(30, -24, 540, 487);
        CourierBold.width[245] = 600;
        CourierBold.boundingBoxes[245] = new Rectangle(30, -15, 540, 651);
        CourierBold.width[112] = 600;
        CourierBold.boundingBoxes[112] = new Rectangle(-1, -142, 571, 596);
        CourierBold.width[182] = 600;
        CourierBold.boundingBoxes[182] = new Rectangle(6, -70, 570, 650);
        CourierBold.width[40] = 600;
        CourierBold.boundingBoxes[40] = new Rectangle(219, -102, 242, 718);
        CourierBold.width[41] = 600;
        CourierBold.boundingBoxes[41] = new Rectangle(139, -102, 242, 718);
        CourierBold.width[37] = 600;
        CourierBold.boundingBoxes[37] = new Rectangle(5, -15, 590, 631);
        CourierBold.width[46] = 600;
        CourierBold.boundingBoxes[46] = new Rectangle(192, -15, 216, 186);
        CourierBold.width[183] = 600;
        CourierBold.boundingBoxes[183] = new Rectangle(196, 165, 208, 186);
        CourierBold.width[137] = 600;
        CourierBold.boundingBoxes[137] = new Rectangle(-113, -15, 826, 631);
        CourierBold.width[43] = 600;
        CourierBold.boundingBoxes[43] = new Rectangle(71, 39, 458, 439);
        CourierBold.width[177] = 600;
        CourierBold.boundingBoxes[177] = new Rectangle(71, 24, 458, 491);
        CourierBold.width[113] = 600;
        CourierBold.boundingBoxes[113] = new Rectangle(20, -142, 571, 596);
        CourierBold.width[63] = 600;
        CourierBold.boundingBoxes[63] = new Rectangle(98, -14, 403, 594);
        CourierBold.width[191] = 600;
        CourierBold.boundingBoxes[191] = new Rectangle(99, -146, 403, 595);
        CourierBold.width[34] = 600;
        CourierBold.boundingBoxes[34] = new Rectangle(135, 277, 330, 285);
        CourierBold.width[132] = 600;
        CourierBold.boundingBoxes[132] = new Rectangle(65, -142, 464, 285);
        CourierBold.width[147] = 600;
        CourierBold.boundingBoxes[147] = new Rectangle(71, 277, 464, 285);
        CourierBold.width[148] = 600;
        CourierBold.boundingBoxes[148] = new Rectangle(61, 277, 464, 285);
        CourierBold.width[145] = 600;
        CourierBold.boundingBoxes[145] = new Rectangle(178, 277, 250, 285);
        CourierBold.width[146] = 600;
        CourierBold.boundingBoxes[146] = new Rectangle(171, 277, 252, 285);
        CourierBold.width[130] = 600;
        CourierBold.boundingBoxes[130] = new Rectangle(175, -142, 252, 285);
        CourierBold.width[39] = 600;
        CourierBold.boundingBoxes[39] = new Rectangle(227, 277, 146, 285);
        CourierBold.width[114] = 600;
        CourierBold.boundingBoxes[114] = new Rectangle(47, 0, 533, 454);
        CourierBold.width[174] = 600;
        CourierBold.boundingBoxes[174] = new Rectangle(0, -18, 600, 598);
        CourierBold.width[115] = 600;
        CourierBold.boundingBoxes[115] = new Rectangle(68, -17, 467, 476);
        CourierBold.width[154] = 600;
        CourierBold.boundingBoxes[154] = new Rectangle(68, -17, 467, 684);
        CourierBold.width[167] = 600;
        CourierBold.boundingBoxes[167] = new Rectangle(83, -70, 434, 650);
        CourierBold.width[59] = 600;
        CourierBold.boundingBoxes[59] = new Rectangle(123, -111, 285, 536);
        CourierBold.width[55] = 600;
        CourierBold.boundingBoxes[55] = new Rectangle(55, 0, 439, 601);
        CourierBold.width[54] = 600;
        CourierBold.boundingBoxes[54] = new Rectangle(90, -15, 431, 631);
        CourierBold.width[47] = 600;
        CourierBold.boundingBoxes[47] = new Rectangle(98, -77, 404, 703);
        CourierBold.width[32] = 600;
        CourierBold.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        CourierBold.width[163] = 600;
        CourierBold.boundingBoxes[163] = new Rectangle(72, -28, 486, 639);
        CourierBold.width[116] = 600;
        CourierBold.boundingBoxes[116] = new Rectangle(47, -15, 485, 577);
        CourierBold.width[254] = 600;
        CourierBold.boundingBoxes[254] = new Rectangle(-14, -142, 584, 768);
        CourierBold.width[51] = 600;
        CourierBold.boundingBoxes[51] = new Rectangle(63, -15, 438, 631);
        CourierBold.width[190] = 600;
        CourierBold.boundingBoxes[190] = new Rectangle(-47, -60, 695, 721);
        CourierBold.width[179] = 600;
        CourierBold.boundingBoxes[179] = new Rectangle(138, 222, 295, 394);
        CourierBold.width[152] = 600;
        CourierBold.boundingBoxes[152] = new Rectangle(89, 493, 423, 143);
        CourierBold.width[153] = 600;
        CourierBold.boundingBoxes[153] = new Rectangle(-9, 230, 758, 332);
        CourierBold.width[50] = 600;
        CourierBold.boundingBoxes[50] = new Rectangle(61, 0, 438, 616);
        CourierBold.width[178] = 600;
        CourierBold.boundingBoxes[178] = new Rectangle(143, 230, 293, 386);
        CourierBold.width[117] = 600;
        CourierBold.boundingBoxes[117] = new Rectangle(-1, -15, 570, 454);
        CourierBold.width[250] = 600;
        CourierBold.boundingBoxes[250] = new Rectangle(-1, -15, 570, 676);
        CourierBold.width[251] = 600;
        CourierBold.boundingBoxes[251] = new Rectangle(-1, -15, 570, 672);
        CourierBold.width[252] = 600;
        CourierBold.boundingBoxes[252] = new Rectangle(-1, -15, 570, 653);
        CourierBold.width[249] = 600;
        CourierBold.boundingBoxes[249] = new Rectangle(-1, -15, 570, 676);
        CourierBold.width[95] = 600;
        CourierBold.boundingBoxes[95] = new Rectangle(0, -125, 600, 50);
        CourierBold.width[118] = 600;
        CourierBold.boundingBoxes[118] = new Rectangle(-1, 0, 602, 439);
        CourierBold.width[119] = 600;
        CourierBold.boundingBoxes[119] = new Rectangle(-18, 0, 636, 439);
        CourierBold.width[120] = 600;
        CourierBold.boundingBoxes[120] = new Rectangle(6, 0, 588, 439);
        CourierBold.width[121] = 600;
        CourierBold.boundingBoxes[121] = new Rectangle(-4, -142, 605, 581);
        CourierBold.width[253] = 600;
        CourierBold.boundingBoxes[253] = new Rectangle(-4, -142, 605, 803);
        CourierBold.width[255] = 600;
        CourierBold.boundingBoxes[255] = new Rectangle(-4, -142, 605, 780);
        CourierBold.width[165] = 600;
        CourierBold.boundingBoxes[165] = new Rectangle(10, 0, 580, 562);
        CourierBold.width[122] = 600;
        CourierBold.boundingBoxes[122] = new Rectangle(81, 0, 439, 439);
        CourierBold.width[158] = 600;
        CourierBold.boundingBoxes[158] = new Rectangle(81, 0, 439, 667);
        CourierBold.width[48] = 600;
        CourierBold.boundingBoxes[48] = new Rectangle(87, -15, 426, 631);
        familyNames = new HashSet();
        familyNames.add("Courier");
    }
}

