/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DefaultConfigurationBuilder {
    private static final Log LOG = LogFactory.getLog(DefaultConfigurationBuilder.class.getName());

    public DefaultConfiguration build(InputStream confStream) throws ConfigurationException {
        try {
            DocumentBuilder builder = DefaultConfiguration.DBF.newDocumentBuilder();
            Document document = builder.parse(confStream);
            DefaultConfiguration defaultConfiguration = new DefaultConfiguration(document.getDocumentElement());
            return defaultConfiguration;
        }
        catch (DOMException e2) {
            throw new ConfigurationException("xml parse error", e2);
        }
        catch (ParserConfigurationException e3) {
            throw new ConfigurationException("xml parse error", e3);
        }
        catch (IOException e4) {
            throw new ConfigurationException("xml parse error", e4);
        }
        catch (SAXException e5) {
            throw new ConfigurationException("xml parse error", e5);
        }
        finally {
            try {
                confStream.close();
            }
            catch (IOException e6) {
                throw new IllegalStateException(e6);
            }
        }
    }

    public DefaultConfiguration buildFromFile(File file) throws ConfigurationException {
        try {
            DocumentBuilder builder = DefaultConfiguration.DBF.newDocumentBuilder();
            Document document = builder.parse(file);
            return new DefaultConfiguration(document.getDocumentElement());
        }
        catch (DOMException e2) {
            throw new ConfigurationException("xml parse error", e2);
        }
        catch (ParserConfigurationException e3) {
            throw new ConfigurationException("xml parse error", e3);
        }
        catch (IOException e4) {
            throw new ConfigurationException("xml parse error", e4);
        }
        catch (SAXException e5) {
            throw new ConfigurationException("xml parse error", e5);
        }
    }
}

