/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.util;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fop.complexscripts.util.CharAssociation;

public class GlyphSequence
implements Cloneable {
    private static final int DEFAULT_CHARS_CAPACITY = 8;
    private IntBuffer characters;
    private IntBuffer glyphs;
    private List associations;
    private boolean predications;
    protected GlyphSequence unprocessedGS;

    public GlyphSequence(IntBuffer characters, IntBuffer glyphs, List associations, boolean predications) {
        if (characters == null) {
            characters = IntBuffer.allocate(8);
        }
        if (glyphs == null) {
            glyphs = IntBuffer.allocate(characters.capacity());
        }
        if (associations == null) {
            associations = GlyphSequence.makeIdentityAssociations(characters.limit(), glyphs.limit());
        }
        this.characters = characters;
        this.glyphs = glyphs;
        this.associations = associations;
        this.predications = predications;
        this.unprocessedGS = this;
    }

    public GlyphSequence(IntBuffer characters, IntBuffer glyphs, List associations) {
        this(characters, glyphs, associations, false);
    }

    public GlyphSequence(GlyphSequence gs) {
        this(gs.characters.duplicate(), GlyphSequence.copyBuffer(gs.glyphs), GlyphSequence.copyAssociations(gs.associations), gs.predications);
        this.unprocessedGS = gs.unprocessedGS;
    }

    public GlyphSequence(GlyphSequence gs, int[] bga, int[] iga, int[] lga, CharAssociation[] bal, CharAssociation[] ial, CharAssociation[] lal) {
        this(gs.characters.duplicate(), GlyphSequence.concatGlyphs(bga, iga, lga), GlyphSequence.concatAssociations(bal, ial, lal), gs.predications);
    }

    public IntBuffer getCharacters() {
        return this.characters;
    }

    public int[] getCharacterArray(boolean copy) {
        if (copy) {
            return GlyphSequence.toArray(this.characters);
        }
        return this.characters.array();
    }

    public int getCharacterCount() {
        return this.characters.limit();
    }

    public int getUTF16CharacterCount() {
        int count = 0;
        for (int ch : this.characters.array()) {
            count += Character.charCount(ch);
        }
        return count;
    }

    public int getGlyph(int index) throws IndexOutOfBoundsException {
        return this.glyphs.get(index);
    }

    public int getUnprocessedGlyph(int index) throws IndexOutOfBoundsException {
        return this.unprocessedGS.getGlyph(index);
    }

    public void setUnprocessedGS(GlyphSequence glyphSequence) {
        this.unprocessedGS = glyphSequence;
    }

    public void setGlyph(int index, int gi) throws IndexOutOfBoundsException {
        if (gi > 65535) {
            gi = 65535;
        }
        this.glyphs.put(index, gi);
    }

    public IntBuffer getGlyphs() {
        return this.glyphs;
    }

    public int[] getGlyphs(int offset, int count) {
        int ng = this.getGlyphCount();
        if (offset < 0) {
            offset = 0;
        } else if (offset > ng) {
            offset = ng;
        }
        if (count < 0) {
            count = ng - offset;
        }
        int[] ga = new int[count];
        int n = offset + count;
        int k = 0;
        for (int i = offset; i < n; ++i) {
            if (k >= ga.length) continue;
            ga[k++] = this.glyphs.get(i);
        }
        return ga;
    }

    public int[] getGlyphArray(boolean copy) {
        if (copy) {
            return GlyphSequence.toArray(this.glyphs);
        }
        return this.glyphs.array();
    }

    public int getGlyphCount() {
        return this.glyphs.limit();
    }

    public CharAssociation getAssociation(int index) throws IndexOutOfBoundsException {
        return (CharAssociation)this.associations.get(index);
    }

    public List getAssociations() {
        return this.associations;
    }

    public CharAssociation[] getAssociations(int offset, int count) {
        int ng = this.getGlyphCount();
        if (offset < 0) {
            offset = 0;
        } else if (offset > ng) {
            offset = ng;
        }
        if (count < 0) {
            count = ng - offset;
        }
        CharAssociation[] aa = new CharAssociation[count];
        int n = offset + count;
        int k = 0;
        for (int i = offset; i < n; ++i) {
            if (k >= aa.length) continue;
            aa[k++] = (CharAssociation)this.associations.get(i);
        }
        return aa;
    }

    public void setPredications(boolean enable) {
        this.predications = enable;
    }

    public boolean getPredications() {
        return this.predications;
    }

    public void setPredication(int offset, String key, Object value) {
        if (this.predications) {
            CharAssociation[] aa = this.getAssociations(offset, 1);
            CharAssociation ca = aa[0];
            ca.setPredication(key, value);
        }
    }

    public Object getPredication(int offset, String key) {
        if (this.predications) {
            CharAssociation[] aa = this.getAssociations(offset, 1);
            CharAssociation ca = aa[0];
            return ca.getPredication(key);
        }
        return null;
    }

    public int compareGlyphs(IntBuffer gb) {
        int ng = this.getGlyphCount();
        int n = gb.limit();
        for (int i = 0; i < n; ++i) {
            if (i < ng) {
                int g2;
                int g1 = this.glyphs.get(i);
                if (g1 > (g2 = gb.get(i))) {
                    return 1;
                }
                if (g1 >= g2) continue;
                return -1;
            }
            return -1;
        }
        return 0;
    }

    public Object clone() {
        try {
            GlyphSequence gs = (GlyphSequence)super.clone();
            gs.characters = GlyphSequence.copyBuffer(this.characters);
            gs.glyphs = GlyphSequence.copyBuffer(this.glyphs);
            gs.associations = GlyphSequence.copyAssociations(this.associations);
            return gs;
        }
        catch (CloneNotSupportedException e2) {
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append("chars = [");
        sb.append(this.characters);
        sb.append("], glyphs = [");
        sb.append(this.glyphs);
        sb.append("], associations = [");
        sb.append(this.associations);
        sb.append("]");
        sb.append('}');
        return sb.toString();
    }

    public static boolean sameGlyphs(int[] ga1, int[] ga2) {
        if (ga1 == ga2) {
            return true;
        }
        if (ga1 == null || ga2 == null) {
            return false;
        }
        if (ga1.length != ga2.length) {
            return false;
        }
        int n = ga1.length;
        for (int i = 0; i < n; ++i) {
            if (ga1[i] == ga2[i]) continue;
            return false;
        }
        return true;
    }

    public static IntBuffer concatGlyphs(int[] bga, int[] iga, int[] lga) {
        int ng = 0;
        if (bga != null) {
            ng += bga.length;
        }
        if (iga != null) {
            ng += iga.length;
        }
        if (lga != null) {
            ng += lga.length;
        }
        IntBuffer gb = IntBuffer.allocate(ng);
        if (bga != null) {
            gb.put(bga);
        }
        if (iga != null) {
            gb.put(iga);
        }
        if (lga != null) {
            gb.put(lga);
        }
        gb.flip();
        return gb;
    }

    public static List concatAssociations(CharAssociation[] baa, CharAssociation[] iaa, CharAssociation[] laa) {
        int na = 0;
        if (baa != null) {
            na += baa.length;
        }
        if (iaa != null) {
            na += iaa.length;
        }
        if (laa != null) {
            na += laa.length;
        }
        if (na > 0) {
            ArrayList gl = new ArrayList(na);
            if (baa != null) {
                Collections.addAll(gl, baa);
            }
            if (iaa != null) {
                Collections.addAll(gl, iaa);
            }
            if (laa != null) {
                Collections.addAll(gl, laa);
            }
            return gl;
        }
        return null;
    }

    public static GlyphSequence join(GlyphSequence gs, GlyphSequence[] sa) {
        assert (sa != null);
        int tg = 0;
        int ta = 0;
        for (GlyphSequence s : sa) {
            IntBuffer ga = s.getGlyphs();
            assert (ga != null);
            int ng = ga.limit();
            List al = s.getAssociations();
            assert (al != null);
            int na = al.size();
            assert (na == ng);
            tg += ng;
            ta += na;
        }
        IntBuffer uga = IntBuffer.allocate(tg);
        ArrayList ual = new ArrayList(ta);
        for (GlyphSequence s : sa) {
            uga.put(s.getGlyphs());
            ual.addAll(s.getAssociations());
        }
        return new GlyphSequence(gs.getCharacters(), uga, ual, gs.getPredications());
    }

    public static GlyphSequence reorder(GlyphSequence gs, int source, int count, int target) {
        if (source != target) {
            int ng = gs.getGlyphCount();
            int[] ga = gs.getGlyphArray(false);
            int[] nga = new int[ng];
            CharAssociation[] aa = gs.getAssociations(0, ng);
            CharAssociation[] naa = new CharAssociation[ng];
            if (source < target) {
                int t = 0;
                int s = 0;
                int e2 = source;
                while (s < e2) {
                    nga[t] = ga[s];
                    naa[t] = aa[s];
                    ++s;
                    ++t;
                }
                s = source + count;
                e2 = target;
                while (s < e2) {
                    nga[t] = ga[s];
                    naa[t] = aa[s];
                    ++s;
                    ++t;
                }
                s = source;
                e2 = source + count;
                while (s < e2) {
                    nga[t] = ga[s];
                    naa[t] = aa[s];
                    ++s;
                    ++t;
                }
                s = target;
                e2 = ng;
                while (s < e2) {
                    nga[t] = ga[s];
                    naa[t] = aa[s];
                    ++s;
                    ++t;
                }
            } else {
                int t = 0;
                int s = 0;
                int e3 = target;
                while (s < e3) {
                    nga[t] = ga[s];
                    naa[t] = aa[s];
                    ++s;
                    ++t;
                }
                s = source;
                e3 = source + count;
                while (s < e3) {
                    nga[t] = ga[s];
                    naa[t] = aa[s];
                    ++s;
                    ++t;
                }
                s = target;
                e3 = source;
                while (s < e3) {
                    nga[t] = ga[s];
                    naa[t] = aa[s];
                    ++s;
                    ++t;
                }
                s = source + count;
                e3 = ng;
                while (s < e3) {
                    nga[t] = ga[s];
                    naa[t] = aa[s];
                    ++s;
                    ++t;
                }
            }
            return new GlyphSequence(gs, null, nga, null, null, naa, null);
        }
        return gs;
    }

    private static int[] toArray(IntBuffer ib) {
        if (ib != null) {
            int n = ib.limit();
            int[] ia = new int[n];
            ib.get(ia, 0, n);
            return ia;
        }
        return new int[0];
    }

    private static List makeIdentityAssociations(int numChars, int numGlyphs) {
        int nc = numChars;
        int ng = numGlyphs;
        ArrayList<CharAssociation> av = new ArrayList<CharAssociation>(ng);
        int n = ng;
        for (int i = 0; i < n; ++i) {
            int k = i > nc ? nc : i;
            av.add(new CharAssociation(i, k == nc ? 0 : 1));
        }
        return av;
    }

    private static IntBuffer copyBuffer(IntBuffer ib) {
        if (ib != null) {
            int[] ia = new int[ib.capacity()];
            int p = ib.position();
            int l = ib.limit();
            System.arraycopy(ib.array(), 0, ia, 0, ia.length);
            return IntBuffer.wrap(ia, p, l - p);
        }
        return null;
    }

    private static List copyAssociations(List ca) {
        if (ca != null) {
            return new ArrayList(ca);
        }
        return ca;
    }
}

