/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.CharacterSetOrientation;
import org.apache.fop.afp.fonts.CharacterSetType;
import org.apache.fop.afp.fonts.FopCharacterSet;
import org.apache.fop.afp.util.AFPResourceAccessor;
import org.apache.fop.afp.util.StructuredFieldReader;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.Typeface;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;

public abstract class CharacterSetBuilder {
    protected static final Log LOG = LogFactory.getLog(CharacterSetBuilder.class);
    private static final CharacterSetOrientation[] EMPTY_CSO_ARRAY = new CharacterSetOrientation[0];
    private static final byte[] CODEPAGE_SF = new byte[]{-45, -88, -121};
    private static final byte[] CHARACTER_TABLE_SF = new byte[]{-45, -116, -121};
    private static final byte[] FONT_DESCRIPTOR_SF = new byte[]{-45, -90, -119};
    private static final byte[] FONT_CONTROL_SF = new byte[]{-45, -89, -119};
    private static final byte[] FONT_ORIENTATION_SF = new byte[]{-45, -82, -119};
    private static final byte[] FONT_POSITION_SF = new byte[]{-45, -84, -119};
    private static final byte[] FONT_INDEX_SF = new byte[]{-45, -116, -119};
    private final Map<String, Map<String, String>> codePagesCache = Collections.synchronizedMap(new WeakHashMap());
    private final SoftMapCache characterSetsCache = new SoftMapCache(true);

    private CharacterSetBuilder() {
    }

    public static CharacterSetBuilder getSingleByteInstance() {
        return SingleByteLoader.getInstance();
    }

    public static CharacterSetBuilder getDoubleByteInstance() {
        return DoubleByteLoader.getInstance();
    }

    private InputStream openInputStream(AFPResourceAccessor accessor, String uriStr, AFPEventProducer eventProducer) throws IOException {
        URI uri;
        try {
            uri = InternalResourceResolver.cleanURI(uriStr.trim());
        }
        catch (URISyntaxException e2) {
            throw new MalformedURLException("Invalid uri: " + uriStr + " (" + e2.getMessage() + ")");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening " + uri);
        }
        return accessor.createInputStream(uri);
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
    }

    public CharacterSet buildSBCS(String characterSetName, String codePageName, String encoding, AFPResourceAccessor accessor, AFPEventProducer eventProducer) throws IOException {
        return this.processFont(characterSetName, codePageName, encoding, CharacterSetType.SINGLE_BYTE, accessor, eventProducer);
    }

    public CharacterSet buildDBCS(String characterSetName, String codePageName, String encoding, CharacterSetType charsetType, AFPResourceAccessor accessor, AFPEventProducer eventProducer) throws IOException {
        return this.processFont(characterSetName, codePageName, encoding, charsetType, accessor, eventProducer);
    }

    public CharacterSet build(String characterSetName, String codePageName, String encoding, Typeface typeface, AFPEventProducer eventProducer) throws IOException {
        return new FopCharacterSet(codePageName, encoding, characterSetName, typeface, eventProducer);
    }

    public CharacterSet build(String characterSetName, String codePageName, String encoding, Typeface typeface, AFPResourceAccessor accessor, AFPEventProducer eventProducer) throws IOException {
        return new FopCharacterSet(codePageName, encoding, characterSetName, typeface, accessor, eventProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharacterSet processFont(String characterSetName, String codePageName, String encoding, CharacterSetType charsetType, AFPResourceAccessor accessor, AFPEventProducer eventProducer) throws IOException {
        URI charSetURI = accessor.resolveURI(characterSetName);
        String cacheKey = charSetURI.toASCIIString() + "_" + characterSetName + "_" + codePageName;
        CharacterSet characterSet = (CharacterSet)this.characterSetsCache.get(cacheKey);
        if (characterSet != null) {
            return characterSet;
        }
        characterSet = new CharacterSet(codePageName, encoding, charsetType, characterSetName, accessor, eventProducer);
        InputStream inputStream = null;
        try {
            Map<String, String> codePage;
            Map<String, Map<String, String>> map = this.codePagesCache;
            synchronized (map) {
                codePage = this.codePagesCache.get(codePageName);
                if (codePage == null) {
                    codePage = this.loadCodePage(codePageName, encoding, accessor, eventProducer);
                    this.codePagesCache.put(codePageName, codePage);
                }
            }
            inputStream = this.openInputStream(accessor, characterSetName, eventProducer);
            StructuredFieldReader structuredFieldReader = new StructuredFieldReader(inputStream);
            FontDescriptor fontDescriptor = CharacterSetBuilder.processFontDescriptor(structuredFieldReader);
            characterSet.setNominalVerticalSize(fontDescriptor.getNominalFontSizeInMillipoints());
            FontControl fontControl = this.processFontControl(structuredFieldReader);
            if (fontControl != null) {
                double metricNormalizationFactor;
                CharacterSetOrientation[] characterSetOrientations = this.processFontOrientation(structuredFieldReader);
                if (fontControl.isRelative()) {
                    metricNormalizationFactor = 1.0;
                } else {
                    int dpi = fontControl.getDpi();
                    metricNormalizationFactor = 7.2E7 / (double)fontDescriptor.getNominalFontSizeInMillipoints() / (double)dpi;
                }
                ValueNormalizer normalizer = new ValueNormalizer(metricNormalizationFactor);
                this.processFontPosition(structuredFieldReader, characterSetOrientations, normalizer);
                for (CharacterSetOrientation characterSetOrientation : characterSetOrientations) {
                    this.processFontIndex(structuredFieldReader, characterSetOrientation, codePage, normalizer);
                    characterSet.addCharacterSetOrientation(characterSetOrientation);
                }
            } else {
                throw new IOException("Missing D3AE89 Font Control structured field.");
            }
            this.closeInputStream(inputStream);
        }
        catch (Throwable throwable) {
            this.closeInputStream(inputStream);
            throw throwable;
        }
        this.characterSetsCache.put(cacheKey, characterSet);
        return characterSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> loadCodePage(String codePage, String encoding, AFPResourceAccessor accessor, AFPEventProducer eventProducer) throws IOException {
        HashMap<String, String> codePages = new HashMap<String, String>();
        InputStream inputStream = null;
        try {
            inputStream = this.openInputStream(accessor, codePage.trim(), eventProducer);
        }
        catch (IOException e2) {
            eventProducer.codePageNotFound(this, e2);
            throw e2;
        }
        try {
            StructuredFieldReader structuredFieldReader = new StructuredFieldReader(inputStream);
            byte[] data = structuredFieldReader.getNext(CHARACTER_TABLE_SF);
            int position = 0;
            byte[] gcgiBytes = new byte[8];
            byte[] charBytes = new byte[1];
            for (int index = 3; index < data.length; ++index) {
                if (position < 8) {
                    gcgiBytes[position] = data[index];
                    ++position;
                    continue;
                }
                if (position == 9) {
                    position = 0;
                    charBytes[0] = data[index];
                    String gcgiString = new String(gcgiBytes, "Cp1146");
                    String charString = new String(charBytes, encoding);
                    codePages.put(gcgiString, charString);
                    continue;
                }
                ++position;
            }
        }
        finally {
            this.closeInputStream(inputStream);
        }
        return codePages;
    }

    private static FontDescriptor processFontDescriptor(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] fndData = structuredFieldReader.getNext(FONT_DESCRIPTOR_SF);
        return new FontDescriptor(fndData);
    }

    private FontControl processFontControl(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] fncData = structuredFieldReader.getNext(FONT_CONTROL_SF);
        FontControl fontControl = null;
        if (fncData != null) {
            int metricResolution;
            fontControl = new FontControl();
            if (fncData[7] == 2) {
                fontControl.setRelative(true);
            }
            if ((metricResolution = CharacterSetBuilder.getUBIN(fncData, 9)) == 1000) {
                fontControl.setUnitsPerEm(1000);
            } else {
                fontControl.setDpi(metricResolution / 10);
            }
        }
        return fontControl;
    }

    private CharacterSetOrientation[] processFontOrientation(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] data = structuredFieldReader.getNext(FONT_ORIENTATION_SF);
        int position = 0;
        byte[] fnoData = new byte[26];
        ArrayList<CharacterSetOrientation> orientations = new ArrayList<CharacterSetOrientation>();
        for (int index = 3; index < data.length; ++index) {
            fnoData[position] = data[index];
            if (++position != 26) continue;
            position = 0;
            int orientation = CharacterSetBuilder.determineOrientation(fnoData[2]);
            int spaceIncrement = CharacterSetBuilder.getUBIN(fnoData, 8);
            int emIncrement = CharacterSetBuilder.getUBIN(fnoData, 14);
            int nominalCharacterIncrement = CharacterSetBuilder.getUBIN(fnoData, 20);
            orientations.add(new CharacterSetOrientation(orientation, spaceIncrement, emIncrement, nominalCharacterIncrement));
        }
        return orientations.toArray(EMPTY_CSO_ARRAY);
    }

    private void processFontPosition(StructuredFieldReader structuredFieldReader, CharacterSetOrientation[] characterSetOrientations, ValueNormalizer normalizer) throws IOException {
        byte[] data = structuredFieldReader.getNext(FONT_POSITION_SF);
        int position = 0;
        byte[] fpData = new byte[26];
        int characterSetOrientationIndex = 0;
        for (int index = 3; index < data.length; ++index) {
            if (position < 22) {
                fpData[position] = data[index];
                if (position == 9) {
                    CharacterSetOrientation characterSetOrientation = characterSetOrientations[characterSetOrientationIndex];
                    int xHeight = CharacterSetBuilder.getSBIN(fpData, 2);
                    int capHeight = CharacterSetBuilder.getSBIN(fpData, 4);
                    int ascHeight = CharacterSetBuilder.getSBIN(fpData, 6);
                    int dscHeight = CharacterSetBuilder.getSBIN(fpData, 8);
                    dscHeight *= -1;
                    int underscoreWidth = CharacterSetBuilder.getUBIN(fpData, 17);
                    int underscorePosition = CharacterSetBuilder.getSBIN(fpData, 20);
                    characterSetOrientation.setXHeight(normalizer.normalize(xHeight));
                    characterSetOrientation.setCapHeight(normalizer.normalize(capHeight));
                    characterSetOrientation.setAscender(normalizer.normalize(ascHeight));
                    characterSetOrientation.setDescender(normalizer.normalize(dscHeight));
                    characterSetOrientation.setUnderscoreWidth(normalizer.normalize(underscoreWidth));
                    characterSetOrientation.setUnderscorePosition(normalizer.normalize(underscorePosition));
                }
            } else if (position == 22) {
                position = 0;
                ++characterSetOrientationIndex;
                fpData[position] = data[index];
            }
            ++position;
        }
    }

    private void processFontIndex(StructuredFieldReader structuredFieldReader, CharacterSetOrientation cso, Map<String, String> codepage, ValueNormalizer normalizer) throws IOException {
        byte[] data = structuredFieldReader.getNext(FONT_INDEX_SF);
        int position = 0;
        byte[] gcgid = new byte[8];
        byte[] fiData = new byte[20];
        String firstABCMismatch = null;
        for (int index = 3; index < data.length; ++index) {
            double diffPercent;
            int c;
            int b;
            if (position < 8) {
                gcgid[position] = data[index];
                ++position;
                continue;
            }
            if (position < 27) {
                fiData[position - 8] = data[index];
                ++position;
                continue;
            }
            if (position != 27) continue;
            fiData[position - 8] = data[index];
            position = 0;
            String gcgiString = new String(gcgid, "Cp1146");
            String idx = codepage.get(gcgiString);
            if (idx == null) continue;
            char cidx = idx.charAt(0);
            int width = CharacterSetBuilder.getUBIN(fiData, 0);
            int ascendHt = CharacterSetBuilder.getSBIN(fiData, 2);
            int descendDp = CharacterSetBuilder.getSBIN(fiData, 4);
            int a = CharacterSetBuilder.getSBIN(fiData, 10);
            int abc = a + (b = CharacterSetBuilder.getUBIN(fiData, 12)) + (c = CharacterSetBuilder.getSBIN(fiData, 14));
            int diff = Math.abs(abc - width);
            if (diff != 0 && width != 0 && (diffPercent = (double)(100 * diff) / (double)width) > 2.0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(gcgiString + ": " + a + " + " + b + " + " + c + " = " + (a + b + c) + " but found: " + width);
                }
                if (firstABCMismatch == null) {
                    firstABCMismatch = gcgiString;
                }
            }
            int normalizedWidth = normalizer.normalize(width);
            int x0 = normalizer.normalize(a);
            int y0 = normalizer.normalize(-descendDp);
            int dx = normalizer.normalize(b);
            int dy = normalizer.normalize(ascendHt + descendDp);
            cso.setCharacterMetrics(cidx, normalizedWidth, new Rectangle(x0, y0, dx, dy));
        }
        if (LOG.isDebugEnabled() && firstABCMismatch != null) {
            LOG.debug("Font has metrics inconsitencies where A+B+C doesn't equal the character increment. The first such character found: " + firstABCMismatch);
        }
    }

    private static int getUBIN(byte[] data, int start) {
        return ((data[start] & 0xFF) << 8) + (data[start + 1] & 0xFF);
    }

    private static int getSBIN(byte[] data, int start) {
        int ubin = ((data[start] & 0xFF) << 8) + (data[start + 1] & 0xFF);
        if ((ubin & 0x8000) != 0) {
            return ubin | 0xFFFF0000;
        }
        return ubin;
    }

    private static int determineOrientation(byte orientation) {
        int degrees = 0;
        switch (orientation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 45: {
                degrees = 90;
                break;
            }
            case 90: {
                degrees = 180;
                break;
            }
            case -121: {
                degrees = 270;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid orientation: " + orientation);
            }
        }
        return degrees;
    }

    private static final class DoubleByteLoader
    extends CharacterSetBuilder {
        private static final DoubleByteLoader INSTANCE = new DoubleByteLoader();

        private DoubleByteLoader() {
        }

        static DoubleByteLoader getInstance() {
            return INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Map<String, String> loadCodePage(String codePage, String encoding, AFPResourceAccessor accessor, AFPEventProducer eventProducer) throws IOException {
            HashMap<String, String> codePages = new HashMap<String, String>();
            InputStream inputStream = null;
            try {
                inputStream = ((CharacterSetBuilder)this).openInputStream(accessor, codePage.trim(), eventProducer);
            }
            catch (IOException e2) {
                eventProducer.codePageNotFound(this, e2);
                throw e2;
            }
            try {
                byte[] data;
                StructuredFieldReader structuredFieldReader = new StructuredFieldReader(inputStream);
                while ((data = structuredFieldReader.getNext(CHARACTER_TABLE_SF)) != null) {
                    int position = 0;
                    byte[] gcgiBytes = new byte[8];
                    byte[] charBytes = new byte[2];
                    for (int index = 3; index < data.length; ++index) {
                        if (position < 8) {
                            gcgiBytes[position] = data[index];
                            ++position;
                            continue;
                        }
                        if (position == 9) {
                            charBytes[0] = data[index];
                            ++position;
                            continue;
                        }
                        if (position == 10) {
                            position = 0;
                            charBytes[1] = data[index];
                            String gcgiString = new String(gcgiBytes, "Cp1146");
                            String charString = new String(charBytes, encoding);
                            codePages.put(gcgiString, charString);
                            continue;
                        }
                        ++position;
                    }
                }
            }
            finally {
                ((CharacterSetBuilder)this).closeInputStream(inputStream);
            }
            return codePages;
        }
    }

    private static final class SingleByteLoader
    extends CharacterSetBuilder {
        private static final SingleByteLoader INSTANCE = new SingleByteLoader();

        private SingleByteLoader() {
        }

        private static SingleByteLoader getInstance() {
            return INSTANCE;
        }
    }

    private static class FontDescriptor {
        private byte[] data;

        public FontDescriptor(byte[] data) {
            this.data = data;
        }

        public int getNominalFontSizeInMillipoints() {
            int nominalFontSize = 100 * CharacterSetBuilder.getUBIN(this.data, 39);
            return nominalFontSize;
        }
    }

    private class FontControl {
        private int dpi;
        private int unitsPerEm;
        private boolean isRelative;

        private FontControl() {
        }

        public int getDpi() {
            return this.dpi;
        }

        public void setDpi(int i) {
            this.dpi = i;
        }

        public int getUnitsPerEm() {
            return this.unitsPerEm;
        }

        public void setUnitsPerEm(int value) {
            this.unitsPerEm = value;
        }

        public boolean isRelative() {
            return this.isRelative;
        }

        public void setRelative(boolean b) {
            this.isRelative = b;
        }
    }

    private static class ValueNormalizer {
        private final double factor;

        public ValueNormalizer(double factor) {
            this.factor = factor;
        }

        public int normalize(int value) {
            return (int)Math.round((double)value * this.factor);
        }
    }
}

