/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.swing.gvt.Overlay;

public class SVGUpdateOverlay
implements Overlay {
    List rects = new LinkedList();
    int size;
    int updateCount;
    int[] counts;

    public SVGUpdateOverlay(int size, int numUpdates) {
        this.size = size;
        this.counts = new int[numUpdates];
    }

    public void addRect(Rectangle r) {
        this.rects.add(r);
        if (this.rects.size() > this.size) {
            this.rects.remove(0);
        }
        ++this.updateCount;
    }

    public void endUpdate() {
        int i;
        for (i = 0; i < this.counts.length - 1; ++i) {
            this.counts[i] = this.counts[i + 1];
        }
        this.counts[i] = this.updateCount;
        this.updateCount = 0;
        int num = this.rects.size();
        for (i = this.counts.length - 1; i >= 0; --i) {
            if (this.counts[i] > num) {
                this.counts[i] = num;
            }
            num -= this.counts[i];
        }
        this.counts[0] = this.counts[0] + num;
    }

    @Override
    public void paint(Graphics g) {
        int group2;
        Iterator i = this.rects.iterator();
        int count = 0;
        int idx = 0;
        for (group2 = 0; group2 < this.counts.length - 1 && idx == this.counts[group2]; ++group2) {
        }
        int cmax = this.counts.length - 1;
        while (i.hasNext()) {
            Rectangle r = (Rectangle)i.next();
            Color c = new Color(1.0f, (float)(cmax - group2) / (float)cmax, 0.0f, ((float)count + 1.0f) / (float)this.rects.size());
            g.setColor(c);
            g.drawRect(r.x, r.y, r.width, r.height);
            ++count;
            ++idx;
            while (group2 < this.counts.length - 1 && idx == this.counts[group2]) {
                ++group2;
                idx = 0;
            }
        }
    }
}

