/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;

public abstract class AbstractPanInteractor
extends InteractorAdapter {
    public static final Cursor PAN_CURSOR = new Cursor(13);
    protected boolean finished = true;
    protected int xStart;
    protected int yStart;
    protected int xCurrent;
    protected int yCurrent;
    protected Cursor previousCursor;

    @Override
    public boolean endInteraction() {
        return this.finished;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (!this.finished) {
            this.mouseExited(e2);
            return;
        }
        this.finished = false;
        this.xStart = e2.getX();
        this.yStart = e2.getY();
        JGVTComponent c = (JGVTComponent)e2.getSource();
        this.previousCursor = c.getCursor();
        c.setCursor(PAN_CURSOR);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        JGVTComponent c = (JGVTComponent)e2.getSource();
        this.xCurrent = e2.getX();
        this.yCurrent = e2.getY();
        AffineTransform at = AffineTransform.getTranslateInstance(this.xCurrent - this.xStart, this.yCurrent - this.yStart);
        AffineTransform rt = (AffineTransform)c.getRenderingTransform().clone();
        rt.preConcatenate(at);
        c.setRenderingTransform(rt);
        if (c.getCursor() == PAN_CURSOR) {
            c.setCursor(this.previousCursor);
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.finished = true;
        JGVTComponent c = (JGVTComponent)e2.getSource();
        c.setPaintingTransform(null);
        if (c.getCursor() == PAN_CURSOR) {
            c.setCursor(this.previousCursor);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        JGVTComponent c = (JGVTComponent)e2.getSource();
        this.xCurrent = e2.getX();
        this.yCurrent = e2.getY();
        AffineTransform at = AffineTransform.getTranslateInstance(this.xCurrent - this.xStart, this.yCurrent - this.yStart);
        c.setPaintingTransform(at);
    }
}

