/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.LinkedList;
import java.util.List;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;

public abstract class TimeContainer
extends TimedElement {
    protected List children = new LinkedList();

    public void addChild(TimedElement e2) {
        if (e2 == this) {
            throw new IllegalArgumentException("recursive datastructure not allowed here!");
        }
        this.children.add(e2);
        e2.parent = this;
        this.setRoot(e2, this.root);
        this.root.fireElementAdded(e2);
        this.root.currentIntervalWillUpdate();
    }

    protected void setRoot(TimedElement e2, TimedDocumentRoot root) {
        e2.root = root;
        if (e2 instanceof TimeContainer) {
            TimeContainer c = (TimeContainer)e2;
            for (Object aChildren : c.children) {
                TimedElement te = (TimedElement)aChildren;
                this.setRoot(te, root);
            }
        }
    }

    public void removeChild(TimedElement e2) {
        this.children.remove(e2);
        e2.parent = null;
        this.setRoot(e2, null);
        this.root.fireElementRemoved(e2);
        this.root.currentIntervalWillUpdate();
    }

    public TimedElement[] getChildren() {
        return this.children.toArray(new TimedElement[this.children.size()]);
    }

    @Override
    protected float sampleAt(float parentSimpleTime, boolean hyperlinking) {
        super.sampleAt(parentSimpleTime, hyperlinking);
        return this.sampleChildren(parentSimpleTime, hyperlinking);
    }

    protected float sampleChildren(float parentSimpleTime, boolean hyperlinking) {
        float mint = Float.POSITIVE_INFINITY;
        for (Object aChildren : this.children) {
            TimedElement e2 = (TimedElement)aChildren;
            float t = e2.sampleAt(parentSimpleTime, hyperlinking);
            if (!(t < mint)) continue;
            mint = t;
        }
        return mint;
    }

    @Override
    protected void reset(boolean clearCurrentBegin) {
        super.reset(clearCurrentBegin);
        for (Object aChildren : this.children) {
            TimedElement e2 = (TimedElement)aChildren;
            e2.reset(clearCurrentBegin);
        }
    }

    @Override
    protected boolean isConstantAnimation() {
        return false;
    }

    public abstract float getDefaultBegin(TimedElement var1);
}

