/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import jena.cmdline.CmdLineUtils;

public class rdfcompare {
    public static void main(String ... args) {
        if (args.length < 2 || args.length > 4) {
            rdfcompare.usage();
            System.exit(-1);
        }
        String in1 = args[0];
        String in2 = args[1];
        String lang1 = "RDF/XML";
        if (args.length > 2) {
            lang1 = args[2];
        }
        String lang2 = "N-TRIPLE";
        if (args.length == 4) {
            lang2 = args[3];
        }
        System.out.println(in1 + " " + in2 + " " + lang1 + " " + lang2);
        try {
            Model m1 = ModelFactory.createDefaultModel();
            Model m2 = ModelFactory.createDefaultModel();
            rdfcompare.read(m1, in1, lang1);
            rdfcompare.read(m2, in2, lang2);
            if (m1.isIsomorphicWith(m2)) {
                System.out.println("models are equal");
                System.out.println();
                System.exit(0);
            } else {
                System.out.println("models are unequal");
                System.out.println();
                System.exit(1);
            }
        }
        catch (Exception e2) {
            System.err.println("Unhandled exception:");
            System.err.println("    " + e2.toString());
            System.exit(-1);
        }
    }

    protected static void usage() {
        System.err.println("usage:");
        System.err.println("    java jena.rdfcompare source1 source2 [lang1 [lang2]]");
        System.err.println();
        System.err.println("    source1 and source2 can be URL's or filenames");
        System.err.println("    lang1 and lang2 can take values:");
        System.err.println("      RDF/XML");
        System.err.println("      N-TRIPLE");
        System.err.println("      N3");
        System.err.println("    lang1 defaults to RDF/XML, lang2 to N-TRIPLE");
        System.err.println();
    }

    protected static void read(Model model, String in, String lang) throws FileNotFoundException {
        try {
            URL url = new URL(in);
            model.read(in, lang);
        }
        catch (MalformedURLException e2) {
            model.read(new FileInputStream(in), "", lang);
        }
    }

    static {
        CmdLineUtils.setLog4jConfiguration();
    }
}

