/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.dtd;

import com.sun.tools.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.model.TypeUse;
import com.sun.tools.xjc.reader.dtd.Block;
import com.sun.tools.xjc.reader.dtd.TDTDReader;
import com.sun.tools.xjc.reader.dtd.Term;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIConversion;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIElement;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.model.core.WildcardMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

final class Element
extends Term
implements Comparable<Element> {
    final String name;
    private final TDTDReader owner;
    private short contentModelType;
    private Term contentModel;
    boolean isReferenced;
    private CClassInfo classInfo;
    private boolean classInfoComputed;
    final List<CPropertyInfo> attributes = new ArrayList<CPropertyInfo>();
    private final List<Block> normalizedBlocks = new ArrayList<Block>();
    private boolean mustBeClass;
    private Locator locator;

    public Element(TDTDReader owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    @Override
    void normalize(List<Block> r, boolean optional) {
        Block o = new Block(optional, false);
        o.elements.add(this);
        r.add(o);
    }

    @Override
    void addAllElements(Block b) {
        b.elements.add(this);
    }

    @Override
    boolean isOptional() {
        return false;
    }

    @Override
    boolean isRepeated() {
        return false;
    }

    void define(short contentModelType, Term contentModel, Locator locator) {
        assert (this.contentModel == null);
        this.contentModelType = contentModelType;
        this.contentModel = contentModel;
        this.locator = locator;
        contentModel.normalize(this.normalizedBlocks, false);
        for (Block b : this.normalizedBlocks) {
            if (!b.isRepeated && b.elements.size() <= 1) continue;
            for (Element e2 : b.elements) {
                this.owner.getOrCreateElement((String)e2.name).mustBeClass = true;
            }
        }
    }

    private TypeUse getConversion() {
        BIConversion conv;
        assert (this.contentModel == Term.EMPTY);
        BIElement e2 = this.owner.bindInfo.element(this.name);
        if (e2 != null && (conv = e2.getConversion()) != null) {
            return conv.getTransducer();
        }
        return CBuiltinLeafInfo.STRING;
    }

    CClassInfo getClassInfo() {
        if (!this.classInfoComputed) {
            this.classInfoComputed = true;
            this.classInfo = this.calcClass();
        }
        return this.classInfo;
    }

    private CClassInfo calcClass() {
        BIElement e2 = this.owner.bindInfo.element(this.name);
        if (e2 == null) {
            if (this.contentModelType != 2 || !this.attributes.isEmpty() || this.mustBeClass) {
                return this.createDefaultClass();
            }
            if (this.contentModel != Term.EMPTY) {
                throw new UnsupportedOperationException("mixed content model not supported");
            }
            if (this.isReferenced) {
                return null;
            }
            return this.createDefaultClass();
        }
        return e2.clazz;
    }

    private CClassInfo createDefaultClass() {
        String className = this.owner.model.getNameConverter().toClassName(this.name);
        QName tagName = new QName("", this.name);
        return new CClassInfo(this.owner.model, this.owner.getTargetPackage(), className, this.locator, null, tagName, null, null);
    }

    void bind() {
        CClassInfo ci = this.getClassInfo();
        assert (ci != null || this.attributes.isEmpty());
        for (CPropertyInfo p : this.attributes) {
            ci.addProperty(p);
        }
        switch (this.contentModelType) {
            case 1: {
                CReferencePropertyInfo rp = new CReferencePropertyInfo("Content", true, false, true, null, null, this.locator, false, false, false);
                rp.setWildcard(WildcardMode.SKIP);
                ci.addProperty(rp);
                return;
            }
            case 3: {
                break;
            }
            case 2: {
                if (this.contentModel != Term.EMPTY) {
                    throw new UnsupportedOperationException("mixed content model unsupported yet");
                }
                if (ci != null) {
                    CPropertyInfo p;
                    p = new CValuePropertyInfo("value", null, null, this.locator, this.getConversion(), null);
                    ci.addProperty(p);
                }
                return;
            }
            case 0: {
                assert (ci != null);
                return;
            }
        }
        ArrayList<Block> n = new ArrayList<Block>();
        this.contentModel.normalize(n, false);
        HashSet<String> names = new HashSet<String>();
        boolean collision = false;
        block7: for (Block block : n) {
            for (Element e2 : block.elements) {
                if (names.add(e2.name)) continue;
                collision = true;
                break block7;
            }
        }
        if (collision) {
            Block all = new Block(true, true);
            for (Block block : n) {
                all.elements.addAll(block.elements);
            }
            n.clear();
            n.add(all);
        }
        for (Block b : n) {
            CElementPropertyInfo p;
            if (b.isRepeated || b.elements.size() > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Element e2 : b.elements) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("Or");
                    }
                    stringBuilder.append(this.owner.model.getNameConverter().toPropertyName(e2.name));
                }
                p = new CElementPropertyInfo(stringBuilder.toString(), CElementPropertyInfo.CollectionMode.REPEATED_ELEMENT, ID.NONE, null, null, null, this.locator, !b.isOptional);
                for (Element e2 : b.elements) {
                    CClassInfo child = this.owner.getOrCreateElement(e2.name).getClassInfo();
                    assert (child != null);
                    p.getTypes().add(new CTypeRef(child, new QName("", e2.name), null, false, null));
                }
            } else {
                String string = b.elements.iterator().next().name;
                String string2 = this.owner.model.getNameConverter().toPropertyName(string);
                Element ref = this.owner.getOrCreateElement(string);
                CNonElement refType = ref.getClassInfo() != null ? ref.getClassInfo() : ref.getConversion().getInfo();
                p = new CElementPropertyInfo(string2, refType.isCollection() ? CElementPropertyInfo.CollectionMode.REPEATED_VALUE : CElementPropertyInfo.CollectionMode.NOT_REPEATED, ID.NONE, null, null, null, this.locator, !b.isOptional);
                p.getTypes().add(new CTypeRef(refType.getInfo(), new QName("", string), null, false, null));
            }
            ci.addProperty(p);
        }
    }

    @Override
    public int compareTo(Element that) {
        return this.name.compareTo(that.name);
    }
}

