/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.model;

import java.math.BigInteger;

public final class Multiplicity {
    public final BigInteger min;
    public final BigInteger max;
    public static final Multiplicity ZERO = new Multiplicity(0, 0);
    public static final Multiplicity ONE = new Multiplicity(1, 1);
    public static final Multiplicity OPTIONAL = new Multiplicity(0, 1);
    public static final Multiplicity STAR = new Multiplicity(0, null);
    public static final Multiplicity PLUS = new Multiplicity(1, null);

    public static Multiplicity create(BigInteger min2, BigInteger max2) {
        if (BigInteger.ZERO.equals(min2) && max2 == null) {
            return STAR;
        }
        if (BigInteger.ONE.equals(min2) && max2 == null) {
            return PLUS;
        }
        if (max2 != null) {
            if (BigInteger.ZERO.equals(min2) && BigInteger.ZERO.equals(max2)) {
                return ZERO;
            }
            if (BigInteger.ZERO.equals(min2) && BigInteger.ONE.equals(max2)) {
                return OPTIONAL;
            }
            if (BigInteger.ONE.equals(min2) && BigInteger.ONE.equals(max2)) {
                return ONE;
            }
        }
        return new Multiplicity(min2, max2);
    }

    public static Multiplicity create(int min2, Integer max2) {
        return Multiplicity.create(BigInteger.valueOf(min2), BigInteger.valueOf(max2.intValue()));
    }

    private Multiplicity(BigInteger min2, BigInteger max2) {
        this.min = min2;
        this.max = max2;
    }

    private Multiplicity(int min2, int max2) {
        this(BigInteger.valueOf(min2), BigInteger.valueOf(max2));
    }

    private Multiplicity(int min2, Integer max2) {
        this(BigInteger.valueOf(min2), max2 == null ? null : BigInteger.valueOf(max2.intValue()));
    }

    public boolean equals(Object o) {
        if (!(o instanceof Multiplicity)) {
            return false;
        }
        Multiplicity that = (Multiplicity)o;
        if (!this.min.equals(that.min)) {
            return false;
        }
        return !(this.max != null ? !this.max.equals(that.max) : that.max != null);
    }

    public int hashCode() {
        return this.min.add(this.max).intValue();
    }

    public boolean isUnique() {
        if (this.max == null) {
            return false;
        }
        return BigInteger.ONE.equals(this.min) && BigInteger.ONE.equals(this.max);
    }

    public boolean isOptional() {
        if (this.max == null) {
            return false;
        }
        return BigInteger.ZERO.equals(this.min) && BigInteger.ONE.equals(this.max);
    }

    public boolean isAtMostOnce() {
        if (this.max == null) {
            return false;
        }
        return this.max.compareTo(BigInteger.ONE) <= 0;
    }

    public boolean isZero() {
        if (this.max == null) {
            return false;
        }
        return BigInteger.ZERO.equals(this.max);
    }

    public boolean includes(Multiplicity rhs) {
        if (rhs.min.compareTo(this.min) == -1) {
            return false;
        }
        if (this.max == null) {
            return true;
        }
        if (rhs.max == null) {
            return false;
        }
        return rhs.max.compareTo(this.max) <= 0;
    }

    public String getMaxString() {
        if (this.max == null) {
            return "unbounded";
        }
        return this.max.toString();
    }

    public String toString() {
        return "(" + this.min + ',' + this.getMaxString() + ')';
    }

    public static Multiplicity choice(Multiplicity lhs, Multiplicity rhs) {
        return Multiplicity.create(lhs.min.min(rhs.min), lhs.max == null || rhs.max == null ? null : lhs.max.max(rhs.max));
    }

    public static Multiplicity group(Multiplicity lhs, Multiplicity rhs) {
        return Multiplicity.create(lhs.min.add(rhs.min), lhs.max == null || rhs.max == null ? null : lhs.max.add(rhs.max));
    }

    public static Multiplicity multiply(Multiplicity lhs, Multiplicity rhs) {
        BigInteger min2 = lhs.min.multiply(rhs.min);
        Object max2 = Multiplicity.isZero(lhs.max) || Multiplicity.isZero(rhs.max) ? BigInteger.ZERO : (lhs.max == null || rhs.max == null ? null : lhs.max.multiply(rhs.max));
        return Multiplicity.create(min2, (BigInteger)max2);
    }

    private static boolean isZero(BigInteger i) {
        return i != null && BigInteger.ZERO.equals(i);
    }

    public static Multiplicity oneOrMore(Multiplicity c) {
        if (c.max == null) {
            return c;
        }
        if (BigInteger.ZERO.equals(c.max)) {
            return c;
        }
        return Multiplicity.create(c.min, null);
    }

    public Multiplicity makeOptional() {
        if (BigInteger.ZERO.equals(this.min)) {
            return this;
        }
        return Multiplicity.create(BigInteger.ZERO, this.max);
    }

    public Multiplicity makeRepeated() {
        if (this.max == null || BigInteger.ZERO.equals(this.max)) {
            return this;
        }
        return Multiplicity.create(this.min, null);
    }
}

