/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Messages;
import java.io.OutputStream;
import java.io.PrintStream;
import org.xml.sax.SAXParseException;

public class ConsoleErrorReporter
extends ErrorReceiver {
    private PrintStream output;
    private boolean hadError = false;

    public ConsoleErrorReporter(PrintStream out) {
        this.output = out;
    }

    public ConsoleErrorReporter(OutputStream out) {
        this(new PrintStream(out));
    }

    public ConsoleErrorReporter() {
        this(System.out);
    }

    @Override
    public void warning(SAXParseException e2) {
        this.print("Driver.WarningMessage", e2);
    }

    @Override
    public void error(SAXParseException e2) {
        this.hadError = true;
        this.print("Driver.ErrorMessage", e2);
    }

    @Override
    public void fatalError(SAXParseException e2) {
        this.hadError = true;
        this.print("Driver.ErrorMessage", e2);
    }

    @Override
    public void info(SAXParseException e2) {
        this.print("Driver.InfoMessage", e2);
    }

    public boolean hadError() {
        return this.hadError;
    }

    private void print(String resource, SAXParseException e2) {
        this.output.println(Messages.format(resource, e2.getMessage()));
        this.output.println(this.getLocationString(e2));
        this.output.println();
    }
}

