/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.WrappedIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import org.slf4j.LoggerFactory;

public class FileUtils {
    public static final String langXML = "RDF/XML";
    public static final String langXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langN3 = "N3";
    public static final String langTurtle = "TURTLE";
    public static final String encodingUTF8 = "utf-8";
    static Charset utf8 = null;
    private static int counter;

    public static Reader asUTF8(InputStream in) {
        if (JenaRuntime.runUnder("http://jena.hpl.hp.com/2004/07/feature/noCharset")) {
            return new InputStreamReader(in);
        }
        return new InputStreamReader(in, utf8.newDecoder());
    }

    public static BufferedReader asBufferedUTF8(InputStream in) {
        BufferedReader r = new BufferedReader(FileUtils.asUTF8(in));
        return r;
    }

    public static Writer asUTF8(OutputStream out) {
        if (JenaRuntime.runUnder("http://jena.hpl.hp.com/2004/07/feature/noCharset")) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, utf8.newEncoder());
    }

    public static PrintWriter asPrintWriterUTF8(OutputStream out) {
        return new PrintWriter(FileUtils.asUTF8(out));
    }

    public static String guessLang(String name, String otherwise) {
        String suffix = FileUtils.getFilenameExt(name);
        if (suffix.equals("n3")) {
            return langN3;
        }
        if (suffix.equals("nt")) {
            return langNTriple;
        }
        if (suffix.equals("ttl")) {
            return langTurtle;
        }
        if (suffix.equals("rdf")) {
            return langXML;
        }
        if (suffix.equals("owl")) {
            return langXML;
        }
        return otherwise;
    }

    public static String guessLang(String urlStr) {
        return FileUtils.guessLang(urlStr, langXML);
    }

    public static String toFilename(String filenameOrURI) {
        if (!FileUtils.isFile(filenameOrURI)) {
            return null;
        }
        String fn = filenameOrURI;
        if (!fn.startsWith("file:")) {
            return fn;
        }
        fn = fn.startsWith("file:///") ? fn.substring("file://".length()) : (fn.startsWith("file://localhost/") ? fn.substring("file://localhost".length()) : fn.substring("file:".length()));
        return FileUtils.decodeFileName(fn);
    }

    public static String decodeFileName(String s) {
        if (s.indexOf(37) < 0) {
            return s;
        }
        int len = s.length();
        StringBuffer sbuff = new StringBuffer(len);
        block3: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    int codepoint = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                    char ch = (char)codepoint;
                    sbuff.append(ch);
                    i += 2;
                    continue block3;
                }
                default: {
                    sbuff.append(c);
                }
            }
        }
        return sbuff.toString();
    }

    public static String toURL(String filename) {
        if (filename.length() > 5 && filename.substring(0, 5).equalsIgnoreCase("file:")) {
            return filename;
        }
        return "file://" + new File(filename).toURI().toString().substring(5);
    }

    @Deprecated
    public static String encodeFileName(String s) {
        int len = s.length();
        StringBuffer sbuff = new StringBuffer(len);
        block3: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case ' ': 
                case '~': {
                    sbuff.append('%');
                    sbuff.append(Integer.toHexString(c).toUpperCase(Locale.ENGLISH));
                    continue block3;
                }
                default: {
                    sbuff.append(c);
                }
            }
        }
        return sbuff.toString();
    }

    public static boolean isFile(String name) {
        String scheme = FileUtils.getScheme(name);
        if (scheme == null) {
            return true;
        }
        if (scheme.equals("file")) {
            return true;
        }
        return scheme.length() == 1;
    }

    public static boolean isURI(String name) {
        return FileUtils.getScheme(name) != null;
    }

    public static String getScheme(String uri) {
        for (int i = 0; i < uri.length(); ++i) {
            char ch = uri.charAt(i);
            if (ch == ':') {
                return uri.substring(0, i);
            }
            if (!FileUtils.isASCIILetter(ch)) break;
        }
        return null;
    }

    private static boolean isASCIILetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    public static String getDirname(String filename) {
        File f = new File(filename);
        return f.getParent();
    }

    public static String getFilenameExt(String filename) {
        int iSlash = filename.lastIndexOf(47);
        int iBack = filename.lastIndexOf(92);
        int iExt = filename.lastIndexOf(46);
        if (iBack > iSlash) {
            iSlash = iBack;
        }
        return iExt > iSlash ? filename.substring(iExt + 1).toLowerCase() : "";
    }

    public static File tempFileName(String prefix, String suffix) {
        File result = new File(FileUtils.getTempDirectory(), prefix + FileUtils.randomNumber() + suffix);
        if (result.exists()) {
            return FileUtils.tempFileName(prefix, suffix);
        }
        result.deleteOnExit();
        return result;
    }

    public static File getScratchDirectory(String prefix) {
        File result = new File(FileUtils.getTempDirectory(), prefix + FileUtils.randomNumber());
        if (result.exists()) {
            return FileUtils.getScratchDirectory(prefix);
        }
        if (!result.mkdir()) {
            throw new JenaException("mkdir failed on " + result);
        }
        result.deleteOnExit();
        return result;
    }

    public static String getTempDirectory() {
        return JenaRuntime.getSystemProperty("java.io.tmpdir");
    }

    private static int randomNumber() {
        return ++counter;
    }

    public static BufferedReader openResourceFile(String filename) {
        try {
            InputStream is = FileUtils.openResourceFileAsStream(filename);
            return new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (IOException e2) {
            throw new WrappedIOException(e2);
        }
    }

    public static InputStream openResourceFileAsStream(String filename) throws FileNotFoundException {
        InputStream is = ClassLoader.getSystemResourceAsStream(filename);
        if (is == null && (is = FileUtils.class.getResourceAsStream("/" + filename)) == null && (is = FileUtils.class.getResourceAsStream(filename)) == null) {
            is = new FileInputStream(filename);
        }
        return is;
    }

    public static BufferedReader readerFromURL(String urlStr) {
        try {
            return FileUtils.asBufferedUTF8(new URL(urlStr).openStream());
        }
        catch (MalformedURLException e2) {
            try {
                return FileUtils.asBufferedUTF8(new FileInputStream(urlStr));
            }
            catch (FileNotFoundException f) {
                throw new WrappedIOException(f);
            }
        }
        catch (IOException e3) {
            throw new WrappedIOException(e3);
        }
    }

    public static String readWholeFileAsUTF8(String filename) throws IOException {
        FileInputStream in = new FileInputStream(filename);
        return FileUtils.readWholeFileAsUTF8(in);
    }

    public static String readWholeFileAsUTF8(InputStream in) throws IOException {
        BufferedReader r = new BufferedReader(FileUtils.asUTF8(in), 1024);
        return FileUtils.readWholeFileAsUTF8(r);
    }

    private static String readWholeFileAsUTF8(Reader r) throws IOException {
        int l;
        StringWriter sw = new StringWriter(1024);
        char[] buff = new char[1024];
        while ((l = r.read(buff)) != -1 && l > 0) {
            sw.write(buff, 0, l);
        }
        r.close();
        sw.close();
        return sw.toString();
    }

    static {
        try {
            utf8 = Charset.forName(encodingUTF8);
        }
        catch (Throwable ex) {
            LoggerFactory.getLogger(FileUtils.class).warn("Failed to get charset for UTF-8", ex);
        }
        counter = 0;
    }
}

