/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.report;

import com.codecamp.sepa.core.SEPACreditTransfer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

public class SEPAReport {
    private final Logger logger = Logger.getLogger(SEPAReport.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCTReport(SEPACreditTransfer sEPACreditTransfer, File file) {
        OutputStream outputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JAXBContext jAXBContext = JAXBContext.newInstance(SEPACreditTransfer.class);
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            marshaller.marshal((Object)sEPACreditTransfer, byteArrayOutputStream);
            System.out.println(byteArrayOutputStream.toString());
            FopFactory fopFactory = FopFactory.newInstance(new File(".").toURI());
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            Fop fop = fopFactory.newFop("application/pdf", outputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(this.getClass().getResourceAsStream("/com/codecamp/sepa/report/sepaCTReport.xsl"));
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            StreamSource streamSource2 = new StreamSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            SAXResult sAXResult = new SAXResult(fop.getDefaultHandler());
            transformer.transform(streamSource2, sAXResult);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while creating report!", exception);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                this.logger.log(Level.SEVERE, "Exception while creating report!", iOException);
            }
        }
    }
}

