/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.parser.excel;

import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPADirectDebitTransaction;
import com.codecamp.sepa.core.SEPANormalizer;
import com.codecamp.sepa.gui.DebitParser;
import com.codecamp.sepa.parser.DirectDebitValidator;
import com.codecamp.sepa.parser.ParserLineResult;
import com.codecamp.sepa.parser.ParserResult;
import com.codecamp.sepa.parser.ParserUtils;
import com.codecamp.sepa.parser.ValidationException;
import com.codecamp.sepa.parser.excel.command.ColumnReaderCommandFactory;
import com.codecamp.sepa.parser.sheet.NoObject;
import com.codecamp.sepa.parser.sheet.command.ColumnReaderCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;

public class ExcelDirectDebitParser
implements DebitParser {
    private final Logger logger = Logger.getLogger(ExcelDirectDebitParser.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParserResult parse(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) {
        ParserResult parserResult = new ParserResult();
        SEPADirectDebit sEPADirectDebit = new SEPADirectDebit();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Workbook workbook = WorkbookFactory.create(fileInputStream);
            List<SEPADirectDebitTransaction> list = this.readDirectDebitTransactions(workbook.getSheetAt(0), parserResult, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10);
            sEPADirectDebit.getTransactionList().addAll(list);
            parserResult.setDirectDebit(sEPADirectDebit);
            parserResult.setHeaderSuccessfull(true);
        }
        catch (InvalidFormatException invalidFormatException) {
            this.logger.log(Level.WARNING, "Exception while opening Excel file \"" + file.getAbsolutePath() + "\"", invalidFormatException);
            parserResult.setHeaderSuccessfull(false);
            parserResult.setHeaderMessage(invalidFormatException.getMessage());
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Exception while opening Excel file \"" + file.getAbsolutePath() + "\"", exception);
            parserResult.setHeaderSuccessfull(false);
            parserResult.setHeaderMessage(exception.getMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.logger.log(Level.WARNING, "Fehler beim \u00d6ffnen der Excel-Datei \"" + file.getAbsolutePath() + "\"", iOException);
                }
            }
        }
        return parserResult;
    }

    protected List<SEPADirectDebitTransaction> readDirectDebitTransactions(Sheet sheet, ParserResult parserResult, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) {
        ArrayList<SEPADirectDebitTransaction> arrayList = new ArrayList<SEPADirectDebitTransaction>();
        SEPADirectDebitTransaction sEPADirectDebitTransaction = null;
        int n = sheet.getLastRowNum();
        int n2 = this.determineStartingRow(sheet.getRow(0));
        this.checkBIC(sheet, n2, parserResult);
        parserResult.setStartingRow(n2);
        for (int i = n2; i <= n; ++i) {
            Row row = sheet.getRow(i);
            List<Field> list = Arrays.asList(SEPADirectDebitTransaction.class.getDeclaredFields());
            sEPADirectDebitTransaction = new SEPADirectDebitTransaction();
            ParserLineResult parserLineResult = new ParserLineResult();
            for (Field field : list) {
                if ("BIC".equals(field.getName()) && !bl || "end2EndId".equals(field.getName()) && !bl2 || "currency".equals(field.getName()) && !bl3 || "countryCode".equals(field.getName()) && !bl4 || "addressLine1".equals(field.getName()) && !bl4 || "addressLine2".equals(field.getName()) && !bl4 || "collectionDate".equals(field.getName()) && !bl5 || "type".equals(field.getName()) && !bl6) continue;
                ColumnReaderCommand columnReaderCommand = ColumnReaderCommandFactory.create(field, row);
                try {
                    Object object = columnReaderCommand.getValueFromColumnOrColumns(!bl);
                    if (NoObject.class == object.getClass()) continue;
                    field.setAccessible(true);
                    field.set(sEPADirectDebitTransaction, object);
                }
                catch (InstantiationException instantiationException) {
                    this.logger.log(Level.WARNING, "Cannot read value.", instantiationException);
                    sEPADirectDebitTransaction = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.log(Level.WARNING, "Cannot set value into field.", illegalAccessException);
                    sEPADirectDebitTransaction = null;
                }
            }
            try {
                DirectDebitValidator.validateLine(sEPADirectDebitTransaction.getKontoinhaber(), sEPADirectDebitTransaction.getIBAN(), sEPADirectDebitTransaction.getBIC(), sEPADirectDebitTransaction.getMandatsReferenzNr(), sEPADirectDebitTransaction.getSignatureDate() != null ? sEPADirectDebitTransaction.getSignatureDate().getTime() : null, sEPADirectDebitTransaction.getVerwendungszweck(), sEPADirectDebitTransaction.getAmount(), sEPADirectDebitTransaction.getEnd2EndId(), sEPADirectDebitTransaction.getCurrency(), sEPADirectDebitTransaction.getCountryCode(), sEPADirectDebitTransaction.getAddressLine1(), sEPADirectDebitTransaction.getAddressLine2(), sEPADirectDebitTransaction.getCollectionDate(), sEPADirectDebitTransaction.getType(), bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10);
                sEPADirectDebitTransaction.setIBAN(sEPADirectDebitTransaction.getIBAN().replaceAll(" ", ""));
                if (bl && !bl10) {
                    sEPADirectDebitTransaction.setBIC(sEPADirectDebitTransaction.getBIC().replaceAll(" ", ""));
                }
                sEPADirectDebitTransaction.setVerwendungszweck(sEPADirectDebitTransaction.getVerwendungszweck().trim());
                if (!bl10) {
                    sEPADirectDebitTransaction.setMandatsReferenzNr(sEPADirectDebitTransaction.getMandatsReferenzNr().replaceAll(" ", ""));
                }
                if (bl2) {
                    sEPADirectDebitTransaction.setEnd2EndId(sEPADirectDebitTransaction.getEnd2EndId().replaceAll(" ", ""));
                }
                if (bl3) {
                    sEPADirectDebitTransaction.setCurrency(sEPADirectDebitTransaction.getCurrency().replaceAll(" ", ""));
                }
                if (bl4) {
                    sEPADirectDebitTransaction.setCountryCode(sEPADirectDebitTransaction.getCountryCode().replaceAll(" ", ""));
                }
                if (bl7) {
                    sEPADirectDebitTransaction.setKontoinhaber(SEPANormalizer.normalize(sEPADirectDebitTransaction.getKontoinhaber()));
                    sEPADirectDebitTransaction.setVerwendungszweck(SEPANormalizer.normalize(sEPADirectDebitTransaction.getVerwendungszweck()));
                    if (sEPADirectDebitTransaction.getAddressLine1() != null) {
                        sEPADirectDebitTransaction.setAddressLine1(SEPANormalizer.normalize(sEPADirectDebitTransaction.getAddressLine1()));
                    }
                    if (sEPADirectDebitTransaction.getAddressLine2() != null) {
                        sEPADirectDebitTransaction.setAddressLine2(SEPANormalizer.normalize(sEPADirectDebitTransaction.getAddressLine2()));
                    }
                }
                parserLineResult.setSucessfull(true);
                parserLineResult.setLineMessage(sEPADirectDebitTransaction.getKontoinhaber() + ", " + sEPADirectDebitTransaction.getIBAN() + (bl && !bl10 ? ", " + sEPADirectDebitTransaction.getBIC() : "") + (!bl10 ? ", " + sEPADirectDebitTransaction.getMandatsReferenzNr() : "") + (!bl10 && sEPADirectDebitTransaction.getSignatureDate() != null ? ", " + ParserUtils.formatDateForLog(sEPADirectDebitTransaction.getSignatureDate()) : "") + ", " + sEPADirectDebitTransaction.getVerwendungszweck() + ", " + ParserUtils.formatBigDecimalForLog(sEPADirectDebitTransaction.getAmount()) + (bl2 ? ", " + sEPADirectDebitTransaction.getEnd2EndId() : "") + (bl3 ? ", " + sEPADirectDebitTransaction.getCurrency() : "") + (bl4 ? ", " + sEPADirectDebitTransaction.getCountryCode() : "") + (bl4 ? ", " + StringUtils.trimToEmpty(sEPADirectDebitTransaction.getAddressLine1()) : "") + (bl4 ? ", " + StringUtils.trimToEmpty(sEPADirectDebitTransaction.getAddressLine2()) : "") + (bl5 ? ", " + ParserUtils.formatDateForLog(sEPADirectDebitTransaction.getCollectionDate()) : "") + (bl6 ? ", " + sEPADirectDebitTransaction.getType() : ""));
            }
            catch (ValidationException validationException) {
                parserLineResult.setSucessfull(false);
                parserLineResult.setLineMessage(validationException.getMessage() + (validationException.getNotValidatingValue() != null ? " (" + validationException.getNotValidatingValue() + ")" : ""));
                sEPADirectDebitTransaction = null;
                this.logger.log(Level.WARNING, parserLineResult.getLineMessage(), validationException);
            }
            if (sEPADirectDebitTransaction != null) {
                sEPADirectDebitTransaction.setAmount(sEPADirectDebitTransaction.getAmount().setScale(2));
                sEPADirectDebitTransaction.setIBAN(sEPADirectDebitTransaction.getIBAN().toUpperCase());
                if (bl && !bl10) {
                    sEPADirectDebitTransaction.setBIC(sEPADirectDebitTransaction.getBIC().toUpperCase());
                }
                if (bl2) {
                    sEPADirectDebitTransaction.setEnd2EndId(sEPADirectDebitTransaction.getEnd2EndId().toUpperCase());
                }
                if (bl3) {
                    sEPADirectDebitTransaction.setCurrency(sEPADirectDebitTransaction.getCurrency().toUpperCase());
                }
                if (bl4) {
                    sEPADirectDebitTransaction.setCountryCode(sEPADirectDebitTransaction.getCountryCode().toUpperCase());
                }
                arrayList.add(sEPADirectDebitTransaction);
                parserResult.setSuccessfull(parserResult.getSuccessfull() + 1);
                parserResult.setSum(parserResult.getSum().add(sEPADirectDebitTransaction.getAmount()));
            } else {
                parserResult.setNotSuccessfull(parserResult.getNotSuccessfull() + 1);
            }
            parserResult.getLineResults().add(parserLineResult);
        }
        return arrayList;
    }

    private int determineStartingRow(Row row) {
        int n = 0;
        try {
            Cell cell = row.getCell(new CellReference("A").getCol());
            if (cell.getCellType() == 1) {
                String string = cell.getStringCellValue();
                if (ParserUtils.isExample(string)) {
                    this.logger.log(Level.INFO, "This is the template with header and example: Start reading from line 2...");
                    n = 2;
                } else if (ParserUtils.isHeader(string)) {
                    this.logger.log(Level.INFO, "This is the template with header: Start reading from line 1...");
                    n = 1;
                } else {
                    this.logger.log(Level.INFO, "This is not the template: Start reading from line 0...");
                }
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Cannot read value.", exception);
        }
        return n;
    }

    private void checkBIC(Sheet sheet, int n, ParserResult parserResult) {
        try {
            if (2 == n) {
                String string;
                Row row = sheet.getRow(0);
                Cell cell = row.getCell(new CellReference("C").getCol());
                if (cell.getCellType() == 1 && ParserUtils.isExampleBIC(string = cell.getStringCellValue())) {
                    this.logger.log(Level.INFO, "This is the template with header and example and column BIC.");
                    parserResult.setBICFound(true);
                }
            } else if (1 == n) {
                String string;
                Row row = sheet.getRow(1);
                Cell cell = row.getCell(new CellReference("C").getCol());
                if (cell.getCellType() == 1 && ParserUtils.isHeaderBIC(string = cell.getStringCellValue())) {
                    this.logger.log(Level.INFO, "This is the template with header and column BIC.");
                    parserResult.setBICFound(true);
                }
            } else {
                String string;
                Row row = sheet.getRow(2);
                Cell cell = row.getCell(new CellReference("C").getCol());
                if (cell.getCellType() == 1 && ParserUtils.isBIC(string = cell.getStringCellValue())) {
                    this.logger.log(Level.INFO, "This is presumably a BIC.");
                    parserResult.setBICFound(true);
                }
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Cannot read value.", exception);
        }
    }
}

