/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.parser.csv;

import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.parser.DirectDebitValidator;
import com.codecamp.sepa.parser.ParserUtils;
import com.codecamp.sepa.parser.ValidationException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class CSVDirectDebitValidator
extends DirectDebitValidator {
    public static void validateCSVLine(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) throws ValidationException {
        Serializable serializable;
        int n = bl && bl2 && bl3 ? 9 : (bl && bl2 ? 8 : (bl && bl3 ? 8 : (bl || bl2 || bl3 ? 7 : 6)));
        if (bl4) {
            n += 3;
        }
        if (bl5) {
            ++n;
        }
        if (bl6) {
            ++n;
        }
        if (string == null || string.isEmpty() || string.replaceAll(" ", "").isEmpty()) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.row.empty"), (Object)null);
        }
        string = string.replaceAll(" ", "");
        string = string.replaceAll("\"", "");
        String[] stringArray = (string = string.replaceAll("'", "")).split(string2);
        if (stringArray.length < n) {
            throw new ValidationException(MessageFormat.format(ApplicationContext.get().text().getString("validation.columnNo"), stringArray.length, n), (Object)null);
        }
        CSVDirectDebitValidator.validateKontoinhaber(ParserUtils.removeBOM(stringArray[0]), bl7, bl8, bl9);
        CSVDirectDebitValidator.validateIBAN(stringArray[1], false);
        if (bl && !bl10) {
            CSVDirectDebitValidator.validateBIC(stringArray[2]);
        }
        if (!bl10) {
            CSVDirectDebitValidator.validateMandatsReferenzNr(stringArray[bl ? 3 : 2]);
        }
        Date date2 = null;
        if (!bl10) {
            if (stringArray[bl ? 4 : 3] == null || stringArray[bl ? 4 : 3].isEmpty()) {
                throw new ValidationException(ApplicationContext.get().text().getString("validation.signaturedate.empty.user.msg"), stringArray[bl ? 4 : 3]);
            }
            serializable = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
            try {
                date2 = serializable.parse(stringArray[bl ? 4 : 3]);
            }
            catch (ParseException parseException) {
                throw new ValidationException(ApplicationContext.get().text().getString("validation.signaturedate.user.msg"), stringArray[bl ? 4 : 3], parseException);
            }
            CSVDirectDebitValidator.validateSignatureDate(date2);
        }
        CSVDirectDebitValidator.validateVerwendungszweck(stringArray[bl ? 5 : 4], bl7, bl8, bl9, false, false);
        serializable = null;
        if (stringArray[bl ? 6 : 5] == null || stringArray[bl ? 6 : 5].isEmpty()) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.user.msg"), bl ? 6 : 5);
        }
        try {
            serializable = new BigDecimal(stringArray[bl ? 6 : 5].replaceAll(",", "."));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.number.user.msg"), bl ? 6 : 5, numberFormatException);
        }
        CSVDirectDebitValidator.validateAmount((BigDecimal)serializable);
        try {
            if (bl2) {
                CSVDirectDebitValidator.validateIdText(stringArray[bl ? 7 : 6]);
            }
            if (bl3) {
                CSVDirectDebitValidator.validateCurrency(stringArray[bl ? 8 : 7]);
            }
            if (bl4) {
                CSVDirectDebitValidator.validateCountryCode(stringArray[bl ? 9 : 8]);
                CSVDirectDebitValidator.validateAddressLine(stringArray[bl ? 10 : 9], bl7, bl8, bl9);
                CSVDirectDebitValidator.validateAddressLine(stringArray[bl ? 11 : 10], bl7, bl8, bl9);
            }
            if (bl5) {
                if (stringArray[bl ? 12 : 11] == null || stringArray[bl ? 12 : 11].isEmpty()) {
                    throw new ValidationException(ApplicationContext.get().text().getString("validation.datum.expired.user.msg"), stringArray[bl ? 12 : 11]);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
                try {
                    date2 = simpleDateFormat.parse(stringArray[bl ? 12 : 11]);
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(date2);
                    CSVDirectDebitValidator.validateExecutionsDate(gregorianCalendar);
                }
                catch (ParseException parseException) {
                    throw new ValidationException(ApplicationContext.get().text().getString("validation.datum.expired.user.msg"), stringArray[bl ? 12 : 11], parseException);
                }
            }
            if (bl6) {
                CSVDirectDebitValidator.validateDDType(stringArray[bl ? 13 : 12]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ValidationException(MessageFormat.format(ApplicationContext.get().text().getString("validation.columnNo"), stringArray.length, arrayIndexOutOfBoundsException.getMessage()), (Object)null);
        }
    }
}

