/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.parser.csv;

import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.parser.CreditTransferValidator;
import com.codecamp.sepa.parser.ParserUtils;
import com.codecamp.sepa.parser.ValidationException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class CSVCreditTransferValidator
extends CreditTransferValidator {
    public static void validateCSVLine(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14) throws ValidationException {
        int n = bl && bl2 && bl3 ? 7 : (bl && bl3 ? 6 : (bl && bl2 ? 6 : (bl || bl2 ? 5 : 4)));
        if (bl4) {
            n += 3;
        }
        if (bl6) {
            ++n;
        }
        if (bl11) {
            ++n;
        }
        if (bl12) {
            n += 3;
        }
        if (string == null || string.isEmpty() || string.replaceAll(" ", "").isEmpty()) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.row.empty"), (Object)null);
        }
        string = string.replaceAll(" ", "");
        string = string.replaceAll("\"", "");
        String[] stringArray = (string = string.replaceAll("'", "")).split(string2);
        if (stringArray.length < n) {
            throw new ValidationException(MessageFormat.format(ApplicationContext.get().text().getString("validation.columnNo"), stringArray.length, n), (Object)null);
        }
        CSVCreditTransferValidator.validateKontoinhaber(ParserUtils.removeBOM(stringArray[0]), bl8, bl9, bl10);
        if (bl5) {
            CSVCreditTransferValidator.validateText(stringArray[1], bl9, bl10);
        } else {
            CSVCreditTransferValidator.validateIBAN(stringArray[1], bl11);
        }
        if (bl) {
            CSVCreditTransferValidator.validateBIC(stringArray[2]);
        } else if (bl7) {
            CSVCreditTransferValidator.validateClrSysIdAndMmbId(stringArray[2]);
        }
        CSVCreditTransferValidator.validateVerwendungszweck(stringArray[bl ? 3 : 2], bl8, bl9, bl10, bl11, bl13);
        BigDecimal bigDecimal = null;
        if (stringArray[bl ? 4 : 3] == null || stringArray[bl ? 4 : 3].isEmpty()) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.user.msg"), stringArray[bl ? 4 : 3]);
        }
        try {
            bigDecimal = new BigDecimal(stringArray[bl ? 4 : 3].replaceAll(",", "."));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException(ApplicationContext.get().text().getString("validation.amount.number.user.msg"), stringArray[bl ? 4 : 3], numberFormatException);
        }
        CSVCreditTransferValidator.validateAmount(bigDecimal);
        try {
            if (bl2) {
                CSVCreditTransferValidator.validateIdText(stringArray[bl ? 5 : 4]);
            }
            if (bl3) {
                CSVCreditTransferValidator.validateCurrency(stringArray[bl ? 6 : 5]);
            }
            if (bl4) {
                CSVCreditTransferValidator.validateCountryCode(stringArray[bl ? 7 : 6]);
                CSVCreditTransferValidator.validateAddressLine(stringArray[bl ? 8 : 7], bl8, bl9, bl10);
                CSVCreditTransferValidator.validateAddressLine(stringArray[bl ? 9 : 8], bl8, bl9, bl10);
            }
            if (bl6) {
                if (stringArray[bl ? 10 : 9] == null || stringArray[bl ? 10 : 9].isEmpty()) {
                    throw new ValidationException(ApplicationContext.get().text().getString("validation.datum.expired.user.msg"), stringArray[bl ? 10 : 9]);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
                try {
                    Date date2 = null;
                    date2 = simpleDateFormat.parse(stringArray[bl ? 10 : 9]);
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(date2);
                    CSVCreditTransferValidator.validateExecutionsDate(gregorianCalendar);
                }
                catch (ParseException parseException) {
                    throw new ValidationException(ApplicationContext.get().text().getString("validation.datum.expired.user.msg"), stringArray[bl ? 10 : 9], parseException);
                }
            }
            if (bl11) {
                CSVCreditTransferValidator.validateAdditionalInformation(stringArray[bl ? 11 : 10], bl8, bl9, bl10);
            }
            if (bl12) {
                CSVCreditTransferValidator.validateKontoinhaberPayerFromFile(stringArray[bl ? 12 : 11], bl8, bl9, bl10);
                CSVCreditTransferValidator.validateIBANPayerFromFile(stringArray[bl ? 13 : 12]);
                CSVCreditTransferValidator.validateBICPayerFromFile(stringArray[bl ? 14 : 13]);
            }
            if (bl14) {
                CSVCreditTransferValidator.validateIdText(stringArray[bl ? 15 : 14]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ValidationException(MessageFormat.format(ApplicationContext.get().text().getString("validation.columnNo"), stringArray.length, arrayIndexOutOfBoundsException.getMessage()), (Object)null);
        }
    }
}

