/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.parser.csv;

import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPACreditTransferTransaction;
import com.codecamp.sepa.core.SEPANormalizer;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.gui.CreditParser;
import com.codecamp.sepa.parser.ParserLineResult;
import com.codecamp.sepa.parser.ParserResult;
import com.codecamp.sepa.parser.ParserUtils;
import com.codecamp.sepa.parser.ValidationException;
import com.codecamp.sepa.parser.csv.CSVCreditTransferValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSVCreditTransferParser
implements CreditParser {
    private final Logger logger = Logger.getLogger(CSVCreditTransferParser.class.getName());
    private final ParserResult parserResult = new ParserResult();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParserResult parse(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                this.logger.log(Level.INFO, "Reading line: " + (String)object);
                arrayList.add(object);
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while reading CSV file!", exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    this.logger.log(Level.SEVERE, "Exception while reading CSV file!", iOException);
                }
            }
        }
        object = new SEPACreditTransfer();
        try {
            if (arrayList == null || arrayList.size() == 0) {
                throw new ValidationException(ApplicationContext.get().text().getString("validation.row.empty"), (Object)null);
            }
            this.checkBIC((String)arrayList.get(0), ";");
            for (int i = 0; i < arrayList.size(); ++i) {
                ParserLineResult parserLineResult;
                String string = (String)arrayList.get(i);
                SEPACreditTransferTransaction sEPACreditTransferTransaction = this.parseLine(string, parserLineResult = new ParserLineResult(), ";", bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl12, bl13, bl14, bl15);
                if (sEPACreditTransferTransaction != null) {
                    sEPACreditTransferTransaction.setAmount(sEPACreditTransferTransaction.getAmount().setScale(2));
                    sEPACreditTransferTransaction.setIBAN(sEPACreditTransferTransaction.getIBAN().toUpperCase());
                    if (bl) {
                        sEPACreditTransferTransaction.setBIC(sEPACreditTransferTransaction.getBIC().toUpperCase());
                    }
                    if (bl2) {
                        sEPACreditTransferTransaction.setEnd2EndId(sEPACreditTransferTransaction.getEnd2EndId().toUpperCase());
                    }
                    if (bl4) {
                        sEPACreditTransferTransaction.setCountryCode(sEPACreditTransferTransaction.getCountryCode().toUpperCase());
                    }
                    if (bl13) {
                        sEPACreditTransferTransaction.setIBANPayerTrx(sEPACreditTransferTransaction.getIBANPayerTrx().toUpperCase());
                        sEPACreditTransferTransaction.setBICPayerTrx(sEPACreditTransferTransaction.getBICPayerTrx().toUpperCase());
                    }
                    ((SEPACreditTransfer)object).getTransactionList().add(sEPACreditTransferTransaction);
                    this.parserResult.setSuccessfull(this.parserResult.getSuccessfull() + 1);
                    this.parserResult.setSum(this.parserResult.getSum().add(sEPACreditTransferTransaction.getAmount()));
                } else {
                    this.parserResult.setNotSuccessfull(this.parserResult.getNotSuccessfull() + 1);
                }
                this.parserResult.getLineResults().add(parserLineResult);
            }
            this.parserResult.setHeaderSuccessfull(true);
        }
        catch (Exception exception) {
            this.parserResult.setHeaderSuccessfull(false);
            this.parserResult.setHeaderMessage(exception.getMessage());
            this.logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        this.parserResult.setCreditTransfer((SEPACreditTransfer)object);
        return this.parserResult;
    }

    private void checkBIC(String string, String string2) {
        try {
            String[] stringArray = string.split(string2);
            String string3 = stringArray[2].replaceAll(" ", "");
            this.parserResult.setBICFound(ParserUtils.isBIC(string3));
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while checking if BIC exists.", exception);
        }
    }

    private SEPACreditTransferTransaction parseLine(String string, ParserLineResult parserLineResult, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15) {
        SEPACreditTransferTransaction sEPACreditTransferTransaction = null;
        try {
            CSVCreditTransferValidator.validateCSVLine(string, string2, bl && !bl7, bl2, bl3, bl4, bl5 || bl7 || bl8, bl6, bl7, bl9, bl10, bl11, bl12, bl13, bl14, bl15);
            sEPACreditTransferTransaction = new SEPACreditTransferTransaction();
            string = string.replaceAll("\"", "");
            string = string.replaceAll("'", "");
            String[] stringArray = string.split(string2);
            sEPACreditTransferTransaction.setKontoinhaber(ParserUtils.removeBOM(stringArray[0]));
            sEPACreditTransferTransaction.setIBAN(stringArray[1].replaceAll(" ", ""));
            if (bl) {
                if (bl7) {
                    sEPACreditTransferTransaction.setBIC(stringArray[2]);
                } else {
                    sEPACreditTransferTransaction.setBIC(stringArray[2].replaceAll(" ", ""));
                }
            }
            sEPACreditTransferTransaction.setVerwendungszweck(stringArray[bl ? 3 : 2].replaceAll(string2, "").trim());
            sEPACreditTransferTransaction.setAmount(new BigDecimal(stringArray[bl ? 4 : 3].replaceAll(",", ".").trim()));
            if (bl2) {
                sEPACreditTransferTransaction.setEnd2EndId(stringArray[bl ? 5 : 4].replaceAll(" ", ""));
            }
            if (bl3) {
                sEPACreditTransferTransaction.setCurrency(stringArray[bl ? 6 : 5].replaceAll(" ", ""));
            }
            if (bl4) {
                sEPACreditTransferTransaction.setCountryCode(stringArray[bl ? 7 : 6].replaceAll(" ", ""));
                sEPACreditTransferTransaction.setAddressLine1(stringArray[bl ? 8 : 7]);
                sEPACreditTransferTransaction.setAddressLine2(stringArray[bl ? 9 : 8]);
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
            if (bl6) {
                try {
                    Date date2 = simpleDateFormat.parse(stringArray[bl ? 10 : 9].replaceAll(" ", ""));
                    gregorianCalendar.setTime(date2);
                }
                catch (ParseException parseException) {
                    this.logger.log(Level.SEVERE, "Exception while Parsing date (executionDate): " + stringArray[bl ? 10 : 9], parseException);
                }
                sEPACreditTransferTransaction.setExecutionDate(gregorianCalendar);
            }
            if (bl12) {
                sEPACreditTransferTransaction.setAdditionalInformation(stringArray[bl ? 11 : 10]);
            }
            if (bl13) {
                sEPACreditTransferTransaction.setKontoinhaberPayerTrx(stringArray[bl ? 12 : 11]);
                sEPACreditTransferTransaction.setIBANPayerTrx(stringArray[bl ? 13 : 12].replaceAll(" ", ""));
                sEPACreditTransferTransaction.setBICPayerTrx(stringArray[bl ? 14 : 13].replaceAll(" ", ""));
            }
            if (bl15) {
                sEPACreditTransferTransaction.setRegulatoryReportingCode(stringArray[bl ? 15 : 14]);
            }
            if (bl9) {
                sEPACreditTransferTransaction.setKontoinhaber(SEPANormalizer.normalize(sEPACreditTransferTransaction.getKontoinhaber()));
                sEPACreditTransferTransaction.setVerwendungszweck(SEPANormalizer.normalize(sEPACreditTransferTransaction.getVerwendungszweck()));
                if (sEPACreditTransferTransaction.getAddressLine1() != null) {
                    sEPACreditTransferTransaction.setAddressLine1(SEPANormalizer.normalize(sEPACreditTransferTransaction.getAddressLine1()));
                }
                if (sEPACreditTransferTransaction.getAddressLine2() != null) {
                    sEPACreditTransferTransaction.setAddressLine2(SEPANormalizer.normalize(sEPACreditTransferTransaction.getAddressLine2()));
                }
            }
            if (bl9 && sEPACreditTransferTransaction.getAdditionalInformation() != null) {
                sEPACreditTransferTransaction.setAdditionalInformation(SEPANormalizer.normalize(sEPACreditTransferTransaction.getAdditionalInformation()));
            }
            if (bl13 && bl9) {
                sEPACreditTransferTransaction.setKontoinhaberPayerTrx(SEPANormalizer.normalize(sEPACreditTransferTransaction.getKontoinhaberPayerTrx()));
            }
            parserLineResult.setSucessfull(true);
            parserLineResult.setLineMessage(ParserUtils.removeBOM(stringArray[0]) + ", " + stringArray[1].replaceAll(" ", "") + ", " + stringArray[2].replaceAll(" ", "") + ", " + stringArray[3] + (bl ? ", " + stringArray[4] : "") + (bl2 ? ", " + stringArray[bl ? 5 : 4] : "") + (bl3 ? ", " + stringArray[bl ? 6 : 5] : "") + (bl4 ? ", " + stringArray[bl ? 7 : 6] + ", " + stringArray[bl ? 8 : 7] + ", " + stringArray[bl ? 9 : 8] : "") + (bl6 ? ", " + stringArray[bl ? 10 : 9] : "") + (bl12 ? ", " + stringArray[bl ? 11 : 10] : "") + (bl13 ? ", " + stringArray[bl ? 12 : 11] : "") + (bl13 ? ", " + stringArray[bl ? 13 : 12] : "") + (bl13 ? ", " + stringArray[bl ? 14 : 13] : "") + (bl15 ? ", " + stringArray[bl ? 15 : 14] : ""));
        }
        catch (ValidationException validationException) {
            parserLineResult.setSucessfull(false);
            parserLineResult.setLineMessage(validationException.getMessage() + (validationException.getNotValidatingValue() != null ? " (" + validationException.getNotValidatingValue() + ")" : ""));
            this.logger.log(Level.WARNING, parserLineResult.getLineMessage(), validationException);
        }
        catch (Exception exception) {
            parserLineResult.setSucessfull(false);
            parserLineResult.setLineMessage(exception.getMessage());
            this.logger.log(Level.WARNING, parserLineResult.getLineMessage(), exception);
        }
        return sEPACreditTransferTransaction;
    }
}

