/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.parser;

import com.codecamp.sepa.core.SEPAValidator;
import com.codecamp.sepa.parser.ValidationException;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParserUtils {
    private static final Logger logger = Logger.getLogger(ParserUtils.class.getName());

    public static boolean isExample(String string) {
        boolean bl = false;
        if ("Max Mustermann".equals(string)) {
            bl = true;
        } else if ("John Doe".equals(string)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isHeader(String string) {
        boolean bl = false;
        if ("Kontoinhaber".equals(string)) {
            bl = true;
        } else if ("Account holder".equals(string)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isExampleBIC(String string) {
        return "ABCDEFGH123".equals(string);
    }

    public static boolean isHeaderBIC(String string) {
        return "BIC".equals(string);
    }

    public static boolean isBIC(String string) {
        try {
            SEPAValidator.validateBIC(string);
        }
        catch (ValidationException validationException) {
            logger.log(Level.INFO, "This presumably not a BIC.");
            return false;
        }
        return true;
    }

    public static String formatDateForLog(GregorianCalendar gregorianCalendar) {
        return gregorianCalendar.get(1) + "-" + (gregorianCalendar.get(2) + 1) + "-" + gregorianCalendar.get(5);
    }

    public static BigDecimal formatBigDecimalForLog(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2);
    }

    public static String removeBOM(String string) {
        String string2 = string;
        return string2.replace("\uefbbBF", "").replace("\ufffe", "").replace("\ufeff", "").replace("\u00ef\u00bb\u00bf", "").replace("\u00ff\u00fe", "").replace("\u00fe\u00ff", "");
    }
}

