/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui.verifier;

import com.codecamp.sepa.core.SEPAValidator;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.gui.ErrorMessages;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.gui.VerificationStateCallback;
import com.codecamp.sepa.gui.verifier.NotNullVerifier;
import com.codecamp.sepa.parser.ValidationException;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;

public class NotNullGlaeubigerIdVerifier
extends NotNullVerifier {
    private boolean conditionalNotStrict;

    public NotNullGlaeubigerIdVerifier(JComponent jComponent, FieldType fieldType, VerificationStateCallback verificationStateCallback, ErrorMessages errorMessages, boolean bl) {
        super(jComponent, fieldType, verificationStateCallback, errorMessages);
        this.conditionalNotStrict = bl;
    }

    @Override
    public boolean verify(JComponent jComponent) {
        boolean bl = super.verify(jComponent);
        if (bl) {
            try {
                if (this.conditionalNotStrict) {
                    if (StringUtils.trimToNull(this.txt) == null) {
                        throw new ValidationException(ApplicationContext.get().text().getString("pleaseFillIn"), this.txt);
                    }
                } else {
                    SEPAValidator.validateGlaeubigerId(this.txt);
                }
                this.resetMessage();
            }
            catch (ValidationException validationException) {
                this.setErrorMessage(validationException.getMessage());
                bl = false;
            }
        }
        this.callback.toggleVerificationState(this.fieldType, bl);
        return bl;
    }

    public boolean isConditionalNotStrict() {
        return this.conditionalNotStrict;
    }

    public void setConditionalNotStrict(boolean bl) {
        this.conditionalNotStrict = bl;
    }
}

