/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui.verifier;

import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.gui.ErrorMessages;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.gui.VerificationStateCallback;
import com.codecamp.sepa.gui.verifier.NotNullVerifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;

public class NotNullDateTodayOrInFutureVerifier
extends NotNullVerifier {
    public NotNullDateTodayOrInFutureVerifier(JComponent jComponent, FieldType fieldType, VerificationStateCallback verificationStateCallback, ErrorMessages errorMessages) {
        super(jComponent, fieldType, verificationStateCallback, errorMessages);
    }

    @Override
    public boolean verify(JComponent jComponent) {
        boolean bl;
        block7: {
            bl = super.verify(jComponent);
            if (bl) {
                this.correctDateInput(jComponent);
                if (this.txt.matches(ApplicationContext.get().text().getString("datePatternRegex"))) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
                    Date date2 = null;
                    try {
                        date2 = simpleDateFormat.parse(StringUtils.trimToNull(this.txt));
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(14, 0);
                        calendar.set(13, 0);
                        calendar.set(12, 0);
                        calendar.set(10, 0);
                        calendar.set(11, 0);
                        Date date3 = calendar.getTime();
                        if (!date2.after(date3) && !date2.equals(date3)) {
                            this.setErrorMessage(ApplicationContext.get().text().getString("validation.datum.expired.user.msg"));
                            bl = false;
                            break block7;
                        }
                        if (date2.equals(date3)) {
                            this.setWarningMessage(ApplicationContext.get().text().getString("validation.datum.today.user.msg"));
                            break block7;
                        }
                        this.resetMessage();
                    }
                    catch (ParseException parseException) {
                        this.setErrorMessage(ApplicationContext.get().text().getString("validation.datum.user.msg"));
                        bl = false;
                    }
                } else {
                    this.setErrorMessage(ApplicationContext.get().text().getString("validation.datum.user.msg"));
                    bl = false;
                }
            }
        }
        this.callback.toggleVerificationState(this.fieldType, bl);
        return bl;
    }

    private void correctDateInput(JComponent jComponent) {
        Object object;
        String[] stringArray = this.txt.split("\\.");
        if (stringArray.length == 3) {
            if (stringArray[0].length() == 1) {
                stringArray[0] = "0" + stringArray[0];
            }
            if (stringArray[1].length() == 1) {
                stringArray[1] = "0" + stringArray[1];
            }
            if (stringArray[2].length() == 2) {
                stringArray[2] = "20" + stringArray[2];
            }
            this.txt = stringArray[0] + "." + stringArray[1] + "." + stringArray[2];
            object = (JTextField)jComponent;
            ((JTextComponent)object).setText(this.txt);
        }
        if (((String[])(object = this.txt.split("-"))).length == 3) {
            if (object[0].length() == 2) {
                object[0] = "20" + object[0];
            }
            if (object[1].length() == 1) {
                object[1] = "0" + object[1];
            }
            if (object[2].length() == 1) {
                object[2] = "0" + object[2];
            }
            this.txt = object[0] + "-" + object[1] + "-" + object[2];
            JTextField jTextField = (JTextField)jComponent;
            jTextField.setText(this.txt);
        }
    }
}

