/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.CreditTransferSubformat;
import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPAWriter;
import com.codecamp.sepa.core.ServiceLevel;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.gui.CreditParser;
import com.codecamp.sepa.gui.CreditTransferParserFactory;
import com.codecamp.sepa.gui.ErrorMessages;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.gui.SEPAApp;
import com.codecamp.sepa.gui.SEPAVerificationStateCallback;
import com.codecamp.sepa.gui.SepaTab;
import com.codecamp.sepa.gui.UeberweisungAccountDialog;
import com.codecamp.sepa.gui.UeberweisungVerificationStateCallback;
import com.codecamp.sepa.gui.UeberweisungenOptionsDialog;
import com.codecamp.sepa.gui.verifier.NotNullBICVerifier;
import com.codecamp.sepa.gui.verifier.NotNullDateTodayOrInFutureVerifier;
import com.codecamp.sepa.gui.verifier.NotNullIBANVerifier;
import com.codecamp.sepa.gui.verifier.NotNullKontoinhaberVerifier;
import com.codecamp.sepa.gui.verifier.SaveOnlyVerifier;
import com.codecamp.sepa.gui.verifier.TypedSaveOnlyVerifier;
import com.codecamp.sepa.parser.ParserLineResult;
import com.codecamp.sepa.parser.ParserResult;
import com.codecamp.sepa.parser.ParserUtils;
import com.codecamp.sepa.report.SEPAReport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang3.StringUtils;

public class UeberweisungenTab
extends SepaTab {
    private static final long serialVersionUID = 1L;
    protected JLabel uploadLabel = new JLabel(ApplicationContext.get().text().getString("noFileSelected"));
    protected JButton uploadBtn;
    private JLabel kontoinhaber;
    private JTextField kontoinhaberField;
    private JLabel iban;
    private JTextField ibanField;
    private JLabel bic;
    private JTextField bicField;
    private JLabel ausfuehrungsdatumLabel;
    private JTextField ausfuehrungsdatumField;
    private JLabel importBICLabel;
    private JCheckBox importBICCheckbox;
    private JLabel subformatLabel;
    private JComboBox<CreditTransferSubformat> subformatComboBox;
    private SEPACreditTransfer credit;
    private JLabel errorLabel;
    private ErrorMessages errorMessages;
    private JButton optionsButton;
    private JButton openAccountDialog;
    private JButton openManual;
    private JButton openFAQ;
    private JButton openSupportEMail;
    private final UeberweisungVerificationStateCallback callback = new UeberweisungVerificationStateCallback(this.downloadButton);
    SEPAPreferences preferences = new SEPAPreferences();

    public UeberweisungenTab(StyledDocument styledDocument, JButton jButton) {
        super(styledDocument, jButton);
        this.init();
    }

    private void init() {
        SEPAPreferences sEPAPreferences = new SEPAPreferences();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{28, 28, 28, 28, 0};
        gridBagLayout.rowHeights = new int[]{28, 28, 28, 28, 0, 28, 28, 28};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.setLayout(gridBagLayout);
        this.kontoinhaber = new JLabel(ApplicationContext.get().text().getString("accountHolder"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.kontoinhaber, gridBagConstraints);
        this.kontoinhaberField = new JTextField();
        this.kontoinhaberField.setColumns(10);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        this.add((Component)this.kontoinhaberField, gridBagConstraints2);
        this.kontoinhaberField.setText(sEPAPreferences.loadPreference(FieldType.KONTOINHABER_UEBERWEISUNG.name()));
        this.kontoinhaberField.setComponentPopupMenu(UeberweisungenTab.getCopyCutPasteMenu());
        this.openAccountDialog = new JButton(ApplicationContext.get().text().getString("ueberweisungenTab.openAccountDialog"));
        this.openAccountDialog.setToolTipText(ApplicationContext.get().text().getString("ueberweisungenTab.chooseAccountDialogTooltip"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.gridy = 0;
        this.add((Component)this.openAccountDialog, gridBagConstraints3);
        this.openAccountDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new UeberweisungAccountDialog(UeberweisungenTab.this.kontoinhaberField, UeberweisungenTab.this.ibanField, UeberweisungenTab.this.bicField);
                UeberweisungenTab.this.kontoinhaberField.getInputVerifier().verify(UeberweisungenTab.this.kontoinhaberField);
                UeberweisungenTab.this.ibanField.getInputVerifier().verify(UeberweisungenTab.this.ibanField);
                UeberweisungenTab.this.bicField.getInputVerifier().verify(UeberweisungenTab.this.bicField);
            }
        });
        this.iban = new JLabel("IBAN");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        this.add((Component)this.iban, gridBagConstraints4);
        this.ibanField = new JTextField();
        this.ibanField.setColumns(10);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.anchor = 11;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 1;
        this.add((Component)this.ibanField, gridBagConstraints5);
        this.ibanField.setText(sEPAPreferences.loadPreference(FieldType.IBAN_UEBERWEISUNG.name()));
        this.ibanField.setComponentPopupMenu(UeberweisungenTab.getCopyCutPasteMenu());
        this.bic = new JLabel("BIC");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.anchor = 13;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 2;
        this.add((Component)this.bic, gridBagConstraints6);
        this.bicField = new JTextField();
        this.bicField.setColumns(10);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.anchor = 11;
        gridBagConstraints7.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints7.gridx = 2;
        gridBagConstraints7.gridy = 2;
        this.add((Component)this.bicField, gridBagConstraints7);
        this.bicField.setText(sEPAPreferences.loadPreference(FieldType.BIC_UEBERWEISUNG.name()));
        this.bicField.setComponentPopupMenu(UeberweisungenTab.getCopyCutPasteMenu());
        this.ausfuehrungsdatumLabel = new JLabel(ApplicationContext.get().text().getString("ueberweisungenTab.ausfuehrungesdatum"));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.anchor = 13;
        gridBagConstraints8.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 3;
        this.add((Component)this.ausfuehrungsdatumLabel, gridBagConstraints8);
        this.ausfuehrungsdatumField = new JTextField();
        this.ausfuehrungsdatumField.setToolTipText(ApplicationContext.get().text().getString("ueberweisungenTab.ausfuehrungesdatum.tooltip"));
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints9.anchor = 11;
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.gridx = 2;
        gridBagConstraints9.gridy = 3;
        this.add((Component)this.ausfuehrungsdatumField, gridBagConstraints9);
        this.ausfuehrungsdatumField.setColumns(10);
        this.ausfuehrungsdatumField.setText(sEPAPreferences.loadPreference(FieldType.AUSFUEHRUNGSDATUM_UEBERWEISUNG.name()));
        this.ausfuehrungsdatumField.setComponentPopupMenu(UeberweisungenTab.getCopyCutPasteMenu());
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.anchor = 13;
        gridBagConstraints10.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.gridy = 4;
        this.add((Component)this.uploadLabel, gridBagConstraints10);
        this.uploadBtn = new JButton(ApplicationContext.get().text().getString("selectFile"));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints11.gridx = 2;
        gridBagConstraints11.gridy = 4;
        this.add((Component)this.uploadBtn, gridBagConstraints11);
        this.uploadBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                UeberweisungenTab.this.doOpenFileDialog();
            }
        });
        this.importBICLabel = new JLabel(ApplicationContext.get().text().getString("ueberweisungenTab.noBIC"));
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.anchor = 13;
        gridBagConstraints12.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints12.gridx = 1;
        gridBagConstraints12.gridy = 5;
        this.add((Component)this.importBICLabel, gridBagConstraints12);
        this.importBICCheckbox = new JCheckBox();
        this.importBICCheckbox.setSelected(sEPAPreferences.loadPreference(FieldType.IMPORTBIC_UEBERWEISUNG.name(), false));
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.gridx = 2;
        gridBagConstraints13.gridy = 5;
        this.add((Component)this.importBICCheckbox, gridBagConstraints13);
        this.subformatLabel = new JLabel(ApplicationContext.get().text().getString("ueberweisungenTab.subformat"));
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.anchor = 13;
        gridBagConstraints14.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints14.gridx = 1;
        gridBagConstraints14.gridy = 6;
        this.add((Component)this.subformatLabel, gridBagConstraints14);
        this.subformatComboBox = new JComboBox<CreditTransferSubformat>(CreditTransferSubformat.values());
        String string = sEPAPreferences.loadPreference(FieldType.SUBFORMAT_UEBERWEISUNG.name());
        this.subformatComboBox.setSelectedItem((Object)(string != null ? CreditTransferSubformat.valueOf(string) : CreditTransferSubformat.getDefaultByCountry(Locale.getDefault())));
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.gridx = 2;
        gridBagConstraints15.gridy = 6;
        this.add(this.subformatComboBox, gridBagConstraints15);
        this.optionsButton = new JButton(ApplicationContext.get().text().getString("ueberweisungenTab.options"));
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints16.fill = 11;
        gridBagConstraints16.gridx = 2;
        gridBagConstraints16.gridy = 7;
        this.add((Component)this.optionsButton, gridBagConstraints16);
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new UeberweisungenOptionsDialog(UeberweisungenTab.this.kontoinhaberField, UeberweisungenTab.this.ibanField, UeberweisungenTab.this.bicField, UeberweisungenTab.this.ausfuehrungsdatumField, UeberweisungenTab.this.importBICCheckbox, UeberweisungenTab.this.subformatComboBox, UeberweisungenTab.this.centerTextPanelDocument, UeberweisungenTab.this.logPanelStyle);
            }
        });
        this.openManual = new JButton(ApplicationContext.get().text().getString("ueberweisungenTab.openManual"));
        this.openManual.setToolTipText(ApplicationContext.get().text().getString("ueberweisungenTab.openManualTooltip"));
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints17.fill = 2;
        gridBagConstraints17.gridx = 3;
        gridBagConstraints17.gridy = 7;
        this.add((Component)this.openManual, gridBagConstraints17);
        this.openManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SEPAApp.openWebpage(new URL(ApplicationContext.get().text().getString("manualURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    UeberweisungenTab.this.logger.log(Level.WARNING, "Could not open connection to www.sepaapp.eu", exception);
                }
            }
        });
        this.openFAQ = new JButton(ApplicationContext.get().text().getString("ueberweisungenTab.openFAQ"));
        this.openFAQ.setToolTipText(ApplicationContext.get().text().getString("ueberweisungenTab.openFAQTooltip"));
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints18.fill = 2;
        gridBagConstraints18.gridx = 4;
        gridBagConstraints18.gridy = 7;
        this.add((Component)this.openFAQ, gridBagConstraints18);
        this.openFAQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SEPAApp.openWebpage(new URL(ApplicationContext.get().text().getString("faqURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    UeberweisungenTab.this.logger.log(Level.WARNING, "Could not open connection to www.sepaapp.eu", exception);
                }
            }
        });
        this.openSupportEMail = new JButton(ApplicationContext.get().text().getString("ueberweisungenTab.openSupportEMail"));
        this.openSupportEMail.setToolTipText(ApplicationContext.get().text().getString("lastschriftenTab.openSupportEMailTooltip"));
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints19.fill = 2;
        gridBagConstraints19.gridx = 3;
        gridBagConstraints19.gridy = 8;
        this.add((Component)this.openSupportEMail, gridBagConstraints19);
        this.openSupportEMail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SEPAApp.openWebpage(new URL(ApplicationContext.get().text().getString("supportEMailURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    UeberweisungenTab.this.logger.log(Level.WARNING, "Could not open connection to www.sepaapp.eu", exception);
                }
            }
        });
        this.errorLabel = new JLabel("");
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints20.gridx = 2;
        gridBagConstraints20.gridy = 8;
        this.add((Component)this.errorLabel, gridBagConstraints20);
        this.errorMessages = new ErrorMessages(this.errorLabel);
        NotNullKontoinhaberVerifier notNullKontoinhaberVerifier = new NotNullKontoinhaberVerifier(this.kontoinhaberField, FieldType.KONTOINHABER_UEBERWEISUNG, this.callback, this.errorMessages);
        NotNullIBANVerifier notNullIBANVerifier = new NotNullIBANVerifier(this.ibanField, FieldType.IBAN_UEBERWEISUNG, this.callback, this.errorMessages, sEPAPreferences.loadPreference(FieldType.USE_BANKGIRO_UEBERWEISUNG.name(), false) || sEPAPreferences.loadPreference(FieldType.ACCOUNT_NO_INSTEAD_OF_IBAN_GUI_UEBERWEISUNG.name(), false));
        NotNullBICVerifier notNullBICVerifier = new NotNullBICVerifier(this.bicField, FieldType.BIC_UEBERWEISUNG, this.callback, this.errorMessages, sEPAPreferences.loadPreference(FieldType.USE_BANKGIRO_UEBERWEISUNG.name(), false), false, false);
        NotNullDateTodayOrInFutureVerifier notNullDateTodayOrInFutureVerifier = new NotNullDateTodayOrInFutureVerifier(this.ausfuehrungsdatumField, FieldType.AUSFUEHRUNGSDATUM_UEBERWEISUNG, this.callback, this.errorMessages);
        SaveOnlyVerifier saveOnlyVerifier = new SaveOnlyVerifier(this.importBICCheckbox, FieldType.IMPORTBIC_UEBERWEISUNG);
        TypedSaveOnlyVerifier typedSaveOnlyVerifier = new TypedSaveOnlyVerifier(this.subformatComboBox, FieldType.SUBFORMAT_UEBERWEISUNG);
        this.kontoinhaberField.setInputVerifier(notNullKontoinhaberVerifier);
        this.ibanField.setInputVerifier(notNullIBANVerifier);
        this.bicField.setInputVerifier(notNullBICVerifier);
        this.ausfuehrungsdatumField.setInputVerifier(notNullDateTodayOrInFutureVerifier);
        this.importBICCheckbox.setInputVerifier(saveOnlyVerifier);
        this.subformatComboBox.setInputVerifier(typedSaveOnlyVerifier);
        ((InputVerifier)notNullKontoinhaberVerifier).verify(this.kontoinhaberField);
        ((InputVerifier)notNullIBANVerifier).verify(this.ibanField);
        ((InputVerifier)notNullBICVerifier).verify(this.bicField);
        ((InputVerifier)notNullDateTodayOrInFutureVerifier).verify(this.ausfuehrungsdatumField);
        ((InputVerifier)saveOnlyVerifier).verify(this.importBICCheckbox);
        ((InputVerifier)typedSaveOnlyVerifier).verify(this.subformatComboBox);
        if (!sEPAPreferences.hasValidProLicense() && sEPAPreferences.hasEvaluationPeriodExpired()) {
            this.openAccountDialog.setEnabled(Boolean.FALSE);
        }
    }

    protected void getGuiValues() {
        Object object;
        this.credit.setKontoinhaber(StringUtils.trimToNull(this.kontoinhaberField.getText()));
        if (this.preferences.loadPreference(FieldType.USE_BANKGIRO_UEBERWEISUNG.name(), false)) {
            this.credit.setIBAN(StringUtils.trimToNull(this.ibanField.getText()).toUpperCase());
            this.credit.setBIC(StringUtils.trimToNull(this.bicField.getText()).toUpperCase());
        } else {
            this.credit.setIBAN(StringUtils.trimToNull(this.ibanField.getText()).replace(" ", "").toUpperCase());
            this.credit.setBIC(StringUtils.trimToNull(this.bicField.getText()).replace(" ", "").toUpperCase());
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
        try {
            object = simpleDateFormat.parse(StringUtils.trimToNull(this.ausfuehrungsdatumField.getText()));
            gregorianCalendar.setTime((Date)object);
        }
        catch (ParseException parseException) {
            this.logger.log(Level.SEVERE, "Exception while Parsing date (ExecutionDate): " + this.ausfuehrungsdatumField.getText(), parseException);
        }
        this.credit.setExecutionDate(gregorianCalendar);
        this.credit.setSubformat((CreditTransferSubformat)((Object)this.subformatComboBox.getSelectedItem()));
        this.credit.setCategoryPurpose(this.preferences.loadPreference(FieldType.CATEGORY_PURPOSE_UEBERWEISUNG.name()) != null ? CategoryPurpose.valueOf(this.preferences.loadPreference(FieldType.CATEGORY_PURPOSE_UEBERWEISUNG.name())) : CategoryPurpose.EMPTY);
        this.credit.setIdentificationID(this.preferences.loadPreference(FieldType.SPANISH_NUMBER_UEBERWEISUNG.name()));
        this.credit.setIdentIdOrg(this.preferences.loadPreference(FieldType.USE_ORG_ID_UEBERWEISUNG.name(), false));
        this.credit.setIdentIdPrv(this.preferences.loadPreference(FieldType.USE_PRV_ID_UEBERWEISUNG.name(), true));
        this.credit.setGenerateEnd2EndId(this.preferences.loadPreference(FieldType.GENERATE_END2END_ID_UEBERWEISUNG.name(), true));
        this.credit.setEnd2EndIdFromFile(this.preferences.loadPreference(FieldType.END2END_ID_FROM_FILE_UEBERWEISUNG.name(), false));
        this.credit.setEnd2EndId(this.preferences.loadPreference(FieldType.END2ENDID_UEBERWEISUNG.name()));
        this.credit.setBatchBooking(this.preferences.loadPreference(FieldType.BATCH_BOOKING_SELECT_UEBERWEISUNG.name()) != null ? BatchBooking.valueOf(this.preferences.loadPreference(FieldType.BATCH_BOOKING_SELECT_UEBERWEISUNG.name())) : BatchBooking.EMPTY);
        this.credit.setSetDebitorCurrency(this.preferences.loadPreference(FieldType.DEBITOR_CURRENCY_UEBERWEISUNG.name(), false));
        this.credit.setUseFastCreditTransfer(this.preferences.loadPreference(FieldType.FAST_CREDIT_TRANSFER_UEBERWEISUNG.name(), false));
        this.credit.setSetTxNo(this.preferences.loadPreference(FieldType.TX_NO_UEBERWEISUNG.name(), false));
        this.credit.setUsePIIforEachTrx(this.preferences.loadPreference(FieldType.PII_FOR_EACH_TRX_UEBERWEISUNG.name(), false));
        this.credit.setNationalPayment(this.preferences.loadPreference(FieldType.NATIONAL_PAYMENT_UEBERWEISUNG.name(), false));
        this.credit.setSetLocalInstrumentCore(this.preferences.loadPreference(FieldType.SET_LOCAL_INTRUMENT_CORE_UEBERWEISUNG.name(), false));
        this.credit.setCurrency(StringUtils.upperCase(this.preferences.loadPreference(FieldType.CURRENCY_UEBERWEISUNG.name(), "EUR")));
        this.credit.setChargeBearer(this.preferences.loadPreference(FieldType.CHARGEBEARER_UEBERWEISUNG.name()) != null ? ChargeBearer.valueOf(this.preferences.loadPreference(FieldType.CHARGEBEARER_UEBERWEISUNG.name())) : ChargeBearer.EMPTY);
        this.credit.setPmtInfId(this.preferences.loadPreference(FieldType.PMTID_UEBERWEISUNG.name()));
        this.credit.setUseESRKtoNo(this.preferences.loadPreference(FieldType.USE_ESR_KTONO_UEBERWEISUNG.name(), false));
        this.credit.setUseESRReferenceNo(this.preferences.loadPreference(FieldType.USE_ESR_REFNO_UEBERWEISUNG.name(), false));
        this.credit.setExecutionDateFromFile(this.preferences.loadPreference(FieldType.IMPORT_EXECUTIONDATE_FROM_FILE_UEBERWEISUNG.name(), false));
        this.credit.setXmlHeaderWithSchemaLocation(this.preferences.loadPreference(FieldType.XML_HEADER_WITH_SCHEMA_LOCATION_UEBERWEISUNG.name(), false));
        this.credit.setUseBankgiro(this.preferences.loadPreference(FieldType.USE_BANKGIRO_UEBERWEISUNG.name(), false));
        this.credit.setUseSCOR(this.preferences.loadPreference(FieldType.USE_SCOR_UEBERWEISUNG.name(), false));
        this.credit.setPaymentTypeInformationOnTrxLevel(this.preferences.loadPreference(FieldType.PAYMENT_TYPE_INFORMATION_ON_TRX_LEVEL_UEBERWEISUNG.name(), false));
        this.credit.setInstantCT(this.preferences.loadPreference(FieldType.IS_INSTANT_CT_UEBERWEISUNG.name(), false));
        this.credit.setAccountNoInsteadOfIBAN(this.preferences.loadPreference(FieldType.ACCOUNT_NO_INSTEAD_OF_IBAN_UEBERWEISUNG.name(), false));
        this.credit.setServiceLevel(this.preferences.loadPreference(FieldType.SERVICE_LEVEL_UEBERWEISUNG.name()) != null ? ServiceLevel.valueOf(this.preferences.loadPreference(FieldType.SERVICE_LEVEL_UEBERWEISUNG.name())) : ServiceLevel.SEPA);
        this.credit.setQrRechnung(this.preferences.loadPreference(FieldType.QR_RECHNUNG_UEBERWEISUNG.name(), false));
        this.credit.setPayerFromFile(this.preferences.loadPreference(FieldType.PAYERFROMFILE_UEBERWEISUNG.name(), false));
        this.credit.setSwiftConf(this.preferences.loadPreference(FieldType.SWIFTCONF_UEBERWEISUNG.name(), false));
        this.credit.setAccountNoInsteadOfIBANGUI(this.preferences.loadPreference(FieldType.ACCOUNT_NO_INSTEAD_OF_IBAN_GUI_UEBERWEISUNG.name(), false));
        object = this.preferences.loadPreference(FieldType.COUNTRY_CODE_UEBERWEISUNG.name(), null);
        if (object != null && !((String)object).isEmpty()) {
            this.credit.setCountryCode(StringUtils.upperCase((String)object));
        }
        this.credit.setSplitPayment(this.preferences.loadPreference(FieldType.SPLIT_PAYMENT_UEBERWEISUNG.name(), false));
        this.credit.setNameInInitParty(this.preferences.loadPreference(FieldType.NAME_IN_INITPRTY_UEBERWEISUNG.name(), true));
        this.credit.setAddressLine1(this.preferences.loadPreference(FieldType.ADDRESSLINE1_UEBERWEISUNG.name()));
        this.credit.setAddressLine2(this.preferences.loadPreference(FieldType.ADDRESSLINE2_UEBERWEISUNG.name()));
        this.credit.setAddSoftwareNameAndVendor(this.preferences.loadPreference(FieldType.ADD_SOFTWARE_NAME_AND_VENDOR_UEBERWEISUNG.name(), false));
        this.credit.setAddCountryCodeFromIBANToBIC(this.preferences.loadPreference(FieldType.ADD_COUNTRY_CODE_FROM_IBAN_TO_BIC_UEBERWEISUNG.name(), false));
        this.credit.setUseStructuredAddress(this.preferences.loadPreference(FieldType.USE_STRUCTURED_ADDRESS_UEBERWEISUNG.name(), false));
        String string = this.preferences.loadPreference(FieldType.REGULATORY_REPORT_CODE_UEBERWEISUNG.name(), null);
        if (string != null && !string.isEmpty()) {
            this.credit.setRegulatoryReportingCode(string);
        }
        this.credit.setRegulatoryReportingCodeFromFile(this.preferences.loadPreference(FieldType.REGULATORY_REPORT_CODE_FROM_FILE_UEBERWEISUNG.name(), false));
        ApplicationContext.get().setUseTimeZoneFor001(this.preferences.loadPreference(FieldType.USE_TZ_001_UEBERWEISUNG.name(), true));
    }

    @Override
    protected void doOpenFile(Path path) {
        this.logger.finest("+doOpenFile");
        try {
            this.downloadButton.setEnabled(Boolean.FALSE);
            this.uploadLabel.setText(path.toFile().getName());
            Locale locale = Locale.getDefault();
            String string = locale.getCountry();
            CreditParser creditParser = CreditTransferParserFactory.create(path);
            ParserResult parserResult = creditParser.parse(path.toFile(), this.importBICCheckbox.isSelected(), this.preferences.loadPreference(FieldType.END2END_ID_FROM_FILE_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.CURRENCY_FROM_FILE_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.ADDRESS_FROM_FILE_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.USE_ESR_KTONO_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.IMPORT_EXECUTIONDATE_FROM_FILE_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.USE_BANKGIRO_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.ACCOUNT_NO_INSTEAD_OF_IBAN_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.NORMALIZE_UEBERWEISUNG.name(), !"DE".equals(string) || !"AT".equals(string)), this.preferences.loadPreference(FieldType.UMLAUTS_UEBERWEISUNG.name(), "DE".equals(string) || "AT".equals(string)), this.preferences.loadPreference(FieldType.SPECIAL_CHARACTERS_CH_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.QR_RECHNUNG_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.PAYERFROMFILE_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.SPLIT_PAYMENT_UEBERWEISUNG.name(), false), this.preferences.loadPreference(FieldType.REGULATORY_REPORT_CODE_FROM_FILE_UEBERWEISUNG.name(), false));
            this.credit = parserResult.getCreditTransfer();
            this.writeLogLine(this.uploadLabel.getText(), this.logPanelStyle.getRegularStyle());
            this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
            int n = 0;
            for (ParserLineResult parserLineResult : parserResult.getLineResults()) {
                this.logger.log(Level.FINEST, String.format("Parsing %s", parserLineResult.getLineMessage()));
                ++n;
                if (parserLineResult.isSucessfull()) {
                    this.writeLogLine(parserLineResult.getLineMessage(), this.logPanelStyle.getIconOkStyle());
                    this.writeLogLine(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n + (parserResult.getStartingRow() > 0 ? " (" + ApplicationContext.get().text().getString("row") + " " + (n + parserResult.getStartingRow()) + ")" : "") + " - " + parserLineResult.getLineMessage(), this.logPanelStyle.getRegularStyle());
                    continue;
                }
                this.writeLogLine(parserLineResult.getLineMessage(), this.logPanelStyle.getIconErrorStyle());
                this.writeLogLine(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n + (parserResult.getStartingRow() > 0 ? " (" + ApplicationContext.get().text().getString("row") + " " + (n + parserResult.getStartingRow()) + ")" : "") + " - " + parserLineResult.getLineMessage(), this.logPanelStyle.getErrorStyle());
            }
            this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("successfullyImported") + parserResult.getSuccessfull() + ", " + ApplicationContext.get().text().getString("sumImported") + ParserUtils.formatBigDecimalForLog(parserResult.getSum()), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("errorImported") + parserResult.getNotSuccessfull(), this.logPanelStyle.getRegularStyle());
            if (!parserResult.isHeaderSuccessfull()) {
                this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("unknownError"), this.logPanelStyle.getErrorStyle());
            }
            if (this.importBICCheckbox.isSelected() && !parserResult.isBICFound() || !this.importBICCheckbox.isSelected() && parserResult.isBICFound()) {
                this.writeLogLine(ApplicationContext.get().text().getString("bicWarning"), this.logPanelStyle.getIconWarningStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("bicWarning"), this.logPanelStyle.getRegularStyle());
            }
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
            this.callback.setExternalVerification(parserResult.isHeaderSuccessfull() && parserResult.getSuccessfull() > 0);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while opening file.", exception);
        }
        this.logger.finest("-doOpenFile");
    }

    @Override
    protected void doSave(Path path) {
        this.logger.finest("+doSave");
        try {
            SEPAWriter sEPAWriter = new SEPAWriter();
            this.getGuiValues();
            if (!path.toString().toLowerCase().endsWith(".xml")) {
                path = Paths.get(path.toAbsolutePath().toString() + ".xml", new String[0]);
                this.logger.fine("adding file extension \".xml\"");
            }
            String string = this.preferences.loadPreference(FieldType.SPLIT_UEBERWEISUNG.name());
            int n = 0;
            if (string != null && !string.isEmpty()) {
                n = Integer.parseInt(string);
            }
            if (n > 0) {
                int n2;
                String string2 = path.toString();
                if (path.toString().endsWith(".xml") || path.toString().endsWith(".XML")) {
                    string2 = path.toString().substring(0, path.toString().lastIndexOf(46));
                }
                ArrayList<SEPACreditTransfer> arrayList = new ArrayList<SEPACreditTransfer>();
                SEPACreditTransfer sEPACreditTransfer = null;
                int n3 = 0;
                for (n2 = 0; n2 < this.credit.getTransactionList().size(); ++n2) {
                    if (n3 % n == 0) {
                        sEPACreditTransfer = this.credit.clone();
                        arrayList.add(sEPACreditTransfer);
                    }
                    sEPACreditTransfer.getTransactionList().add(this.credit.getTransactionList().get(n3));
                    ++n3;
                }
                n2 = 1;
                for (SEPACreditTransfer sEPACreditTransfer2 : arrayList) {
                    Path path2 = Paths.get(string2 + "_" + n2 + ".xml", new String[0]);
                    sEPAWriter.createSEPACreditTransferXMLFile(sEPACreditTransfer2, path2.toFile());
                    this.logger.log(Level.INFO, String.format("SEPA XML file created: %s", path2.toAbsolutePath().toString()));
                    this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-------------------------------\n", this.logPanelStyle.getRegularStyle());
                    this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-", this.logPanelStyle.getIconSaveStyle());
                    this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), path2.toAbsolutePath().toString()) + "\n", path2.toAbsolutePath().toString()), this.logPanelStyle.getRegularStyle());
                    ++n2;
                    this.createReport(sEPACreditTransfer2, path2);
                }
            } else {
                sEPAWriter.createSEPACreditTransferXMLFile(this.credit, path.toFile());
                this.logger.log(Level.INFO, String.format("SEPA XML file created: %s", path.toAbsolutePath().toString()));
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-------------------------------\n", this.logPanelStyle.getRegularStyle());
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-", this.logPanelStyle.getIconSaveStyle());
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), path.toAbsolutePath().toString()) + "\n", path.toAbsolutePath().toString()), this.logPanelStyle.getRegularStyle());
                this.createReport(this.credit, path);
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while saving file.", exception);
            try {
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-------------------------------\n", this.logPanelStyle.getErrorStyle());
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-", this.logPanelStyle.getIconErrorStyle());
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("errorWhileSaving"), exception.getMessage(), path.toAbsolutePath().toString()) + "\n", path.toAbsolutePath().toString()), this.logPanelStyle.getErrorStyle());
            }
            catch (BadLocationException badLocationException) {
                this.logger.log(Level.SEVERE, "Exception while saving file.", badLocationException);
            }
        }
        this.logger.finest("-doSave");
    }

    protected void createReport(SEPACreditTransfer sEPACreditTransfer, Path path) throws NoSuchAlgorithmException, IOException, BadLocationException {
        if (this.preferences.loadPreference(FieldType.CREATE_PDF_REPORT_UEBERWEISUNG.name(), false)) {
            SEPAReport sEPAReport = new SEPAReport();
            Path path2 = Paths.get(path.toAbsolutePath().toString().replace(".xml", "") + ".pdf", new String[0]);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
            sEPACreditTransfer.setExecutionDateReport(simpleDateFormat.format(this.credit.getExecutionDate().getTime()));
            sEPACreditTransfer.setBatchId(path.getFileName().toString().replace(".xml", ""));
            sEPACreditTransfer.setFileName(path.getFileName().toString());
            sEPACreditTransfer.setFileCreationDate(simpleDateFormat.format(new Date()));
            sEPACreditTransfer.setNoOfTx(sEPACreditTransfer.getTransactionList().size());
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-256");
            MessageDigest messageDigest3 = MessageDigest.getInstance("MD5");
            sEPACreditTransfer.setSha1(UeberweisungenTab.getFileChecksum(messageDigest, path.toFile()));
            sEPACreditTransfer.setSha256(UeberweisungenTab.getFileChecksum(messageDigest2, path.toFile()));
            sEPACreditTransfer.setMd5(UeberweisungenTab.getFileChecksum(messageDigest3, path.toFile()));
            sEPAReport.generateCTReport(sEPACreditTransfer, path2.toFile());
            this.logger.log(Level.INFO, String.format("SEPA PDF report created: %s", path.toAbsolutePath().toString()));
            this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-------------------------------\n", this.logPanelStyle.getRegularStyle());
            this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-", this.logPanelStyle.getIconSaveStyle());
            this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("pdfReportSpeicherort"), path2.toAbsolutePath().toString()) + "\n", path2.toAbsolutePath().toString()), this.logPanelStyle.getRegularStyle());
        }
    }

    @Override
    public SEPAVerificationStateCallback getDownloadButtonCallback() {
        return this.callback;
    }

    @Override
    public JLabel getUploadLabel() {
        return this.uploadLabel;
    }
}

