/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class Styles {
    public static final String BASE = "BASE";
    public static final String ICON_OK = "ICON_OK";
    public static final String ICON_ERROR = "ICON_ERROR";
    public static final String ICON_WARNING = "ICON_WARNING";
    public static final String ICON_SAVE = "ICON_SAVE";
    public static final String REGULAR = "REGULAR";
    public static final String TEXT_ERROR = "TEXT_ERROR";
    Map<String, Style> styles = new HashMap<String, Style>();

    public Styles(StyledDocument styledDocument) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = styledDocument.addStyle("regular", style);
        Style style3 = styledDocument.addStyle("iconOk", style2);
        StyleConstants.setAlignment(style3, 1);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("ok.png"));
        if (imageIcon != null) {
            StyleConstants.setIcon(style3, imageIcon);
        }
        Style style4 = styledDocument.addStyle("iconError", style2);
        StyleConstants.setAlignment(style4, 1);
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("error.png"));
        if (imageIcon2 != null) {
            StyleConstants.setIcon(style4, imageIcon2);
        }
        Style style5 = styledDocument.addStyle("iconWarning", style2);
        StyleConstants.setAlignment(style4, 1);
        ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("warning.png"));
        if (imageIcon3 != null) {
            StyleConstants.setIcon(style5, imageIcon3);
        }
        Style style6 = styledDocument.addStyle("iconSave", style2);
        StyleConstants.setAlignment(style6, 1);
        ImageIcon imageIcon4 = new ImageIcon(this.getClass().getResource("floppy_disk_ok.png"));
        if (imageIcon4 != null) {
            StyleConstants.setIcon(style6, imageIcon4);
        }
        Style style7 = styledDocument.addStyle("textError", style2);
        style7.addAttribute(StyleConstants.Foreground, Color.red);
        StyleConstants.setAlignment(style7, 1);
        this.styles.put(BASE, style);
        this.styles.put(REGULAR, style2);
        this.styles.put(TEXT_ERROR, style7);
        this.styles.put(ICON_OK, style3);
        this.styles.put(ICON_ERROR, style4);
        this.styles.put(ICON_WARNING, style5);
        this.styles.put(ICON_SAVE, style6);
    }

    public Style getRegularStyle() {
        return this.styles.get(REGULAR);
    }

    public Style getErrorStyle() {
        return this.styles.get(TEXT_ERROR);
    }

    public Style getIconOkStyle() {
        return this.styles.get(ICON_OK);
    }

    public Style getIconErrorStyle() {
        return this.styles.get(ICON_ERROR);
    }

    public Style getIconWarningStyle() {
        return this.styles.get(ICON_WARNING);
    }

    public Style getIconSaveStyle() {
        return this.styles.get(ICON_SAVE);
    }
}

