/*
 * Decompiled with CFR 0.152.
 */
package com.codecamp.sepa.gui;

import com.codecamp.sepa.SEPAPreferences;
import com.codecamp.sepa.core.BatchBooking;
import com.codecamp.sepa.core.CategoryPurpose;
import com.codecamp.sepa.core.ChargeBearer;
import com.codecamp.sepa.core.CreditTransferSubformat;
import com.codecamp.sepa.core.DirectDebitKind;
import com.codecamp.sepa.core.DirectDebitSubformat;
import com.codecamp.sepa.core.DirectDebitType;
import com.codecamp.sepa.core.SEPACreditTransfer;
import com.codecamp.sepa.core.SEPADirectDebit;
import com.codecamp.sepa.core.SEPAValidator;
import com.codecamp.sepa.core.SEPAWriter;
import com.codecamp.sepa.core.ServiceLevel;
import com.codecamp.sepa.gui.ApplicationContext;
import com.codecamp.sepa.gui.CreditParser;
import com.codecamp.sepa.gui.CreditTransferParserFactory;
import com.codecamp.sepa.gui.DebitParser;
import com.codecamp.sepa.gui.DirectDebitParserFactory;
import com.codecamp.sepa.gui.FieldType;
import com.codecamp.sepa.gui.SepaTab;
import com.codecamp.sepa.parser.ParserLineResult;
import com.codecamp.sepa.parser.ParserResult;
import com.codecamp.sepa.parser.ValidationException;
import com.codecamp.sepa.report.SEPAReport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class SEPAAppCommandLine {
    private static Logger logger = Logger.getLogger(SEPAAppCommandLine.class.getName());

    /*
     * WARNING - void declaration
     */
    public void doCommandLineInterface(String[] stringArray) {
        block88: {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ApplicationContext.get().text().getString("datePattern"));
                String string = stringArray[0];
                SEPAPreferences sEPAPreferences = new SEPAPreferences();
                if (sEPAPreferences.hasValidProLicense() || !sEPAPreferences.hasEvaluationPeriodExpired()) {
                    if ("SCT".equals(string)) {
                        int n;
                        Object bl104;
                        Object bl103;
                        int sEPADirectDebit3;
                        Object n10;
                        Comparable<Date> comparable;
                        if (stringArray.length < 20) {
                            System.out.println(ApplicationContext.get().text().getString("sct.usageHint1"));
                            System.out.println("     " + ApplicationContext.get().text().getString("sct.usageHint2"));
                            System.out.println("     " + ApplicationContext.get().text().getString("sct.usageHint3"));
                            System.out.println("     " + ApplicationContext.get().text().getString("sct.usageHint4"));
                            System.exit(2);
                        }
                        String string2 = StringUtils.trimToNull(stringArray[1]);
                        String string3 = StringUtils.trimToNull(stringArray[2].replace(" ", "").toUpperCase());
                        String string4 = StringUtils.trimToNull(stringArray[3].replace(" ", "").toUpperCase());
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        try {
                            comparable = simpleDateFormat.parse(StringUtils.trimToNull(stringArray[4]));
                            gregorianCalendar.setTime((Date)comparable);
                        }
                        catch (ParseException parseException) {
                            logger.log(Level.SEVERE, "Exception while Parsing date (ExecutionDate): " + stringArray[4], parseException);
                            System.out.println(ApplicationContext.get().text().getString("validationFault") + " " + parseException.getMessage());
                        }
                        comparable = gregorianCalendar;
                        CreditTransferSubformat creditTransferSubformat = null;
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        boolean bl11 = true;
                        boolean bl12 = false;
                        boolean bl13 = false;
                        boolean bl14 = false;
                        boolean bl15 = false;
                        boolean bl16 = false;
                        try {
                            bl11 = Boolean.valueOf(StringUtils.trimToNull(stringArray[16]));
                            bl13 = Boolean.valueOf(StringUtils.trimToNull(stringArray[18]));
                            bl15 = Boolean.valueOf(StringUtils.trimToNull(stringArray[20]));
                            SEPAValidator.validateKontoinhaber(string2, false, bl11, bl15);
                            if (!bl13) {
                                SEPAValidator.validateIBAN(string3, false);
                            }
                            SEPAValidator.validateBIC(string4);
                            creditTransferSubformat = CreditTransferSubformat.valueOf(StringUtils.trimToNull(stringArray[5]));
                            bl = Boolean.valueOf(StringUtils.trimToNull(stringArray[6]));
                            bl2 = Boolean.valueOf(StringUtils.trimToNull(stringArray[7]));
                            bl3 = Boolean.valueOf(StringUtils.trimToNull(stringArray[8]));
                            bl4 = Boolean.valueOf(StringUtils.trimToNull(stringArray[9]));
                            bl5 = Boolean.valueOf(StringUtils.trimToNull(stringArray[10]));
                            bl6 = Boolean.valueOf(StringUtils.trimToNull(stringArray[11]));
                            bl7 = Boolean.valueOf(StringUtils.trimToNull(stringArray[12]));
                            bl8 = Boolean.valueOf(StringUtils.trimToNull(stringArray[13]));
                            bl9 = Boolean.valueOf(StringUtils.trimToNull(stringArray[14]));
                            bl10 = Boolean.valueOf(StringUtils.trimToNull(stringArray[15]));
                            bl12 = Boolean.valueOf(StringUtils.trimToNull(stringArray[17]));
                            bl14 = Boolean.valueOf(StringUtils.trimToNull(stringArray[19]));
                            bl16 = Boolean.valueOf(StringUtils.trimToNull(stringArray[21]));
                        }
                        catch (ValidationException validationException) {
                            logger.log(Level.SEVERE, "ValidationException: " + validationException.getMessage(), validationException);
                            System.out.println(ApplicationContext.get().text().getString("validationFault") + " " + validationException.getMessage());
                            System.exit(130);
                        }
                        String string5 = StringUtils.trimToNull(stringArray[22]);
                        String string6 = StringUtils.trimToNull(stringArray[23]);
                        File file = new File(string5);
                        CreditParser creditParser = CreditTransferParserFactory.create(file.toPath());
                        ParserResult bl96 = creditParser.parse(file, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl11, bl15, bl10, bl12, bl14, bl16);
                        SEPACreditTransfer string57 = bl96.getCreditTransfer();
                        string57.setEnd2EndIdFromFile(bl2);
                        string57.setUseESRKtoNo(bl5);
                        string57.setExecutionDateFromFile(bl6);
                        string57.setUseBankgiro(bl7);
                        string57.setAccountNoInsteadOfIBAN(bl8);
                        string57.setAccountNoInsteadOfIBANGUI(bl13);
                        string57.setQrRechnung(bl10);
                        string57.setKontoinhaber(string2);
                        string57.setIBAN(string3);
                        string57.setBIC(string4);
                        string57.setExecutionDate((GregorianCalendar)comparable);
                        string57.setSubformat(creditTransferSubformat);
                        string57.setCurrency("EUR");
                        boolean string46 = false;
                        String arrayList = null;
                        if (stringArray.length > 25) {
                            String bl82 = StringUtils.trimToNull(stringArray[24]);
                            if (bl82 != null) {
                                string57.setCategoryPurpose(CategoryPurpose.valueOf(bl82));
                            }
                            n10 = StringUtils.trimToNull(stringArray[25]);
                            string57.setIdentificationID((String)n10);
                            boolean string28 = Boolean.valueOf(StringUtils.trimToNull(stringArray[26]));
                            string57.setIdentIdPrv(string28);
                            boolean bl83 = Boolean.valueOf(StringUtils.trimToNull(stringArray[27]));
                            string57.setIdentIdOrg(bl83);
                            sEPADirectDebit3 = Boolean.valueOf(StringUtils.trimToNull(stringArray[28])).booleanValue();
                            ApplicationContext.get().setUseTimeZoneFor001(sEPADirectDebit3 != 0);
                            boolean bl51 = Boolean.valueOf(StringUtils.trimToNull(stringArray[29]));
                            string57.setGenerateEnd2EndId(bl51);
                            bl103 = StringUtils.trimToNull(stringArray[30]);
                            string57.setEnd2EndId((String)bl103);
                            bl104 = StringUtils.trimToNull(stringArray[31]);
                            if (bl104 != null) {
                                string57.setBatchBooking(BatchBooking.valueOf((String)bl104));
                            }
                            boolean bl85 = Boolean.valueOf(StringUtils.trimToNull(stringArray[32]));
                            string57.setSetDebitorCurrency(bl85);
                            n = Boolean.valueOf(StringUtils.trimToNull(stringArray[33])).booleanValue();
                            string57.setUseFastCreditTransfer(n != 0);
                            boolean bl17 = Boolean.valueOf(StringUtils.trimToNull(stringArray[34]));
                            string57.setSetTxNo(bl17);
                            boolean bl18 = Boolean.valueOf(StringUtils.trimToNull(stringArray[35]));
                            string57.setUsePIIforEachTrx(bl18);
                            boolean bl19 = Boolean.valueOf(StringUtils.trimToNull(stringArray[36]));
                            string57.setNationalPayment(bl19);
                            boolean bl20 = Boolean.valueOf(StringUtils.trimToNull(stringArray[37]));
                            string57.setSetLocalInstrumentCore(bl20);
                            String string7 = StringUtils.trimToNull(stringArray[38]);
                            string57.setCurrency(string7);
                            String string8 = StringUtils.trimToNull(stringArray[39]);
                            if (string8 != null) {
                                string57.setChargeBearer(ChargeBearer.valueOf(string8));
                            }
                            String string9 = StringUtils.trimToNull(stringArray[40]);
                            string57.setPmtInfId(string9);
                            boolean bl21 = Boolean.valueOf(StringUtils.trimToNull(stringArray[41]));
                            string57.setUseESRReferenceNo(bl21);
                            boolean bl22 = Boolean.valueOf(StringUtils.trimToNull(stringArray[42]));
                            string57.setXmlHeaderWithSchemaLocation(bl22);
                            boolean bl23 = Boolean.valueOf(StringUtils.trimToNull(stringArray[43]));
                            string57.setUseSCOR(bl23);
                            boolean bl24 = Boolean.valueOf(StringUtils.trimToNull(stringArray[44]));
                            string57.setPaymentTypeInformationOnTrxLevel(bl24);
                            boolean bl25 = Boolean.valueOf(StringUtils.trimToNull(stringArray[45]));
                            string57.setInstantCT(bl25);
                            String string10 = StringUtils.trimToNull(stringArray[46]);
                            if (string10 != null) {
                                string57.setServiceLevel(ServiceLevel.valueOf(string10));
                            } else {
                                string57.setServiceLevel(ServiceLevel.SEPA);
                            }
                            string46 = Boolean.valueOf(StringUtils.trimToNull(stringArray[47]));
                            boolean bl26 = Boolean.valueOf(StringUtils.trimToNull(stringArray[48]));
                            string57.setSwiftConf(bl26);
                            String string11 = StringUtils.trimToNull(stringArray[49]);
                            string57.setCountryCode(string11);
                            arrayList = StringUtils.trimToNull(stringArray[50]);
                            boolean bl27 = Boolean.valueOf(StringUtils.trimToNull(stringArray[51]));
                            string57.setNameInInitParty(bl27);
                            String string12 = StringUtils.trimToNull(stringArray[52]);
                            string57.setAddressLine1(string12);
                            String string13 = StringUtils.trimToNull(stringArray[53]);
                            string57.setAddressLine2(string13);
                            boolean bl28 = Boolean.valueOf(StringUtils.trimToNull(stringArray[54]));
                            string57.setAddSoftwareNameAndVendor(bl28);
                            boolean bl29 = Boolean.valueOf(StringUtils.trimToNull(stringArray[55]));
                            string57.setAddCountryCodeFromIBANToBIC(bl29);
                            boolean bl30 = Boolean.valueOf(StringUtils.trimToNull(stringArray[56]));
                            string57.setUseStructuredAddress(bl30);
                            String string14 = StringUtils.trimToNull(stringArray[57]);
                            string57.setRegulatoryReportingCode(string14);
                        }
                        System.out.println("---");
                        int sEPADirectDebit2 = 0;
                        for (ParserLineResult string43 : bl96.getLineResults()) {
                            logger.log(Level.FINEST, String.format("Parsing %s", string43.getLineMessage()));
                            ++sEPADirectDebit2;
                            if (string43.isSucessfull()) {
                                System.out.println(string43.getLineMessage());
                                System.out.println(" - " + ApplicationContext.get().text().getString("numberShort") + " " + sEPADirectDebit2 + " (" + ApplicationContext.get().text().getString("row") + " " + (sEPADirectDebit2 + 2) + ") - " + string43.getLineMessage());
                                continue;
                            }
                            System.out.println(string43.getLineMessage());
                            System.out.println(" - " + ApplicationContext.get().text().getString("numberShort") + " " + sEPADirectDebit2 + " (" + ApplicationContext.get().text().getString("row") + " " + (sEPADirectDebit2 + 2) + ") - " + string43.getLineMessage());
                        }
                        System.out.println("---");
                        System.out.println(ApplicationContext.get().text().getString("successfullyImported") + bl96.getSuccessfull());
                        System.out.println(ApplicationContext.get().text().getString("errorImported") + bl96.getNotSuccessfull());
                        if (!bl96.isHeaderSuccessfull()) {
                            System.out.println("---");
                            System.out.println(ApplicationContext.get().text().getString("unknownError"));
                            System.exit(131);
                        }
                        System.out.println("-------------------------------");
                        n10 = new SEPAWriter();
                        File n9 = new File(string6);
                        Path path = n9.toPath();
                        if (!path.toString().toLowerCase().endsWith(".xml")) {
                            path = Paths.get(path.toAbsolutePath().toString() + ".xml", new String[0]);
                            logger.fine("adding file extension \".xml\"");
                        }
                        sEPADirectDebit3 = 0;
                        if (arrayList != null && !arrayList.isEmpty()) {
                            sEPADirectDebit3 = Integer.parseInt(arrayList);
                        }
                        if (sEPADirectDebit3 > 0) {
                            String object = path.toString();
                            if (path.toString().endsWith(".xml") || path.toString().endsWith(".XML")) {
                                object = path.toString().substring(0, path.toString().lastIndexOf(46));
                            }
                            bl103 = new ArrayList();
                            bl104 = null;
                            boolean bl105 = false;
                            for (n = 0; n < string57.getTransactionList().size(); ++n) {
                                void var43_185;
                                if (var43_185 % sEPADirectDebit3 == false) {
                                    bl104 = string57.clone();
                                    bl103.add(bl104);
                                }
                                ((SEPACreditTransfer)bl104).getTransactionList().add(string57.getTransactionList().get((int)var43_185));
                                ++var43_185;
                            }
                            n = 1;
                            Iterator iterator = bl103.iterator();
                            while (iterator.hasNext()) {
                                SEPACreditTransfer sEPACreditTransfer = (SEPACreditTransfer)iterator.next();
                                Path path2 = Paths.get(object + "_" + n + ".xml", new String[0]);
                                ((SEPAWriter)n10).createSEPACreditTransferXMLFile(sEPACreditTransfer, path2.toFile());
                                logger.log(Level.INFO, String.format("SEPA XML file created: %s", path2.toAbsolutePath().toString()));
                                System.out.println("-------------------------------\n");
                                System.out.println("-");
                                System.out.println(String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), path2.toAbsolutePath().toString()) + "\n", path2.toAbsolutePath().toString()));
                                ++n;
                            }
                        } else {
                            ((SEPAWriter)n10).createSEPACreditTransferXMLFile(string57, path.toFile());
                            logger.log(Level.INFO, String.format("SEPA XML file created: %s", path.toAbsolutePath().toString()));
                            System.out.println("-------------------------------\n");
                            System.out.println("-");
                            System.out.println(String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), path.toAbsolutePath().toString()) + "\n", path.toAbsolutePath().toString()));
                        }
                        if (string46 && sEPADirectDebit3 == 0) {
                            SEPAReport bl31 = new SEPAReport();
                            bl103 = Paths.get(path.toAbsolutePath().toString().replace(".xml", "") + ".pdf", new String[0]);
                            string57.setExecutionDateReport(simpleDateFormat.format(string57.getExecutionDate().getTime()));
                            string57.setBatchId(path.getFileName().toString().replace(".xml", ""));
                            string57.setFileName(path.getFileName().toString());
                            string57.setFileCreationDate(simpleDateFormat.format(new Date()));
                            string57.setNoOfTx(string57.getTransactionList().size());
                            bl104 = MessageDigest.getInstance("SHA-1");
                            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                            MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
                            string57.setSha1(SepaTab.getFileChecksum((MessageDigest)bl104, path.toFile()));
                            string57.setSha256(SepaTab.getFileChecksum(messageDigest, path.toFile()));
                            string57.setMd5(SepaTab.getFileChecksum(messageDigest2, path.toFile()));
                            bl31.generateCTReport(string57, bl103.toFile());
                            logger.log(Level.INFO, String.format("SEPA PDF report created: %s", path.toAbsolutePath().toString()));
                            System.out.println("-------------------------------\n");
                            System.out.println("-");
                            System.out.println(String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("pdfReportSpeicherort"), bl103.toAbsolutePath().toString()) + "\n", bl103.toAbsolutePath().toString()));
                        }
                        System.exit(bl96.getNotSuccessfull() == 0 ? 0 : 132);
                        break block88;
                    }
                    if ("SCTx".equals(string)) {
                        Object object;
                        Iterable iterable;
                        Object object2;
                        boolean bl;
                        ServiceLevel serviceLevel;
                        Comparable<Date> comparable;
                        Object object6;
                        if (stringArray.length < 4) {
                            System.out.println(ApplicationContext.get().text().getString("sctx.usageHint"));
                            System.exit(2);
                        }
                        String string18 = StringUtils.trimToNull(stringArray[1]);
                        String string19 = StringUtils.trimToNull(stringArray[2]);
                        String string20 = StringUtils.trimToNull(stringArray[3]);
                        Properties properties = new Properties();
                        try {
                            object6 = new FileInputStream(new File(string18));
                            properties.load((InputStream)object6);
                        }
                        catch (IOException iOException) {
                            logger.log(Level.SEVERE, "Exception while loading configuration!", iOException);
                        }
                        object6 = Locale.getDefault();
                        String string21 = ((Locale)object6).getCountry();
                        String string22 = properties.getProperty(FieldType.KONTOINHABER_UEBERWEISUNG.name());
                        String string23 = properties.getProperty(FieldType.IBAN_UEBERWEISUNG.name());
                        String string24 = properties.getProperty(FieldType.BIC_UEBERWEISUNG.name());
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        try {
                            comparable = simpleDateFormat.parse(properties.getProperty(FieldType.AUSFUEHRUNGSDATUM_UEBERWEISUNG.name()));
                            gregorianCalendar.setTime((Date)comparable);
                        }
                        catch (ParseException parseException) {
                            logger.log(Level.SEVERE, "Exception while Parsing date (ExecutionDate): " + properties.getProperty(FieldType.AUSFUEHRUNGSDATUM_UEBERWEISUNG.name()), parseException);
                            System.out.println(ApplicationContext.get().text().getString("validationFault") + " " + parseException.getMessage());
                        }
                        comparable = gregorianCalendar;
                        boolean bl35 = properties.getProperty(FieldType.IMPORTBIC_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.IMPORTBIC_UEBERWEISUNG.name())) : false;
                        CreditTransferSubformat creditTransferSubformat = properties.getProperty(FieldType.SUBFORMAT_UEBERWEISUNG.name()) != null ? CreditTransferSubformat.valueOf(properties.getProperty(FieldType.SUBFORMAT_UEBERWEISUNG.name())) : CreditTransferSubformat.getDefaultByCountry(Locale.getDefault());
                        boolean bl36 = properties.getProperty(FieldType.USE_TZ_001_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_TZ_001_UEBERWEISUNG.name())) : true;
                        CategoryPurpose categoryPurpose = properties.getProperty(FieldType.CATEGORY_PURPOSE_UEBERWEISUNG.name()) != null ? CategoryPurpose.valueOf(properties.getProperty(FieldType.CATEGORY_PURPOSE_UEBERWEISUNG.name())) : CategoryPurpose.EMPTY;
                        String string25 = properties.getProperty(FieldType.SPANISH_NUMBER_UEBERWEISUNG.name());
                        boolean bl37 = properties.getProperty(FieldType.USE_ORG_ID_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_ORG_ID_UEBERWEISUNG.name())) : false;
                        boolean bl38 = properties.getProperty(FieldType.USE_PRV_ID_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_PRV_ID_UEBERWEISUNG.name())) : true;
                        boolean bl39 = properties.getProperty(FieldType.GENERATE_END2END_ID_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.GENERATE_END2END_ID_UEBERWEISUNG.name())) : true;
                        boolean bl40 = properties.getProperty(FieldType.END2END_ID_FROM_FILE_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.END2END_ID_FROM_FILE_UEBERWEISUNG.name())) : false;
                        String string26 = properties.getProperty(FieldType.END2ENDID_UEBERWEISUNG.name());
                        BatchBooking batchBooking = properties.getProperty(FieldType.BATCH_BOOKING_SELECT_UEBERWEISUNG.name()) != null ? BatchBooking.valueOf(properties.getProperty(FieldType.BATCH_BOOKING_SELECT_UEBERWEISUNG.name())) : BatchBooking.EMPTY;
                        boolean bl41 = properties.getProperty(FieldType.DEBITOR_CURRENCY_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.DEBITOR_CURRENCY_UEBERWEISUNG.name())) : false;
                        boolean bl42 = properties.getProperty(FieldType.FAST_CREDIT_TRANSFER_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.FAST_CREDIT_TRANSFER_UEBERWEISUNG.name())) : false;
                        boolean bl43 = properties.getProperty(FieldType.TX_NO_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.TX_NO_UEBERWEISUNG.name())) : false;
                        boolean bl44 = properties.getProperty(FieldType.PII_FOR_EACH_TRX_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.PII_FOR_EACH_TRX_UEBERWEISUNG.name())) : false;
                        boolean bl32 = properties.getProperty(FieldType.NATIONAL_PAYMENT_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.NATIONAL_PAYMENT_UEBERWEISUNG.name())) : false;
                        boolean bl33 = properties.getProperty(FieldType.SET_LOCAL_INTRUMENT_CORE_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.SET_LOCAL_INTRUMENT_CORE_UEBERWEISUNG.name())) : false;
                        String bl97 = properties.getProperty(FieldType.CURRENCY_UEBERWEISUNG.name());
                        boolean bl98 = properties.getProperty(FieldType.CURRENCY_FROM_FILE_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.CURRENCY_FROM_FILE_UEBERWEISUNG.name())) : false;
                        boolean chargeBearer = properties.getProperty(FieldType.ADDRESS_FROM_FILE_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.ADDRESS_FROM_FILE_UEBERWEISUNG.name())) : false;
                        ChargeBearer string58 = properties.getProperty(FieldType.CHARGEBEARER_UEBERWEISUNG.name()) != null ? ChargeBearer.valueOf(properties.getProperty(FieldType.CHARGEBEARER_UEBERWEISUNG.name())) : ChargeBearer.EMPTY;
                        String bl99 = properties.getProperty(FieldType.PMTID_UEBERWEISUNG.name());
                        boolean bl100 = properties.getProperty(FieldType.USE_ESR_KTONO_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_ESR_KTONO_UEBERWEISUNG.name())) : false;
                        boolean bl88 = properties.getProperty(FieldType.USE_ESR_REFNO_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_ESR_REFNO_UEBERWEISUNG.name())) : false;
                        boolean bl34 = properties.getProperty(FieldType.IMPORT_EXECUTIONDATE_FROM_FILE_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.IMPORT_EXECUTIONDATE_FROM_FILE_UEBERWEISUNG.name())) : false;
                        boolean bl45 = properties.getProperty(FieldType.XML_HEADER_WITH_SCHEMA_LOCATION_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.XML_HEADER_WITH_SCHEMA_LOCATION_UEBERWEISUNG.name())) : false;
                        boolean bl46 = properties.getProperty(FieldType.USE_BANKGIRO_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_BANKGIRO_UEBERWEISUNG.name())) : false;
                        boolean bl47 = properties.getProperty(FieldType.USE_SCOR_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_SCOR_UEBERWEISUNG.name())) : false;
                        boolean bl48 = properties.getProperty(FieldType.PAYMENT_TYPE_INFORMATION_ON_TRX_LEVEL_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.PAYMENT_TYPE_INFORMATION_ON_TRX_LEVEL_UEBERWEISUNG.name())) : false;
                        boolean bl49 = properties.getProperty(FieldType.IS_INSTANT_CT_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.IS_INSTANT_CT_UEBERWEISUNG.name())) : false;
                        boolean bl50 = properties.getProperty(FieldType.ACCOUNT_NO_INSTEAD_OF_IBAN_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.ACCOUNT_NO_INSTEAD_OF_IBAN_UEBERWEISUNG.name())) : false;
                        ServiceLevel serviceLevel2 = serviceLevel = properties.getProperty(FieldType.SERVICE_LEVEL_UEBERWEISUNG.name()) != null ? ServiceLevel.valueOf(properties.getProperty(FieldType.SERVICE_LEVEL_UEBERWEISUNG.name())) : ServiceLevel.SEPA;
                        boolean bl51 = properties.getProperty(FieldType.NORMALIZE_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.NORMALIZE_UEBERWEISUNG.name())) : !"DE".equals(string21) || !"AT".equals(string21);
                        boolean bl52 = properties.getProperty(FieldType.CREATE_PDF_REPORT_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.CREATE_PDF_REPORT_UEBERWEISUNG.name())) : false;
                        boolean bl53 = bl = properties.getProperty(FieldType.QR_RECHNUNG_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.QR_RECHNUNG_UEBERWEISUNG.name())) : false;
                        boolean bl54 = properties.getProperty(FieldType.UMLAUTS_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.UMLAUTS_UEBERWEISUNG.name())) : "DE".equals(string21) || "AT".equals(string21);
                        boolean bl55 = properties.getProperty(FieldType.PAYERFROMFILE_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.PAYERFROMFILE_UEBERWEISUNG.name())) : false;
                        boolean bl56 = properties.getProperty(FieldType.SWIFTCONF_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.SWIFTCONF_UEBERWEISUNG.name())) : false;
                        boolean bl57 = properties.getProperty(FieldType.ACCOUNT_NO_INSTEAD_OF_IBAN_GUI_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.ACCOUNT_NO_INSTEAD_OF_IBAN_GUI_UEBERWEISUNG.name())) : false;
                        String string15 = StringUtils.trimToNull(properties.getProperty(FieldType.COUNTRY_CODE_UEBERWEISUNG.name()));
                        boolean bl58 = properties.getProperty(FieldType.SPLIT_PAYMENT_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.SPLIT_PAYMENT_UEBERWEISUNG.name())) : false;
                        boolean bl59 = properties.getProperty(FieldType.SPECIAL_CHARACTERS_CH_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.SPECIAL_CHARACTERS_CH_UEBERWEISUNG.name())) : false;
                        String string16 = properties.getProperty(FieldType.SPLIT_UEBERWEISUNG.name());
                        boolean bl60 = properties.getProperty(FieldType.NAME_IN_INITPRTY_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.NAME_IN_INITPRTY_UEBERWEISUNG.name())) : true;
                        String string17 = properties.getProperty(FieldType.ADDRESSLINE1_UEBERWEISUNG.name());
                        String string27 = properties.getProperty(FieldType.ADDRESSLINE2_UEBERWEISUNG.name());
                        boolean bl61 = properties.getProperty(FieldType.ADD_SOFTWARE_NAME_AND_VENDOR_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.ADD_SOFTWARE_NAME_AND_VENDOR_UEBERWEISUNG.name())) : false;
                        boolean bl62 = properties.getProperty(FieldType.ADD_COUNTRY_CODE_FROM_IBAN_TO_BIC_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.ADD_COUNTRY_CODE_FROM_IBAN_TO_BIC_UEBERWEISUNG.name())) : false;
                        boolean bl63 = properties.getProperty(FieldType.USE_STRUCTURED_ADDRESS_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_STRUCTURED_ADDRESS_UEBERWEISUNG.name())) : false;
                        String string28 = StringUtils.trimToNull(properties.getProperty(FieldType.REGULATORY_REPORT_CODE_UEBERWEISUNG.name()));
                        boolean bl64 = properties.getProperty(FieldType.REGULATORY_REPORT_CODE_FROM_FILE_UEBERWEISUNG.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.REGULATORY_REPORT_CODE_FROM_FILE_UEBERWEISUNG.name())) : false;
                        ApplicationContext.get().setUseTimeZoneFor001(bl36);
                        File file = new File(string19);
                        CreditParser creditParser = CreditTransferParserFactory.create(file.toPath());
                        ParserResult parserResult = creditParser.parse(file, bl35, bl40, bl98, chargeBearer, bl100, bl34, bl46, bl50, bl51, bl54, bl59, bl, bl55, bl58, bl64);
                        SEPACreditTransfer sEPACreditTransfer = parserResult.getCreditTransfer();
                        sEPACreditTransfer.setEnd2EndIdFromFile(bl40);
                        sEPACreditTransfer.setUseESRKtoNo(bl100);
                        sEPACreditTransfer.setExecutionDateFromFile(bl34);
                        sEPACreditTransfer.setUseBankgiro(bl46);
                        sEPACreditTransfer.setAccountNoInsteadOfIBAN(bl50);
                        sEPACreditTransfer.setAccountNoInsteadOfIBANGUI(bl57);
                        sEPACreditTransfer.setQrRechnung(bl);
                        sEPACreditTransfer.setKontoinhaber(string22);
                        sEPACreditTransfer.setIBAN(string23);
                        sEPACreditTransfer.setBIC(string24);
                        sEPACreditTransfer.setExecutionDate((GregorianCalendar)comparable);
                        sEPACreditTransfer.setSubformat(creditTransferSubformat);
                        sEPACreditTransfer.setCategoryPurpose(categoryPurpose);
                        sEPACreditTransfer.setIdentificationID(string25);
                        sEPACreditTransfer.setIdentIdPrv(bl38);
                        sEPACreditTransfer.setIdentIdOrg(bl37);
                        sEPACreditTransfer.setGenerateEnd2EndId(bl39);
                        sEPACreditTransfer.setEnd2EndId(string26);
                        sEPACreditTransfer.setBatchBooking(batchBooking);
                        sEPACreditTransfer.setSetDebitorCurrency(bl41);
                        sEPACreditTransfer.setUseFastCreditTransfer(bl42);
                        sEPACreditTransfer.setSetTxNo(bl43);
                        sEPACreditTransfer.setUsePIIforEachTrx(bl44);
                        sEPACreditTransfer.setNationalPayment(bl32);
                        sEPACreditTransfer.setSetLocalInstrumentCore(bl33);
                        sEPACreditTransfer.setCurrency(bl97);
                        sEPACreditTransfer.setChargeBearer(string58);
                        sEPACreditTransfer.setPmtInfId(bl99);
                        sEPACreditTransfer.setUseESRReferenceNo(bl88);
                        sEPACreditTransfer.setXmlHeaderWithSchemaLocation(bl45);
                        sEPACreditTransfer.setUseSCOR(bl47);
                        sEPACreditTransfer.setPaymentTypeInformationOnTrxLevel(bl48);
                        sEPACreditTransfer.setInstantCT(bl49);
                        sEPACreditTransfer.setServiceLevel(serviceLevel);
                        sEPACreditTransfer.setPayerFromFile(bl55);
                        sEPACreditTransfer.setSwiftConf(bl56);
                        sEPACreditTransfer.setCountryCode(string15);
                        sEPACreditTransfer.setSplitPayment(bl58);
                        sEPACreditTransfer.setNameInInitParty(bl60);
                        sEPACreditTransfer.setAddressLine1(string17);
                        sEPACreditTransfer.setAddressLine2(string27);
                        sEPACreditTransfer.setAddSoftwareNameAndVendor(bl61);
                        sEPACreditTransfer.setAddCountryCodeFromIBANToBIC(bl62);
                        sEPACreditTransfer.setUseStructuredAddress(bl63);
                        sEPACreditTransfer.setRegulatoryReportingCode(string28);
                        sEPACreditTransfer.setRegulatoryReportingCodeFromFile(bl64);
                        System.out.println("---");
                        int n = 0;
                        for (ParserLineResult parserLineResult : parserResult.getLineResults()) {
                            logger.log(Level.FINEST, String.format("Parsing %s", parserLineResult.getLineMessage()));
                            ++n;
                            if (parserLineResult.isSucessfull()) {
                                System.out.println(parserLineResult.getLineMessage());
                                System.out.println(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n + " (" + ApplicationContext.get().text().getString("row") + " " + (n + 2) + ") - " + parserLineResult.getLineMessage());
                                continue;
                            }
                            System.out.println(parserLineResult.getLineMessage());
                            System.out.println(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n + " (" + ApplicationContext.get().text().getString("row") + " " + (n + 2) + ") - " + parserLineResult.getLineMessage());
                        }
                        System.out.println("---");
                        System.out.println(ApplicationContext.get().text().getString("successfullyImported") + parserResult.getSuccessfull());
                        System.out.println(ApplicationContext.get().text().getString("errorImported") + parserResult.getNotSuccessfull());
                        if (!parserResult.isHeaderSuccessfull()) {
                            System.out.println("---");
                            System.out.println(ApplicationContext.get().text().getString("unknownError"));
                            System.exit(131);
                        }
                        System.out.println("-------------------------------");
                        SEPAWriter sEPAWriter = new SEPAWriter();
                        File file2 = new File(string20);
                        Path path = file2.toPath();
                        if (!path.toString().toLowerCase().endsWith(".xml")) {
                            path = Paths.get(path.toAbsolutePath().toString() + ".xml", new String[0]);
                            logger.fine("adding file extension \".xml\"");
                        }
                        int n2 = 0;
                        if (string16 != null && !string16.isEmpty()) {
                            n2 = Integer.parseInt(string16);
                        }
                        if (n2 > 0) {
                            int n3;
                            object2 = path.toString();
                            if (path.toString().endsWith(".xml") || path.toString().endsWith(".XML")) {
                                object2 = path.toString().substring(0, path.toString().lastIndexOf(46));
                            }
                            iterable = new ArrayList<SEPACreditTransfer>();
                            object = null;
                            int n4 = 0;
                            for (n3 = 0; n3 < sEPACreditTransfer.getTransactionList().size(); ++n3) {
                                if (n4 % n2 == 0) {
                                    object = sEPACreditTransfer.clone();
                                    iterable.add(object);
                                }
                                ((SEPACreditTransfer)object).getTransactionList().add(sEPACreditTransfer.getTransactionList().get(n4));
                                ++n4;
                            }
                            n3 = 1;
                            for (SEPACreditTransfer sEPACreditTransfer2 : iterable) {
                                Path path3 = Paths.get((String)object2 + "_" + n3 + ".xml", new String[0]);
                                sEPAWriter.createSEPACreditTransferXMLFile(sEPACreditTransfer2, path3.toFile());
                                logger.log(Level.INFO, String.format("SEPA XML file created: %s", path3.toAbsolutePath().toString()));
                                System.out.println("-------------------------------\n");
                                System.out.println("-");
                                System.out.println(String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), path3.toAbsolutePath().toString()) + "\n", path3.toAbsolutePath().toString()));
                                ++n3;
                            }
                        } else {
                            sEPAWriter.createSEPACreditTransferXMLFile(sEPACreditTransfer, path.toFile());
                            logger.log(Level.INFO, String.format("SEPA XML file created: %s", path.toAbsolutePath().toString()));
                            System.out.println("-------------------------------\n");
                            System.out.println("-");
                            System.out.println(String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), path.toAbsolutePath().toString()) + "\n", path.toAbsolutePath().toString()));
                        }
                        if (bl52 && n2 == 0) {
                            object2 = new SEPAReport();
                            iterable = Paths.get(path.toAbsolutePath().toString().replace(".xml", "") + ".pdf", new String[0]);
                            sEPACreditTransfer.setExecutionDateReport(simpleDateFormat.format(sEPACreditTransfer.getExecutionDate().getTime()));
                            sEPACreditTransfer.setBatchId(path.getFileName().toString().replace(".xml", ""));
                            sEPACreditTransfer.setFileName(path.getFileName().toString());
                            sEPACreditTransfer.setFileCreationDate(simpleDateFormat.format(new Date()));
                            sEPACreditTransfer.setNoOfTx(sEPACreditTransfer.getTransactionList().size());
                            object = MessageDigest.getInstance("SHA-1");
                            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                            MessageDigest messageDigest3 = MessageDigest.getInstance("MD5");
                            sEPACreditTransfer.setSha1(SepaTab.getFileChecksum((MessageDigest)object, path.toFile()));
                            sEPACreditTransfer.setSha256(SepaTab.getFileChecksum(messageDigest, path.toFile()));
                            sEPACreditTransfer.setMd5(SepaTab.getFileChecksum(messageDigest3, path.toFile()));
                            ((SEPAReport)object2).generateCTReport(sEPACreditTransfer, iterable.toFile());
                            logger.log(Level.INFO, String.format("SEPA PDF report created: %s", path.toAbsolutePath().toString()));
                            System.out.println("-------------------------------\n");
                            System.out.println("-");
                            System.out.println(String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("pdfReportSpeicherort"), iterable.toAbsolutePath().toString()) + "\n", iterable.toAbsolutePath().toString()));
                        }
                        System.exit(parserResult.getNotSuccessfull() == 0 ? 0 : 132);
                        break block88;
                    }
                    if ("SDD".equals(string)) {
                        Object object;
                        int n;
                        Object object3;
                        Object object9;
                        Comparable<Date> comparable;
                        if (stringArray.length < 17) {
                            System.out.println(ApplicationContext.get().text().getString("sdd.usageHint1"));
                            System.out.println("     " + ApplicationContext.get().text().getString("sdd.usageHint2"));
                            System.out.println("     " + ApplicationContext.get().text().getString("sdd.usageHint3"));
                            System.out.println("     " + ApplicationContext.get().text().getString("sdd.usageHint4"));
                            System.exit(2);
                        }
                        String string34 = StringUtils.trimToNull(stringArray[1]);
                        String string35 = StringUtils.trimToNull(stringArray[2].replace(" ", "").toUpperCase());
                        String string36 = StringUtils.trimToNull(stringArray[3].replace(" ", "").toUpperCase());
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        try {
                            comparable = simpleDateFormat.parse(StringUtils.trimToNull(stringArray[4]));
                            gregorianCalendar.setTime((Date)comparable);
                        }
                        catch (ParseException parseException) {
                            logger.log(Level.SEVERE, "Exception while Parsing date (CollectionDate): " + stringArray[4], parseException);
                            System.out.println(ApplicationContext.get().text().getString("validationFault") + " " + parseException.getMessage());
                        }
                        comparable = gregorianCalendar;
                        String string37 = StringUtils.trimToNull(stringArray[5].replace(" ", "").toUpperCase());
                        DirectDebitSubformat directDebitSubformat = null;
                        boolean bl = false;
                        boolean bl72 = false;
                        boolean bl73 = false;
                        boolean bl74 = false;
                        boolean bl75 = false;
                        boolean bl76 = false;
                        boolean bl77 = false;
                        boolean bl78 = true;
                        boolean bl79 = false;
                        try {
                            bl78 = Boolean.valueOf(StringUtils.trimToNull(stringArray[14]));
                            bl79 = Boolean.valueOf(StringUtils.trimToNull(stringArray[15]));
                            SEPAValidator.validateKontoinhaber(string34, false, bl78, bl79);
                            SEPAValidator.validateIBAN(string35, false);
                            SEPAValidator.validateBIC(string36);
                            directDebitSubformat = DirectDebitSubformat.valueOf(StringUtils.trimToNull(stringArray[6]));
                            bl = Boolean.valueOf(StringUtils.trimToNull(stringArray[7]));
                            bl72 = Boolean.valueOf(StringUtils.trimToNull(stringArray[8]));
                            bl73 = Boolean.valueOf(StringUtils.trimToNull(stringArray[9]));
                            bl74 = Boolean.valueOf(StringUtils.trimToNull(stringArray[10]));
                            bl75 = Boolean.valueOf(StringUtils.trimToNull(stringArray[11]));
                            bl76 = Boolean.valueOf(StringUtils.trimToNull(stringArray[12]));
                            bl77 = Boolean.valueOf(StringUtils.trimToNull(stringArray[13]));
                        }
                        catch (ValidationException validationException) {
                            logger.log(Level.SEVERE, "ValidationException: " + validationException.getMessage(), validationException);
                            System.out.println(ApplicationContext.get().text().getString("validationFault") + " " + validationException.getMessage());
                            System.exit(130);
                        }
                        String string38 = StringUtils.trimToNull(stringArray[16]);
                        String string39 = StringUtils.trimToNull(stringArray[17]);
                        File file = new File(string38);
                        DebitParser debitParser = DirectDebitParserFactory.create(file.toPath());
                        ParserResult parserResult = debitParser.parse(file, bl, bl72, bl73, bl74, bl75, bl76, bl77, bl78, bl79, DirectDebitSubformat.PAIN_008_001_02_CH_03.equals((Object)directDebitSubformat));
                        SEPADirectDebit sEPADirectDebit = parserResult.getDirectDebit();
                        sEPADirectDebit.setEnd2EndIdFromFile(bl72);
                        sEPADirectDebit.setCollectionDateFromFile(bl75);
                        sEPADirectDebit.setDirectDebitTypeFromFile(bl76);
                        sEPADirectDebit.setKontoinhaber(string34);
                        sEPADirectDebit.setIBAN(string35);
                        sEPADirectDebit.setBIC(string36);
                        sEPADirectDebit.setGlaeubigerId(string37);
                        sEPADirectDebit.setCollectionDate((GregorianCalendar)comparable);
                        sEPADirectDebit.setSubformat(directDebitSubformat);
                        sEPADirectDebit.setCurrency("EUR");
                        String string40 = null;
                        if (stringArray.length > 19) {
                            String string41 = StringUtils.trimToNull(stringArray[18]);
                            sEPADirectDebit.setType(DirectDebitType.valueOf(string41));
                            object9 = StringUtils.trimToNull(stringArray[19]);
                            sEPADirectDebit.setKind(DirectDebitKind.valueOf((String)object9));
                            String object82 = StringUtils.trimToNull(stringArray[20]);
                            if (object82 != null) {
                                sEPADirectDebit.setCategoryPurpose(CategoryPurpose.valueOf(object82));
                            }
                            object3 = StringUtils.trimToNull(stringArray[21]);
                            sEPADirectDebit.setIdentificationID((String)object3);
                            n = Boolean.valueOf(StringUtils.trimToNull(stringArray[22])).booleanValue();
                            sEPADirectDebit.setIdentIdPrv(n != 0);
                            boolean bl65 = Boolean.valueOf(StringUtils.trimToNull(stringArray[23]));
                            sEPADirectDebit.setIdentIdOrg(bl65);
                            boolean bl66 = Boolean.valueOf(StringUtils.trimToNull(stringArray[24]));
                            ApplicationContext.get().setUseTimeZoneFor001(bl66);
                            boolean bl67 = Boolean.valueOf(StringUtils.trimToNull(stringArray[25]));
                            sEPADirectDebit.setGenerateEnd2EndId(bl67);
                            String string29 = StringUtils.trimToNull(stringArray[26]);
                            sEPADirectDebit.setEnd2EndId(string29);
                            String string30 = StringUtils.trimToNull(stringArray[27]);
                            if (string30 != null) {
                                sEPADirectDebit.setBatchBooking(BatchBooking.valueOf(string30));
                            }
                            boolean bl68 = Boolean.valueOf(StringUtils.trimToNull(stringArray[28]));
                            sEPADirectDebit.setSetTxNo(bl68);
                            boolean bl69 = Boolean.valueOf(StringUtils.trimToNull(stringArray[29]));
                            sEPADirectDebit.setUsePIIforEachTrx(bl69);
                            object = StringUtils.trimToNull(stringArray[30]);
                            sEPADirectDebit.setCurrency((String)object);
                            String string31 = StringUtils.trimToNull(stringArray[31]);
                            if (string31 != null) {
                                sEPADirectDebit.setChargeBearer(ChargeBearer.valueOf(string31));
                            }
                            String string32 = StringUtils.trimToNull(stringArray[32]);
                            sEPADirectDebit.setPmtInfId(string32);
                            boolean bl70 = Boolean.valueOf(StringUtils.trimToNull(stringArray[33]));
                            sEPADirectDebit.setXmlHeaderWithSchemaLocation(bl70);
                            boolean bl71 = Boolean.valueOf(StringUtils.trimToNull(stringArray[34]));
                            sEPADirectDebit.setBDD(bl71);
                            string40 = StringUtils.trimToNull(stringArray[35]);
                            boolean bl80 = Boolean.valueOf(StringUtils.trimToNull(stringArray[36]));
                            sEPADirectDebit.setAddSoftwareNameAndVendor(bl80);
                        }
                        System.out.println("---");
                        int n8 = 0;
                        for (ParserLineResult parserLineResult : parserResult.getLineResults()) {
                            logger.log(Level.FINEST, String.format("Parsing %s", parserLineResult.getLineMessage()));
                            ++n8;
                            if (parserLineResult.isSucessfull()) {
                                System.out.println(parserLineResult.getLineMessage());
                                System.out.println(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n8 + " (" + ApplicationContext.get().text().getString("row") + " " + (n8 + 2) + ") - " + parserLineResult.getLineMessage());
                                continue;
                            }
                            System.out.println(parserLineResult.getLineMessage());
                            System.out.println(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n8 + " (" + ApplicationContext.get().text().getString("row") + " " + (n8 + 2) + ") - " + parserLineResult.getLineMessage());
                        }
                        System.out.println("---");
                        System.out.println(ApplicationContext.get().text().getString("successfullyImported") + parserResult.getSuccessfull());
                        System.out.println(ApplicationContext.get().text().getString("errorImported") + parserResult.getNotSuccessfull());
                        if (!parserResult.isHeaderSuccessfull()) {
                            System.out.println("---");
                            System.out.println(ApplicationContext.get().text().getString("unknownError"));
                            System.exit(131);
                        }
                        System.out.println("-------------------------------");
                        object9 = new SEPAWriter();
                        File file3 = new File(string39);
                        object3 = file3.toPath();
                        if (!object3.toString().toLowerCase().endsWith(".xml")) {
                            object3 = Paths.get(object3.toAbsolutePath().toString() + ".xml", new String[0]);
                            logger.fine("adding file extension \".xml\"");
                        }
                        n = 0;
                        if (string40 != null && !string40.isEmpty()) {
                            n = Integer.parseInt(string40);
                        }
                        if (n > 0) {
                            int n5;
                            String string33 = object3.toString();
                            if (object3.toString().endsWith(".xml") || object3.toString().endsWith(".XML")) {
                                string33 = object3.toString().substring(0, object3.toString().lastIndexOf(46));
                            }
                            ArrayList<SEPADirectDebit> arrayList = new ArrayList<SEPADirectDebit>();
                            SEPADirectDebit sEPADirectDebit2 = null;
                            int n6 = 0;
                            for (n5 = 0; n5 < sEPADirectDebit.getTransactionList().size(); ++n5) {
                                if (n6 % n == 0) {
                                    sEPADirectDebit2 = sEPADirectDebit.clone();
                                    arrayList.add(sEPADirectDebit2);
                                }
                                sEPADirectDebit2.getTransactionList().add(sEPADirectDebit.getTransactionList().get(n6));
                                ++n6;
                            }
                            n5 = 1;
                            for (SEPADirectDebit sEPADirectDebit3 : arrayList) {
                                object = Paths.get(string33 + "_" + n5 + ".xml", new String[0]);
                                ((SEPAWriter)object9).createSEPADirectDebitXMLFile(sEPADirectDebit3, object.toFile());
                                logger.log(Level.INFO, String.format("SEPA XML file created: %s", object.toAbsolutePath().toString()));
                                System.out.println("-------------------------------\n");
                                System.out.println("-");
                                System.out.println(String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), object.toAbsolutePath().toString()) + "\n", object.toAbsolutePath().toString()));
                                ++n5;
                            }
                        } else {
                            ((SEPAWriter)object9).createSEPADirectDebitXMLFile(sEPADirectDebit, object3.toFile());
                            logger.log(Level.INFO, String.format("SEPA XML file created: %s", object3.toAbsolutePath().toString()));
                            System.out.println("-------------------------------\n");
                            System.out.println("-");
                            System.out.println(String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), object3.toAbsolutePath().toString()) + "\n", object3.toAbsolutePath().toString()));
                        }
                        System.exit(parserResult.getNotSuccessfull() == 0 ? 0 : 132);
                        break block88;
                    }
                    if ("SDDx".equals(string)) {
                        boolean bl;
                        boolean bl81;
                        Comparable<Date> comparable;
                        Object object10;
                        if (stringArray.length < 4) {
                            System.out.println(ApplicationContext.get().text().getString("sddx.usageHint"));
                            System.exit(2);
                        }
                        String string47 = StringUtils.trimToNull(stringArray[1]);
                        String string48 = StringUtils.trimToNull(stringArray[2]);
                        String string49 = StringUtils.trimToNull(stringArray[3]);
                        Properties properties = new Properties();
                        try {
                            object10 = new FileInputStream(new File(string47));
                            properties.load((InputStream)object10);
                        }
                        catch (IOException iOException) {
                            logger.log(Level.SEVERE, "Exception while loading configuration!", iOException);
                        }
                        object10 = Locale.getDefault();
                        String string50 = ((Locale)object10).getCountry();
                        String string51 = properties.getProperty(FieldType.KONTOINHABER_LASTSCHRIFT.name());
                        String string52 = properties.getProperty(FieldType.IBAN_LASTSCHRIFT.name());
                        String string53 = properties.getProperty(FieldType.BIC_LASTSCHRIFT.name());
                        String string54 = properties.getProperty(FieldType.GLAEUBIGERID_LASTSCHRIFT.name());
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        try {
                            comparable = simpleDateFormat.parse(properties.getProperty(FieldType.ABBUCHUNGSDATUM_LASTSCHRIFT.name()));
                            gregorianCalendar.setTime((Date)comparable);
                        }
                        catch (ParseException parseException) {
                            logger.log(Level.SEVERE, "Exception while Parsing date (CollectionDate): " + properties.getProperty(FieldType.ABBUCHUNGSDATUM_LASTSCHRIFT.name()), parseException);
                            System.out.println(ApplicationContext.get().text().getString("validationFault") + " " + parseException.getMessage());
                        }
                        comparable = gregorianCalendar;
                        DirectDebitType directDebitType = properties.getProperty(FieldType.TYP_LASTSCHRIFT.name()) != null ? DirectDebitType.valueOf(properties.getProperty(FieldType.TYP_LASTSCHRIFT.name())) : DirectDebitType.EINMAL;
                        DirectDebitKind directDebitKind = properties.getProperty(FieldType.ART_LASTSCHRIFT.name()) != null ? DirectDebitKind.valueOf(properties.getProperty(FieldType.ART_LASTSCHRIFT.name())) : DirectDebitKind.CORE;
                        boolean bl89 = properties.getProperty(FieldType.IMPORTBIC_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.IMPORTBIC_LASTSCHRIFT.name())) : false;
                        DirectDebitSubformat directDebitSubformat = properties.getProperty(FieldType.SUBFORMAT_LASTSCHRIFT.name()) != null ? DirectDebitSubformat.valueOf(properties.getProperty(FieldType.SUBFORMAT_LASTSCHRIFT.name())) : DirectDebitSubformat.getDefaultByCountry(Locale.getDefault());
                        boolean bl90 = properties.getProperty(FieldType.USE_TZ_001_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_TZ_001_LASTSCHRIFT.name())) : true;
                        CategoryPurpose categoryPurpose = properties.getProperty(FieldType.CATEGORY_PURPOSE_LASTSCHRIFT.name()) != null ? CategoryPurpose.valueOf(properties.getProperty(FieldType.CATEGORY_PURPOSE_LASTSCHRIFT.name())) : CategoryPurpose.EMPTY;
                        String string55 = properties.getProperty(FieldType.SPANISH_NUMBER_LASTSCHRIFT.name());
                        boolean bl91 = properties.getProperty(FieldType.USE_ORG_ID_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_ORG_ID_LASTSCHRIFT.name())) : false;
                        boolean bl92 = properties.getProperty(FieldType.USE_PRV_ID_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.USE_PRV_ID_LASTSCHRIFT.name())) : true;
                        boolean bl93 = properties.getProperty(FieldType.GENERATE_END2END_ID_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.GENERATE_END2END_ID_LASTSCHRIFT.name())) : true;
                        boolean bl94 = properties.getProperty(FieldType.END2END_ID_FROM_FILE_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.END2END_ID_FROM_FILE_LASTSCHRIFT.name())) : false;
                        String string56 = properties.getProperty(FieldType.END2ENDID_LASTSCHRIFT.name());
                        BatchBooking batchBooking = properties.getProperty(FieldType.BATCH_BOOKING_SELECT_LASTSCHRIFT.name()) != null ? BatchBooking.valueOf(properties.getProperty(FieldType.BATCH_BOOKING_SELECT_LASTSCHRIFT.name())) : BatchBooking.EMPTY;
                        boolean bl82 = properties.getProperty(FieldType.TX_NO_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.TX_NO_LASTSCHRIFT.name())) : false;
                        boolean bl83 = properties.getProperty(FieldType.PII_FOR_EACH_TRX_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.PII_FOR_EACH_TRX_LASTSCHRIFT.name())) : false;
                        String string34 = properties.getProperty(FieldType.CURRENCY_LASTSCHRIFT.name());
                        boolean bl84 = properties.getProperty(FieldType.CURRENCY_FROM_FILE_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.CURRENCY_FROM_FILE_LASTSCHRIFT.name())) : false;
                        boolean bl85 = properties.getProperty(FieldType.ADDRESS_FROM_FILE_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.ADDRESS_FROM_FILE_LASTSCHRIFT.name())) : false;
                        ChargeBearer chargeBearer = properties.getProperty(FieldType.CHARGEBEARER_LASTSCHRIFT.name()) != null ? ChargeBearer.valueOf(properties.getProperty(FieldType.CHARGEBEARER_LASTSCHRIFT.name())) : ChargeBearer.EMPTY;
                        String string35 = properties.getProperty(FieldType.PMTID_LASTSCHRIFT.name());
                        boolean bl86 = properties.getProperty(FieldType.IMPORT_EXECUTIONDATE_FROM_FILE_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.IMPORT_EXECUTIONDATE_FROM_FILE_LASTSCHRIFT.name())) : false;
                        boolean bl87 = properties.getProperty(FieldType.XML_HEADER_WITH_SCHEMA_LOCATION_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.XML_HEADER_WITH_SCHEMA_LOCATION_LASTSCHRIFT.name())) : false;
                        boolean bl88 = bl81 = properties.getProperty(FieldType.DIRECT_DEBIT_TYPE_FROM_FILE.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.DIRECT_DEBIT_TYPE_FROM_FILE.name())) : false;
                        boolean bl95 = properties.getProperty(FieldType.NORMALIZE_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.NORMALIZE_LASTSCHRIFT.name())) : (bl = !"DE".equals(string50) || !"AT".equals(string50));
                        boolean bl96 = properties.getProperty(FieldType.UMLAUTS_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.UMLAUTS_LASTSCHRIFT.name())) : "DE".equals(string50) || "AT".equals(string50);
                        boolean bl97 = properties.getProperty(FieldType.BDD_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.BDD_LASTSCHRIFT.name())) : false;
                        boolean bl98 = properties.getProperty(FieldType.SPECIAL_CHARACTERS_CH_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.SPECIAL_CHARACTERS_CH_LASTSCHRIFT.name())) : false;
                        String string36 = properties.getProperty(FieldType.SPLIT_LASTSCHRIFT.name());
                        boolean bl99 = properties.getProperty(FieldType.ADD_SOFTWARE_NAME_AND_VENDOR_LASTSCHRIFT.name()) != null ? Boolean.valueOf(properties.getProperty(FieldType.ADD_SOFTWARE_NAME_AND_VENDOR_LASTSCHRIFT.name())) : false;
                        ApplicationContext.get().setUseTimeZoneFor001(bl90);
                        File file = new File(string48);
                        DebitParser debitParser = DirectDebitParserFactory.create(file.toPath());
                        ParserResult parserResult = debitParser.parse(file, bl89, bl94, bl84, bl85, bl86, bl81, bl, bl96, bl98, DirectDebitSubformat.PAIN_008_001_02_CH_03.equals((Object)directDebitSubformat));
                        SEPADirectDebit sEPADirectDebit = parserResult.getDirectDebit();
                        sEPADirectDebit.setEnd2EndIdFromFile(bl94);
                        sEPADirectDebit.setCollectionDateFromFile(bl86);
                        sEPADirectDebit.setDirectDebitTypeFromFile(bl81);
                        sEPADirectDebit.setKontoinhaber(string51);
                        sEPADirectDebit.setIBAN(string52);
                        sEPADirectDebit.setBIC(string53);
                        sEPADirectDebit.setGlaeubigerId(string54);
                        sEPADirectDebit.setCollectionDate((GregorianCalendar)comparable);
                        sEPADirectDebit.setSubformat(directDebitSubformat);
                        sEPADirectDebit.setType(directDebitType);
                        sEPADirectDebit.setKind(directDebitKind);
                        sEPADirectDebit.setCategoryPurpose(categoryPurpose);
                        sEPADirectDebit.setIdentificationID(string55);
                        sEPADirectDebit.setIdentIdPrv(bl92);
                        sEPADirectDebit.setIdentIdOrg(bl91);
                        sEPADirectDebit.setGenerateEnd2EndId(bl93);
                        sEPADirectDebit.setEnd2EndId(string56);
                        sEPADirectDebit.setBatchBooking(batchBooking);
                        sEPADirectDebit.setSetTxNo(bl82);
                        sEPADirectDebit.setUsePIIforEachTrx(bl83);
                        sEPADirectDebit.setCurrency(string34);
                        sEPADirectDebit.setChargeBearer(chargeBearer);
                        sEPADirectDebit.setPmtInfId(string35);
                        sEPADirectDebit.setXmlHeaderWithSchemaLocation(bl87);
                        sEPADirectDebit.setBDD(bl97);
                        sEPADirectDebit.setAddSoftwareNameAndVendor(bl99);
                        System.out.println("---");
                        int n = 0;
                        for (ParserLineResult parserLineResult : parserResult.getLineResults()) {
                            logger.log(Level.FINEST, String.format("Parsing %s", parserLineResult.getLineMessage()));
                            ++n;
                            if (parserLineResult.isSucessfull()) {
                                System.out.println(parserLineResult.getLineMessage());
                                System.out.println(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n + " (" + ApplicationContext.get().text().getString("row") + " " + (n + 2) + ") - " + parserLineResult.getLineMessage());
                                continue;
                            }
                            System.out.println(parserLineResult.getLineMessage());
                            System.out.println(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n + " (" + ApplicationContext.get().text().getString("row") + " " + (n + 2) + ") - " + parserLineResult.getLineMessage());
                        }
                        System.out.println("---");
                        System.out.println(ApplicationContext.get().text().getString("successfullyImported") + parserResult.getSuccessfull());
                        System.out.println(ApplicationContext.get().text().getString("errorImported") + parserResult.getNotSuccessfull());
                        if (!parserResult.isHeaderSuccessfull()) {
                            System.out.println("---");
                            System.out.println(ApplicationContext.get().text().getString("unknownError"));
                            System.exit(131);
                        }
                        System.out.println("-------------------------------");
                        SEPAWriter sEPAWriter = new SEPAWriter();
                        File file4 = new File(string49);
                        Path path = file4.toPath();
                        if (!path.toString().toLowerCase().endsWith(".xml")) {
                            path = Paths.get(path.toAbsolutePath().toString() + ".xml", new String[0]);
                            logger.fine("adding file extension \".xml\"");
                        }
                        int n7 = 0;
                        if (string36 != null && !string36.isEmpty()) {
                            n7 = Integer.parseInt(string36);
                        }
                        if (n7 > 0) {
                            int n8;
                            String string37 = path.toString();
                            if (path.toString().endsWith(".xml") || path.toString().endsWith(".XML")) {
                                string37 = path.toString().substring(0, path.toString().lastIndexOf(46));
                            }
                            ArrayList<SEPADirectDebit> arrayList = new ArrayList<SEPADirectDebit>();
                            SEPADirectDebit sEPADirectDebit4 = null;
                            int n9 = 0;
                            for (n8 = 0; n8 < sEPADirectDebit.getTransactionList().size(); ++n8) {
                                if (n9 % n7 == 0) {
                                    sEPADirectDebit4 = sEPADirectDebit.clone();
                                    arrayList.add(sEPADirectDebit4);
                                }
                                sEPADirectDebit4.getTransactionList().add(sEPADirectDebit.getTransactionList().get(n9));
                                ++n9;
                            }
                            n8 = 1;
                            for (SEPADirectDebit sEPADirectDebit5 : arrayList) {
                                Path path4 = Paths.get(string37 + "_" + n8 + ".xml", new String[0]);
                                sEPAWriter.createSEPADirectDebitXMLFile(sEPADirectDebit5, path4.toFile());
                                logger.log(Level.INFO, String.format("SEPA XML file created: %s", path4.toAbsolutePath().toString()));
                                System.out.println("-------------------------------\n");
                                System.out.println("-");
                                System.out.println(String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), path4.toAbsolutePath().toString()) + "\n", path4.toAbsolutePath().toString()));
                                ++n8;
                            }
                        } else {
                            sEPAWriter.createSEPADirectDebitXMLFile(sEPADirectDebit, path.toFile());
                            logger.log(Level.INFO, String.format("SEPA XML file created: %s", path.toAbsolutePath().toString()));
                            System.out.println("-------------------------------\n");
                            System.out.println("-");
                            System.out.println(String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("sepaXmlSpeicherort"), path.toAbsolutePath().toString()) + "\n", path.toAbsolutePath().toString()));
                        }
                        System.exit(parserResult.getNotSuccessfull() == 0 ? 0 : 132);
                        break block88;
                    }
                    if (!sEPAPreferences.hasValidProLicense() && string != null && !string.isEmpty() && sEPAPreferences.isValidProLicense(string)) {
                        sEPAPreferences.saveProLicense(string);
                        System.out.println(ApplicationContext.get().text().getString("proLicenceSaved"));
                        System.exit(0);
                    } else {
                        System.out.println(ApplicationContext.get().text().getString("missingPaymentType"));
                        System.exit(127);
                    }
                    System.exit(1);
                    break block88;
                }
                if (string != null && !string.isEmpty() && !string.equals("SCT") && !string.equals("SDD") && sEPAPreferences.isValidProLicense(string)) {
                    sEPAPreferences.saveProLicense(string);
                    System.out.println(ApplicationContext.get().text().getString("proLicenceSaved"));
                    System.exit(0);
                } else {
                    System.out.println(ApplicationContext.get().text().getString("needsProLicence"));
                    System.exit(126);
                }
                System.exit(1);
            }
            catch (Exception exception) {
                Logger.getGlobal().log(Level.SEVERE, "Exception while initializing SEPAApp CLI.", exception);
                System.out.println(exception.getMessage());
                System.exit(1);
            }
        }
    }
}

